#ifndef OPUCI_INTENTION_DRIBBLE_H
#define OPUCI_INTENTION_DRIBBLE_H

#include <rcsc/player/soccer_intention.h>
#include <rcsc/geom/vector_2d.h>

class Opuci_IntentionDribble
    : public rcsc::SoccerIntention {
 private:
      rcsc::Vector2D M_target_point;
      int M_dash_count;

 public:
 Opuci_IntentionDribble( rcsc::Vector2D target_point, int dash_count = 1 )
   :M_target_point( target_point )
	,M_dash_count( dash_count )
	{ }
      bool finished( const rcsc::PlayerAgent * agent );
      bool execute( rcsc::PlayerAgent * agent );

 private:
      bool neckToMate( rcsc::PlayerAgent * agent );
      double dashPower( rcsc::PlayerAgent * agent );
};

#endif
