#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "opuci_intercept.h"
#include "opuci_intercept_cycle.h"
#include "experiment.h"
#include <rcsc/common/audio_memory.h>

#include <rcsc/player/intercept_table.h>
#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/player/say_message_builder.h>
#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>

/*-------------------------------------------------------------------*/
/*!

 */
bool
Opuci_Intercept::finished( const rcsc::PlayerAgent * agent )
{
    const rcsc::WorldModel & wm = agent->world();
    int self_min = wm.interceptTable()->selfReachCycle();
    const rcsc::Vector2D target_point = wm.ball().inertiaPoint( self_min );
    //自分以外にパスが出された場合，インテンションを切る
    if( wm.audioMemory().passTime() == wm.time()
        && ! wm.audioMemory().pass().empty()
        && wm.audioMemory().pass().front().receiver_ != wm.self().unum() )
    {
        Experiment().getData( agent, 
                              wm.audioMemory().pass().front().sender_,
                              wm.audioMemory().pass().front().receiver_ );
        Experiment().discrimination( 1 );
        return true;
    }
    //キックできる味方が存在する場合，インテンションを切る
    else if( wm.existKickableTeammate() )
    {
        Experiment().getData( agent, 
                              M_passer,
                              wm.getTeammateNearestToBall( 100 )->unum() );
        Experiment().discrimination( 1 );
        return true;
    }
    //キックできる敵が存在する場合，インテンションを切る
    else if( wm.existKickableOpponent() )
    {
        Experiment().getData( agent, 
                              M_passer,
                              0 );
        Experiment().discrimination( 1 );
        return true;
    }
    //指定されたダッシュカウントを過ぎた場合，インテンションを切る
    else if( M_dash_count <= 0 )
    {
        Experiment().getData( agent, 
                              M_passer, 
                              0 );
        Experiment().discrimination( 1 );
        return true;
    }
    //自分がボールをキックできる位置へ移動した場合，インテンションを切る
    else if( wm.self().pos().dist( wm.ball().pos() ) < wm.self().playerType().kickableArea() )
    {
        Experiment().discrimination( 0 );
        return true;
    }
    //自分が目標位置へ到達した場合，インテンションを切る
    else if( wm.self().pos().dist( target_point ) < wm.self().playerType().kickableArea() )
    {
        Experiment().discrimination( 0 );
	return true;
    } 

    return false;
}
/*-------------------------------------------------------------------*/
/*!

 */
bool
Opuci_Intercept::execute( rcsc::PlayerAgent * agent )
{
    const rcsc::WorldModel & wm = agent->world();
    const rcsc::PlayerType & PT = wm.self().playerType();
    const double dash_power = dashPower( agent );

    int self_min = wm.interceptTable()->selfReachCycle();
    //int self_cycle = Opuci_InterceptCycle().selfCycle( agent );
    //opuciMoveと同様のアルゴリズムでtarget_pointへ移動
    const rcsc::Vector2D target_point = wm.ball().inertiaPoint( self_min );
    const rcsc::Line2D body_r_line( rcsc::Vector2D( wm.self().pos().x + PT.kickableArea() * wm.self().body().sin(),
                                                    wm.self().pos().y - PT.kickableArea() * wm.self().body().cos() ),
                                    wm.self().body() );
    const rcsc::Line2D body_l_line( rcsc::Vector2D( wm.self().pos().x - PT.kickableArea() * wm.self().body().sin(),
                                                    wm.self().pos().y + PT.kickableArea() * wm.self().body().cos() ),
                                    wm.self().body() );

    const double target_inside =
        ( body_r_line.a() * target_point.x + body_r_line.b() * target_point.y + body_r_line.c() )
        * ( body_l_line.a() * target_point.x + body_l_line.b() * target_point.y + body_l_line.c() );

    if( target_inside <= 0.0
        && fabs( ( wm.self().body() - rcsc::Vector2D( target_point - wm.self().pos() ).th() ).degree() ) < 90.0 )
    {
        agent->doDash( dash_power );
        agent->debugClient().addMessage( "opuciInTrCptDash:%f", dash_power );
    }
    else
    {
        rcsc::AngleDeg angle = ( target_point - ( wm.self().pos() + wm.self().vel() ) ).th() - wm.self().body();
        agent->doTurn( angle );
        agent->debugClient().addMessage( "opuciInTrCptTurn" );
    }
    //首振り
    neckToMate( agent );

    M_dash_count--;
    //メッセージの送受信
    if( wm.ball().rposCount() < 1 )
    {
        agent->addSayMessage( new rcsc::BallPlayerMessage( agent->effector().queuedNextBallPos(), 
                                                           agent->effector().queuedNextBallVel(),
                                                           wm.self().unum(),
                                                           agent->effector().queuedNextMyPos(),
                                                           agent->effector().queuedNextMyBody() ) );
    }
    else
    {
        agent->addSayMessage( new rcsc::OnePlayerMessage( wm.self().unum(),
                                                          agent->effector().queuedNextMyPos() ) );
    }
    if( wm.getTeammateNearestToBall( 100 ) )
    {
        agent->doAttentionto( wm.self().side(),
                              wm.getTeammateNearestToBall( 100 )->unum() );
    }

    agent->debugClient().addMessage( "opuciIntercept" );

    return true;
}
/*-------------------------------------------------------------------*/
/*!

*/
bool
Opuci_Intercept::neckToMate( rcsc::PlayerAgent * agent )
{
    const rcsc::WorldModel & wm = agent->world();

    const rcsc::Vector2D next_ball_pos = agent->effector().queuedNextBallPos();
    const rcsc::Vector2D next_self_pos = agent->effector().queuedNextSelfPos();
    const rcsc::AngleDeg next_self_body = agent->effector().queuedNextSelfBody();

    if( wm.ball().posCount() > 1 )
    {
        agent->doTurnNeck( ( next_ball_pos - next_self_pos ).th() - ( wm.self().neck() + next_self_body ) );
    }
    else
    {
        int max_count = 0;
        rcsc::AngleDeg search_angle = next_self_body;
        for( rcsc::AngleDeg angle = -90.0; angle.degree() <= 90.0; angle += 10.0 )
        {
            const rcsc::AngleDeg target_angle = next_self_body + angle;
            if( wm.dirCount( target_angle ) > max_count )
            {
                max_count = wm.dirCount( target_angle );
                search_angle = target_angle;
            }
        }
        for( int num = 7; num <= 11; num++ )
        {
            if( wm.teammate( num ) )
            {
                const rcsc::AngleDeg target_angle = ( wm.teammate( num )->pos() - next_self_pos ).th();
                if( wm.teammate( num )->posCount() > max_count
                    && ( target_angle - next_self_body ).abs() < 120.0 )
                {
                    max_count = wm.teammate( num )->posCount();
                    search_angle = target_angle;
                }
            }
        }
        agent->doTurnNeck( search_angle - ( wm.self().neck() + next_self_body ) );
    }
    return true;
}
/*-------------------------------------------------------------------*/
/*!

 */
double
Opuci_Intercept::dashPower( rcsc::PlayerAgent * agent )
{
    const rcsc::WorldModel & wm = agent->world();
    double power = rcsc::ServerParam::i().maxDashPower(); 

    const rcsc::ServerParam & SP = rcsc::ServerParam::i();
    if( wm.self().stamina() < SP.staminaMax() * SP.effortDecThr() * 1.2
        || wm.self().stamina() < SP.staminaMax() * SP.recoverDecThr() * 1.2 )
    {
        power = 0.0;
    }

    power = std::min( power, rcsc::ServerParam::i().maxDashPower() );
    agent->debugClient().addMessage( "power:%d", int( power ) );
    return power;
}
