#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "opuci_intercept_cycle.h"

#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>

/*-------------------------------------------------------------------*/
/*!

 */
int
Opuci_InterceptCycle::selfCycle( rcsc::PlayerAgent * agent )
{
  const rcsc::WorldModel & wm = agent->world();
  const rcsc::ServerParam & SP = rcsc::ServerParam::i();
  const double player_size = wm.self().playerType().kickableArea();

  int cycle = 0;
  rcsc::Vector2D ball_pos = wm.ball().pos();
  rcsc::Vector2D ball_vel = wm.ball().vel();
  rcsc::Vector2D self_pos = wm.self().pos();
  rcsc::Vector2D self_vel = wm.self().vel();
  rcsc::AngleDeg self_body = wm.self().body();
  //double self_stamina = wm.self().stamina();
  //const double self_stamina_inc = wm.self().playerType().staminaIncMax() * wm.self().recovery();

  while( cycle < 100 )
    {
      if( self_pos.dist( ball_pos ) < player_size )
	{
	  return cycle;
	}

      rcsc::Vector2D next_ball_pos = ball_pos + ball_vel;
      const rcsc::Line2D body_right_line( rcsc::Vector2D( self_pos.x + player_size * self_body.sin(),
							  self_pos.y - player_size * self_body.cos() ),
					  self_body );
      const rcsc::Line2D body_left_line( rcsc::Vector2D( self_pos.x - player_size * self_body.sin(),
							 self_pos.y + player_size * self_body.cos() ),
					 self_body );

      const double target_inside =
	( body_right_line.getA() * next_ball_pos.x + body_right_line.getB() * next_ball_pos.y + body_right_line.getC() )
	* ( body_left_line.getA() * next_ball_pos.x + body_left_line.getB() * next_ball_pos.y + body_left_line.getC() );

      if( target_inside <= 0.0
	  && fabs( ( self_body - rcsc::Vector2D( next_ball_pos - self_pos ).th() ).degree() ) < 90.0 )
	{
	  double power = SP.maxDashPower();
	  const double next_dist = next_ball_pos.dist( self_pos + self_vel );
	  if( next_dist - wm.self().playerType().realSpeedMax() < player_size )
	    {
	      power = ( next_dist / ( wm.self().playerType().dashPowerRate() * wm.self().effort() ) );
	    }
	  /*
	  else if( self_stamina < SP.staminaMax() * SP.effortDecThr() * 1.2
		   || self_stamina < SP.staminaMax() * SP.recoverDecThr() * 1.2 )
	    {
	      power = 0.0;
	    }
	  */
	  double next_speed = wm.self().effort() * wm.self().playerType().dashPowerRate() * power;
	  rcsc::Vector2D self_speed( next_speed * self_body.cos(), next_speed * self_body.sin() );
	  self_vel += self_speed;
	  self_pos += self_vel;
	  //self_stamina += self_stamina_inc - power;
	}
      else
	{
	  rcsc::AngleDeg angle = ( next_ball_pos - ( self_pos + self_vel ) ).th() - self_body;
	  rcsc::AngleDeg real_angle = angle;
	  if( angle.degree() * ( 1.0 + self_vel.r() * wm.self().playerType().inertiaMoment() ) > 180.0 )
	    {
	      real_angle = 180.0 / ( 1.0 + self_vel.r() * wm.self().playerType().inertiaMoment() );
	    }
	  else if( angle.degree() * ( 1.0 + self_vel.r() * wm.self().playerType().inertiaMoment() ) < - 180.0 )
	    {
	      real_angle =  - 180.0 / ( 1.0 + self_vel.r() * wm.self().playerType().inertiaMoment() );
	    }
	  self_pos += self_vel;
	  self_body += real_angle;
	  //self_stamina += self_stamina_inc;
	}
      ball_pos += ball_vel;
      ball_vel *= rcsc::ServerParam::i().ballDecay();
      self_vel *= wm.self().playerType().playerDecay();
      cycle++;
    }
  return 100;
}
/*-------------------------------------------------------------------*/
/*!

 */
int
Opuci_InterceptCycle::mateCycle( rcsc::PlayerAgent * agent )
{
  const rcsc::WorldModel & wm = agent->world();
  int min_cycle = 100;

  for( int unum = 2; unum <= 11; unum ++ )
    {
      if( wm.teammate( unum ) && unum != wm.self().unum() )
	{
	  int cycle = 0;
	  const double player_size = wm.teammate( unum )->playerTypePtr()->kickableArea();
	  rcsc::Vector2D ball_pos = wm.ball().pos();
	  rcsc::Vector2D ball_vel = wm.ball().vel();
	  rcsc::Vector2D mate_pos = wm.teammate( unum )->pos();
	  rcsc::Vector2D mate_vel = wm.teammate( unum )->vel();
	  rcsc::AngleDeg mate_body = wm.teammate( unum )->body();
	  
	  while( cycle < 100 )
	    {
	      if( mate_pos.dist( ball_pos ) < player_size )
		{
		  break;
		}

	      rcsc::Vector2D next_ball_pos = ball_pos + ball_vel;
	      const rcsc::Line2D body_right_line( rcsc::Vector2D( mate_pos.x + player_size * mate_body.sin(),
								  mate_pos.y - player_size * mate_body.cos() ),
						  mate_body );
	      const rcsc::Line2D body_left_line( rcsc::Vector2D( mate_pos.x - player_size * mate_body.sin(),
								 mate_pos.y + player_size * mate_body.cos() ),
						 mate_body );

	      const double target_inside =
		( body_right_line.getA() * next_ball_pos.x + body_right_line.getB() 
		  * next_ball_pos.y + body_right_line.getC() )
		* ( body_left_line.getA() * next_ball_pos.x + body_left_line.getB() 
		    * next_ball_pos.y + body_left_line.getC() );

	      if( target_inside <= 0.0
		  && fabs( ( mate_body - rcsc::Vector2D( next_ball_pos - mate_pos ).th() ).degree() ) < 90.0 )
		{
		  double power = rcsc::ServerParam::i().maxDashPower();
		  const double next_dist = next_ball_pos.dist( mate_pos + mate_vel );
		  if( next_dist - wm.teammate( unum )->playerTypePtr()->realSpeedMax() < player_size )
		    {
		      power = ( next_dist / ( wm.teammate( unum )->playerTypePtr()->dashPowerRate() 
					      * wm.teammate( unum )->playerTypePtr()->effortMax() ) );
		    }
		  power = std::min( power, rcsc::ServerParam::i().maxDashPower() );
		  double next_speed = wm.teammate( unum )->playerTypePtr()->effortMax() 
		    * wm.teammate( unum )->playerTypePtr()->dashPowerRate() * power;
		  rcsc::Vector2D mate_speed( next_speed * mate_body.cos(), next_speed * mate_body.sin() );
		  mate_vel += mate_speed;
		  mate_pos += mate_vel;
		}
	      else
		{
		  rcsc::AngleDeg angle = ( next_ball_pos - ( mate_pos + mate_vel ) ).th() - mate_body;
		  rcsc::AngleDeg real_angle = angle;
		  if( angle.degree() * ( 1.0 + mate_vel.r() 
					 * wm.teammate( unum )->playerTypePtr()->inertiaMoment() ) > 180.0 )
		    {
		      real_angle = 180.0 / ( 1.0 + mate_vel.r() 
					     * wm.teammate( unum )->playerTypePtr()->inertiaMoment() );
		    }
		  else if( angle.degree() * ( 1.0 + mate_vel.r() 
					      * wm.teammate( unum )->playerTypePtr()->inertiaMoment() ) < - 180.0 )
		    {
		      real_angle =  - 180.0 / ( 1.0 + mate_vel.r() 
						* wm.teammate( unum )->playerTypePtr()->inertiaMoment() );
		    }
		  mate_pos += mate_vel;
		  mate_body += real_angle;
		}
	      ball_pos += ball_vel;
	      ball_vel *= rcsc::ServerParam::i().ballDecay();
	      mate_vel *= wm.teammate( unum )->playerTypePtr()->playerDecay();
	      cycle++;
	    }

	  if( cycle < min_cycle )
	    {
	      min_cycle = cycle;
	    }
	}
    }
  return min_cycle;
}
/*-------------------------------------------------------------------*/
/*!

 */
int
Opuci_InterceptCycle::nearestMate( rcsc::PlayerAgent * agent )
{
  const rcsc::WorldModel & wm = agent->world();
  int min_cycle = 100;
  int min_unum = 1;

  for( int unum = 2; unum <= 11; unum ++ )
    {
      if( wm.teammate( unum ) && unum != wm.self().unum() )
	{
	  int cycle = 0;
	  const double player_size = wm.teammate( unum )->playerTypePtr()->kickableArea();
	  rcsc::Vector2D ball_pos = wm.ball().pos();
	  rcsc::Vector2D ball_vel = wm.ball().vel();
	  rcsc::Vector2D mate_pos = wm.teammate( unum )->pos();
	  rcsc::Vector2D mate_vel = wm.teammate( unum )->vel();
	  rcsc::AngleDeg mate_body = wm.teammate( unum )->body();
	  
	  while( cycle < 100 )
	    {
	      if( mate_pos.dist( ball_pos ) < player_size )
		{
		  break;
		}

	      rcsc::Vector2D next_ball_pos = ball_pos + ball_vel;
	      const rcsc::Line2D body_right_line( rcsc::Vector2D( mate_pos.x + player_size * mate_body.sin(),
								  mate_pos.y - player_size * mate_body.cos() ),
						  mate_body );
	      const rcsc::Line2D body_left_line( rcsc::Vector2D( mate_pos.x - player_size * mate_body.sin(),
								 mate_pos.y + player_size * mate_body.cos() ),
						 mate_body );
	      
	      const double target_inside =
		( body_right_line.getA() * next_ball_pos.x + body_right_line.getB() 
		  * next_ball_pos.y + body_right_line.getC() )
		* ( body_left_line.getA() * next_ball_pos.x + body_left_line.getB() 
		    * next_ball_pos.y + body_left_line.getC() );

	      if( target_inside <= 0.0
		  && fabs( ( mate_body - rcsc::Vector2D( next_ball_pos - mate_pos ).th() ).degree() ) < 90.0 )
		{
		  double power = rcsc::ServerParam::i().maxDashPower();
		  const double next_dist = next_ball_pos.dist( mate_pos + mate_vel );
		  if( next_dist - wm.teammate( unum )->playerTypePtr()->realSpeedMax() < player_size )
		    {
		      power = ( next_dist / ( wm.teammate( unum )->playerTypePtr()->dashPowerRate() 
					      * wm.teammate( unum )->playerTypePtr()->effortMax() ) );
		    }
		  power = std::min( power, rcsc::ServerParam::i().maxDashPower() );
		  double next_speed = wm.teammate( unum )->playerTypePtr()->effortMax() 
		    * wm.teammate( unum )->playerTypePtr()->dashPowerRate() * power;
		  rcsc::Vector2D mate_speed( next_speed * mate_body.cos(), next_speed * mate_body.sin() );
		  mate_vel += mate_speed;
		  mate_pos += mate_vel;
		}
	      else
		{
		  rcsc::AngleDeg angle = ( next_ball_pos - ( mate_pos + mate_vel ) ).th() - mate_body;
		  rcsc::AngleDeg real_angle = angle;
		  if( angle.degree() * ( 1.0 + mate_vel.r() 
					 * wm.teammate( unum )->playerTypePtr()->inertiaMoment() ) > 180.0 )
		    {
		      real_angle = 180.0 / ( 1.0 + mate_vel.r() 
					     * wm.teammate( unum )->playerTypePtr()->inertiaMoment() );
		    }
		  else if( angle.degree() * ( 1.0 + mate_vel.r() 
					      * wm.teammate( unum )->playerTypePtr()->inertiaMoment() ) < - 180.0 )
		    {
		      real_angle =  - 180.0 / ( 1.0 + mate_vel.r() 
						* wm.teammate( unum )->playerTypePtr()->inertiaMoment() );
		    }
		  mate_pos += mate_vel;
		  mate_body += real_angle;
		}
	      ball_pos += ball_vel;
	      ball_vel *= rcsc::ServerParam::i().ballDecay();
	      mate_vel *= wm.teammate( unum )->playerTypePtr()->playerDecay();
	      cycle++;
	    }

	  if( cycle < min_cycle )
	    {
	      min_cycle = cycle;
	      min_unum = unum;
	    }
	}
    }
  return min_unum;
}
