#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "opuci_kick.h"

#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>

#include <rcsc/geom/angle_deg.h>
#include <rcsc/geom/line_2d.h>
#include <rcsc/geom/circle_2d.h>

/*-------------------------------------------------------------------*/
/*!

 */
bool
Opuci_Kick::execute( rcsc::PlayerAgent * agent )
{
  rcsc::dlog.addText( rcsc::Logger::KICK,
		      "%s:%d:Opuci_Kick"
		      ,__FILE__, __LINE__ );

  const rcsc::WorldModel & wm = agent->world();

  if( wm.self().pos().dist( wm.ball().pos() ) > wm.self().playerType().kickableArea() )
    {
      return false;
    }

  const rcsc::ServerParam & SP = rcsc::ServerParam::i();

  const double kick_power = SP.maxPower();
  /*
  rcsc::AngleDeg rel_angle = ( wm.ball().pos() - wm.self().pos() ).th() - wm.self().body();
  double rel_dir = ( wm.ball().pos() - wm.self().pos() ).r() - SP.ballSize() - wm.self().playerType().playerSize();
  double decay = std::max( ( 1.0 - 0.25 ),
			   std::min( rel_angle.abs() / 180.0 - 0.25,
				     rel_dir / wm.self().playerType().kickableMargin() ) );
  */
  const double ball_accel = kick_power * wm.self().kickRate();

  rcsc::Vector2D next_ball_pos = wm.ball().pos() + wm.ball().vel();
  rcsc::Circle2D kick_power_circle( next_ball_pos, ball_accel );
  rcsc::Line2D line_to_kick_point( wm.ball().pos(), M_kick_point );
  rcsc::Vector2D target_point;
  rcsc::Vector2D target_point_a;
  rcsc::Vector2D target_point_b;

  int intersection = kick_power_circle.intersection( line_to_kick_point, & target_point_a, & target_point_b );
  if( intersection < 1 )
    {
      target_point = M_kick_point;
    }
  else if( M_kick_point.dist( target_point_a ) <= M_kick_point.dist( target_point_b ) )
    {
      target_point = target_point_a;
    }
  else
    {
      target_point = target_point_b;
    }

  const rcsc::AngleDeg angle = ( target_point - next_ball_pos ).th() - wm.self().body();

  agent->doKick( kick_power, angle );
  agent->debugClient().addMessage( "opuciKick:%f", kick_power );
  agent->debugClient().setTarget( target_point );

  return true;
}
