#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "opuci_message.h"

#include <rcsc/common/logger.h>
#include <rcsc/player/intercept_table.h>

/*-------------------------------------------------------------------*/
/*!
  敵、味方のそれぞれから確信度の高いプレーヤを1人ずつ選択して送信しようとする
　確信度の高いプレーヤがいない場合は自分だけ
*/
/*-------------------------------------------------------------------*/
void
Opuci_Message::normalSayMessage( rcsc::PlayerAgent *agent, int thr )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: Opuci_Message::normalSayMessage"
                        ,__FILE__, __LINE__ );

    //ボールのrposcountが1以上ならば自分の位置をメッセージで配信 #SelfMessageの方がいいかもしれない
    //agent->addSayMessage( new rcsc::OnePlayerMessage( wm.self().unum(), agent->effector().queuedNextMyPos() ) );

    const rcsc::WorldModel & wm = agent->world();
    const rcsc::PlayerPtrCont & opps = wm.opponentsFromSelf();
    const rcsc::PlayerPtrCont & mates = wm.teammatesFromSelf();
    rcsc::Vector2D opp_pos = rcsc::ServerParam::i().theirTeamGoalPos();
    rcsc::Vector2D mate_pos = rcsc::ServerParam::i().theirTeamGoalPos();
    int opp_unum = 0;
    int mate_unum = 0;
    int opp_count = 100;
    int mate_count = 100;
    for( rcsc::PlayerPtrCont::const_iterator it = opps.begin();
         it != opps.end();
         ++it )
    {
        if( (*it)->unum() <= 0 &&  11 < (*it)->unum() )
            continue;
        if( (*it)->seenPosCount() < thr && (*it)->pos().dist( wm.self().pos() ) < 25.0 )
        {
            opp_count = (*it)->seenPosCount();
            opp_unum = (*it)->unum();
            if( (*it)->velCount() <= 2 )
                opp_pos = (*it)->pos() + (*it)->vel();
            else
                opp_pos = (*it)->pos();
            break;
        }
    }
    for( rcsc::PlayerPtrCont::const_iterator it = mates.begin();
         it != mates.end();
         ++it )
    {
        if( (*it)->pos().dist( wm.ball().pos() ) < 1.5 )
            continue;
        if( (*it)->unum() <= 0 &&  11 < (*it)->unum() )
            continue;
        if( wm.interceptTable()->fastestTeammate()
            && (*it)->unum() == wm.interceptTable()->fastestTeammate()->unum() )
            continue;

        if( (*it)->seenPosCount() < thr && (*it)->pos().dist( wm.self().pos() ) < 25.0 )
        {
            mate_count = (*it)->seenPosCount();
            mate_unum = (*it)->unum();
            if( (*it)->velCount() <= 2 )
                mate_pos = (*it)->pos() + (*it)->vel();
            else
                mate_pos = (*it)->pos();
            break;
        }
    }
    

    if( opp_count <= thr && mate_count <= thr )
    {
        agent->addSayMessage( new rcsc::ThreePlayerMessage( opp_unum + 11,
                                                            opp_pos,
                                                            mate_unum,
                                                            mate_pos,
                                                            wm.self().unum(),
                                                            agent->effector().queuedNextMyPos() ) );

        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: Reporting opp( %d ) and mate( %d )"
                            ,__FILE__, __LINE__, opp_unum, mate_unum );
    }
    else if( opp_count <= thr )
    {
        agent->addSayMessage( new rcsc::TwoPlayerMessage( opp_unum + 11,
                                                          opp_pos,
                                                          wm.self().unum(),
                                                          agent->effector().queuedNextMyPos() ) );
        
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: Reporting opp( %d ) only"
                            ,__FILE__, __LINE__, opp_unum );
    }
    else if( mate_count <= thr )
    {
        agent->addSayMessage( new rcsc::TwoPlayerMessage( mate_unum,
                                                          mate_pos,
                                                          wm.self().unum(),
                                                          agent->effector().queuedNextMyPos() ) );

        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: Reporting mate( %d ) only"
                            ,__FILE__, __LINE__, mate_unum );
    }
    else
    {
        agent->addSayMessage( new rcsc::OnePlayerMessage( wm.self().unum(), agent->effector().queuedNextMyPos() ) );
    }
}
/*-------------------------------------------------------------------*/
/*!

 */
/*-------------------------------------------------------------------*/
void
Opuci_Message::shootChanceSayMessage( rcsc::PlayerAgent *agent, int thr )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: Opuci_Message::shootChanceSayMessage"
                        ,__FILE__, __LINE__ );

    const rcsc::WorldModel & wm = agent->world();
    const rcsc::PlayerPtrCont & opps = wm.opponentsFromSelf();
    const rcsc::PlayerPtrCont & mates = wm.teammatesFromSelf();
    rcsc::Vector2D opp1_pos = rcsc::ServerParam::i().theirTeamGoalPos();
    rcsc::Vector2D opp2_pos = rcsc::ServerParam::i().theirTeamGoalPos();
    int opp1_unum = 0;
    int opp1_count = 100;
    int opp2_unum = 0;
    int opp2_count = 100;

    for( rcsc::PlayerPtrCont::const_iterator it = opps.begin();
         it != opps.end();
         ++it )
    {
        if( (*it)->unum() <= 0 &&  11 < (*it)->unum() )
            continue;

        if( (*it)->seenPosCount() >= thr || (*it)->pos().dist( wm.self().pos() ) >= 25.0 )
            continue;

        if( opp1_count > (*it)->seenPosCount() )
        {
            opp2_count = opp1_count;
            opp2_unum = opp1_unum;
            opp2_pos = opp1_pos;

            opp1_count = (*it)->seenPosCount();
            opp1_unum = (*it)->unum();
            if( (*it)->velCount() <= 2 )
                opp1_pos = (*it)->pos() + (*it)->vel();
            else
                opp1_pos = (*it)->pos();

            continue;
        }
        else if( opp2_count > (*it)->seenPosCount() )
        {
            opp2_count = (*it)->seenPosCount();
            opp2_unum = (*it)->unum();
            if( (*it)->velCount() <= 2 )
                opp2_pos = (*it)->pos() + (*it)->vel();
            else
                opp2_pos = (*it)->pos();
        }
    }

    if( opp1_count <= thr && opp2_count <= thr )
    {
        agent->addSayMessage( new rcsc::ThreePlayerMessage( opp1_unum + 11,
                                                            opp1_pos,
                                                            opp2_unum + 11,
                                                            opp2_pos,
                                                            wm.self().unum(),
                                                            agent->effector().queuedNextMyPos() ) );

        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: Reporting opp( %d ) and opp( %d )"
                            ,__FILE__, __LINE__, opp1_unum, opp2_unum );
    }
    else if( opp1_count <= thr )
    {
        agent->addSayMessage( new rcsc::TwoPlayerMessage( opp1_unum + 11,
                                                          opp1_pos,
                                                          wm.self().unum(),
                                                          agent->effector().queuedNextMyPos() ) );
        
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: Reporting opp( %d ) only"
                            ,__FILE__, __LINE__, opp1_unum );
    }
    else if( opp2_count <= thr )
    {
        agent->addSayMessage( new rcsc::TwoPlayerMessage( opp2_unum,
                                                          opp2_pos,
                                                          wm.self().unum(),
                                                          agent->effector().queuedNextMyPos() ) );

        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: Reporting opp( %d ) only"
                            ,__FILE__, __LINE__, opp2_unum );
    }
    else
    {
        agent->addSayMessage( new rcsc::OnePlayerMessage( wm.self().unum(), agent->effector().queuedNextMyPos() ) );
    }
}
/*-------------------------------------------------------------------*/
/*!

 */
/*-------------------------------------------------------------------*/
