#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "opuci_move.h"
#include "opuci_intercept_cycle.h"

#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>

#include <rcsc/geom/angle_deg.h>
#include <rcsc/geom/line_2d.h>

/*-------------------------------------------------------------------*/
/*!

 */
bool
Opuci_Move::execute( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::ACTION,
                        "%s:%d:Opuci_Move"
                        ,__FILE__, __LINE__ );

    const rcsc::WorldModel & wm = agent->world();
    double player_size = wm.self().playerType().kickableArea();
    if( M_dist_margin < 0 )
    {
        M_dist_margin = wm.self().playerType().kickableArea();
    }
    else
    {
        player_size = M_dist_margin;
    }
    agent->debugClient().addMessage( "opuciMove" );    
    if( M_target_point.dist( wm.self().pos() ) <= M_dist_margin )
    {
        agent->debugClient().addMessage( "AlreadyThere" );
        agent->debugClient().addCircle( M_target_point, M_dist_margin );
        return false;
    }
    agent->debugClient().setTarget( M_target_point );
    if( M_target_point.dist( wm.self().pos() + wm.self().vel() ) <= M_dist_margin )
    {
        agent->debugClient().addMessage( "InertialMove" );
        agent->doTurn( 0 ); 
        return true;
    }

    

    
    const rcsc::Line2D body_right_line( rcsc::Vector2D( wm.self().pos().x + player_size * wm.self().body().sin(),
                                                        wm.self().pos().y - player_size * wm.self().body().cos() ),
                                        wm.self().body() );
    const rcsc::Line2D body_left_line( rcsc::Vector2D( wm.self().pos().x - player_size * wm.self().body().sin(),
                                                       wm.self().pos().y + player_size * wm.self().body().cos() ),
                                       wm.self().body() );

    const double target_inside =
        ( body_right_line.getA() * M_target_point.x + body_right_line.getB() * M_target_point.y + body_right_line.getC() )
        * ( body_left_line.getA() * M_target_point.x + body_left_line.getB() * M_target_point.y + body_left_line.getC() );

    if( target_inside <= 0.0
        && fabs( ( wm.self().body() - rcsc::Vector2D( M_target_point - wm.self().pos() ).th() ).degree() ) < 90.0 )
    {
        double power = dashPower( agent );
        agent->debugClient().addMessage( "opuciDash" );
        agent->doDash( power );
    }
    else
    {
        rcsc::AngleDeg angle = ( M_target_point - ( wm.self().pos() + wm.self().vel() ) ).th() - wm.self().body();
        agent->debugClient().addMessage( "opuciTurn" );
        agent->doTurn( angle );
    }

    return true;
}
/*-------------------------------------------------------------------*/
/*!

 */
double
Opuci_Move::dashPower( rcsc::PlayerAgent * agent )
{
    const rcsc::WorldModel & wm = agent->world();
    double power = M_limit_power;

    const double effort_power = wm.self().effort() * wm.self().playerType().dashPowerRate() * power;
    const rcsc::Vector2D dash_dist( effort_power * wm.self().body().cos(), effort_power * wm.self().body().sin() );
    const rcsc::Vector2D next_self_pos = wm.self().pos() + wm.self().vel() + dash_dist;
    const rcsc::Line2D l3( M_target_point, ( next_self_pos - wm.self().pos() ).th() + 90.0 );
    const double next_dist = M_target_point.dist( wm.self().pos() + wm.self().vel() );
    
    double player_size = wm.self().playerType().kickableArea();
/*
    if( M_dist_margin > 0
        && M_dist_margin < player_size )
    {
        player_size = M_dist_margin;
    }
*/
    if( ( wm.self().pos().x * l3.a() + wm.self().pos().y * l3.b() + l3.c() ) * 
        ( next_self_pos.x * l3.a() + next_self_pos.y * l3.b() + l3.c() ) < 0
        || next_dist < player_size )
    {
        power = ( next_dist / ( wm.self().playerType().dashPowerRate() * wm.self().effort() ) ); 
    }

    power = std::min( power, M_limit_power );
    agent->debugClient().addMessage( "power:%d", int( power ) );
    return power;
}
