#ifndef OPUCI_MOVE_H
#define OPUCI_MOVE_H

#include <rcsc/player/soccer_action.h>
#include <rcsc/geom/vector_2d.h>
#include <rcsc/common/server_param.h>

class Opuci_Move
: public rcsc::BodyAction {
private:
    //! target point to be reached
    const rcsc::Vector2D M_target_point;
    const double M_limit_power;
    double M_dist_margin;
    
public:
Opuci_Move( const rcsc::Vector2D point,
            double power = rcsc::ServerParam::i().maxPower(),
            double margin = -1 )
    : M_target_point( point ),
        M_limit_power( power ),
        M_dist_margin( margin )
        
    { }
    bool execute( rcsc::PlayerAgent * agent );
    
private:
    double dashPower( rcsc::PlayerAgent * agent );
    
};

#endif
