#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "opuci_neck.h"

#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>
#include <rcsc/action/neck_turn_to_point.h>

#include <rcsc/geom/angle_deg.h>

/*-------------------------------------------------------------------*/
/*!

*/
/*-------------------------------------------------------------------*/

bool
Opuci_Neck::execute( rcsc::PlayerAgent * agent )
{
    const rcsc::WorldModel & wm = agent->world();
    const rcsc::Vector2D next_ball_pos = wm.ball().pos() + wm.ball().vel();
    const rcsc::Vector2D next_self_pos = agent->effector().queuedNextSelfPos();
    const rcsc::AngleDeg next_self_body = agent->effector().queuedNextSelfBody();
    agent->debugClient().addMessage( "OpuciNeck" );
    if( wm.ball().posCount() > 1 )
    {
        agent->debugClient().addMessage( "LookBall" );
        lookBall( agent );
    }
    else
    {
        std::vector< rcsc::Vector2D > points;
        rcsc::Vector2D rotation( 10, 0 );
        rotation.rotate( next_self_body );
        points.push_back( next_self_pos + rotation );
        for( int i = 5 ; i <= 85 ; i += 5 )
        {
            rcsc::AngleDeg current = wm.self().body() + wm.self().neck();
            rcsc::AngleDeg next_right = next_self_body + rcsc::AngleDeg( i );
            rcsc::AngleDeg next_left = next_self_body + rcsc::AngleDeg( -i );
            rcsc::AngleDeg right_dif = next_right - current;
            rcsc::AngleDeg left_dif = next_left - current;
            if( right_dif.abs() > 50.0 )
            {
                points.push_back( next_self_pos + rotation.rotatedVector( i ) );
            }
            if( left_dif.abs() > 50.0 )
            {
                points.push_back( next_self_pos + rotation.rotatedVector( -i ) );
            }
        }

        int max_pos_count = 0;
        rcsc::Vector2D target = next_self_pos + rotation;
        rcsc::Vector2D point;

        for( std::vector< rcsc::Vector2D >::iterator it = points.begin();
             it != points.end();
             ++it )
        {
            point = (*it);
            if( point.x < -52.0 )
                point.x = -52.0;
            else if( point.x > 52.0 )
                point.x = 52.0;
            if( point.y < -34.0 )
                point.y = -34.0;
            else if( point.y > 34.0 )
                point.y = 34.0;

            int count = wm.getPointCount( point, 15 );
            if( count > max_pos_count )
            {
                max_pos_count = count;
                target = point;
            }
        }
        rcsc::Vector2D rpos = target - next_self_pos;
        rcsc::AngleDeg angle = rpos.th() - ( next_self_body + wm.self().neck() );
        agent->debugClient().addMessage( "LkPntCnt%d(%f,%f)", max_pos_count, target.x, target.y);
        agent->debugClient().addCircle( target, 0.2 );
        agent->doTurnNeck( angle );
/*
        int max_dir_count = 0;
        rcsc::AngleDeg search_angle = next_self_body;
        for( rcsc::AngleDeg angle = -90.0; angle.degree() <= 90.0; angle += 10.0 )
        {
            const rcsc::AngleDeg target_angle = next_self_body + angle;
            if( wm.dirCount( target_angle ) > max_dir_count )
            {
                max_dir_count = wm.dirCount( target_angle );
                search_angle = target_angle;
            }
        }

        agent->doTurnNeck( search_angle - ( wm.self().neck() + next_self_body ) );
*/
    }

    return true;
}

/*-------------------------------------------------------------------*/
/*!

*/
/*-------------------------------------------------------------------*/

bool 
Opuci_Neck::exewithmark( rcsc::PlayerAgent *agent, int unum2Mark )
{
    const rcsc::WorldModel & wm = agent->world();
    const rcsc::Vector2D next_ball_pos = wm.ball().pos() + wm.ball().vel();
    const rcsc::Vector2D next_self_pos = agent->effector().queuedNextSelfPos();
    const rcsc::AngleDeg next_self_body = agent->effector().queuedNextSelfBody();
    agent->debugClient().addMessage( "NeckMark" );
    if( wm.ball().posCount() > 2 )
    {
        agent->debugClient().addMessage( "LookBall" );
        lookBall( agent );
    }
    else if( unum2Mark != -1 && wm.opponent( unum2Mark )
             && wm.opponent( unum2Mark )->posCount() > 2
             && wm.getPointCount( wm.opponent( unum2Mark )->pos(), 15.0 ) > 2)
    {
        agent->debugClient().addMessage( "LookMark%d", unum2Mark );
        agent->doTurnNeck( ( wm.opponent( unum2Mark )->pos() - next_self_pos ).th() - ( wm.self().neck() + next_self_body ) );
    }
    else
    {
        std::vector< rcsc::Vector2D > points;
        rcsc::Vector2D rotation( 10, 0 );
        rotation.rotate( next_self_body );
        for( int i = 5 ; i <= 85 ; i += 5 )
        {
            rcsc::AngleDeg current = wm.self().body() + wm.self().neck();
            rcsc::AngleDeg next_right = next_self_body + rcsc::AngleDeg( i );
            rcsc::AngleDeg next_left = next_self_body + rcsc::AngleDeg( -i );
            rcsc::AngleDeg right_dif = next_right - current;
            rcsc::AngleDeg left_dif = next_left - current;
            if( right_dif.abs() > 50.0 )
            {
                points.push_back( next_self_pos + rotation.rotatedVector( i ) );
            }
            if( left_dif.abs() > 50.0 )
            {
                points.push_back( next_self_pos + rotation.rotatedVector( -i ) );
            }
        }

        int max_pos_count = 0;
        rcsc::Vector2D target = next_self_pos + rotation;
        rcsc::Vector2D point;
        for( std::vector< rcsc::Vector2D >::iterator it = points.begin();
             it != points.end();
             ++it )
        {
            point = (*it);
            if( point.x < -52.0 )
                point.x = -52.0;
            else if( point.x > 52.0 )
                point.x = 52.0;
            if( point.y < -34.0 )
                point.y = -34.0;
            else if( point.y > 34.0 )
                point.y = 34.0;
                
            int count = wm.getPointCount( point, 15 );
            if( count > max_pos_count )
            {
                max_pos_count = count;
                target = point;
            }
        }
        rcsc::Vector2D rpos = target - next_self_pos;
        rcsc::AngleDeg angle = rpos.th() - ( next_self_body + wm.self().neck() );
        agent->debugClient().addMessage( "LkPntCnt%d(%f,%f)", max_pos_count, target.x, target.y);
        agent->debugClient().addCircle( target, 0.2 );
        agent->doTurnNeck( angle );
    }

    return true;
}

/*-------------------------------------------------------------------*/
/*!

*/
/*-------------------------------------------------------------------*/

bool 
Opuci_Neck::lookBallAnd2Mates( rcsc::PlayerAgent *agent, int unumMate1, int unumMate2 )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: Opuci_Neck::lookBallAnd2Mates"
                        ,__FILE__, __LINE__ );

    const rcsc::WorldModel & wm = agent->world();
    const rcsc::Vector2D next_ball_pos = wm.ball().pos() + wm.ball().vel();
    const rcsc::Vector2D next_self_pos = agent->effector().queuedNextSelfPos();
    const rcsc::AngleDeg next_self_body = agent->effector().queuedNextSelfBody();
    agent->debugClient().addMessage( "NeckBMM" );
    if( wm.ball().posCount() > 3 )
    {
        agent->debugClient().addMessage( "LookBall" );
        agent->doTurnNeck( ( next_ball_pos - next_self_pos ).th() - ( wm.self().neck() + next_self_body ) );
    }
    else if( unumMate1 != -1 && wm.teammate( unumMate1 )
             && wm.teammate( unumMate1 )->posCount() > 2
             && wm.getPointCount( wm.teammate( unumMate1 )->pos(), 15.0 ) > 2)
    {
        agent->debugClient().addMessage( "LookMark%d", unumMate1 );
        agent->debugClient().addCircle( wm.teammate( unumMate1 )->pos(), 0.2 );
        agent->doTurnNeck( ( wm.teammate( unumMate1 )->pos() - next_self_pos ).th() - ( wm.self().neck() + next_self_body ) );
    }
    else if( unumMate2 != -1 && wm.teammate( unumMate2 )
             && wm.teammate( unumMate2 )->posCount() > 2
             && wm.getPointCount( wm.teammate( unumMate2 )->pos(), 15.0 ) > 2)
    {
        agent->debugClient().addMessage( "LookMark%d", unumMate2 );
        agent->debugClient().addCircle( wm.teammate( unumMate2 )->pos(), 0.2 );
        agent->doTurnNeck( ( wm.teammate( unumMate2 )->pos() - next_self_pos ).th() - ( wm.self().neck() + next_self_body ) );
    }
    else
    {
        std::vector< rcsc::Vector2D > points;
        rcsc::Vector2D rotation( 10, 0 );
        rotation.rotate( next_self_body );
        points.push_back( next_self_pos + rotation );
        for( int i = 5 ; i <= 85 ; i += 5 )
        {
            if( std::fabs( wm.self().neck().degree() - (double)i ) > 50.0 )
                points.push_back( next_self_pos + rotation.rotatedVector( i ) );

            if( std::fabs( wm.self().neck().degree() + (double)i ) > 50.0 )
                points.push_back( next_self_pos + rotation.rotatedVector( -i ) );
        }

        int max_pos_count = 0;
        rcsc::Vector2D target = next_self_pos + rotation;
        rcsc::Vector2D point;

        for( std::vector< rcsc::Vector2D >::iterator it = points.begin();
             it != points.end();
             ++it )
        {
            point = (*it);
            if( point.x < -52.0 )
                point.x = -52.0;
            else if( point.x > 52.0 )
                point.x = 52.0;
            if( point.y < -34.0 )
                point.y = -34.0;
            else if( point.y > 34.0 )
                point.y = 34.0;

            int count = wm.getPointCount( point, 15 );
            if( count > max_pos_count )
            {
                max_pos_count = count;
                target = point;
            }
        }
        rcsc::Vector2D rpos = target - next_self_pos;
        rcsc::AngleDeg angle = rpos.th() - ( next_self_body + wm.self().neck() );
        agent->debugClient().addMessage( "LkPntCnt%d(%f,%f)", max_pos_count, target.x, target.y);
        agent->debugClient().addCircle( target, 0.2 );
        agent->doTurnNeck( angle );
    }

    return true;
}

/*-------------------------------------------------------------------*/
/*!

*/
/*-------------------------------------------------------------------*/

bool 
Opuci_Neck::lookBall( rcsc::PlayerAgent * agent )
{
    const rcsc::WorldModel & wm = agent->world();
    rcsc::Vector2D next_ball_pos = wm.ball().pos() + wm.ball().vel();
    rcsc::Vector2D next_self_pos = agent->effector().queuedNextSelfPos();
    rcsc::AngleDeg next_self_body = agent->effector().queuedNextSelfBody();
    rcsc::Vector2D rpos = next_ball_pos - next_self_pos;
    rcsc::AngleDeg next_default = wm.self().neck() + next_self_body;

    if( wm.ball().posValid() )
    {
        agent->doTurnNeck( rpos.th() - next_default );
    }
    else
    {
        agent->debugClient().addMessage( "LostBall" );
        std::vector< rcsc::Vector2D > points;
        rcsc::Vector2D rotation( 10, 0 );
        rotation.rotate( next_self_body );
        points.push_back( next_self_pos + rotation );
        for( int i = 5 ; i <= 85 ; i += 5 )
        {
            rcsc::AngleDeg current = wm.self().body() + wm.self().neck();
            rcsc::AngleDeg next_right = next_self_body + rcsc::AngleDeg( i );
            rcsc::AngleDeg next_left = next_self_body + rcsc::AngleDeg( -i );
            rcsc::AngleDeg right_dif = next_right - current;
            rcsc::AngleDeg left_dif = next_left - current;
            if( right_dif.abs() > 50.0 )
            {
                points.push_back( next_self_pos + rotation.rotatedVector( i ) );
            }
            if( left_dif.abs() > 50.0 )
            {
                points.push_back( next_self_pos + rotation.rotatedVector( -i ) );
            }
        }

        int max_pos_count = 0;
        rcsc::Vector2D target = next_self_pos + rotation;
        rcsc::Vector2D point;

        for( std::vector< rcsc::Vector2D >::iterator it = points.begin();
             it != points.end();
             ++it )
        {
            point = (*it);
            if( point.x < -52.0 )
                point.x = -52.0;
            else if( point.x > 52.0 )
                point.x = 52.0;
            if( point.y < -34.0 )
                point.y = -34.0;
            else if( point.y > 34.0 )
                point.y = 34.0;

            int count = wm.getPointCount( point, 15 );
            if( count > max_pos_count )
            {
                max_pos_count = count;
                target = point;
            }
        }
        rcsc::Vector2D rpos = target - next_self_pos;
        rcsc::AngleDeg angle = rpos.th() - ( next_self_body + wm.self().neck() );
        agent->debugClient().addMessage( "LkPntCnt%d(%f,%f)", max_pos_count, target.x, target.y);
        agent->debugClient().addCircle( target, 0.2 );
        agent->doTurnNeck( angle );        
    }

    return true;
}

/*-------------------------------------------------------------------*/
/*!

*/
/*-------------------------------------------------------------------*/

bool
Opuci_Neck::lookAtPassReceiver( rcsc::PlayerAgent * agent, int passMate )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: Opuci_Neck::lookAtPassReceiver"
                        ,__FILE__, __LINE__ );

    const rcsc::WorldModel & wm = agent->world();
    bool done = false;

    rcsc::Vector2D target;
    
    if( !wm.teammate( passMate ) )
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: I don't know where pass receiver %d is. move to Execute."
                            ,__FILE__, __LINE__ );
        execute( agent );
        return done;
    }

    agent->debugClient().addMessage( "LkMate%d", passMate );

    
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: Look at (%f, %f)."
                        ,__FILE__, __LINE__, wm.teammate(passMate)->pos().x, wm.teammate(passMate)->pos().y );
    agent->setNeckAction( new rcsc::Neck_TurnToPoint( wm.teammate( passMate )->pos() ) );
    done = true;

    return done;
}

/*-------------------------------------------------------------------*/
/*!

*/
/*-------------------------------------------------------------------*/
