#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "opuci_one_step_kick.h"
#include "opuci_kick.h"

#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>

#include <rcsc/geom/angle_deg.h>
#include <rcsc/geom/line_2d.h>
#include <rcsc/geom/circle_2d.h>

/*-------------------------------------------------------------------*/
/*!

 */
bool
Opuci_OneStepKick::execute( rcsc::PlayerAgent * agent )
{
  rcsc::dlog.addText( rcsc::Logger::KICK,
		      "%s:%d:Opuci_Kick"
		      ,__FILE__, __LINE__ );

  const rcsc::WorldModel & wm = agent->world();
  const rcsc::ServerParam & SP = rcsc::ServerParam::i();

  if( wm.self().pos().dist( wm.ball().pos() ) > wm.self().playerType().kickableArea() )
    {
      return false;
    }

  if( M_last_speed <= 0.0 )
    {
      M_last_speed = 0.01;
    }

  double dist_to_target_point = ( M_kick_point - wm.ball().pos() ).r();
  double first_speed = M_last_speed;

  while( dist_to_target_point > 0.0
	 && first_speed < SP.ballSpeedMax() )
    {
      first_speed /= SP.ballDecay();
      dist_to_target_point -= first_speed;
    }

  rcsc::Vector2D first_vel( first_speed * ( M_kick_point - wm.ball().pos() ).th().cos(),
			    first_speed * ( M_kick_point - wm.ball().pos() ).th().sin() );
  rcsc::Vector2D accel = first_vel - wm.ball().vel();
  double kick_power = accel.r() / wm.self().kickRate();
  if( kick_power < SP.maxPower() )
    {
      agent->doKick( kick_power, accel.th() - wm.self().body() );
      agent->debugClient().setTarget( M_kick_point );
      agent->debugClient().addMessage( "opuciKick:%2f", kick_power );
    }
  else
    {
      Opuci_Kick( M_kick_point ).execute( agent );
    }
  return true;
}
