#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "opuci_other_pass.h"
#include "opuci_one_step_kick.h"

#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>

#include <rcsc/geom/vector_2d.h>
#include <rcsc/geom/ray_2d.h>
#include <rcsc/player/say_message_builder.h>
#include <rcsc/action/body_smart_kick.h>
/*-------------------------------------------------------------------*/
/*!

 */
bool
Opuci_OtherPass::execute( rcsc::PlayerAgent * agent )
{

    const rcsc::WorldModel & wm = agent->world();
    if( !wm.self().isKickable() )
    {
        return false;
    }
    rcsc::Vector2D pass_target;
    double first_speed;

    rcsc::PlayerPtrCont::const_iterator end = wm.teammatesFromSelf().end();
    for( rcsc::PlayerPtrCont::const_iterator it = wm.teammatesFromSelf().begin();
         it != end;
         ++it )
    {
        // まず前方の味方のみを対象
        if( (*it)->pos().x < wm.self().pos().x )
            continue;

        // 近すぎるのも除外
        if( wm.self().pos().dist( (*it)->pos() ) < 3.0 )
            continue;

        // posCount が大きいものも除外 とりあえず４以上
        if( (*it)->posCount() > 3 )
            continue;

        const rcsc::PlayerObject * receiver = (*it);
        if( search( agent, receiver, pass_target, first_speed, false ) )
        {
            agent->debugClient().setTarget( pass_target );
            if( rcsc::Body_SmartKick( pass_target, first_speed, first_speed * 0.8, 3 ).execute( agent ) )
            {
                agent->debugClient().addMessage( "Target%d", receiver->unum() );
                agent->addSayMessage( new rcsc::PassMessage( receiver->unum(), pass_target,
                                                             agent->effector().queuedNextBallPos(),
                                                             agent->effector().queuedNextBallVel() ) );
            }            
            return true;
        }
    }
    for( rcsc::PlayerPtrCont::const_iterator it = wm.teammatesFromSelf().begin();
         it != end;
         ++it )
    {
        // 後方の味方のみを対象
        if( (*it)->pos().x > wm.self().pos().x )
            continue;

        // 近すぎるのも除外
        if( wm.self().pos().dist( (*it)->pos() ) < 3.0 )
            continue;

        // posCount が大きいものも除外 とりあえず４以上
        if( (*it)->posCount() > 3 )
            continue;

        const rcsc::PlayerObject * receiver = (*it);
        if( search( agent, receiver, pass_target, first_speed, false ) )
        {
            agent->debugClient().addMessage( "Target%d", receiver->unum() );
            agent->debugClient().setTarget( pass_target );
            if( rcsc::Body_SmartKick( pass_target, first_speed, first_speed * 0.8, 3 ).execute( agent ) )
            {
                agent->debugClient().addMessage( "Target%d", receiver->unum() );
                agent->addSayMessage( new rcsc::PassMessage( receiver->unum(), pass_target,
                                                             agent->effector().queuedNextBallPos(),
                                                             agent->effector().queuedNextBallVel() ) );
            }            
            return true;
        }
    }
    
    
    

    return false;
}
/*-------------------------------------------------------------------*/
/*!

 */
/*-------------------------------------------------------------------*/
bool 
Opuci_OtherPass::search( rcsc::PlayerAgent * agent, const rcsc::PlayerObject * receiver, 
                         rcsc::Vector2D & target_pos, double & kick_power, rcsc::AngleDeg & kick_angle,
                         bool force )
{
    const rcsc::WorldModel & wm = agent->world();
    const rcsc::ServerParam & sp = rcsc::ServerParam::i();


    if( receiver->pos().x > wm.offsideLineX() )
    {
        return false;
    }
    if( receiver->pos().x < wm.self().pos().x - 5 )
    {
        return false;
    }
    if( receiver->pos().dist( wm.self().pos() ) < 5 )
    {
        return false;
    }
    if( receiver->posCount() > 3 )
    {
        return false;
    }


    
    rcsc::Vector2D tmp_target;
    rcsc::Vector2D mate_dash;
    int cycle_margin = 0;
    rcsc::AngleDeg tmp_angle;
    double tmp_power = 0;

    for( int i = -30; i <= 30; i += 10 )
    {
        rcsc::AngleDeg mate_angle = receiver->body() + rcsc::AngleDeg( i );
        rcsc::Vector2D tmp_mate_pos = receiver->pos();
        rcsc::Vector2D tmp_mate_vel = receiver->vel();
        mate_dash.setPolar( receiver->playerTypePtr()->dashPowerRate() * sp.maxPower() * 1.0, mate_angle );
        int mate_turn_cycle = 0;
        int mate_dash_cycle = 0;
        if( i != 0 )
        {
            mate_turn_cycle = 1;
            tmp_mate_pos += tmp_mate_vel;
            tmp_mate_vel *= receiver->playerTypePtr()->playerDecay();
        }

        for( int j = 1; j <= 10; j++ )
        {
            mate_dash_cycle++;
            tmp_mate_vel += mate_dash;
            tmp_mate_pos += tmp_mate_vel;
            if( tmp_mate_pos.x < wm.self().pos().x 
                || tmp_mate_pos.x < receiver->pos().x - 3 )
            {
                break;
            }
            if( tmp_mate_pos.x > 52.0 || tmp_mate_pos.y > 33.0
                || tmp_mate_pos.y < -33.0 )
                break;

            rcsc::Vector2D ball_to_mate = tmp_mate_pos - wm.ball().pos();
            double ball_first_speed = rcsc::calc_first_term_geom_series( ball_to_mate.r(), 
                                                                         sp.ballDecay(), 
                                                                         mate_turn_cycle + mate_dash_cycle + 1 );
            if( ball_first_speed > sp.ballSpeedMax() )
            {
                ball_first_speed = sp.ballSpeedMax();
            }
            rcsc::Vector2D ball_vel;
            ball_vel.setPolar( ball_first_speed, ball_to_mate.th() );
            rcsc::Vector2D accel = ball_vel - wm.ball().vel();
            double power = accel.r() / wm.self().kickRate();
            rcsc::AngleDeg angle = accel.th();
            if( power > sp.maxPower() )
            {
                power = sp.maxPower();
                rcsc::Vector2D next_ball_pos = wm.ball().pos() + wm.ball().vel();
                rcsc::Circle2D kick_power_circle( next_ball_pos, power * wm.self().kickRate() );
                rcsc::Line2D ball_line( wm.ball().pos(), tmp_mate_pos );
                rcsc::Vector2D kick_target, sol1, sol2;
                int intersection = kick_power_circle.intersection( ball_line, &sol1, &sol2 );
                if( intersection < 1 )
                {
                    kick_target = tmp_mate_pos;
                }
                else if( intersection == 1 )
                {
                    kick_target = sol1;
                }
                else
                {
                    if( tmp_mate_pos.dist2( sol1 ) < tmp_mate_pos.dist2( sol2 ) )
                    {
                        kick_target = sol1;
                    }
                    else
                    {
                        kick_target = sol2;
                    }
                }
                angle = ( kick_target - next_ball_pos ).th();
            }
            accel.setPolar( wm.self().kickRate() * power, angle );
            ball_vel = wm.ball().vel() + accel;
            ball_first_speed = ball_vel.r();
            
            bool success = true;
            int opp_min_cycle = 100;
            rcsc::Segment2D pass_seg( wm.ball().pos(), tmp_mate_pos );
            const rcsc::PlayerPtrCont::const_iterator opp_end = wm.opponentsFromSelf().end();
            for( rcsc::PlayerPtrCont::const_iterator it = wm.opponentsFromSelf().begin();
                 it != opp_end;
                 ++it )
            {
                if( (*it)->isTackling() )
                    continue;
                
                rcsc::Vector2D inertial_opp_pos = (*it)->playerTypePtr()->inertiaPoint( (*it)->pos(),
                                                                                        (*it)->vel(),
                                                                                        mate_dash_cycle + mate_turn_cycle );
                rcsc::Circle2D opp_area( (*it)->pos(), (*it)->playerTypePtr()->kickableMargin() );
                rcsc::Circle2D opp_area2( inertial_opp_pos, (*it)->playerTypePtr()->kickableMargin() );
                if( opp_area.intersection( pass_seg, NULL, NULL ) > 0
                    || opp_area2.intersection( pass_seg, NULL, NULL ) > 0 )
                {
                    success = false;
                    break;
                }
                double opp_dist = pass_seg.dist( inertial_opp_pos );
                opp_dist -= (*it)->playerTypePtr()->kickableMargin();
                if( force )
                {

                }
                else if( opp_dist <= 0 )
                {
                    success = false;
                    break;
                }

                int opp_dash = (*it)->playerTypePtr()->cyclesToReachDistance( opp_dist );
                int opp_turn = 0;
                int opp_reach_cycle = opp_dash + opp_turn;
                
                rcsc::Vector2D opp_target = pass_seg.nearestPoint( inertial_opp_pos );
                double ball_dist = wm.ball().pos().dist( opp_target );
                int ball_through_cycle = rcsc::calc_length_geom_series( ball_first_speed, 
                                                                        ball_dist,
                                                                        sp.ballDecay() );
                if( force )
                {

                }
                else if( ball_through_cycle < 0 
                    || ball_through_cycle >= opp_reach_cycle - 1 )
                {
                    success = false;
                    break;
                }
                if( opp_reach_cycle < opp_min_cycle )
                {
                    opp_min_cycle = opp_reach_cycle;
                }
            }//end for opps
            if( success 
                && opp_min_cycle > cycle_margin )
            {
                cycle_margin = opp_min_cycle;
                tmp_target = tmp_mate_pos;
                tmp_power = power;
                tmp_angle = angle;
            }

            tmp_mate_vel *= receiver->playerTypePtr()->playerDecay();
        }//end for j
    }//end for i 

    if( cycle_margin > 0 )
    {
        agent->debugClient().addMessage( "CanOtherPass" );
        if( force )
        {
            agent->debugClient().addMessage( "Force" );
        }
        target_pos = tmp_target;
        kick_power = tmp_power;
        kick_angle = tmp_angle - wm.self().body();
        return true;
    }
    
    return false;
}
/*-------------------------------------------------------------------*/
/*!

 */
/*-------------------------------------------------------------------*/
bool 
Opuci_OtherPass::search( rcsc::PlayerAgent * agent, const rcsc::PlayerObject * receiver, 
                         rcsc::Vector2D & target_pos, double & first_speed, bool force )
{
    const rcsc::WorldModel & wm = agent->world();
    const rcsc::ServerParam & sp = rcsc::ServerParam::i();


    if( receiver->pos().x > wm.offsideLineX() )
    {
        return false;
    }
    if( receiver->pos().x < wm.self().pos().x - 5 )
    {
        return false;
    }
    if( receiver->pos().dist( wm.self().pos() ) < 7 )
    {
        return false;
    }
/*
    if( receiver->posCount() > 3 )
    {
        return false;
    }
*/
    

    
    rcsc::Vector2D tmp_target;
    rcsc::Vector2D mate_dash;
    int cycle_margin = 0;
    double tmp_first_speed = 0;
    double min_speed = 2.5;
    if( receiver->pos().dist( wm.ball().pos() ) < 10 )
    {
        min_speed = 2.0;
    }
    else if( receiver->pos().dist( wm.ball().pos() ) < 15 )
    {
        min_speed = 2.25;
    }
    int min = -30;
    int max = 30;
    if( wm.ball().pos().x > 30 )
    {
        min = - 170;
        max = 180;
    }
    for( int i = -30; i <= 30; i += 10 )
    {
        rcsc::AngleDeg mate_angle = receiver->body() + rcsc::AngleDeg( i );
        rcsc::Vector2D tmp_mate_pos = receiver->pos();
        rcsc::Vector2D tmp_mate_vel = receiver->vel();
        mate_dash.setPolar( receiver->playerTypePtr()->dashPowerRate() * sp.maxPower() * 1.0, mate_angle );
        int mate_turn_cycle = 0;
        int mate_dash_cycle = 0;
        if( i != 0 )
        {
            mate_turn_cycle = 1;
            tmp_mate_pos += tmp_mate_vel;
            tmp_mate_vel *= receiver->playerTypePtr()->playerDecay();
        }

        for( int j = 1; j <= 10; j++ )
        {
            mate_dash_cycle++;
            tmp_mate_vel += mate_dash;
            tmp_mate_pos += tmp_mate_vel;
            if( tmp_mate_pos.x < wm.self().pos().x 
                || tmp_mate_pos.x < receiver->pos().x - 3 )
            {
                break;
            }
            if( tmp_mate_pos.x > 52.0 || tmp_mate_pos.y > 33.0
                || tmp_mate_pos.y < -33.0 )
            {
                break;
            }
            rcsc::Vector2D move = tmp_mate_pos - receiver->pos();
            rcsc::Vector2D ball_to_mate = tmp_mate_pos - wm.ball().pos();
            if( ball_to_mate.r() < move.r() * 1.5 )
            {
                break;
            }
            double dist = ball_to_mate.r() - receiver->playerTypePtr()->kickableMargin();
            if( dist <= 1 )
            {
                break;
            }
            double ball_first_speed = rcsc::calc_first_term_geom_series( ball_to_mate.r(), 
                                                                         sp.ballDecay(), 
                                                                         mate_turn_cycle + mate_dash_cycle + 1 );
            if( ball_first_speed > sp.ballSpeedMax() )
            {
                ball_first_speed = sp.ballSpeedMax();
            }
            if( ball_first_speed < min_speed )
            {
                ball_first_speed = min_speed;
            }
            rcsc::Vector2D ball_vel;
            ball_vel.setPolar( ball_first_speed, ball_to_mate.th() );
            
            bool success = true;
            int opp_min_cycle = 100;
            rcsc::Segment2D pass_seg( wm.ball().pos(), tmp_mate_pos );
            const rcsc::PlayerPtrCont::const_iterator opp_end = wm.opponentsFromSelf().end();
            for( rcsc::PlayerPtrCont::const_iterator it = wm.opponentsFromSelf().begin();
                 it != opp_end;
                 ++it )
            {
                if( (*it)->isTackling() )
                    continue;
                
                rcsc::Vector2D inertial_opp_pos = (*it)->playerTypePtr()->inertiaPoint( (*it)->pos(),
                                                                                        (*it)->vel(),
                                                                                        mate_dash_cycle + mate_turn_cycle );
                rcsc::Circle2D opp_area( (*it)->pos(), (*it)->playerTypePtr()->kickableMargin() );
                rcsc::Circle2D opp_area2( inertial_opp_pos, (*it)->playerTypePtr()->kickableMargin() );
                if( opp_area.intersection( pass_seg, NULL, NULL ) > 0
                    || opp_area2.intersection( pass_seg, NULL, NULL ) > 0 )
                {
                    success = false;
                    break;
                }
                double opp_dist = pass_seg.dist( inertial_opp_pos );
                opp_dist -= (*it)->playerTypePtr()->kickableMargin();
                if( force )
                {

                }
                else if( opp_dist <= 0 )
                {
                    success = false;
                    break;
                }

                int opp_dash = (*it)->playerTypePtr()->cyclesToReachDistance( opp_dist );
                int opp_turn = 0;
                int opp_reach_cycle = opp_dash + opp_turn;
                
                rcsc::Vector2D opp_target = pass_seg.nearestPoint( inertial_opp_pos );
                double ball_dist = wm.ball().pos().dist( opp_target );
                int ball_through_cycle = rcsc::calc_length_geom_series( ball_first_speed, 
                                                                        ball_dist,
                                                                        sp.ballDecay() );
                if( force )
                {

                }
                else if( ball_through_cycle < 0 
                    || ball_through_cycle >= opp_reach_cycle  )
                {
                    success = false;
                    break;
                }
                if( opp_reach_cycle < opp_min_cycle )
                {
                    opp_min_cycle = opp_reach_cycle;
                }
            }//end for opps
            if( success 
                && opp_min_cycle > cycle_margin )
            {
                cycle_margin = opp_min_cycle;
                tmp_target = tmp_mate_pos;
                tmp_first_speed = ball_first_speed;
            }

            tmp_mate_vel *= receiver->playerTypePtr()->playerDecay();
        }//end for j
    }//end for i 

    if( cycle_margin > 0 )
    {
        agent->debugClient().addMessage( "CanOtherPass" );
        if( force )
        {
            agent->debugClient().addMessage( "Force" );
        }
        target_pos = tmp_target;
        first_speed = tmp_first_speed;
        agent->debugClient().addMessage( "Speed%.1f", first_speed );
        return true;
    }
    
    return false;
}
/*-------------------------------------------------------------------*/
/*!

 */
/*-------------------------------------------------------------------*/


