#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "opuci_pass.h"
#include "opuci_one_step_kick.h"

#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>

#include <rcsc/geom/vector_2d.h>

/*-------------------------------------------------------------------*/
/*!

 */
bool
Opuci_Pass::execute( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::PASS,
                        "%s:%d:Opuci_Pass"
                        ,__FILE__, __LINE__ );

    const rcsc::WorldModel & wm = agent->world();
    if( wm.self().pos().dist( wm.ball().pos() ) > wm.self().playerType().kickableArea() )
    {
        return false;
    }
    
    const rcsc::Vector2D goal_pos( 50.0, 0.0 );
    rcsc::Vector2D target_point( -1000.0, 0.0 );
    std::vector<rcsc::Vector2D> target;
    
    bool exist_teammate_to_pass = false;
    bool exist_opponent_to_pass = false;
    for( int num = 2; num <= 11; num++ )
    {
        if( wm.teammate( num ) 
            && wm.self().unum() != num )
        {
            if( wm.teammate( num )->posCount() < 3
                && wm.teammate( num )->pos().x < wm.offsideLineX() )
            {
                exist_opponent_to_pass = false;
                const double dist = wm.self().pos().dist( wm.teammate( num )->pos() ) + 2.0;
                const rcsc::AngleDeg angle_to_mate = ( wm.teammate( num )->pos() - wm.self().pos() ).th();
                const rcsc::Sector2D sector( wm.self().pos(), wm.self().playerType().kickableArea(), dist,
                                             angle_to_mate - 20.0, angle_to_mate + 20.0 );
                for( int opp_num = 1; opp_num <= 11; opp_num++ )
                {
                    if( wm.opponent( opp_num ) )
                    {
                        if( sector.contains( wm.opponent( opp_num )->pos() ) )
                        {
                            exist_opponent_to_pass = true;
                        }
                    }
                }
                if( ! exist_opponent_to_pass
                    && wm.teammate( num )->pos().x > wm.self().pos().x )
                {
                    target.push_back( wm.teammate( num )->pos() );
                    exist_teammate_to_pass = true;
                }
            }
        }
    }
    
    for( std::vector<rcsc::Vector2D>::iterator it = target.begin();
         it != target.end(); ++it )
    {
        if( goal_pos.dist( (*it) ) < goal_pos.dist( target_point ) )
        {
            target_point = (*it);
        }
    }

    if( exist_teammate_to_pass )
    {
        Opuci_OneStepKick( target_point, 1.0 ).execute( agent );
    }
    else
    {
        rcsc::AngleDeg dist_angle = 0.0;
        std::list<double> angle;
        angle.push_back( -60.0 );
        angle.push_back( 60.0 );
        for( int unum = 1; unum <= 11; unum++ )
        {
            if( wm.opponent( unum ) )
            {
                if( wm.self().pos().dist( wm.opponent( unum )->pos() ) < 30.0
                    && wm.opponent( unum )->pos().x > wm.self().pos().x )
                {
                    angle.push_back( ( wm.opponent( unum )->pos() - wm.self().pos() ).th().degree() );
                }
            }
        }
        angle.sort();
        int size = angle.size();
        rcsc::AngleDeg target_angle = 0.0;
        for( int i = 0; i < size - 1; i++ )
        {
            rcsc::AngleDeg start_angle = angle.front();
            angle.pop_front();
            rcsc::AngleDeg last_angle = angle.front();
            if( last_angle.degree() - start_angle.degree() > dist_angle.degree() )
            {
                dist_angle = last_angle - start_angle;
                target_angle = ( last_angle.degree() + start_angle.degree() ) / 2.0;
            }
        }
        target_point = rcsc::Vector2D( wm.self().pos().x + 10.0 * target_angle.cos(),
                                       wm.self().pos().y + 10.0 * target_angle.sin() );
        Opuci_OneStepKick( target_point ).execute( agent );
        agent->debugClient().addMessage( "YakekusoKick" );
    }
    agent->debugClient().setTarget( target_point );


/*
  rcsc::Vector2D target_point( 0.0, 100.0 );
  bool exist_teammate = false;
  if( wm.self().pos().y > 0.0 )
    {
      target_point.y *= -1.0;
    }

  for( int num = 2; num <= 11; num++ )
    {
      if( wm.teammate( num ) && wm.self().unum() != num )
	{
	  if( wm.teammate( num )->pos().x > wm.self().pos().x
	      && fabs( wm.teammate( num )->pos().y - wm.self().pos().y ) < fabs( target_point.y - wm.self().pos().y ) )
	    {
	      target_point = wm.teammate( num )->pos();
	      exist_teammate = true;
	    }
	}
    }

  if( ! exist_teammate )
    {
      agent->debugClient().addMessage("noReceiver");
      return false;
    }
*/

  return true;
}
