#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "opuci_search_ball.h"

#include <rcsc/action/view_synch.h>
#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>

/*-------------------------------------------------------------------*/
/*!

 */
bool
Opuci_SearchBall::execute( rcsc::PlayerAgent * agent )
{
    const rcsc::WorldModel & wm = agent->world();

    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: search ball"
                        ,__FILE__, __LINE__ );

    if( wm.ball().posCount() < 1 )
    {
        agent->debugClient().addMessage( "DontSearchBall" );
        return false;
    }

/*
    if( wm.self().vel().r() > 0.1 )
    {
        double self_vel = wm.self().vel().r();
        if( ( wm.self().body() - wm.self().vel().th() ).abs() > 90.0 )
	{
            self_vel *= -1.0;
	}

        agent->doDash( - self_vel / ( wm.self().playerType().effortMax() * wm.self().playerType().dashPowerRate() ) );
        agent->doTurnNeck( - wm.self().neck() );
        agent->debugClient().addMessage( "opuciSearchBallStop" );
        return true;
    }
*/
    agent->setViewAction( new rcsc::View_Synch() );

    if( wm.self().neck().degree() > -30.0
        && wm.self().neck().degree() < 30.0 )
    {
        agent->doTurnNeck( 60.0 );
        agent->doTurn( 0 );
    }
    else if( wm.self().neck().degree() >= 30.0 )
    {
        agent->doTurnNeck( -120.0 );
        agent->doTurn( 0 );
    }
    else
    {
        agent->doTurnNeck( - wm.self().neck() );
        agent->doTurn( 180.0 );
    }
    agent->debugClient().addMessage( "opuciSearchBall" );
    return true;
}
