#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "opuci_self_pass.h"
#include "opuci_one_step_kick.h"
#include "opuci_intention_dribble.h"

#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>

#include <rcsc/geom/vector_2d.h>
#include <rcsc/geom/ray_2d.h>
#include <rcsc/player/say_message_builder.h>
#include <rcsc/action/body_smart_kick.h>
#include <rcsc/action/body_kick_one_step.h>
/*-------------------------------------------------------------------*/
/*!

 */
/*-------------------------------------------------------------------*/
bool
Opuci_SelfPass::execute( rcsc::PlayerAgent * agent )
{
    //old execute
    const rcsc::WorldModel & wm = agent->world();
    const rcsc::ServerParam & sp = rcsc::ServerParam::i();

    int turn_cycle = 1;
    int kick_cycle = 1;
    
    double degree = M_angle.degree();
    if( wm.dirCount( M_angle ) * M_dash_cycle > 10 )
    {
        return false;
    }
    double moment = degree - wm.self().body().degree();
    if( fabs( moment ) < 5 )
    {
        turn_cycle = 0;
    }
    if( wm.self().canTurn( moment ) )
    {
        int total_cycle = kick_cycle + turn_cycle + M_dash_cycle;
        rcsc::Vector2D moved_pos = wm.self().pos();
        rcsc::Vector2D inertial_move = wm.self().vel();
      
        double stamina = wm.self().stamina();
        double effort = wm.self().effort();
        double recovery = wm.self().recovery();
        double power = 100;
      
        for( int i = 0; i < (kick_cycle + turn_cycle); i++ )
	{
            moved_pos += inertial_move;
            inertial_move *= wm.self().playerType().playerDecay();
            stamina += recovery * wm.self().playerType().staminaIncMax();
            if( stamina > sp.staminaMax() )
                stamina = sp.staminaMax();
	}
      
        rcsc::Vector2D dash_move( 1, 0 );
        dash_move.rotate( degree );
        for( int i = 0; i < M_dash_cycle; i++ )
	{
            if( i == 0 )
	    {
                dash_move.setLength( effort * wm.self().playerType().dashPowerRate() * power );
	    }
            else
	    {
                dash_move.setLength( dash_move.r() + effort * wm.self().playerType().dashPowerRate() * power );
	    }
            if( dash_move.r() > wm.self().playerType().playerSpeedMax() )
                dash_move.setLength( wm.self().playerType().playerSpeedMax() );
	  
            rcsc::Vector2D tmp_move = dash_move + inertial_move;
            if( tmp_move.r() > wm.self().playerType().playerSpeedMax() )
                tmp_move.setLength( wm.self().playerType().playerSpeedMax() );
	  
            moved_pos += tmp_move;
          
            stamina -= power;
            if( stamina <= sp.recoverDecThr() * sp.staminaMax() )
	    {
                if( recovery > sp.recoverMin() )
                    recovery -= sp.recoverDec();
                if( recovery < sp.recoverMin() )
                    recovery = sp.recoverMin();
	    }
            if( stamina <= sp.effortDecThr() * sp.staminaMax() )
	    {
                if( effort > wm.self().playerType().effortMin() )
                    effort -= sp.recoverDec();
                if( effort < wm.self().playerType().effortMin() )
                    effort = wm.self().playerType().effortMin();
	    }
            if( stamina >= sp.effortIncThr() * sp.staminaMax() )
	    {
                if( effort < wm.self().playerType().effortMax() )
		{
                    effort += sp.effortInc();
                    if( effort > wm.self().playerType().effortMax() )
                        effort = wm.self().playerType().effortMax();
		}
	    }
            stamina += recovery * wm.self().playerType().staminaIncMax();
            if( stamina > sp.staminaMax() )
                stamina = sp.staminaMax();
	  
            dash_move *= wm.self().playerType().playerDecay();
            inertial_move *= wm.self().playerType().playerDecay();
	}
      
        rcsc::Vector2D ball_margin( wm.self().kickableArea() * 0.5, 0 );
        ball_margin.rotate( degree );
      
        rcsc::Vector2D ball_target = moved_pos + ball_margin;
      
        if( ball_target.absX() > 51
            || ball_target.absY() > 33 )
	{
            agent->debugClient().addMessage( "TargetOB" );
            return false;
	}
      
      
      
        double ball_dist = wm.ball().pos().dist( ball_target );
        double ball_speed = rcsc::calc_first_term_geom_series( ball_dist, sp.ballDecay(), total_cycle );
        rcsc::Vector2D ball_vector( ball_speed, 0 );
        rcsc::Vector2D rpos = ball_target - wm.ball().pos();
        ball_vector.rotate( rpos.th() );
        rcsc::Vector2D accel = ball_vector - wm.ball().vel();
        double kick_power = accel.r() / wm.self().kickRate();
      
        if( kick_power > sp.maxPower() )
	{
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "%s:%d: Not enough power. Stop selfpass."
                                ,__FILE__, __LINE__ );
            return false;
	}
      
        rcsc::Vector2D next_ball_pos = wm.ball().pos() + ball_vector;
        rcsc::Circle2D next_ball_area( next_ball_pos, sp.ballSize() );
      
        rcsc::Vector2D next_self_pos = wm.self().pos() + wm.self().vel();
        rcsc::Circle2D next_self_area( next_self_pos, wm.self().playerTypePtr()->playerSize() + 0.1 );
      
        if( next_self_area.intersection( next_ball_area, NULL, NULL ) > 0 
            || next_self_area.contains( next_ball_pos ) )
	{
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "%s:%d: Ball will collide. Stop selfpass."
                                ,__FILE__, __LINE__ );
            return false;
	}
      
        const rcsc::PlayerPtrCont::const_iterator end = wm.opponentsFromBall().end();
        for( rcsc::PlayerPtrCont::const_iterator it = wm.opponentsFromBall().begin();
             it != end;
             ++it )
	{
            if( (*it)->isTackling() )
                continue;
/*	  
            const rcsc::Vector2D selfToIt = (*it)->pos() - wm.self().pos();
            const rcsc::AngleDeg difAD( selfToIt.th().degree() - M_angle.degree() );
            if( fabs( difAD.tan() ) > 6 )
                continue;  // たぶん抜ける
*/	  
            rcsc::Vector2D inertial_opp_pos = (*it)->playerTypePtr()->inertiaPoint( (*it)->pos(),
                                                                                    (*it)->vel(),
                                                                                    total_cycle );
            double opp_dist = inertial_opp_pos.dist( ball_target );
            opp_dist -= sp.tackleDist();//(*it)->playerTypePtr()->kickableMargin() * 1.5;
            if( opp_dist <= 0 )
	    {
                rcsc::dlog.addText( rcsc::Logger::TEAM,
                                    "%s:%d: Ball will be tackled. Stop selfpass."
                                    ,__FILE__, __LINE__ );
                return false;
	    }
            if( (*it)->playerTypePtr()->cyclesToReachDistance( opp_dist ) <= total_cycle )
	    {
                rcsc::dlog.addText( rcsc::Logger::TEAM,
                                    "%s:%d: Ball will be stolen. Stop selfpass."
                                    ,__FILE__, __LINE__ );
                return false;
	    }
	}
      
        agent->doKick( kick_power, accel.th() - wm.self().body() );
        agent->debugClient().addCircle( ball_target, 0.1 );
        agent->debugClient().addCircle( moved_pos, 1.0 );
      
        agent->setIntention( new Opuci_IntentionDribble( ball_target, M_dash_cycle ) );
      
      
        return true;
      
    }//end if canturn

    
    
    

    return false;
}

/*-------------------------------------------------------------------*/
/*!

 */
/*-------------------------------------------------------------------*/

bool
Opuci_SelfPass::execute( rcsc::PlayerAgent * agent, bool use_turn )
{
    const rcsc::WorldModel & wm = agent->world();
    const rcsc::ServerParam & sp = rcsc::ServerParam::i();
    
    rcsc::Vector2D target_pos;
    rcsc::Vector2D self_pos = wm.self().pos();
    rcsc::Vector2D self_vel = wm.self().vel();
    rcsc::Vector2D self_dash;
    rcsc::AngleDeg angle = wm.self().body();
    int turn = 0;
    int dash = 0;
    if( use_turn )
    {
        //TODO change angle
        rcsc::AngleDeg angle_dif = M_angle - wm.self().body();
        if( angle_dif.abs() < 5 )
        {
            turn = 0;
            angle = wm.self().body();
        }
        else if( wm.self().canTurn( angle_dif.degree() ) )
        {
            turn++;
            angle = M_angle;
        }
        else
        {
            return false;
        }
    }
    else if( angle.abs() > 45 )
    {
        return false;
    }


    int max_cycle = 15;
    if( wm.ball().pos().x > 47.0 && std::fabs( wm.self().body().degree() ) < 10.0 )
        max_cycle = 3;
    bool finish = false;
    double stamina = wm.self().stamina();
    double effort = wm.self().effort();
    double recovery = wm.self().recovery();
    double power = 100;


    {
        //kick
        self_vel *= wm.self().playerType().playerDecay();
        stamina += recovery * wm.self().playerType().staminaIncMax();
        if( stamina > sp.staminaMax() )
            stamina = sp.staminaMax();
    }


    for( int i = 1; i <= max_cycle; i++ )
    {
        self_dash.setPolar( wm.self().playerType().dashPowerRate() * effort * power, angle );


        stamina -= power;
        if( stamina <= sp.recoverDecThr() * sp.staminaMax() )
        {
            if( recovery > sp.recoverMin() )
                recovery -= sp.recoverDec();
            if( recovery < sp.recoverMin() )
                recovery = sp.recoverMin();
        }
        if( stamina <= sp.effortDecThr() * sp.staminaMax() )
        {
            if( effort > wm.self().playerType().effortMin() )
                effort -= sp.recoverDec();
            if( effort < wm.self().playerType().effortMin() )
                effort = wm.self().playerType().effortMin();
        }
        if( stamina >= sp.effortIncThr() * sp.staminaMax() )
        {
            if( effort < wm.self().playerType().effortMax() )
            {
                effort += sp.effortInc();
                if( effort > wm.self().playerType().effortMax() )
                    effort = wm.self().playerType().effortMax();
            }
        }
        stamina += recovery * wm.self().playerType().staminaIncMax();
        if( stamina > sp.staminaMax() )
            stamina = sp.staminaMax();
        
        




        self_vel += self_dash;
        self_pos += self_vel;
        
        bool safe = true;


        if( self_pos.x > 48 
            || self_pos.absY() > 30 )
        {
            safe = false;
        }

        const rcsc::PlayerPtrCont::const_iterator end = wm.opponentsFromBall().end();
        for( rcsc::PlayerPtrCont::const_iterator it = wm.opponentsFromBall().begin();
             it != end;
             ++it )
	{
            double opp_dist = (*it)->pos().dist( self_pos );
            opp_dist -= (*it)->playerTypePtr()->kickableMargin();
            
            if( opp_dist <= 0 )
            {
                safe = false;
                break;
            }
            if( (*it)->playerTypePtr()->cyclesToReachDistance( opp_dist ) <= i + turn + 1 )
            {
                safe = false;
                break;
            }
        }
        if( !safe && i <= 5 )
        {
            finish = false;
            break;
        }
        
        if( !safe && i > 5 )
        {
            target_pos = self_pos - self_vel;
            dash = i - 1;
            finish = true;
            break;
        }
        else if( safe && i == max_cycle )
        {
            target_pos = self_pos;
            dash = i;
            finish = true;
            break;
        }

        self_vel *= wm.self().playerType().playerDecay();
    }
    if( finish )
    {

        double first_speed = rcsc::calc_first_term_geom_series( wm.ball().pos().dist( target_pos ),
                                                                sp.ballDecay(),
                                                                1 + turn + dash );
        rcsc::Vector2D b2t = target_pos - wm.ball().pos();
        rcsc::Vector2D next_ball_pos;
        next_ball_pos.setPolar( first_speed, b2t.th() );
        next_ball_pos += wm.ball().pos();
        rcsc::Circle2D self_circle( wm.self().pos() + wm.self().vel(), wm.self().playerType().playerSize() );
        rcsc::Circle2D ball_circle( next_ball_pos, sp.ballSize() );
        if( self_circle.intersection( ball_circle, NULL, NULL ) > 0 
            || self_circle.contains( next_ball_pos ) )
            
        {
            agent->debugClient().addMessage( "SelfPassCollision" );
            return false;
        }
        if ( rcsc::Body_SmartKick( target_pos,
                                   first_speed,
                                   first_speed * 0.9,
                                   1 ).execute( agent ) )
        {
            agent->debugClient().addMessage( "SelfPass%d", turn + dash );
            agent->debugClient().setTarget( target_pos );
            agent->setIntention( new Opuci_IntentionDribble( target_pos, turn + dash ) );
            return true;
        }
    }

    return false;
}

/*-------------------------------------------------------------------*/
/*!

 */
/*-------------------------------------------------------------------*/

bool 
Opuci_SelfPass::execute( rcsc::PlayerAgent * agent, const rcsc::PlayerObject * target_opp )
{
    const rcsc::WorldModel & wm = agent->world();
    const rcsc::ServerParam & sp = rcsc::ServerParam::i();
    
    rcsc::Vector2D target_pos;
    rcsc::Vector2D self_pos = wm.self().pos();
    rcsc::Vector2D self_vel = wm.self().vel();
    rcsc::Vector2D self_dash;
    rcsc::AngleDeg angle = wm.self().body();
    int turn = 0;
    int dash = 0;

    if( angle.abs() > 45 )
    {
        return false;
    }
    if( target_opp->posCount() > 0 )
    {
        return false;
    }


    rcsc::AngleDeg angle_dif = M_angle - wm.self().body();
    if( angle_dif.abs() > 5 )
    {
        turn++;
        angle = M_angle;
    }


    int max_cycle = 16;
    bool finish = false;
    double stamina = wm.self().stamina();
    double effort = wm.self().effort();
    double recovery = wm.self().recovery();
    double power = 100;


    {
        //kick
        self_vel *= wm.self().playerType().playerDecay();
        stamina += recovery * wm.self().playerType().staminaIncMax();
        if( stamina > sp.staminaMax() )
            stamina = sp.staminaMax();
    }

    for( int i = 0; i < turn; i++ )
    {
        //turn
        self_vel *= wm.self().playerType().playerDecay();
        stamina += recovery * wm.self().playerType().staminaIncMax();
        if( stamina > sp.staminaMax() )
            stamina = sp.staminaMax();
    }

    for( int i = 1; i <= max_cycle; i++ )
    {
        self_dash.setPolar( wm.self().playerType().dashPowerRate() * effort * power, angle );


        stamina -= power;
        if( stamina <= sp.recoverDecThr() * sp.staminaMax() )
        {
            if( recovery > sp.recoverMin() )
                recovery -= sp.recoverDec();
            if( recovery < sp.recoverMin() )
                recovery = sp.recoverMin();
        }
        if( stamina <= sp.effortDecThr() * sp.staminaMax() )
        {
            if( effort > wm.self().playerType().effortMin() )
                effort -= sp.recoverDec();
            if( effort < wm.self().playerType().effortMin() )
                effort = wm.self().playerType().effortMin();
        }
        if( stamina >= sp.effortIncThr() * sp.staminaMax() )
        {
            if( effort < wm.self().playerType().effortMax() )
            {
                effort += sp.effortInc();
                if( effort > wm.self().playerType().effortMax() )
                    effort = wm.self().playerType().effortMax();
            }
        }
        stamina += recovery * wm.self().playerType().staminaIncMax();
        if( stamina > sp.staminaMax() )
            stamina = sp.staminaMax();
        
        




        self_vel += self_dash;
        self_pos += self_vel;
        
        bool safe = true;


        if( self_pos.x > 48 
            || self_pos.absY() > 30 )
        {
            safe = false;
        }


        double opp_dist = target_opp->pos().dist( self_pos );
        opp_dist -= sp.tackleDist();
        if( opp_dist <= 0 )
        {
            safe = false;
        }
        if( target_opp->playerTypePtr()->cyclesToReachDistance( opp_dist ) <= i + turn + 1 )
        {
            safe = false;
        }
        ///
        
        if( !safe && i <= 5 )
        {
            finish = false;
            break;
        }
        else if( !safe && i > 5 )
        {
            target_pos = self_pos - self_vel;
            dash = i - 1;
            finish = true;
            break;
        }
        else if( safe && i == max_cycle )
        {
            target_pos = self_pos;
            dash = i;
            finish = true;
            break;
        }

        self_vel *= wm.self().playerType().playerDecay();
    }
    if( finish )
    {

        double first_speed = rcsc::calc_first_term_geom_series( wm.ball().pos().dist( target_pos ),
                                                                sp.ballDecay(),
                                                                1 + turn + dash );
        rcsc::Vector2D b2t = target_pos - wm.ball().pos();
        rcsc::Vector2D next_ball_pos;
        next_ball_pos.setPolar( first_speed, b2t.th() );
        next_ball_pos += wm.ball().pos();
        rcsc::Circle2D self_circle( wm.self().pos() + wm.self().vel(), wm.self().playerType().playerSize() );
        rcsc::Circle2D ball_circle( next_ball_pos, sp.ballSize() );
        if( self_circle.intersection( ball_circle, NULL, NULL ) > 0 
            || self_circle.contains( next_ball_pos ) )
            
        {
            agent->debugClient().addMessage( "SelfPassCollision" );
            return false;
        }
        if ( rcsc::Body_SmartKick( target_pos,
                                   first_speed,
                                   first_speed * 0.9,
                                   1 ).execute( agent ) )
        {
            agent->debugClient().addMessage( "SelfPass%d", turn + dash );
            agent->debugClient().setTarget( target_pos );
            agent->setIntention( new Opuci_IntentionDribble( target_pos, turn + dash ) );
            return true;
        }
    }
    


    return false;
}

/*-------------------------------------------------------------------*/
/*!

 */
/*-------------------------------------------------------------------*/

bool
Opuci_SelfPass::forceDash( rcsc::PlayerAgent * agent, int dash_cycle )
{
    const rcsc::WorldModel & wm = agent->world();
    const rcsc::ServerParam & sp = rcsc::ServerParam::i();

    rcsc::Vector2D self_pos = wm.self().pos();
    rcsc::Vector2D self_vel = wm.self().vel();
    rcsc::Vector2D self_dash;
    rcsc::AngleDeg angle = wm.self().body();
    
    int turn = 0;
    int dash = dash_cycle;

/*
    if( angle.abs() > 30 )
    {
        return false;
    }
*/
    
    

    rcsc::AngleDeg angle_dif = M_angle - wm.self().body();
    if( angle_dif.abs() <= 5 )
    {
        turn = 0;
        angle = wm.self().body();
    }
    else if( wm.self().canTurn( angle_dif.degree() ) )
    {
        turn = 1;
        angle = M_angle;
    }
    else
    {
        turn = 2;
        angle = M_angle;
    }


    double stamina = wm.self().stamina();
    double effort = wm.self().effort();
    double recovery = wm.self().recovery();
    double power = 100;


    {
        //kick
        self_vel *= wm.self().playerType().playerDecay();
        stamina += recovery * wm.self().playerType().staminaIncMax();
        if( stamina > sp.staminaMax() )
            stamina = sp.staminaMax();
    }
    for( int i = 0; i < turn; i++ )
    {
        //turn
        self_vel *= wm.self().playerType().playerDecay();
        stamina += recovery * wm.self().playerType().staminaIncMax();
        if( stamina > sp.staminaMax() )
            stamina = sp.staminaMax();
    }
    agent->debugClient().addMessage( "DL%.2f EF%.2f ", wm.self().playerType().dashPowerRate(), effort );
    for( int i = 1; i <= dash_cycle; i++ )
    {
        self_dash.setPolar( wm.self().playerType().dashPowerRate() * effort * power, angle );

        stamina -= power;
        if( stamina <= sp.recoverDecThr() * sp.staminaMax() )
        {
            if( recovery > sp.recoverMin() )
                recovery -= sp.recoverDec();
            if( recovery < sp.recoverMin() )
                recovery = sp.recoverMin();
        }
        if( stamina <= sp.effortDecThr() * sp.staminaMax() )
        {
            if( effort > wm.self().playerType().effortMin() )
                effort -= sp.recoverDec();
            if( effort < wm.self().playerType().effortMin() )
                effort = wm.self().playerType().effortMin();
        }
        if( stamina >= sp.effortIncThr() * sp.staminaMax() )
        {
            if( effort < wm.self().playerType().effortMax() )
            {
                effort += sp.effortInc();
                if( effort > wm.self().playerType().effortMax() )
                    effort = wm.self().playerType().effortMax();
            }
        }
        stamina += recovery * wm.self().playerType().staminaIncMax();
        if( stamina > sp.staminaMax() )
            stamina = sp.staminaMax();
        
        

        self_vel += self_dash;
        self_pos += self_vel;


        self_vel *= wm.self().playerType().playerDecay();
    }   
    rcsc::Vector2D target_pos = self_pos;
    double first_speed = rcsc::calc_first_term_geom_series( wm.ball().pos().dist( target_pos ) + wm.self().kickableArea() * 0.5,
                                                            sp.ballDecay(),
                                                            1 + turn + dash );
    rcsc::Vector2D b2t = target_pos - wm.ball().pos();
    rcsc::Vector2D next_ball_pos;
    next_ball_pos.setPolar( first_speed, b2t.th() );
    next_ball_pos += wm.ball().pos();
    rcsc::Circle2D self_circle( wm.self().pos() + wm.self().vel(), wm.self().playerType().playerSize() );
    rcsc::Circle2D ball_circle( next_ball_pos, sp.ballSize() );
    if( self_circle.intersection( ball_circle, NULL, NULL ) > 0 
        || self_circle.contains( next_ball_pos ) )
        
    {
        agent->debugClient().addMessage( "SelfPassCollision" );
        return false;
    }
    if ( rcsc::Body_KickOneStep( target_pos,
                                 first_speed,
                                 true ).execute( agent ) )
    {
        agent->debugClient().addMessage( "ForceSelfPass%d", turn + dash );
        agent->debugClient().setTarget( target_pos );
        agent->setIntention( new Opuci_IntentionDribble( target_pos, turn + dash ) );
        return true;
    }
    return false;
}

/*-------------------------------------------------------------------*/
/*!

 */
/*-------------------------------------------------------------------*/
int 
Opuci_SelfPass::safeCycle( rcsc::PlayerAgent * agent, const rcsc::PlayerObject * target_opp )
{
    int cycle = 3;
    const rcsc::WorldModel & wm = agent->world();
    const rcsc::ServerParam & sp = rcsc::ServerParam::i();
    rcsc::Vector2D target_pos;
    rcsc::Vector2D self_pos = wm.self().pos();
    rcsc::Vector2D self_vel = wm.self().vel();
    rcsc::Vector2D self_dash;
    rcsc::AngleDeg angle = wm.self().body();
    int turn = 0;
    int dash = 0;


    rcsc::AngleDeg angle_dif = M_angle - wm.self().body();
    if( angle_dif.abs() > 10 )
    {
        turn++;
        angle = M_angle;
    }


    int max_cycle = 15;
    bool finish = false;
    double stamina = wm.self().stamina();
    double effort = wm.self().effort();
    double recovery = wm.self().recovery();
    double power = 100;


    {
        //kick
        self_vel *= wm.self().playerType().playerDecay();
        stamina += recovery * wm.self().playerType().staminaIncMax();
        if( stamina > sp.staminaMax() )
            stamina = sp.staminaMax();
    }

    for( int i = 0; i < turn; i++ )
    {
        //turn
        self_vel *= wm.self().playerType().playerDecay();
        stamina += recovery * wm.self().playerType().staminaIncMax();
        if( stamina > sp.staminaMax() )
            stamina = sp.staminaMax();
    }

    for( int i = 1; i <= max_cycle; i++ )
    {
        self_dash.setPolar( wm.self().playerType().dashPowerRate() * effort * power, angle );


        stamina -= power;
        if( stamina <= sp.recoverDecThr() * sp.staminaMax() )
        {
            if( recovery > sp.recoverMin() )
                recovery -= sp.recoverDec();
            if( recovery < sp.recoverMin() )
                recovery = sp.recoverMin();
        }
        if( stamina <= sp.effortDecThr() * sp.staminaMax() )
        {
            if( effort > wm.self().playerType().effortMin() )
                effort -= sp.recoverDec();
            if( effort < wm.self().playerType().effortMin() )
                effort = wm.self().playerType().effortMin();
        }
        if( stamina >= sp.effortIncThr() * sp.staminaMax() )
        {
            if( effort < wm.self().playerType().effortMax() )
            {
                effort += sp.effortInc();
                if( effort > wm.self().playerType().effortMax() )
                    effort = wm.self().playerType().effortMax();
            }
        }
        stamina += recovery * wm.self().playerType().staminaIncMax();
        if( stamina > sp.staminaMax() )
            stamina = sp.staminaMax();
        
        




        self_vel += self_dash;
        self_pos += self_vel;
        
        bool safe = true;

        if( self_pos.x > 48 
            || self_pos.absY() > 30 )
        {
            safe = false;
        }


        double opp_dist = target_opp->pos().dist( self_pos );
        opp_dist -= sp.tackleDist();
        if( opp_dist <= 0 )
        {
            safe = false;
        }
        if( target_opp->playerTypePtr()->cyclesToReachDistance( opp_dist ) <= i + turn + 1 )
        {
            safe = false;
        }
        ///
        
        if( !safe )
        {
            finish = true;
            dash = i - 1;
            break;
        }
        else if( safe && i == max_cycle )
        {
            target_pos = self_pos;
            dash = i;
            finish = true;
            break;
        }

        self_vel *= wm.self().playerType().playerDecay();
    }
    if( finish )
    {
        cycle = dash;
    }
    return cycle;
}
