#ifndef OPUCI_SELF_PASS_H
#define OPUCI_SELF_PASS_H

#include <rcsc/player/soccer_action.h>
#include <rcsc/player/player_object.h>
class Opuci_SelfPass
    : public rcsc::BodyAction {
 private:
        rcsc::AngleDeg M_angle;
        int M_dash_cycle;
        rcsc::Vector2D M_target;
 public:
        Opuci_SelfPass( rcsc::AngleDeg angle, int dash_cycle)
            :M_angle( angle ), M_dash_cycle( dash_cycle )
	{ }
        Opuci_SelfPass()
            :M_angle( 0 ), M_dash_cycle( 0 )
        { }
        Opuci_SelfPass( rcsc::AngleDeg angle )
            :M_angle( angle ), M_dash_cycle( 0 )
        { }
      bool execute( rcsc::PlayerAgent * agent );
      bool execute( rcsc::PlayerAgent * agent, bool use_turn );
      bool execute( rcsc::PlayerAgent * agent, const rcsc::PlayerObject * target_opp );
      bool forceDash( rcsc::PlayerAgent * agent, int dash_cycle );
      int safeCycle( rcsc::PlayerAgent * agent, const rcsc::PlayerObject * target_opp );
      
};

#endif
