#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "opuci_shoot.h"
#include "opuci_kick.h"

#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>

#include <rcsc/geom/angle_deg.h>
#include <rcsc/geom/line_2d.h>

/*-------------------------------------------------------------------*/
/*!

 */
bool
Opuci_Shoot::execute( rcsc::PlayerAgent * agent )
{
  rcsc::dlog.addText( rcsc::Logger::SHOOT,
		      "%s:%d:Opuci_Shoot"
		      ,__FILE__, __LINE__ );

  const rcsc::WorldModel & wm = agent->world();

  if( wm.self().pos().dist( wm.ball().pos() ) > wm.self().playerType().kickableArea() )
    {
      return false;
    }
  const rcsc::ServerParam & SP = rcsc::ServerParam::i();
  const rcsc::PlayerObject * goalie = wm.getOpponentGoalie();

  const rcsc::Vector2D goal_left( SP.pitchHalfLength(), SP.goalHalfWidth() - 1.0 );
  const rcsc::Vector2D goal_right( SP.pitchHalfLength(), -SP.goalHalfWidth() + 1.0 );
  const rcsc::Vector2D goal_center( SP.pitchHalfLength(), wm.self().pos().y );

  const rcsc::Line2D goal_left_line( wm.self().pos(), goal_left );
  const rcsc::Line2D goal_right_line( wm.self().pos(), goal_right );
  const rcsc::Line2D goal_center_line( wm.self().pos(), goal_center );

  rcsc::Vector2D shoot_target = goal_left;

  if( goalie )
    {
      rcsc::Vector2D left_projection = goal_left_line.projection( goalie->pos() );
      if( left_projection.x < wm.ball().pos().x )
	{
	  left_projection = wm.ball().pos();
	}
      else if( left_projection.x > goal_left.x )
	{
	  left_projection = goal_left;
	}
      int left_cycle = ( left_projection - goalie->pos() ).r() / goalie->playerTypePtr()->playerSpeedMax();

      rcsc::Vector2D right_projection = goal_right_line.projection( goalie->pos() );
      if( right_projection.x < wm.ball().pos().x )
	{
	  right_projection = wm.ball().pos();
	}
      else if( right_projection.x > goal_right.x )
	{
	  right_projection = goal_right;
	}
      int right_cycle = ( right_projection - goalie->pos() ).r() / goalie->playerTypePtr() ->playerSpeedMax();

      if( right_cycle >= left_cycle )
	{
	  shoot_target = goal_right;
	}

      rcsc::Vector2D center_projection = goal_center_line.projection( goalie->pos() );
      if( center_projection.x < wm.ball().pos().x )
	{
	  center_projection = wm.ball().pos();
	}
      else if( center_projection.x > goal_center.x )
	{
	  center_projection = goal_center;
	}
      int center_cycle = ( center_projection - goalie->pos() ).r() / goalie->playerTypePtr() ->playerSpeedMax();
      if( wm.self().pos().absY() < SP.goalHalfWidth() )
	{
	  if( center_cycle >= left_cycle
	      && center_cycle >= right_cycle )
	    {
	      shoot_target = goal_center;
	    }
	}
    }
  else
    {
      if( wm.self().pos().y > 0.0 )
	{
	  shoot_target = goal_left;
	}
      else
	{
	  shoot_target = goal_right;
	}
    }
  Opuci_Kick( shoot_target ).execute( agent );
  agent->debugClient().addMessage( "opuciShoot" );
  agent->debugClient().setTarget( shoot_target );

  return true;
}
