// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef AGENT2D_ROLE_HACHIRO_H
#define AGENT2D_ROLE_HACHIRO_H

#include "soccer_role.h"
#include <rcsc/geom/vector_2d.h>
#include <rcsc/common/server_param.h>

class RoleHachiro
    : public SoccerRole {
private:

public:

    static const std::string NAME;

    RoleHachiro()
      { }

    ~RoleHachiro()
      { }

    virtual
    void execute( rcsc::PlayerAgent * agent );


    static
    const
    std::string & name()
      {
          return NAME;
      }

    static
    SoccerRole::Ptr create()
      {
          SoccerRole::Ptr ptr( new RoleHachiro() );
          return ptr;
      }

private:

    rcsc::Vector2D M_receive_pos;

    void doKick( rcsc::PlayerAgent * agent );
    void doMove( rcsc::PlayerAgent * agent );
    rcsc::Vector2D setOffensivePos( rcsc::PlayerAgent * agent );
    rcsc::Vector2D setDefensivePos( rcsc::PlayerAgent * agent );
    rcsc::Vector2D setDangerPos( rcsc::PlayerAgent * agent );
    double dashPower( rcsc::PlayerAgent * agent,
                      const double limit_power = rcsc::ServerParam::i().maxPower() );
    bool oppAttended( rcsc::PlayerAgent *agent, rcsc::Vector2D opp );
    void searchMatesToCheck( rcsc::PlayerAgent *agent, int &unumMate1, int &unumMate2 );
    void normalSayMessage( rcsc::PlayerAgent *agent, int thr = 5 );
    void attentionTo_10_11_off( rcsc::PlayerAgent *agent, int thr = 3 );
    void attentionTo_ball_10or11( rcsc::PlayerAgent *agent, int thr = 3 );

    static int M_cnt_fw[11];
    static int M_cnt_mf[11];
    static int M_cnt_df[11];

    static int M_unum2Mark;
    static int M_passMate;
    static int M_neck_cnt;
    static int M_ptr;
    static int M_traj[100];
    int M_opp2Mark[3];
    void updateTrajectory( rcsc::PlayerAgent *agent );
    void updateSeeCount( rcsc::PlayerAgent *agent );
    int findOpponent2Check( rcsc::PlayerAgent *agent );
    void kickAction( rcsc::PlayerAgent * agent );

};

#endif
