// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "role_ichiro.h"

#include "bhv_goalie.h"
#include "bhv_opuci_goalie_basic_move.h"
#include "bhv_opuci_goalie_chase_ball.h"
#include "bhv_goalie_free_kick.h"
#include "opuci_neck.h"

#include <rcsc/action/basic_actions.h>
#include <rcsc/action/neck_scan_field.h>
#include <rcsc/action/body_clear_ball2009.h>

#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/player/world_model.h>
#include <rcsc/player/intercept_table.h>

#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>
#include <rcsc/geom/rect_2d.h>

#include <rcsc/action/body_pass.h>
#include <rcsc/action/body_smart_kick.h>
#include <rcsc/player/say_message_builder.h>
//#include <rcsc/action/neck_turn_to_low_conf_teammate.h>

const std::string RoleIchiro::NAME( "Ichiro" );

/*-------------------------------------------------------------------*/
/*!

 */
namespace {
rcss::RegHolder role = SoccerRole::creators().autoReg( &RoleIchiro::create,
                                                       RoleIchiro::name() );
}

/*-------------------------------------------------------------------*/
/*!

 */
void
RoleIchiro::execute( rcsc::PlayerAgent* agent )
{
    Bhv_Goalie().execute( agent );
    /*
    static const
        rcsc::Rect2D our_penalty( rcsc::Vector2D( -rcsc::ServerParam::i().pitchHalfLength(),
                                                  -rcsc::ServerParam::i().penaltyAreaHalfWidth() + 1.0 ),
                                  rcsc::Size2D( rcsc::ServerParam::i().penaltyAreaLength() - 1.0,
                                                rcsc::ServerParam::i().penaltyAreaWidth() - 2.0 ) );

    if( ( agent->world().gameMode().type() == rcsc::GameMode::FreeKick_
          || agent->world().gameMode().type() == rcsc::GameMode::GoalieCatch_ )
        && agent->world().gameMode().side() == agent->world().ourSide() )
    {
        Bhv_GoalieFreeKick().execute( agent );
        return;
    }
    //////////////////////////////////////////////////////////////
    // play_on play

    // catchable
    if ( agent->world().time().cycle()
         > agent->world().self().catchTime().cycle() + rcsc::ServerParam::i().catchBanCycle()
         && agent->world().ball().distFromSelf() < agent->world().self().catchableArea() - 0.05
         && our_penalty.contains( agent->world().ball().pos() ) )
    {
        rcsc::dlog.addText( rcsc::Logger::ROLE,
                            __FILE__": catchable. ball dist=%.1f, my_catchable=%.1f",
                            agent->world().ball().distFromSelf(),
                            agent->world().self().catchableArea() );
        if( agent->world().gameMode().type() == rcsc::GameMode::GoalKick_ )
            rcsc::Body_ClearBall2009().execute( agent );
        else
            agent->doCatch();
        agent->setNeckAction( new rcsc::Neck_TurnToBall() );
    }
    else if ( agent->world().self().isKickable() )
    {
        doKick( agent );
    }
    else
    {
        doMove( agent );
        message( agent );
        if( agent->world().getTeammateNearestToBall( 100 ) )
        {
            //最も近そうな味方が他にいればアテンションを向ける
            agent->doAttentionto( agent->world().self().side(),
                                  agent->world().getTeammateNearestToBall( 100 )->unum() );
        }
        else
        {
            //自分がボールに一番近そうならばアテンションを切る
            agent->doAttentiontoOff();
        }
    }
    */
    return;  
}

/*-------------------------------------------------------------------*/
/*!

 */
void
RoleIchiro::doKick( rcsc::PlayerAgent * agent )
{
    const rcsc::WorldModel & wm = agent->world();
    const rcsc::ServerParam & sp = rcsc::ServerParam::i();

    rcsc::Vector2D target_point;
    double pass_speed = 0.0;
    int receiver = 0;

    //direct pass
    const rcsc::Rect2D penalty_area( rcsc::Vector2D( -sp.pitchHalfLength(), -sp.penaltyAreaHalfWidth() ),
                                     rcsc::Vector2D( -sp.pitchHalfLength() + sp.penaltyAreaLength(),
                                                     sp.penaltyAreaHalfWidth() ) );
    const double ball_decay = sp.ballDecay();
    const double ball_speed_max = sp.ballSpeedMax();
    const rcsc::PlayerPtrCont & opps = wm.opponentsFromSelf();
    const rcsc::PlayerPtrCont & mates = wm.teammatesFromSelf();
    const rcsc::PlayerPtrCont::const_iterator opps_end = opps.end();
    const rcsc::PlayerPtrCont::const_iterator mates_end = mates.end();
    for( rcsc::PlayerPtrCont::const_iterator it = mates.begin();
         it != mates_end;
         ++it )
    {
        bool target_is_free = true;
        const rcsc::Sector2D sector( wm.ball().pos(),
                                     1.0, (*it)->pos().dist( wm.ball().pos() ) + 3.0,
                                     ( (*it)->pos() - wm.ball().pos() ).th() - rcsc::AngleDeg( 30.0 ),
                                     ( (*it)->pos() - wm.ball().pos() ).th() + rcsc::AngleDeg( 30.0 ) );
        for( rcsc::PlayerPtrCont::const_iterator itr = opps.begin();
             itr != opps.end();
             ++itr )
        {
            if( sector.contains( (*itr)->pos() ) )
            {
                target_is_free = false;
            }
        }

        if( target_is_free
            && (*it)->posCount() < 3
            && (*it)->pos().x > -25.0
            && (*it)->pos().x > wm.self().pos().x - 5.0
            && (*it)->pos().dist( wm.self().pos() ) > 10.0 )
        {
            int reach_cycle = log( 1.0 - ( 1.0 - ball_decay ) * wm.self().pos().dist( (*it)->pos() ) 
                                   / ball_speed_max ) / log( ball_decay );
            double ball_speed = (*it)->playerTypePtr()->kickableArea() * 1.5 * pow( 1.0 / ball_decay, reach_cycle - 1 );
            double first_speed = std::min( ball_speed_max, ball_speed );
            if( penalty_area.contains( wm.ball().pos() ) )
            {
                if( rcsc::Body_SmartKick( (*it)->pos(),
                                          first_speed,
                                          first_speed * 0.8,
                                          1 ).execute( agent ) )
                {
                    agent->debugClient().addMessage( "DirectOneStepPass" );
                    agent->addSayMessage( new rcsc::PassMessage( (*it)->unum(),
                                                                 (*it)->pos(),
                                                                 agent->effector().queuedNextBallPos(),
                                                                 agent->effector().queuedNextBallVel() ) );
                    agent->setNeckAction( new Opuci_Neck() );
                    return;
                }
            }
            else
            {
                rcsc::Body_SmartKick( (*it)->pos(),
                                      first_speed,
                                      first_speed * 0.8,
                                      3 ).execute( agent );
                agent->debugClient().addMessage( "DirectPass" );
                agent->addSayMessage( new rcsc::PassMessage( (*it)->unum(),
                                                             (*it)->pos(),
                                                             agent->effector().queuedNextBallPos(),
                                                             agent->effector().queuedNextBallVel() ) );
                agent->setNeckAction( new Opuci_Neck() );
                return;
            }
        }
    }

    if  ( rcsc::Body_Pass::get_best_pass( agent->world(), &target_point, &pass_speed, &receiver )
          && target_point.dist( rcsc::Vector2D( -50.0, 0.0 ) ) > 20.0 )
    {
        double opp_dist = 100.0;
        const rcsc::PlayerObject * opp
            = agent->world().getOpponentNearestTo( target_point, 20, &opp_dist );
        agent->debugClient().addMessage( "GKickOppDist%.1f", opp ? opp_dist : 1000.0 );
        if ( ! opp || opp_dist > 3.0 )
        {
            rcsc::Body_SmartKick( target_point,
                                  pass_speed,
                                  pass_speed * 0.96,
                                  3 ).execute( agent );
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                __FILE__": register goalie kick intention. to (%.1f, %.1f)",
                                target_point.x,
                                target_point.y );
            agent->setNeckAction( new rcsc::Neck_ScanField() );
            if ( agent->config().useCommunication()
                 && receiver != rcsc::Unum_Unknown )
            {
                rcsc::dlog.addText( rcsc::Logger::ACTION,
                                    "%s:%d: execute() set pass communication.freekick"
                                    ,__FILE__, __LINE__ );
                rcsc::Vector2D target_buf = target_point - agent->world().self().pos();
                target_buf.setLength( 0.3 );
                agent->addSayMessage( new rcsc::PassMessage( receiver,
                                                             target_point,
                                                             agent->effector().queuedNextBallPos(),
                                                             agent->effector().queuedNextBallVel() ) );
                return;
            }
        }
    }

    double best_angle = 90.0 * wm.ball().pos().y / wm.ball().pos().absY();
    for( double angle = -90.0; angle <= 90.0; angle += 10.0 )
    {
        bool angle_safety = true;
        const rcsc::Sector2D sector( wm.ball().pos(),
                                     1.0, 20.0,
                                     rcsc::AngleDeg( angle ) - rcsc::AngleDeg( 20.0 ),
                                     rcsc::AngleDeg( angle ) + rcsc::AngleDeg( 20.0 ) );
        for( rcsc::PlayerPtrCont::const_iterator it = opps.begin();
             it != opps_end;
             ++it )
        {
            if( sector.contains( (*it)->pos() ) )
            {
                angle_safety = false;
            }
        }
        if( angle_safety
            && abs( angle ) < abs( best_angle ) )
        {
            best_angle = angle;
        }
    }
    target_point.x = wm.ball().pos().x + rcsc::AngleDeg( best_angle ).cos();
    target_point.y = wm.ball().pos().y + rcsc::AngleDeg( best_angle ).sin();
    if( rcsc::Body_SmartKick( target_point,
                              ball_speed_max,
                              ball_speed_max * 0.8,
                              1 ).execute( agent ) )
    {
        agent->debugClient().addMessage( "GoalieKickAdvance" );
        agent->setNeckAction( new Opuci_Neck() );
        return;
    }
    rcsc::Body_ClearBall2009().execute( agent );
    agent->setNeckAction( new rcsc::Neck_ScanField() );
    return;
}

/*-------------------------------------------------------------------*/
/*!

 */
void
RoleIchiro::doMove( rcsc::PlayerAgent * agent )
{
    if ( Bhv_OpuciGoalieChaseBall::is_ball_chase_situation( agent ) )
    {
        Bhv_OpuciGoalieChaseBall().execute( agent );
    }
    else
    {
        Bhv_OpuciGoalieBasicMove().execute( agent );
    }
}

/*-------------------------------------------------------------------*/
/*!

 */
void
RoleIchiro::message( rcsc::PlayerAgent * agent )
{
    const rcsc::WorldModel & wm = agent->world();

    rcsc::Vector2D fastest_mate = wm.self().pos();
    if( wm.interceptTable()->fastestTeammate() )
    {
        fastest_mate = wm.interceptTable()->fastestTeammate()->pos();
    }
    rcsc::Vector2D first_pos( 50.0, 0.0 );
    rcsc::Vector2D second_pos( 50.0, 0.0 );
    rcsc::Vector2D third_pos( 50.0, 0.0 );
    int first_unum = 0;
    int second_unum = 0;
    int third_unum = 0;
    for( int unum = 1; unum <= 11; unum++ )
    {
        if( wm.opponent( unum ) )
	{
            if( wm.opponent( unum )->pos().x > fastest_mate.x )
	    {
                if( wm.opponent( unum )->pos().dist( fastest_mate ) < first_pos.dist( fastest_mate )
                    && wm.opponent( unum )->pos().dist( wm.self().pos() ) < 25.0 )
		{
                    third_pos = second_pos;
                    third_unum = second_unum;

                    second_pos = first_pos;
                    second_unum = first_unum;

                    first_pos = wm.opponent( unum )->pos();
                    first_unum = unum;
		}
                else if( wm.opponent( unum )->pos().dist( fastest_mate ) < second_pos.dist( fastest_mate )
                         && wm.opponent( unum )->pos().dist( wm.self().pos() ) < 25.0 )
		{
                    third_pos = second_pos;
                    third_unum = second_unum;

                    second_pos = wm.opponent( unum )->pos();
                    second_unum = unum;
		}
                else if( wm.opponent( unum )->pos().dist( fastest_mate ) < third_pos.dist( fastest_mate )
                         && wm.opponent( unum )->pos().dist( wm.self().pos() ) < 25.0 )
		{
                    third_pos = wm.opponent( unum )->pos();
                    third_unum = unum;
		}
	    }
	}
    }

    if( first_unum == 0 )
    {
        const rcsc::Vector2D next_ball_pos = wm.ball().pos() + wm.ball().vel();
        const rcsc::Vector2D next_ball_vel = wm.ball().vel() * rcsc::ServerParam::i().ballDecay();
        agent->addSayMessage( new rcsc::BallMessage( next_ball_pos,
                                                     next_ball_vel ) );
    }
    else if( second_unum == 0 )
    {
        agent->addSayMessage( new rcsc::OnePlayerMessage( first_unum + 11,
                                                          first_pos ) );
    }
    else if( third_unum == 0 )
    {
        agent->addSayMessage( new rcsc::TwoPlayerMessage( first_unum + 11,
                                                          first_pos,
                                                          second_unum + 11,
                                                          second_pos ) );
    }
    else
    {
        agent->addSayMessage( new rcsc::ThreePlayerMessage( first_unum + 11,
                                                            first_pos,
                                                            second_unum + 11,
                                                            second_pos,
                                                            third_unum + 11,
                                                            third_pos ) );
    }

    return;
}
