// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "role_jiro.h"

#include "bhv_simple_pass.h"
#include "bhv_dango.h"
#include "bhv_defense.h"
#include "strategy.h"
#include "opuci_neck.h"
#include "opuci_search_ball.h"

#include "bhv_jiro_defense.h"
#include "bhv_opuci_center_back_move.h"
#include "bhv_opuci_defensive_kick.h"


#include <rcsc/formation/formation.h>

#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/player/intercept_table.h>


#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>

#include <boost/shared_ptr.hpp>

#include <rcsc/player/say_message_builder.h>

const std::string RoleJiro::NAME( "Jiro" );

/*-------------------------------------------------------------------*/
/*!

 */
namespace {
rcss::RegHolder role = SoccerRole::creators().autoReg( &RoleJiro::create,
                                                       RoleJiro::NAME );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
RoleJiro::execute( rcsc::PlayerAgent * agent )
{
    bool kickable = agent->world().self().isKickable();
    if ( agent->world().existKickableTeammate()
         && agent->world().teammatesFromBall().front()->distFromBall()
         < agent->world().ball().distFromSelf() )
    {
        kickable = false;
    }

    if ( kickable )
    {
        doKick( agent );
    }
    else
    {
        doMove( agent );
        Bhv_defense().defenseMessage( agent );
    }
    Bhv_defense().defenseAttention( agent );
/*
    //Bhv_Dango().execute( agent );
  Bhv_SimplePass().execute( agent );

  if( agent->world().ball().posCount() > 5 )
  {
      Opuci_SearchBall().execute( agent );
  }
  else
  {
      Opuci_Neck().execute( agent );
  }
*/
  return;
}

/*-------------------------------------------------------------------*/
/*!

*/
void
RoleJiro::doKick( rcsc::PlayerAgent * agent )
{
    Bhv_opuciDefensiveKick().execute( agent );
    return;
}

/*-------------------------------------------------------------------*/
/*!

*/
void
RoleJiro::doMove( rcsc::PlayerAgent * agent )
{
    const rcsc::WorldModel & wm = agent->world();

    int ball_reach_step = 0;
    if ( ! wm.existKickableTeammate()
         && ! wm.existKickableOpponent() )
    {
        ball_reach_step
            = std::min( wm.interceptTable()->teammateReachCycle(),
                        wm.interceptTable()->opponentReachCycle() );
    }
    const rcsc::Vector2D base_pos
        = wm.ball().inertiaPoint( ball_reach_step );
    boost::shared_ptr< const rcsc::Formation > formation 
        = Strategy::i().getFormation( wm );

    rcsc::Vector2D home_pos
        = (*formation).getPosition( agent->config().playerNumber(),
                                        base_pos );
    if ( rcsc::ServerParam::i().useOffside() )
    {
        home_pos.x = std::min( home_pos.x, wm.offsideLineX() - 1.0 );
    }
    //Bhv_opuciCenterBackMove( home_pos ).execute( agent );
    Bhv_jiroDefense( home_pos ).execute( agent );
    return;
}
