// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "role_juichiro.h"

#include "bhv_formation1.h"
#include "bhv_dango.h"
#include "bhv_offense.h"
#include "bhv_shootchance.h"
#include "bhv_simple_dribble.h"
#include "opuci_direct_pass.h"
#include "opuci_through_pass.h"
#include "opuci_chase_ball.h"
#include "opuci_other_pass.h"
#include "opuci_one_step_kick.h"
#include "opuci_neck.h"
#include "opuci_move.h"
#include "opuci_dribble.h"
#include "opuci_message.h"
#include "opuci_self_pass.h"
#include "strategy.h"
#include "body_dribble_opuci.h"

#include <rcsc/formation/formation.h>
#include <rcsc/player/intercept_table.h>
#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/player/say_message_builder.h>
#include <rcsc/common/logger.h>
#include <rcsc/geom/rect_2d.h>

#include <rcsc/action/body_kick_one_step.h>
#include <rcsc/action/body_advance_ball2009.h>
#include <rcsc/action/body_dribble2008.h>
#include <rcsc/action/body_smart_kick.h>
#include <rcsc/action/body_hold_ball.h>
#include <rcsc/action/body_intercept2009.h>

const std::string RoleJuichiro::NAME( "Juichiro" );

int RoleJuichiro::M_passMate = -1;
int RoleJuichiro::M_neck_cnt = -1;

/*-------------------------------------------------------------------*/
/*!

 */
namespace {
rcss::RegHolder role = SoccerRole::creators().autoReg( &RoleJuichiro::create,
                                                       RoleJuichiro::NAME );
}

/*-------------------------------------------------------------------*/
/*!

 */
void
RoleJuichiro::execute( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: RoleJuichiro::execute"
                        ,__FILE__, __LINE__ );

    const rcsc::WorldModel & wm = agent->world();
    std::vector< int > opp_num;
    Bhv_Offense().surroundOppNum( agent, opp_num );


    rcsc::Vector2D goal_center( 51.5, 0.0 );
    int self_min = std::min( Opuci_ChaseBall().calcCycle( agent ), wm.interceptTable()->selfReachCycle() );
    int mate_min = wm.interceptTable()->teammateReachCycle();
    int opp_min = wm.interceptTable()->opponentReachCycle();

    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: self_min = %d"
                        ,__FILE__, __LINE__, self_min );

    int agent_reach_cycle = std::min( std::min( self_min, mate_min ), opp_min );
    M_receive_pos = wm.ball().inertiaPoint( agent_reach_cycle );
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: M_receive_pos( %f, %f )"
                        ,__FILE__, __LINE__, M_receive_pos.x, M_receive_pos.y );

    rcsc::Vector2D top_left( 30, -25 );
    rcsc::Vector2D bottom_right( 52.5, 25 );
    rcsc::Rect2D shoot_chance( top_left, bottom_right );


    if( M_receive_pos.x > 30.0 )
    {
        agent->debugClient().addMessage( "ShootChance" );
        Bhv_Shootchance( goal_center ).execute( agent );
    }
    else if( wm.self().isKickable() )
    {
        doKick( agent );
    }
    else
    {
        doMove( agent );
    }

    if( wm.ball().rposCount() == 0
        && wm.ball().pos().dist( wm.self().pos() ) < 20.0 )
    {
        //ボールのrposcountが0ならばボールの位置・速度，自分の位置，体の角度をメッセージで配信
        agent->addSayMessage( new rcsc::BallPlayerMessage( agent->effector().queuedNextBallPos(), 
                                                           agent->effector().queuedNextBallVel(),
                                                           wm.self().unum(),
                                                           agent->effector().queuedNextMyPos(),
                                                           agent->effector().queuedNextMyBody() ) );
    }
    else
    {
        Opuci_Message().normalSayMessage( agent, 5 );
    }

    if( !shoot_chance.contains( M_receive_pos ) )
    {
        if( self_min < mate_min )
        {
            //自分がボールに一番近そうならばアテンションを切る
            agent->doAttentiontoOff();
        }
        else
        {
            if( wm.getTeammateNearestToBall( 100 ) )
            {
                //最も近そうな味方が他にいればアテンションを向ける
                agent->doAttentionto( wm.self().side(),
                                      wm.getTeammateNearestToBall( 100 )->unum() );
            }
            else
                agent->doAttentiontoOff();
        }
    }

    return;
}

/*-------------------------------------------------------------------*/
/*!

 */
void
RoleJuichiro::doKick( rcsc::PlayerAgent * agent )
{
    const rcsc::WorldModel & wm = agent->world();

    agent->debugClient().addMessage( "Offense" );
    offensiveKick( agent );

    if( M_passMate == -1 )
        Opuci_Neck().execute( agent );
    else
    {
        Opuci_Neck().lookAtPassReceiver( agent, M_passMate );
        M_neck_cnt--;
        if( M_neck_cnt <= 0 )
            M_passMate = -1;
    }

    
    return;
}

/*-------------------------------------------------------------------*/
/*!

 */
void
RoleJuichiro::doMove( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: RoleJuichiro::doMove"
                        ,__FILE__, __LINE__ );

    bool pointToDone = false;
    const rcsc::WorldModel & wm = agent->world();
    const rcsc::ServerParam & SP = rcsc::ServerParam::i();
    rcsc::Vector2D goal_center( 51.5, 0.0 );

    std::vector< rcsc::Vector2D > oppline;
    Bhv_Offense( goal_center ).getOppEndLine( agent, oppline );

    int self_min = std::min( Opuci_ChaseBall().calcCycle( agent ), wm.interceptTable()->selfReachCycle() );
    int mate_min = wm.interceptTable()->teammateReachCycle();
    int opp_min = wm.interceptTable()->opponentReachCycle();

    const rcsc::PlayerPtrCont & teammates = wm.teammatesFromBall();
    const rcsc::PlayerObject * first_mate = wm.getFirstPlayer( teammates.begin(), teammates.end(), 10, false );

    int agent_reach_cycle = std::min( std::min( self_min, mate_min ), opp_min );

    rcsc::Vector2D target;
    double dash_power;

    rcsc::AngleDeg turn_angle = ( M_receive_pos - wm.self().pos() ).th() - wm.self().body();
    if( (wm.self().pos().x > wm.offsideLineX() - 5 && wm.ball().pos().x > wm.offsideLineX() - 10)
        || turn_angle.abs() < 10.0 )
    {
        turn_angle = -wm.self().body();
    }   
    
    if( !wm.existKickableTeammate() && self_min <= mate_min + 1  )
    {
        if( wm.existKickableOpponent() )
        {
            target = wm.ball().pos();
            dash_power = dashPower( agent, SP.maxPower() );
            agent->debugClient().addMessage( "AttackOpp" );
            Opuci_Move( target, dash_power, wm.ball().pos().dist( wm.self().pos() ) / 2.0 ).execute( agent );
        }
        else
        {
            agent->debugClient().addMessage( "ChaseBall" );
            if( Opuci_ChaseBall().calcCycle( agent ) < wm.interceptTable()->selfReachCycle() )
            {
                rcsc::dlog.addText( rcsc::Logger::TEAM,
                                    "%s:%d: Intercept by OpuciChaseBall"
                                    ,__FILE__, __LINE__ );
                Opuci_ChaseBall().execute( agent );
            }
            else
            {
                rcsc::dlog.addText( rcsc::Logger::TEAM,
                                    "%s:%d: Intercept by Body_Intercept2009"
                                    ,__FILE__, __LINE__ );
                rcsc::Body_Intercept2009().execute( agent );
            }
        }
    }
    else if( wm.self().pos().x > wm.offsideLineX() )
    {
        //オフサイドラインから戻るように修正
        target.x = (int)((wm.offsideLineX() - 3.0) / 5.0) * 5.0;
        if( ( M_receive_pos.x - target.x ) > 20 )
        {
            if( oppline.empty() )
                target.y = 0.0;
            else
                target.y = (int)((oppline.front().y + oppline.back().y) / 10.0) * 5.0;
            dash_power = dashPower( agent, SP.maxPower() * 0.2 );

            if( target.y < -15.0 )
                target.y = -15.0;
            else if( target.y > 15.0 )
                target.y = 15.0;
        }
        else
        {
            target.y = wm.self().pos().y;
            dash_power = dashPower( agent, SP.maxPower() );
        }

        //目標位置へ移動
        if( Opuci_Move( target, dash_power, 1.5 ).execute( agent ) )
        {
            agent->debugClient().setTarget( target );
        }
        else
        {
            //目標位置に到達している場合はボールに体を向ける
            agent->doTurn( turn_angle );
            agent->debugClient().addMessage("Turn2Ball%d", __LINE__);
        }

        agent->debugClient().addMessage("Back2Area");
        agent->debugClient().setTarget( target );

    }
    else if( wm.self().pointtoPos().isValid()
             && wm.time().cycle() - wm.self().pointtoTime().cycle() <= 5 )
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: time(%d), pointtoTime(%d)"
                            ,__FILE__, __LINE__, wm.time().cycle(), wm.self().pointtoTime().cycle() );

        // スルーパスを受けるためにターン禁止期間
        // 期間はpointtoから5サイクル
        rcsc::Line2D l_body( wm.self().pos(), wm.self().body() );
        int cycle2offsideX = wm.self().playerType().cyclesToReachDistance(
            wm.self().pos().dist( rcsc::Vector2D( wm.offsideLineX(), l_body.getY( wm.offsideLineX() ) ) )
            );

        if( cycle2offsideX >= 2 )
        {
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "%s:%d: Dash50 to offsideLineX"
                                ,__FILE__, __LINE__ );
            agent->doDash( 50.0 );
        }
        else if( cycle2offsideX == 1 )
        {
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "%s:%d: Dash40 to offsideLineX"
                                ,__FILE__, __LINE__ );
            agent->doDash( 40.0 );
        }
        else
        {
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "%s:%d: Wait. Do nothing."
                                ,__FILE__, __LINE__ );
            agent->doDash( 0.0 );
        }
    }
    else if( opp_min < mate_min )
    {
        //敵が味方より早くボールに到達可能な場合
        dash_power = dashPower( agent, SP.maxPower() * 0.7 );
        target.x = wm.offsideLineX() - 5.0;
        target.y = 0.0;

        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: Target_pos(%f, %f)"
                            ,__FILE__, __LINE__, target.x, target.y );
        
        //目標位置へ移動
        if( Opuci_Move( target, dash_power, 3.0 ).execute( agent ) )
        {
            agent->debugClient().addMessage("OpponentBall");
            agent->debugClient().setTarget( target );
        }
        else
        {
            //目標位置に到達している場合はゴールの方を向く
            agent->doTurn( turn_angle );
            agent->debugClient().addMessage("Turn2RcvPnt");
        }
    }
    else if( first_mate )
    {
        agent->debugClient().addMessage( "11OffenceMv" );
        dash_power = dashPower( agent, SP.maxPower() * 0.9 );

        target = setOffensivePos( agent );
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: Target_pos(%f, %f)"
                            ,__FILE__, __LINE__, target.x, target.y );

        //目標位置へ移動
        double th_dist = target.dist( wm.self().pos() ) > 3.0
            ? target.dist( wm.self().pos() ) / 3.0 : 2.0;
        if( Opuci_Move( target, dash_power, th_dist ).execute( agent ) )
        {
            agent->debugClient().addMessage("OurBall");
            agent->debugClient().setTarget( target );
        }
        else
        {
            //目標位置に到達している場合は敵ゴールに体を向ける
            rcsc::Vector2D t_receive;
            bool dopointTo = Bhv_Offense(goal_center).decideTurnAngleWhenImThere( agent, t_receive );
            agent->doTurn( (t_receive - wm.self().pos()).th() - wm.self().body() );
            agent->debugClient().addMessage("TurnAndPointto%d", __LINE__);

            if( mate_min <= 2 && std::fabs( (t_receive - wm.self().pos()).th().degree() - agent->effector().queuedNextMyBody().degree() ) < 10.0
                && M_receive_pos.dist( wm.self().pos() )  < 20.0
                && wm.offsideLineX() - wm.self().pos().x < 3.5 && wm.self().pos().x < wm.offsideLineX() )
            {
                rcsc::Vector2D pointToPos;
                pointToPos.setPolar( 10.0, agent->effector().queuedNextMyBody() );
                pointToPos += wm.self().pos();
                agent->doPointto( t_receive.x, t_receive.y );
                pointToDone = true;
            }
        }

    }
    else
    {
        agent->debugClient().addMessage( "Formation1" );
        Bhv_Formation1().execute( agent );
    }

    if( !pointToDone && wm.self().pointtoPos().isValid()
        && wm.time().cycle() - wm.self().pointtoTime().cycle() > 5 )
        agent->doPointtoOff();

    Opuci_Neck().execute( agent );
    return;
}

/*-------------------------------------------------------------------*/
/*!

 */
/*-------------------------------------------------------------------*/

rcsc::Vector2D
RoleJuichiro::setOffensivePos( rcsc::PlayerAgent * agent )
{
    const rcsc::WorldModel & wm = agent->world();
    rcsc::Vector2D target; // 移動目標

    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: role_Juichiro::setOffensivePos"
                        ,__FILE__, __LINE__ );

    target.x = std::min( wm.offsideLineX(), M_receive_pos.x + 15.0 );

    if( M_receive_pos.y < wm.self().pos().y )
    {
        target.y = M_receive_pos.y + 15.0;
    }
    else
    {
        target.y = M_receive_pos.y - 15.0;
    }

    // ほぼゴール方向を向いていればターンしないように目標値を直進方向に設定
/*
    rcsc::Line2D l_body( wm.self().pos(), wm.self().body() );
    if( -9.3 < l_body.getY( wm.offsideLineX() ) && l_body.getY( wm.offsideLineX() ) < 9.3 )
        target.y = l_body.getY( wm.offsideLineX() );
    else
        target.y = 0.0;
*/    
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: Target specified" ,__FILE__, __LINE__ );

    return target;

}

/*-------------------------------------------------------------------*/
/*!
  ダッシュパワーを決定する関数
*/
/*-------------------------------------------------------------------*/

double
RoleJuichiro::dashPower( rcsc::PlayerAgent * agent,
                         const double limit_power )
{
    const rcsc::WorldModel & wm = agent->world();
    const rcsc::ServerParam & SP = rcsc::ServerParam::i();
    if( wm.self().stamina() < SP.staminaMax() * SP.effortDecThr() * 1.2 
        || wm.self().stamina() < SP.staminaMax() * SP.recoverDecThr() * 1.2 )
    {
        //スタミナ切れが近い場合は停止する
        return 0.0;
    }
    //制限パワー：デフォルトは最大パワー
    return limit_power;
}

/*-------------------------------------------------------------------*/
/*!

 */
/*-------------------------------------------------------------------*/

bool
RoleJuichiro::offensiveKick( rcsc::PlayerAgent * agent )
{
    const rcsc::WorldModel & wm = agent->world();
    const rcsc::ServerParam & sp = rcsc::ServerParam::i();
    const rcsc::Vector2D pOfNoRet( 53.0, 0.0 );
    rcsc::Vector2D next_self_pos = wm.self().pos() + wm.self().vel();
    rcsc::Vector2D next_bpos = wm.ball().inertiaPoint( 1 );
    rcsc::Vector2D tmp_target = pOfNoRet - next_self_pos;
    rcsc::AngleDeg angle_dif = tmp_target.th() - wm.self().body();
    rcsc::Vector2D goal_center( 52, 0 ); 
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d:RoleJuichiro::offensiveKick"
                        ,__FILE__, __LINE__ );


    rcsc::Vector2D pass_target = next_self_pos;
    double first_speed = sp.ballSpeedMax();

    int count_thr = 2;
    if( wm.interceptTable()->opponentReachCycle() < 3 )
    {
        count_thr = 4;
    }


    bool frontier = true;
    const rcsc::PlayerPtrCont::const_iterator end_self = wm.teammatesFromSelf().end();
    for( rcsc::PlayerPtrCont::const_iterator it = wm.teammatesFromSelf().begin();
         it != end_self;
         ++it )
    {
        if( (*it)->pos().x > wm.self().pos().x )
        {
            frontier = false;
            break;
        }
    }


    std::vector< rcsc::PlayerObject* > point_mates;
    for( rcsc::PlayerPtrCont::const_iterator it = wm.teammatesFromSelf().begin();
         it != end_self;
         ++it )
    {
        if( frontier
            && (*it)->pos().absY() > wm.self().pos().absY() )
        {
            continue;
        }
        if( (*it)->pointtoCount() < 10 )
        {
            point_mates.push_back( (*it) );
        }
    }
    if( !point_mates.empty() )
    {
        for( std::vector< rcsc::PlayerObject* >::iterator it = point_mates.begin();
             it != point_mates.end();
             ++it )
        {
            for( std::vector< rcsc::PlayerObject* >::iterator it2 = it;
                 it2 != point_mates.end();
                 ++it2 )
            {
                if( (*it)->pos().x < (*it2)->pos().x )
                    std::swap( *it, *it2 );
            }
        }
        for( std::vector< rcsc::PlayerObject* >::iterator it = point_mates.begin();
             it != point_mates.end();
             ++it )
        {
            if( Bhv_Offense().pointingPass( agent, (*it), pass_target, first_speed ) )
            {
                if( (*it)->seenPosCount() == 0 )
                {
                    const rcsc::PlayerObject * receiver = (*it);
                    if( rcsc::Body_SmartKick( pass_target, first_speed, first_speed * 0.95, 1 ).execute( agent ) )
                    {
                        agent->debugClient().setTarget( pass_target );
                        agent->debugClient().addMessage( "PointingPass%d", receiver->unum() );
                        agent->addSayMessage( new rcsc::PassMessage( receiver->unum(), pass_target,
                                                                     agent->effector().queuedNextBallPos(),
                                                                     agent->effector().queuedNextBallVel() ) );
                    }
                    if( M_neck_cnt <= 0 )
                        M_passMate = -1;
                }
                else if( M_passMate != -1 )
                {
                    rcsc::dlog.addText( rcsc::Logger::TEAM,
                                        "%s:%d: Keep locking on %d at the next cycle."
                                        ,__FILE__, __LINE__, M_passMate );
                    rcsc::Body_HoldBall().execute( agent );
                }
                else
                {
                    rcsc::dlog.addText( rcsc::Logger::TEAM,
                                        "%s:%d: seenCount = %d. Lock on %d at the next cycle."
                                        ,__FILE__, __LINE__, (*it)->seenPosCount(), (*it)->unum() );
                    M_passMate = (*it)->unum();
                    rcsc::Body_HoldBall().execute( agent );
                    M_neck_cnt = 3;
                }
                return true;
            }
        }
    }

    double length = 20.0;
    double width = 13.0;

    rcsc::Vector2D vertex1 = wm.self().pos() + rcsc::Vector2D( -wm.self().kickableArea() * 1.5, 0 );
    rcsc::Vector2D vertex2 = wm.self().pos() + rcsc::Vector2D( length, -width );
    rcsc::Vector2D vertex3 = wm.self().pos() + rcsc::Vector2D( length, width );
    rcsc::Triangle2D triangle( vertex1, vertex2, vertex3 );

    rcsc::Vector2D tl = wm.self().pos() + rcsc::Vector2D( 0, -width);
    rcsc::Vector2D br = wm.self().pos() + rcsc::Vector2D( length / 5.0, width );
    rcsc::Rect2D rectangle( tl, br );

    rcsc::Vector2D tl2( br.x, tl.y );
    rcsc::Vector2D br2( br.x + length / 3.0, br.y );
    rcsc::Rect2D rectangle2( tl2, br2 );

    bool exist_tri = false;    
    bool exist_rect = false;
    bool exist_rect2 = false;

    const rcsc::PlayerPtrCont::const_iterator opp_end = wm.opponentsFromBall().end();    
    for( rcsc::PlayerPtrCont::const_iterator it = wm.opponentsFromBall().begin();
         it != opp_end;
         ++it )
    {
        if( (*it)->goalie() )
            continue;

        if( exist_tri == false && triangle.contains( (*it)->pos() ) )
        {
            exist_tri = true;
        }
        if( exist_rect == false && rectangle.contains( (*it)->pos() ) )
        {
            exist_rect = true;
        }
        if( exist_rect2 == false && rectangle2.contains( (*it)->pos() ) )
        {
            exist_rect2 = true;
        }

        if( exist_tri && exist_rect && exist_rect2 )
            break;
    }

    if( !exist_tri
        && exist_rect 
        && !exist_rect2 )
    {
        int dash_cycle = 15;
        if( wm.getOpponentGoalie() )
        {
            dash_cycle = Opuci_SelfPass( 0 ).safeCycle( agent, wm.getOpponentGoalie() );
        }
        if( dash_cycle < 4 )
        {
            dash_cycle = 4;
        }
        if( Opuci_SelfPass( 0 ).forceDash( agent, dash_cycle ) )
        {
            agent->debugClient().addLine( vertex1, vertex2 );
            agent->debugClient().addLine( vertex1, vertex3 );
            agent->debugClient().addLine( vertex2, vertex3 );
            agent->debugClient().addRectangle( rectangle );
            agent->debugClient().addRectangle( rectangle2 );
/*
            std::ofstream ofs;
            ofs.open( "11kick.txt", std::ios::app );
            ofs << wm.time().cycle() << " ";
            if( wm.ourSide() == rcsc::LEFT )
            {
                ofs << "left "; 
            }
            else
            {
                ofs << "right ";
            }
            ofs << wm.self().unum() << std::endl;
            ofs.close();
*/
            return true;
        }
    }



    if( std::fabs( wm.self().body().degree() ) < 10.0 )
    {
        rcsc::Vector2D self_to_target = goal_center - wm.self().pos();
        rcsc::AngleDeg base_angle = self_to_target.th();
        for( int dash_cycle = 10; dash_cycle >= 3 ; dash_cycle-- )
        {
            if(Bhv_Offense( goal_center ).doSelfPass( agent, wm.self().body(), dash_cycle ) )
            {
                agent->debugClient().addMessage( "BodySPass%d", dash_cycle );
                return true;
            }
            else if(Bhv_Offense( goal_center ).doSelfPass( agent, rcsc::AngleDeg( 0.0 ), dash_cycle ) )
            {
                agent->debugClient().addMessage( "StraightSPass%d", dash_cycle );
                return true;
            }
        }
    }


    bool danger = false;
    for( rcsc::PlayerPtrCont::const_iterator it = wm.opponentsFromBall().begin();
         it != opp_end;
         ++it )
    {
        if( (*it)->isTackling() )
            continue;

        rcsc::Vector2D next_opp_pos = (*it)->pos() + (*it)->vel();
        double margin = sp.tackleDist();//(*it)->playerTypePtr()->kickableMargin();

        rcsc::Vector2D opp_to_ball = wm.ball().pos() - next_opp_pos;

        rcsc::Circle2D turned_opp_circle( next_opp_pos, margin );
        rcsc::Vector2D opp_dash;
        opp_dash.setPolar( sp.defaultDashPowerRate() * 100, opp_to_ball.th() );
        next_opp_pos += opp_dash;
        rcsc::Circle2D dashed_opp_circle( next_opp_pos, margin );
        if( turned_opp_circle.contains( wm.ball().pos() ) 
            || dashed_opp_circle.contains( wm.ball().pos() ) )
        {
            danger = true;
            break;
        }
    }

    std::vector< rcsc::Vector2D > oppline;
    Bhv_Offense( pOfNoRet ).getOppEndLine( agent, oppline );
    





    if( frontier && Opuci_SelfPass( wm.self().body() ).execute( agent, false ) )
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: SelfPass executed." ,__FILE__, __LINE__ );
        return true;
    }

    //前線である場合
    if( frontier && !danger )
    {
        agent->debugClient().addMessage( "ImFront" );
        // 前にドリブル
        // detect two nearest opponents in the defense line
        if( oppline.size() == 1 && fabs(next_bpos.y) < 20.0 ) //およそペナルティエリア
        {
            rcsc::Vector2D self_center( wm.self().pos().x + 10, wm.self().pos().y );
            if( Body_DribbleOpuci( self_center, 1.0, sp.maxPower(), 4, false ).execute( agent ) )
            {
                agent->debugClient().addMessage( "DribbleA" );
                return true;
            }
        }
        else
        {
            // detect two nearest opponents in the defense line
            double nearest_disy = 1000.0;
            double nearest_disy2 = 1500.0;
            rcsc::Vector2D nearestOppInLine( 0.0, 0.0 );
            rcsc::Vector2D nearestOppInLine2( 0.0, 0.0 );
            for( std::vector< rcsc::Vector2D >::iterator it = oppline.begin();
                 it < oppline.end() ; it++ )
            {
                if( fabs( (*it).y - wm.self().pos().y ) < nearest_disy )
                {
                    nearest_disy2 = nearest_disy;
                    nearest_disy = fabs( (*it).y - wm.self().pos().y );
                    nearestOppInLine2 = nearestOppInLine;
                    nearestOppInLine = (*it);
                }
                else if( fabs( (*it).y - wm.self().pos().y ) < nearest_disy2 )
                {
                    nearest_disy2 = fabs( (*it).y = wm.self().pos().y );
                    nearestOppInLine2 = (*it);
                }
            }
	  
            if( (wm.self().pos().y - nearestOppInLine.y)
                * (wm.self().pos().y - nearestOppInLine2.y) < 0 )
            {
                // I'm between the two nearest opponents in the frontier
                rcsc::Vector2D between = nearestOppInLine + nearestOppInLine2;

                between.setPolar( 7, between.th() );
                rcsc::Vector2D target = wm.self().pos() + between;
                if( Body_DribbleOpuci( target, 1.0, sp.maxPower(), 4, false ).execute( agent ) )
                {
                    agent->debugClient().addMessage( "DribbleC" );
                    return true;
                }
            }
            else if( wm.self().pos().y < nearestOppInLine.y )
            {
                rcsc::Vector2D self_center( wm.self().pos().x + 10, wm.self().pos().y );
                if( Body_DribbleOpuci( self_center, 1.0, sp.maxPower(), 4, false ).execute( agent ) )
                {
                    agent->debugClient().addMessage( "DribbleF" );
                    return true;
                }                  
            }
            else if( wm.self().pos().y > nearestOppInLine.y )
            {
                rcsc::Vector2D self_center( wm.self().pos().x + 10, wm.self().pos().y );
                if( Body_DribbleOpuci( self_center, 1.0, sp.maxPower(), 4, false ).execute( agent ) )
                {
                    agent->debugClient().addMessage( "DribbleG" );
                    return true;
                }                  
            }
        }
    } // end if frontier

/*
    if( angle_dif.abs() > 80 )
    {
        agent->debugClient().addMessage( "HoldForward" );
        rcsc::Body_HoldBall().execute( agent );
        return true;
    }
*/


    if( wm.ball().pos().x > 0.0 )
    {
        const rcsc::PlayerPtrCont::const_iterator end = wm.teammatesFromBall().end();
        for( rcsc::PlayerPtrCont::const_iterator it = wm.teammatesFromBall().begin();
             it != end;
             ++it )
        {    
            if( (*it)->unum() < 7 )
            {
                continue;
            }
            const rcsc::PlayerObject * receiver = (*it);//wm.getTeammateNearestTo( candidates.at( i ), 5, NULL  );
            if( receiver )
            {
                if( receiver->posCount() > count_thr )
                {
                    continue;
                }
                if( fabs( receiver->pos().y - wm.self().pos().y ) > 5 )
                {
                    if( Opuci_ThroughPass().search( agent, receiver, pass_target, first_speed ) )
                    {
                        if( receiver->seenPosCount() == 0 )
                        {
                            agent->debugClient().addMessage( "Target%d", receiver->unum() );
                            agent->debugClient().setTarget( pass_target );
                            if( rcsc::Body_SmartKick( pass_target, first_speed, first_speed * 0.8, 3 ).execute( agent ) )
                            {
                                agent->addSayMessage( new rcsc::PassMessage( receiver->unum(), pass_target,
                                                                             agent->effector().queuedNextBallPos(),
                                                                             agent->effector().queuedNextBallVel() ) );
                            }
                            if( M_neck_cnt <= 0 )
                                M_passMate = -1;
                        }
                        else if( M_passMate != 0 )
                        {
                            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                                "%s:%d: Keep locking on %d at the next cycle."
                                                ,__FILE__, __LINE__, M_passMate );
                            rcsc::Body_HoldBall().execute( agent );
                        }
                        else
                        {
                            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                                "%s:%d: seenCount = %d. Lock on %d at the next cycle."
                                                ,__FILE__, __LINE__, receiver->seenPosCount(), receiver->unum() );
                            M_passMate = receiver->unum();
                            rcsc::Body_HoldBall().execute( agent );
                            M_neck_cnt = 3;
                        }
                        return true;
                    }
                    else if( Opuci_OtherPass().search( agent, receiver, pass_target, first_speed, false ) )
                    {
                        if( receiver->seenPosCount() == 0 )
                        {
                            agent->debugClient().addMessage( "Target%d", receiver->unum() );
                            agent->debugClient().setTarget( pass_target );
                            if( rcsc::Body_SmartKick( pass_target, first_speed, first_speed * 0.8, 3 ).execute( agent ) )
                            {
                                agent->addSayMessage( new rcsc::PassMessage( receiver->unum(), pass_target,
                                                                             agent->effector().queuedNextBallPos(),
                                                                             agent->effector().queuedNextBallVel() ) );
                            }
                            if( M_neck_cnt <= 0 )
                                M_passMate = -1;
                        }
                        else if( M_passMate != 0 )
                        {
                            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                                "%s:%d: Keep locking on %d at the next cycle."
                                                ,__FILE__, __LINE__, M_passMate );
                            rcsc::Body_HoldBall().execute( agent );
                        }
                        else
                        {
                            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                                "%s:%d: seenCount = %d. Lock on %d at the next cycle."
                                                ,__FILE__, __LINE__, receiver->seenPosCount(), receiver->unum() );
                            M_passMate = receiver->unum();
                            rcsc::Body_HoldBall().execute( agent );
                            M_neck_cnt = 3;
                        }
                        
                        return true;
                    }
                }
            }
        }
    }


    std::vector< rcsc::PlayerObject* > cand_mates;
    std::vector< rcsc::PlayerObject* > sub_mates;
    rcsc::PlayerPtrCont::const_iterator end = wm.teammatesFromSelf().end();
    for( rcsc::PlayerPtrCont::const_iterator it = wm.teammatesFromSelf().begin();
         it != end;
         ++it )
    {
        if( (*it)->pos().x >= wm.self().pos().x - 5
            && (*it)->pos().dist( wm.self().pos() ) >= 5 
            && (*it)->posCount() <= count_thr )
        {
            cand_mates.push_back( (*it) );
        }
        else
        {
            sub_mates.push_back( (*it) );
        }
    }
    if( !cand_mates.empty() )
    {
        for( std::vector< rcsc::PlayerObject* >::iterator it1 = cand_mates.begin();
             it1 != cand_mates.end();
             ++it1 )
        {
            for( std::vector< rcsc::PlayerObject* >::iterator it2 = it1;
                 it2 != cand_mates.end();
                 ++it2 )
            {
                if( (*it2)->pos().x > (*it1)->pos().x )
                {
                    swap_ranges( it1, it1 + 1, it2 );
                }
            }
        }
        for( int i = 0; i < (int)cand_mates.size(); i++ )
        {
            const rcsc::PlayerObject * receiver = cand_mates.at( i );
            if( Opuci_DirectPass().search( agent, receiver, pass_target, first_speed ) )
            {
                if( receiver->seenPosCount() == 0 )
                {
                    agent->debugClient().addMessage( "Target%d", receiver->unum() );
                    agent->debugClient().setTarget( pass_target );
                    if( rcsc::Body_SmartKick( pass_target, first_speed, first_speed * 0.8, 3 ).execute( agent ) )
                    {
                        agent->addSayMessage( new rcsc::PassMessage( receiver->unum(), pass_target,
                                                                     agent->effector().queuedNextBallPos(),
                                                                     agent->effector().queuedNextBallVel() ) );
                    }
                    if( M_neck_cnt <= 0 )
                        M_passMate = -1;
                }
                else if( M_passMate != 0 )
                {
                    rcsc::dlog.addText( rcsc::Logger::TEAM,
                                        "%s:%d: Keep locking on %d at the next cycle."
                                        ,__FILE__, __LINE__, M_passMate );
                    rcsc::Body_HoldBall().execute( agent );
                }
                else
                {
                    rcsc::dlog.addText( rcsc::Logger::TEAM,
                                        "%s:%d: seenCount = %d. Lock on %d at the next cycle."
                                        ,__FILE__, __LINE__, receiver->seenPosCount(), receiver->unum() );
                    M_passMate = receiver->unum();
                    rcsc::Body_HoldBall().execute( agent );
                    M_neck_cnt = 3;
                }
                
                return true;
            }
        
        }
    }

    if( danger )
    {
        rcsc::Body_AdvanceBall2009().execute( agent );
        agent->debugClient().addMessage( "Advance" );

        return true;
    }


    if( Body_DribbleOpuci( goal_center, 1.0, sp.maxPower(), 1, false ).execute( agent ) )
    {
        agent->debugClient().addMessage( "OneDribble" );
        return true;
    }
    else
    {
        rcsc::Body_HoldBall2008().execute( agent );
        return true;
    }

}

/*-------------------------------------------------------------------*/
/*!

 */
/*-------------------------------------------------------------------*/
