// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "role_juro.h"

#include "bhv_dango.h"
#include "bhv_simple_dribble.h"
#include "bhv_offense.h"
#include "bhv_shootchance.h"
#include "strategy.h"
#include "opuci_neck.h"
#include "opuci_move.h"
#include "bhv_formation1.h"
#include "opuci_through_pass.h"
#include "opuci_direct_pass.h"
#include "opuci_chase_ball.h"
#include "opuci_self_pass.h"
#include "opuci_dribble.h"
#include "opuci_one_step_kick.h"
#include "opuci_other_pass.h"
#include "body_dribble_opuci.h"
#include "opuci_message.h"
#include <rcsc/player/say_message_builder.h>
#include <rcsc/formation/formation.h>
#include <rcsc/player/intercept_table.h>
#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>

#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>
#include <rcsc/geom/rect_2d.h>
#include <rcsc/geom/ray_2d.h>

#include <rcsc/action/body_kick_one_step.h>
#include <rcsc/action/body_advance_ball2009.h>
#include <rcsc/action/body_dribble2008.h>
#include <rcsc/action/body_smart_kick.h>
#include <rcsc/action/body_hold_ball.h>
#include <rcsc/action/body_intercept2009.h>

const std::string RoleJuro::NAME( "Juro" );

int RoleJuro::M_passMate = -1;
int RoleJuro::M_neck_cnt = -1;

/*-------------------------------------------------------------------*/
/*!

 */
/*-------------------------------------------------------------------*/

namespace {
rcss::RegHolder role = SoccerRole::creators().autoReg( &RoleJuro::create,
                                                       RoleJuro::NAME );
}

/*-------------------------------------------------------------------*/
/*!

*/
/*-------------------------------------------------------------------*/

void
RoleJuro::execute( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: RoleJuro::execute"
                        ,__FILE__, __LINE__ );

    const rcsc::WorldModel & wm = agent->world();
    std::vector< int > opp_num;
    Bhv_Offense().surroundOppNum( agent, opp_num );

   
    rcsc::Vector2D top_left( 30, -34 );
    rcsc::Vector2D bottom_right( 52.5, 34 );
    rcsc::Rect2D shoot_chance( top_left, bottom_right );
    rcsc::Vector2D goal_center( 51.5, 0.0 );

    int self_min = std::min( Opuci_ChaseBall().calcCycle( agent ),
                             wm.interceptTable()->selfReachCycle() );
    int mate_min = wm.interceptTable()->teammateReachCycle();
    int opp_min = wm.interceptTable()->opponentReachCycle();
    
    int min = std::min( self_min, std::min( mate_min, opp_min ) );
    int our_min = std::min( self_min, mate_min );

    M_receive_pos = wm.ball().inertiaPoint( min );
    rcsc::dlog.addText( rcsc::Logger::TEAM, "%s:%d: M_receive_pos(%f, %f)"
                        ,__FILE__, __LINE__, M_receive_pos.x, M_receive_pos.y );

    if( M_receive_pos.x > 30.0 )
    {
        agent->debugClient().addMessage( "ShootChance" );
        Bhv_Shootchance( goal_center ).execute( agent );
        return;
    }
  
    if( wm.self().isKickable() )
    {
        doKick( agent );

        if( M_passMate == -1 )
            Opuci_Neck().execute( agent );
        else
        {
            Opuci_Neck().lookAtPassReceiver( agent, M_passMate );
            M_neck_cnt--;
            if( M_neck_cnt <= 0 )
                M_passMate = -1;
        }
    }
    else
    {
        doMove( agent );
    }
    
    if( wm.ball().rposCount() == 0
        && wm.ball().pos().dist( wm.self().pos() ) < 20.0 )
    {
        //ボールのrposcountが0ならばボールの位置・速度，自分の位置，体の角度をメッセージで配信
        agent->addSayMessage( new rcsc::BallPlayerMessage( agent->effector().queuedNextBallPos(), 
                                                           agent->effector().queuedNextBallVel(),
                                                           wm.self().unum(),
                                                           agent->effector().queuedNextMyPos(),
                                                           agent->effector().queuedNextMyBody() ) );
    }
    else
        Opuci_Message().normalSayMessage( agent, 5 );

    return;
}

/*-------------------------------------------------------------------*/
/*!

*/
/*-------------------------------------------------------------------*/

void
RoleJuro::doKick( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: RoleJuro::doKick" ,__FILE__, __LINE__ );

    const rcsc::WorldModel & wm = agent->world();
    const rcsc::ServerParam & sp = rcsc::ServerParam::i();

    bool acted = false;
    rcsc::Vector2D goal_center( 51.5, 0.0 );
    rcsc::Vector2D pass_target;
    double first_speed = sp.ballSpeedMax();
    
    const rcsc::PlayerPtrCont::const_iterator opp_end = wm.opponentsFromBall().end();
    std::vector< rcsc::PlayerObject* > point_mates;
    const rcsc::PlayerPtrCont::const_iterator end_self = wm.teammatesFromSelf().end();
    for( rcsc::PlayerPtrCont::const_iterator it = wm.teammatesFromSelf().begin();
         it != end_self;
         ++it )
    {
        if( (*it)->pointtoCount() < 10 )
        {
            point_mates.push_back( (*it) );
        }
    }
    if( !point_mates.empty() 
        && wm.getOpponentGoalie() )
    {
        for( std::vector< rcsc::PlayerObject* >::iterator it = point_mates.begin();
             it != point_mates.end();
             ++it )
        {
            for( std::vector< rcsc::PlayerObject* >::iterator it2 = it;
                 it2 != point_mates.end();
                 ++it2 )
            {
                if( (*it)->pos().x < (*it2)->pos().x )
                    std::swap( *it, *it2 );
            }
        }
        for( std::vector< rcsc::PlayerObject* >::iterator it = point_mates.begin();
             it != point_mates.end();
             ++it )
        {
            if( acted == true )
            {
                break;
            }
            if( Bhv_Offense().pointingPass( agent, (*it), pass_target, first_speed ) )
            {
                if( (*it)->seenPosCount() == 0 )
                {
                    const rcsc::PlayerObject * receiver = (*it);
                    if( rcsc::Body_SmartKick( pass_target, first_speed, first_speed * 0.95, 1 ).execute( agent ) )
                    {
                        agent->debugClient().setTarget( pass_target );
                        agent->debugClient().addMessage( "PointingPass%d", receiver->unum() );
                        agent->addSayMessage( new rcsc::PassMessage( receiver->unum(), pass_target,
                                                                     agent->effector().queuedNextBallPos(),
                                                                     agent->effector().queuedNextBallVel() ) );
                    }
                    if( M_neck_cnt <= 0 )
                        M_passMate = -1;
                }
                else if( M_passMate != -1 )
                {
                    rcsc::dlog.addText( rcsc::Logger::TEAM,
                                        "%s:%d: Keep locking on %d at the next cycle."
                                        ,__FILE__, __LINE__, M_passMate );
                    rcsc::Body_HoldBall().execute( agent );
                }
                else
                {
                    rcsc::dlog.addText( rcsc::Logger::TEAM,
                                        "%s:%d: seenCount = %d. Lock on %d at the next cycle."
                                        ,__FILE__, __LINE__, (*it)->seenPosCount(), (*it)->unum() );
                    M_passMate = (*it)->unum();
                    rcsc::Body_HoldBall().execute( agent );
                    M_neck_cnt = 3;
                }
                acted = true;
                break;
            }
        }
    }




    std::vector< int > unumffmate;
    Bhv_Offense( goal_center ).findFrontFreeMate( unumffmate, agent );

    bool danger = false;
    for( rcsc::PlayerPtrCont::const_iterator it = wm.opponentsFromBall().begin();
         it != opp_end;
         ++it )
    {
        rcsc::Vector2D next_opp_pos = (*it)->pos() + (*it)->vel();
        double margin = sp.tackleDist();//(*it)->playerTypePtr()->kickableMargin();

        rcsc::Vector2D opp_to_ball = wm.ball().pos() - next_opp_pos;
        
        rcsc::Circle2D turned_opp_circle( next_opp_pos, margin );
        rcsc::Vector2D opp_dash;
        opp_dash.setPolar( sp.defaultDashPowerRate() * 100, opp_to_ball.th() );
        next_opp_pos += opp_dash;
        rcsc::Circle2D dashed_opp_circle( next_opp_pos, margin );
        if( turned_opp_circle.contains( wm.ball().pos() ) 
            || dashed_opp_circle.contains( wm.ball().pos() ) )
        {
            danger = true;
            break;
        }
    }

    std::vector< rcsc::PlayerObject* > front_mates;
    bool frontier = true;
    // check if I'm in the frontier
    int count_thr = 2;
    if( wm.interceptTable()->opponentReachCycle() < 3 )
    {
        count_thr = 4;
    }
    for( rcsc::PlayerPtrCont::const_iterator it = wm.teammatesFromSelf().begin();
         it != end_self;
         ++it )
    {
        if( (*it)->pos().x > wm.self().pos().x )
        {
            frontier = false;
            if( (*it)->seenPosCount() <= count_thr
                && (*it)->pos().x < wm.offsideLineX() )
            {
                front_mates.push_back( (*it) );                
            }
        }
    }
    //　前方にいる味方ほどfrontにソート
    for( std::vector< rcsc::PlayerObject* >::iterator it = front_mates.begin();
         it != front_mates.end();
         ++it )
    {
        for( std::vector< rcsc::PlayerObject* >::iterator it2 = it;
             it2 != front_mates.end();
             ++it2 )
        {
            if( (*it)->pos().x < (*it2)->pos().x )
                std::swap( *it, *it2 );
        }
    }


    rcsc::Vector2D next_self_pos = wm.self().pos() + wm.self().vel();
    rcsc::Vector2D next_bpos = wm.ball().inertiaPoint( 1 );
    rcsc::Vector2D tmp_target = goal_center - next_self_pos;
    rcsc::AngleDeg angle_dif = tmp_target.th() - wm.self().body();

    std::vector< rcsc::Vector2D > oppline;
    Bhv_Offense( goal_center ).getOppEndLine( agent, oppline );

 
#if 1    
    double length = 20.0;
    double width = 13.0;

    rcsc::Vector2D vertex1 = wm.self().pos() + rcsc::Vector2D( -wm.self().kickableArea() * 1.3, 0 );
    rcsc::Vector2D vertex2 = wm.self().pos() + rcsc::Vector2D( length, -width );
    rcsc::Vector2D vertex3 = wm.self().pos() + rcsc::Vector2D( length, width );
    rcsc::Triangle2D triangle( vertex1, vertex2, vertex3 );

    rcsc::Vector2D tl = wm.self().pos() + rcsc::Vector2D( 0, -width );
    rcsc::Vector2D br = wm.self().pos() + rcsc::Vector2D( length / 5.0, width );
    rcsc::Rect2D rectangle( tl, br );

    rcsc::Vector2D tl2( br.x, tl.y );
    rcsc::Vector2D br2( br.x + length / 3.0, br.y );
    rcsc::Rect2D rectangle2( tl2, br2 );

    bool exist_tri = false;    
    bool exist_rect = false;
    bool exist_rect2 = false;
    
    for( rcsc::PlayerPtrCont::const_iterator it = wm.opponentsFromBall().begin();
         it != opp_end;
         ++it )
    {
        if( (*it)->goalie() )
            continue;

        if( !exist_tri && triangle.contains( (*it)->pos() ) )
        {
            exist_tri = true;
        }
        if( !exist_rect && rectangle.contains( (*it)->pos() ) )
        {
            exist_rect = true;
        }
        if( !exist_rect2 && rectangle2.contains( (*it)->pos() ) )
        {
            exist_rect2 = true;
        }

        if( exist_tri && exist_rect && exist_rect2 )
            break;
    }
    if( acted == false 
        && !exist_tri
        && exist_rect 
        && !exist_rect2 )
    {
        int dash_cycle = 15;
        if( wm.getOpponentGoalie() )
        {
            dash_cycle = Opuci_SelfPass( 0 ).safeCycle( agent, wm.getOpponentGoalie() );
        }
        if( dash_cycle < 4 )
        {
            dash_cycle = 4;
        }
        if( wm.getOpponentNearestToSelf( 100 )
            && wm.getOpponentNearestToSelf( 100 )->pos().dist( wm.self().pos() ) > 3.0 )
        {
            double y = wm.self().pos().y;
            if( y > 32 )
            {
                y = 32;
            }
            else if( y < -32 )
            {
                y = -32;
            }
            Body_DribbleOpuci( rcsc::Vector2D( 52.5, y ), 1.0, sp.maxPower(), 2, true ).execute( agent );
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "%s:%d: Lib-base dribble." ,__FILE__, __LINE__ );
            acted = true;
        }
        else if( Opuci_SelfPass( 0 ).forceDash( agent, dash_cycle ) )
        {
            agent->debugClient().addLine( vertex1, vertex2 );
            agent->debugClient().addLine( vertex1, vertex3 );
            agent->debugClient().addLine( vertex2, vertex3 );
            agent->debugClient().addRectangle( rectangle );
            agent->debugClient().addRectangle( rectangle2 );
/*
            std::ofstream ofs;
            ofs.open( "9kick.txt", std::ios::app );
            ofs << wm.time().cycle() << " ";
            if( wm.ourSide() == rcsc::LEFT )
            {
                ofs << "left "; 
            }
            else
            {
                ofs << "right ";
            }
            ofs << wm.self().unum() << std::endl;
            ofs.close();
*/
            acted = true;
        }
    }
#endif


    if( acted == false && frontier && Opuci_SelfPass( wm.self().body() ).execute( agent, false ) )
    {
        acted = true;
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: SelfPass executed." ,__FILE__, __LINE__ );
    }

    rcsc::Vector2D top_left = rcsc::Vector2D( wm.self().pos().x, wm.self().pos().y - 1.8 );
    rcsc::Vector2D bottom_right = rcsc::Vector2D( wm.self().pos().x + 7, wm.self().pos().y + 1.8 );
    rcsc::Rect2D front_area( top_left, bottom_right );
    if( acted == false && !wm.existOpponentIn( front_area, 5, true ) )
    {
        rcsc::Vector2D self_center( wm.self().pos().x + 8, wm.self().pos().y );
        if( self_center.y > 32 )
        {
            self_center.y = 32;
        }
        else if( self_center.y < -32 )
        {
            self_center.y = -32;
        }
        if( acted == false && Body_DribbleOpuci( self_center, 1.0, sp.maxPower(), 4, false ).execute( agent ) )
        {
            agent->debugClient().addMessage( "FrontDribble" );
            acted = true;
        }
    }
    //前線である場合
    if( frontier && !danger && acted == false )
    {
        agent->debugClient().addMessage( "ImFront" );
        // 前にドリブル
        // detect two nearest opponents in the defense line
        if( oppline.size() == 1 && fabs(next_bpos.y) < 20.0 ) //およそペナルティエリア
        {
            rcsc::Vector2D self_center( wm.self().pos().x + 10, wm.self().pos().y );
            if( self_center.y > 32 )
            {
                self_center.y = 32;
            }
            else if( self_center.y < -32 )
            {
                self_center.y = -32;
            }
            if( Body_DribbleOpuci( self_center, 1.0, sp.maxPower(), 4, false ).execute( agent ) )
            {
                agent->debugClient().addMessage( "DribbleA" );
                acted = true;
            }
        }
        else
        {
            // detect two nearest opponents in the defense line
            double nearest_disy = 1000.0;
            double nearest_disy2 = 1500.0;
            rcsc::Vector2D nearestOppInLine( 0.0, 0.0 );
            rcsc::Vector2D nearestOppInLine2( 0.0, 0.0 );
            for( std::vector< rcsc::Vector2D >::iterator it = oppline.begin();
                 it < oppline.end() ; it++ )
            {
                if( fabs( (*it).y - wm.self().pos().y ) < nearest_disy )
                {
                    nearest_disy2 = nearest_disy;
                    nearest_disy = fabs( (*it).y - wm.self().pos().y );
                    nearestOppInLine2 = nearestOppInLine;
                    nearestOppInLine = (*it);
                }
                else if( fabs( (*it).y - wm.self().pos().y ) < nearest_disy2 )
                {
                    nearest_disy2 = fabs( (*it).y = wm.self().pos().y );
                    nearestOppInLine2 = (*it);
                }
            }
            if( acted == false && (wm.self().pos().y - nearestOppInLine.y)
                * (wm.self().pos().y - nearestOppInLine2.y) < 0 )
            {
                // I'm between the two nearest opponents in the frontier
                rcsc::Vector2D between = nearestOppInLine + nearestOppInLine2;

                between.setPolar( 7, between.th() );
                rcsc::Vector2D target = wm.self().pos() + between;
                if( target.y > 32 )
                {
                    target.y = 32;
                }
                else if( target.y < -32 )
                {
                    target.y = -32;
                }
                if( Body_DribbleOpuci( target, 1.0, sp.maxPower(), 4, false ).execute( agent ) )
                {
                    agent->debugClient().addMessage( "DribbleC" );
                    acted = true;
                }
            }
            if( acted == false && wm.self().pos().y < nearestOppInLine.y )
            {
                rcsc::Vector2D top_side( nearestOppInLine.x, -31.5 );
                if( Body_DribbleOpuci( top_side, 1.0, sp.maxPower(), 4, false ).execute( agent ) )
                {
                    agent->debugClient().addMessage( "DribbleD" );
                    acted = true;
                }                
            }
            if( acted == false && wm.self().pos().y > nearestOppInLine.y )
            {
                rcsc::Vector2D self_center( wm.self().pos().x + 10, wm.self().pos().y );
                if( self_center.y > 32 )
                {
                    self_center.y = 32;
                }
                else if( self_center.y < -32 )
                {
                    self_center.y = -32;
                }
                if( Body_DribbleOpuci( self_center, 1.0, sp.maxPower(), 4, false ).execute( agent ) )
                {
                    agent->debugClient().addMessage( "DribbleF" );
                    acted = true;
                }                  
            }
        }
    } // end if frontier
    

   
    
    int self_opp = Bhv_Offense().countSectorOpp( agent, wm.self().pos(), 0, 15, 30 );
    std::vector< int > opp_num;
    Bhv_Offense().surroundOppNum( agent, opp_num );    
    int self_opp2 = 3;
    switch( wm.self().unum() )
    {
    case 7:
        self_opp2 = opp_num[0];
        break;
    case 8:
        self_opp2 = opp_num[1];
        break;
    case 9:
        self_opp2 = opp_num[2];
        break;
    case 10:
        self_opp2 = opp_num[3];
        break;
    case 11:
        self_opp2 = opp_num[4];
        break;
    default:
        break;
    }
    for( std::vector< rcsc::PlayerObject* >::iterator it = front_mates.begin();
         it != front_mates.end();
         ++it )
    {
        if( acted )
            break;
        int mate_opp = Bhv_Offense().countSectorOpp( agent, (*it)->pos(), 0, 15, 30 );
        int mate_opp2 = 5;
        switch( (*it)->unum() )
        {
        case 7:
            mate_opp2 = opp_num[0];
            break;
        case 8:
            mate_opp2 = opp_num[1];
            break;
        case 9:
            mate_opp2 = opp_num[2];
            break;
        case 10:
            mate_opp2 = opp_num[3];
            break;
        case 11:
            mate_opp2 = opp_num[4];
            break;
        default:
            break;
        }
        if( mate_opp <= self_opp 
            || mate_opp2 <= self_opp2 )
        {
            const rcsc::PlayerObject * receiver = (*it);

            if( Opuci_ThroughPass().search( agent, receiver, pass_target, first_speed ) )
            {
                if( receiver->seenPosCount() == 0 )
                {
                    agent->debugClient().addMessage( "2Front%d", __LINE__ );
                    agent->debugClient().addMessage( "Target%d", receiver->unum() );
                    agent->debugClient().setTarget( pass_target );
                    rcsc::dlog.addText( rcsc::Logger::TEAM,
                                        "%s:%d: ThroughPass to %d (posCount = %d)"
                                        ,__FILE__, __LINE__, receiver->unum(), receiver->posCount() );
                    if( rcsc::Body_SmartKick( pass_target, first_speed, first_speed * 0.8, 3 ).execute( agent ) )
                    {
                        agent->addSayMessage( new rcsc::PassMessage( receiver->unum(), pass_target,
                                                                     agent->effector().queuedNextBallPos(),
                                                                     agent->effector().queuedNextBallVel() ) );
                    }
                    if( M_neck_cnt <= 0 )
                        M_passMate = -1;
                }
                else if( M_passMate != -1 )
                {
                    rcsc::dlog.addText( rcsc::Logger::TEAM,
                                        "%s:%d: Keep locking on %d at the next cycle."
                                        ,__FILE__, __LINE__, M_passMate );
                    rcsc::Body_HoldBall().execute( agent );
                }
                else
                {
                    rcsc::dlog.addText( rcsc::Logger::TEAM,
                                        "%s:%d: seenCount = %d. Lock on %d at the next cycle."
                                        ,__FILE__, __LINE__, receiver->seenPosCount(), receiver->unum() );
                    M_passMate = receiver->unum();
                    rcsc::Body_HoldBall().execute( agent );
                    M_neck_cnt = 3;
                }

                acted = true;
                break;
            }
            else if( Opuci_OtherPass().search( agent, receiver, pass_target, first_speed, false ) )
            {
                if( receiver->seenPosCount() == 0 )
                {
                    agent->debugClient().addMessage( "2Front%d", __LINE__ );
                    agent->debugClient().addMessage( "Target%d", receiver->unum() );
                    agent->debugClient().setTarget( pass_target );
                    rcsc::dlog.addText( rcsc::Logger::TEAM,
                                        "%s:%d: OtherPass to %d (posCount = %d)"
                                        ,__FILE__, __LINE__, receiver->unum(), receiver->posCount() );
                    if( rcsc::Body_SmartKick( pass_target, first_speed, first_speed * 0.8, 3 ).execute( agent ) )
                    {
                        agent->addSayMessage( new rcsc::PassMessage( receiver->unum(), pass_target,
                                                                     agent->effector().queuedNextBallPos(),
                                                                     agent->effector().queuedNextBallVel() ) );
                    }
                    if( M_neck_cnt <= 0 )
                        M_passMate = -1;
                }
                else if( M_passMate != -1 )
                {
                    rcsc::dlog.addText( rcsc::Logger::TEAM,
                                        "%s:%d: Keep locking on %d at the next cycle."
                                        ,__FILE__, __LINE__, M_passMate );
                    rcsc::Body_HoldBall().execute( agent );
                }
                else
                {
                    rcsc::dlog.addText( rcsc::Logger::TEAM,
                                        "%s:%d: seenCount = %d. Lock on %d at the next cycle."
                                        ,__FILE__, __LINE__, receiver->seenPosCount(), receiver->unum() );
                    M_passMate = receiver->unum();
                    rcsc::Body_HoldBall().execute( agent );
                    M_neck_cnt = 3;
                }

                
                acted = true;
                break;
            }            
            else if( Opuci_DirectPass().search( agent, receiver, pass_target, first_speed ) )
            {
                if( receiver->seenPosCount() == 0 )
                {
                    agent->debugClient().addMessage( "2Front%d", __LINE__ );
                    agent->debugClient().addMessage( "Target%d", receiver->unum() );
                    agent->debugClient().setTarget( pass_target );
                    rcsc::dlog.addText( rcsc::Logger::TEAM,
                                        "%s:%d: DirectPass to %d (posCount = %d)"
                                        ,__FILE__, __LINE__, receiver->unum(), receiver->posCount() );
                    if( rcsc::Body_SmartKick( pass_target, first_speed, first_speed * 0.8, 3 ).execute( agent ) )
                    {
                        agent->addSayMessage( new rcsc::PassMessage( receiver->unum(), pass_target,
                                                                     agent->effector().queuedNextBallPos(),
                                                                     agent->effector().queuedNextBallVel() ) );
                    }
                    if( M_neck_cnt <= 0 )
                        M_passMate = -1;
                }
                else if( M_passMate != -1 )
                {
                    rcsc::dlog.addText( rcsc::Logger::TEAM,
                                        "%s:%d: Keep locking on %d at the next cycle."
                                        ,__FILE__, __LINE__, M_passMate );
                    rcsc::Body_HoldBall().execute( agent );
                }
                else
                {
                    rcsc::dlog.addText( rcsc::Logger::TEAM,
                                        "%s:%d: seenCount = %d. Lock on %d at the next cycle."
                                        ,__FILE__, __LINE__, receiver->seenPosCount(), receiver->unum() );
                    M_passMate = receiver->unum();
                    rcsc::Body_HoldBall().execute( agent );
                    M_neck_cnt = 3;
                }
                
                acted = true;
                break;
            }
        }
    }
    

    for( std::vector<int>::iterator it = unumffmate.begin() ;
         it != unumffmate.end();
         ++it )
    {
        if( acted || !danger )
            break;
        const rcsc::PlayerObject * receiver = (rcsc::PlayerObject*)wm.teammate( *it );
        if( !receiver )
            continue;

        if( Opuci_ThroughPass().search( agent, receiver, pass_target, first_speed ) )
        {
            if( receiver->seenPosCount() == 0 )
            {
                agent->debugClient().addMessage( "Target%d", *it );
                agent->debugClient().setTarget( pass_target );
                rcsc::dlog.addText( rcsc::Logger::TEAM,
                                    "%s:%d: ThroughPass to %d (posCount = %d)"
                                    ,__FILE__, __LINE__, *it, receiver->posCount() );
                if( rcsc::Body_SmartKick( pass_target, first_speed, first_speed * 0.8, 3 ).execute( agent ) )
                {
                    agent->addSayMessage( new rcsc::PassMessage( *it, pass_target,
                                                                 agent->effector().queuedNextBallPos(),
                                                                 agent->effector().queuedNextBallVel() ) );
                }
                if( M_neck_cnt <= 0 )
                    M_passMate = -1;
            }
            else if( M_passMate != -1 )
            {
                rcsc::dlog.addText( rcsc::Logger::TEAM,
                                    "%s:%d: Keep locking on %d at the next cycle."
                                    ,__FILE__, __LINE__, M_passMate );
                rcsc::Body_HoldBall().execute( agent );
            }
            else
            {
                rcsc::dlog.addText( rcsc::Logger::TEAM,
                                    "%s:%d: seenCount = %d. Lock on %d at the next cycle."
                                    ,__FILE__, __LINE__, receiver->seenPosCount(), receiver->unum() );
                M_passMate = receiver->unum();
                rcsc::Body_HoldBall().execute( agent );
                M_neck_cnt = 3;
            }
            acted = true;
            break;
        }
        else if( Opuci_OtherPass().search( agent, receiver, pass_target, first_speed, false ) )
        {
            if( receiver->seenPosCount() == 0 )
            {
                agent->debugClient().addMessage( "Target%d", receiver->unum() );
                agent->debugClient().setTarget( pass_target );
                rcsc::dlog.addText( rcsc::Logger::TEAM,
                                    "%s:%d: OtherPass to %d (posCount = %d)"
                                    ,__FILE__, __LINE__, *it, receiver->posCount() );
                if( rcsc::Body_SmartKick( pass_target, first_speed, first_speed * 0.8, 3 ).execute( agent ) )
                {
                    agent->addSayMessage( new rcsc::PassMessage( *it, pass_target,
                                                                 agent->effector().queuedNextBallPos(),
                                                                 agent->effector().queuedNextBallVel() ) );
                }
                if( M_neck_cnt <= 0 )
                    M_passMate = -1;
            }
            else if( M_passMate != -1 )
            {
                rcsc::dlog.addText( rcsc::Logger::TEAM,
                                    "%s:%d: Keep locking on %d at the next cycle."
                                    ,__FILE__, __LINE__, M_passMate );
                rcsc::Body_HoldBall().execute( agent );
            }
            else
            {
                rcsc::dlog.addText( rcsc::Logger::TEAM,
                                    "%s:%d: seenCount = %d. Lock on %d at the next cycle."
                                    ,__FILE__, __LINE__, receiver->seenPosCount(), receiver->unum() );
                M_passMate = receiver->unum();
                rcsc::Body_HoldBall().execute( agent );
                M_neck_cnt = 3;
            }

            acted = true;
            break;
        }
        else if( Opuci_DirectPass().search( agent, receiver, pass_target, first_speed ) )
        {
            if( receiver->seenPosCount() == 0 )
            {
                agent->debugClient().addMessage( "Target%d", *it );
                agent->debugClient().setTarget( pass_target );
                rcsc::dlog.addText( rcsc::Logger::TEAM,
                                    "%s:%d: DirectPass to %d (posCount = %d)"
                                    ,__FILE__, __LINE__, *it, receiver->posCount() );
                if( rcsc::Body_SmartKick( pass_target, first_speed, first_speed * 0.8, 3 ).execute( agent ) )
                {
                    agent->addSayMessage( new rcsc::PassMessage( *it, pass_target,
                                                                 agent->effector().queuedNextBallPos(),
                                                                 agent->effector().queuedNextBallVel() ) );
                }
                if( M_neck_cnt <= 0 )
                    M_passMate = -1;
            }
            else if( M_passMate != -1 )
            {
                rcsc::dlog.addText( rcsc::Logger::TEAM,
                                    "%s:%d: Keep locking on %d at the next cycle."
                                    ,__FILE__, __LINE__, M_passMate );
                rcsc::Body_HoldBall().execute( agent );
            }
            else
            {
                rcsc::dlog.addText( rcsc::Logger::TEAM,
                                    "%s:%d: seenCount = %d. Lock on %d at the next cycle."
                                    ,__FILE__, __LINE__, receiver->seenPosCount(), receiver->unum() );
                M_passMate = receiver->unum();
                rcsc::Body_HoldBall().execute( agent );
                M_neck_cnt = 3;
            }
            
            acted = true;
            break;
        }

        
    }

    if( acted == false && angle_dif.abs() > 80 )
    {
        agent->debugClient().addMessage( "HoldForward" );
        rcsc::Body_HoldBall().execute( agent );
        acted = true;
    }



    rcsc::PlayerPtrCont::const_iterator end = wm.teammatesFromSelf().end();
    for( rcsc::PlayerPtrCont::const_iterator it = wm.teammatesFromSelf().begin();
         it != end;
         ++it )
    {
        if( acted == true )
            break;
        const rcsc::PlayerObject * receiver = (*it);

        if( Opuci_ThroughPass().search( agent, receiver, pass_target, first_speed ) )
        {
            if( receiver->seenPosCount() == 0 )
            {
                agent->debugClient().addMessage( "Target%d", receiver->unum() );
                agent->debugClient().setTarget( pass_target );
                if( rcsc::Body_SmartKick( pass_target, first_speed, first_speed * 0.8, 3 ).execute( agent ) )
                {
                    agent->addSayMessage( new rcsc::PassMessage( receiver->unum(), pass_target,
                                                                 agent->effector().queuedNextBallPos(),
                                                                 agent->effector().queuedNextBallVel() ) );
                }
                if( M_neck_cnt <= 0 )
                    M_passMate = -1;
            }
            else if( M_passMate != -1 )
            {
                rcsc::dlog.addText( rcsc::Logger::TEAM,
                                    "%s:%d: Keep locking on %d at the next cycle."
                                    ,__FILE__, __LINE__, M_passMate );
                rcsc::Body_HoldBall().execute( agent );
            }
            else
            {
                rcsc::dlog.addText( rcsc::Logger::TEAM,
                                    "%s:%d: seenCount = %d. Lock on %d at the next cycle."
                                    ,__FILE__, __LINE__, receiver->seenPosCount(), receiver->unum() );
                M_passMate = receiver->unum();
                rcsc::Body_HoldBall().execute( agent );
                M_neck_cnt = 3;
            }

            acted = true;
        }
        else if( Opuci_OtherPass().search( agent, receiver, pass_target, first_speed, false ) )
        {
            if( receiver->seenPosCount() == 0 )
            {
                agent->debugClient().addMessage( "Target%d", receiver->unum() );
                agent->debugClient().setTarget( pass_target );
                if( rcsc::Body_SmartKick( pass_target, first_speed, first_speed * 0.8, 3 ).execute( agent ) )
                {
                    agent->addSayMessage( new rcsc::PassMessage( receiver->unum(), pass_target,
                                                                 agent->effector().queuedNextBallPos(),
                                                                 agent->effector().queuedNextBallVel() ) );
                }
                if( M_neck_cnt <= 0 )
                    M_passMate = -1;
            }
            else if( M_passMate != -1 )
            {
                rcsc::dlog.addText( rcsc::Logger::TEAM,
                                    "%s:%d: Keep locking on %d at the next cycle."
                                    ,__FILE__, __LINE__, M_passMate );
                rcsc::Body_HoldBall().execute( agent );
            }
            else
            {
                rcsc::dlog.addText( rcsc::Logger::TEAM,
                                    "%s:%d: seenCount = %d. Lock on %d at the next cycle."
                                    ,__FILE__, __LINE__, receiver->seenPosCount(), receiver->unum() );
                M_passMate = receiver->unum();
                rcsc::Body_HoldBall().execute( agent );
                M_neck_cnt = 3;
            }

            acted = true;
        }
    }
    std::vector< rcsc::PlayerObject* > cand_mates;
    std::vector< rcsc::PlayerObject* > sub_mates;
    for( rcsc::PlayerPtrCont::const_iterator it = wm.teammatesFromSelf().begin();
         it != end;
         ++it )
    {
        if( (*it)->pos().x >= wm.self().pos().x - 5
            && (*it)->pos().dist( wm.self().pos() ) >= 5 
            && (*it)->seenPosCount() <= count_thr )
        {
            cand_mates.push_back( (*it) );
        }
        else
        {
            sub_mates.push_back( (*it) );
        }
        
    }
    if( !cand_mates.empty() )
    {
        for( std::vector< rcsc::PlayerObject* >::iterator it1 = cand_mates.begin();
             it1 != cand_mates.end();
             ++it1 )
        {
            for( std::vector< rcsc::PlayerObject* >::iterator it2 = it1;
                 it2 != cand_mates.end();
                 ++it2 )
            {
                int opp_num1 = Bhv_Offense().countSectorOpp( agent, (*it1)->pos(), 0, 20, 30 );
                int opp_num2 = Bhv_Offense().countSectorOpp( agent, (*it2)->pos(), 0, 20, 30 );
                
                
                if( opp_num2 < opp_num1 )
                {
                    swap_ranges( it1, it1 + 1, it2 );
                }
            }
        }
        for( int i = 0; i < (int)cand_mates.size(); i++ )
        {
            if( acted == true )
                break;
            rcsc::PlayerObject * receiver = cand_mates.at( i );
            std::vector< rcsc::PlayerObject* > subs;
            if( Opuci_DirectPass().search( agent, receiver, pass_target, first_speed ) )
            {
                if( receiver->seenPosCount() == 0 )
                {
                    agent->debugClient().addMessage( "Target%d", receiver->unum() );
                    agent->debugClient().setTarget( pass_target );
                    if( rcsc::Body_SmartKick( pass_target, first_speed, first_speed * 0.8, 3 ).execute( agent ) )
                    {
                        agent->addSayMessage( new rcsc::PassMessage( receiver->unum(), pass_target,
                                                                     agent->effector().queuedNextBallPos(),
                                                                     agent->effector().queuedNextBallVel() ) );
                    }
                    if( M_neck_cnt <= 0 )
                        M_passMate = -1;
                }
                else if( M_passMate != -1 )
                {
                    rcsc::dlog.addText( rcsc::Logger::TEAM,
                                        "%s:%d: Keep locking on %d at the next cycle."
                                        ,__FILE__, __LINE__, M_passMate );
                    rcsc::Body_HoldBall().execute( agent );
                }
                else
                {
                    rcsc::dlog.addText( rcsc::Logger::TEAM,
                                        "%s:%d: seenCount = %d. Lock on %d at the next cycle."
                                        ,__FILE__, __LINE__, receiver->seenPosCount(), receiver->unum() );
                    M_passMate = receiver->unum();
                    rcsc::Body_HoldBall().execute( agent );
                    M_neck_cnt = 3;
                }

                acted = true;
            }
            else if( Bhv_Offense().getSubReceiver( agent, cand_mates.at( i ), subs ) )
            {
                for( int j = 0; j < (int)subs.size(); j++ )
                {
                    receiver = subs.at( j );
                    if( Opuci_DirectPass().search( agent, receiver, pass_target, first_speed ) )
                    {
                        if( receiver->seenPosCount() == 0 )
                        {
                            agent->debugClient().addMessage( "Target%d", receiver->unum() );
                            agent->debugClient().addLine( wm.self().pos(), subs.at( j )->pos() );
                            agent->debugClient().addLine( subs.at( j )->pos(), cand_mates.at( i )->pos() );
                            agent->debugClient().setTarget( pass_target );
                            if( rcsc::Body_SmartKick( pass_target, first_speed, first_speed * 0.8, 3 ).execute( agent ) )
                            {
                                agent->addSayMessage( new rcsc::PassMessage( receiver->unum(), pass_target,
                                                                             agent->effector().queuedNextBallPos(),
                                                                             agent->effector().queuedNextBallVel() ) );
                            }
                            if( M_neck_cnt <= 0 )
                                M_passMate = -1;
                        }
                        else if( M_passMate != -1 )
                        {
                            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                                "%s:%d: Keep locking on %d at the next cycle."
                                                ,__FILE__, __LINE__, M_passMate );
                            rcsc::Body_HoldBall().execute( agent );
                        }
                        else
                        {
                            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                                "%s:%d: seenCount = %d. Lock on %d at the next cycle."
                                                ,__FILE__, __LINE__, receiver->seenPosCount(), receiver->unum() );
                            M_passMate = receiver->unum();
                            rcsc::Body_HoldBall().execute( agent );
                            M_neck_cnt = 3;
                        }

                        acted = true;
                        break;
                    }
                    else if( Opuci_OtherPass().search( agent, receiver, pass_target, first_speed, false ) )
                    {
                        if( receiver->seenPosCount() == 0 )
                        {
                            agent->debugClient().addMessage( "Target%d", receiver->unum() );
                            agent->debugClient().addLine( wm.self().pos(), subs.at( j )->pos() );
                            agent->debugClient().addLine( subs.at( j )->pos(), cand_mates.at( i )->pos() );
                            agent->debugClient().setTarget( pass_target );
                            if( rcsc::Body_SmartKick( pass_target, first_speed, first_speed * 0.8, 3 ).execute( agent ) )
                            {
                                agent->addSayMessage( new rcsc::PassMessage( receiver->unum(), pass_target,
                                                                             agent->effector().queuedNextBallPos(),
                                                                             agent->effector().queuedNextBallVel() ) );
                            }
                            if( M_neck_cnt <= 0 )
                                M_passMate = -1;
                        }
                        else if( M_passMate != -1 )
                        {
                            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                                "%s:%d: Keep locking on %d at the next cycle."
                                                ,__FILE__, __LINE__, M_passMate );
                            rcsc::Body_HoldBall().execute( agent );
                        }
                        else
                        {
                            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                                "%s:%d: seenCount = %d. Lock on %d at the next cycle."
                                                ,__FILE__, __LINE__, receiver->seenPosCount(), receiver->unum() );
                            M_passMate = receiver->unum();
                            rcsc::Body_HoldBall().execute( agent );
                            M_neck_cnt = 3;
                        }

                        
                        acted = true;
                    }
                }
            }
        
        }
    }



    if( danger && acted == false )
    {
        if( !cand_mates.empty() )
        {
            double self_length;
            rcsc::AngleDeg angle;
            Bhv_Offense().freeSector( agent, wm.self().pos(), angle, self_length );
            for( std::vector< rcsc::PlayerObject* >::iterator it = cand_mates.begin();
                 it != cand_mates.end();
                 ++it )
            {
                if( acted == true )
                    break;
                double mate_length;
                Bhv_Offense().freeSector( agent, (*it)->pos(), angle, mate_length );
                if( mate_length > self_length )
                {
                    if( Opuci_DirectPass().execute( agent, (*it) ) )
                    {
                        agent->debugClient().addMessage( "ForcePass" );
                        acted = true;
                    }
                }
            }
        }

        if( acted == false )
        {
            rcsc::Body_AdvanceBall2009().execute( agent );
            agent->debugClient().addMessage( "Advance" );
            acted = true;
        }
    }

    if( acted == false && Body_DribbleOpuci( goal_center, 1.0, sp.maxPower(), 1, false ).execute( agent ) )
    {
        agent->debugClient().addMessage( "OneDribble" );
        acted = true;
    }
    else if( acted == false )
    {
        rcsc::Body_HoldBall2008().execute( agent );
        acted = true;
    }


    if( !wm.teammate( 8 ) || wm.teammate( 8 )->posCount() >=5 )
    {
        // 九郎修正ポイント
        //八朗の位置を教えてもらう
        agent->doAttentionto( wm.self().side(), 8 );
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: Attention to 8" ,__FILE__, __LINE__ );
    }
    else if( !wm.teammate( 11 ) || wm.teammate( 11 )->posCount() >= 5 )
    {
        //　十朗修正ポイント
        //十一朗の位置を教えてもらう
        agent->doAttentionto( wm.self().side(), 11 );
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: Attention to 11" ,__FILE__, __LINE__ );
    }
    else
    {
        int max_cnt = -1000;
        int max_index = -1;
        for( int i = 7 ; i <= 11 ; i++ )
        {
            if( !wm.teammate( i ) )
                continue;

            else if( max_cnt < wm.teammate( i )->posCount() )
            {
                max_cnt = wm.teammate( i )->posCount();
                max_index = i;
            }
        }

        if( max_index == -1 )
        {
            agent->doAttentiontoOff();
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "%s:%d: No player to attend. Attention Off." ,__FILE__, __LINE__ );
        }
        else if( max_cnt <= 1 )
        {
            agent->doAttentiontoOff();
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "%s:%d: Max posCount = %d. Attention Off" ,__FILE__, __LINE__, max_cnt );
        }
        else
        {
            agent->doAttentionto( wm.self().side(), max_index );
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "%s:%d: Attention to %d (posCount = %d)" ,__FILE__, __LINE__, max_index, max_cnt );
        }
    }

    return;
}

/*-------------------------------------------------------------------*/
/*!

*/
/*-------------------------------------------------------------------*/

void
RoleJuro::doMove( rcsc::PlayerAgent * agent )
{
    const rcsc::WorldModel & wm = agent->world();
    const rcsc::ServerParam & sp = rcsc::ServerParam::i();

    int self_min = wm.interceptTable()->selfReachCycle();
    int mate_min = wm.interceptTable()->teammateReachCycle();
    int opp_min = wm.interceptTable()->opponentReachCycle();
    
    int agent_reach_cycle = std::min( std::min( self_min, mate_min ), opp_min );

    rcsc::Vector2D goal_center( 51.5, 0.0 );
    rcsc::Vector2D top_left( 30, -25 );
    rcsc::Vector2D bottom_right( 52.5, 25 );
    rcsc::Rect2D shoot_chance( top_left, bottom_right );
    
    std::vector< rcsc::Vector2D > oppline;
    Bhv_Offense( goal_center ).getOppEndLine( agent, oppline );
    bool pointToDone = false;

    rcsc::AngleDeg turn_angle = ( M_receive_pos - wm.self().pos() ).th() - wm.self().body();
    if( wm.self().pos().x > wm.offsideLineX() - 5
        && wm.ball().pos().x > wm.offsideLineX() - 10 )
    {
        turn_angle = -wm.self().body();
    }   

    if( self_min <= mate_min + 1 && !wm.existKickableTeammate() 
        && !wm.existKickableOpponent() )
    {
        rcsc::Body_Intercept2009().execute( agent );
	rcsc::Vector2D next_ball_pos = agent->effector().queuedNextBallPos();
	rcsc::Vector2D next_self_pos = agent->effector().queuedNextSelfPos();
	rcsc::AngleDeg next_self_body = agent->effector().queuedNextSelfBody();
	rcsc::Vector2D rpos = next_ball_pos - next_self_pos;
	rcsc::AngleDeg angle = rpos.th() - next_self_body;
        if( (wm.ball().posCount() >= 1
	     || wm.ball().velCount() >= 1)
	    && fabs( angle.degree() ) < 115.0 )
        {
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "%s:%d: doturnneck( %f )"
                                ,__FILE__, __LINE__, angle.degree() );
            agent->doTurnNeck( angle -wm.self().neck() );
            agent->debugClient().addMessage( "LookBall" );
        }
        else
        {
/*
            Bhv_Offense( goal_center ).neckToMate( agent );
            agent->debugClient().addMessage( "LookMate" );
*/
        }
    }
    else if( wm.self().pos().x > wm.offsideLineX() )
    {
        //オフサイドラインから戻るように修正
        double dash_power;
        rcsc::Vector2D target( 25.0, wm.self().pos().y ); // 九郎修正ポイント
        target.x = (int)((wm.offsideLineX() - 3.0) / 5.0) * 5.0;
        if( ( M_receive_pos.x - target.x ) > 20 )
        {
            if( oppline.empty() )
                target.y = 25.0; //九郎修正ポイント -25.0
            else
            {
                target.y = (int)((oppline.front().y + 34.0 )/ 10.0) * 5.0; //九郎修正ポイント
                if( target.y > 25.0 )
                    target.y = 25.0;
            }
            dash_power = dashPower( agent, sp.maxPower() * 0.2 );
        }
        else
        {
            target.y = wm.self().pos().y;
            dash_power = dashPower( agent, sp.maxPower() );
        }

        //目標位置へ移動
        if( Opuci_Move( target, dash_power, 1.5 ).execute( agent ) )
        {
            agent->debugClient().setTarget( target );
        }
        else
        {
            //目標位置に到達している場合はボールに体を向ける
            agent->doTurn( turn_angle );
            agent->debugClient().addMessage("Turn2Ball%d", __LINE__);
        }

        agent->debugClient().addMessage("Back2Area");
        agent->debugClient().setTarget( target );

    }
    else if( wm.self().pointtoPos().isValid()
             && wm.time().cycle() - wm.self().pointtoTime().cycle() <= 5 )
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: time(%d), pointtoTime(%d)"
                            ,__FILE__, __LINE__, wm.time().cycle(), wm.self().pointtoTime().cycle() );

        // スルーパスを受けるためにターン禁止期間
        // 期間はpointtoから5サイクル
        int cycle2offsideX = wm.self().playerType().cyclesToReachDistance(
            wm.offsideLineX() - wm.self().pos().x );

        if( cycle2offsideX >= 2 )
        {
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "%s:%d: Dash50 to offsideLineX"
                                ,__FILE__, __LINE__ );
            agent->doDash( 50.0 );
        }
        else if( cycle2offsideX == 1 )
        {
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "%s:%d: Dash40 to offsideLineX"
                                ,__FILE__, __LINE__ );
            agent->doDash( 40.0 );
        }
        else
        {
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "%s:%d: Wait. Do nothing."
                                ,__FILE__, __LINE__ );
            agent->doDash( 0.0 );
        }
    }
    else if( ( wm.existKickableOpponent() && !wm.existKickableTeammate() )
             || ( opp_min + 3 < mate_min ) )
    {
        agent->debugClient().addMessage( "OppBall" );
        double dash_power = dashPower( agent, false );
        rcsc::Vector2D target_pos = defensePos( agent );
        double dist_thr = target_pos.dist( wm.self().pos() ) / 2;
        if( dist_thr < 1.0 || wm.self().pos().x > wm.offsideLineX() - 1 )
        {
            dist_thr = 1.0;
        }
        if( !Opuci_Move( target_pos, dash_power, dist_thr ).execute( agent ) )
        {
            rcsc::AngleDeg angle = wm.ball().angleFromSelf() - wm.self().body();
            agent->doTurn( angle );
        }
    }
    else
    {
        double dash_power = dashPower( agent, true );
        rcsc::Vector2D target_pos = offensePos( agent );
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: Target_pos(%f, %f)"
                            ,__FILE__, __LINE__, target_pos.x, target_pos.y );
        
        double th_dist = target_pos.dist( wm.self().pos() ) > 3.0
            ? target_pos.dist( wm.self().pos() ) / 3.0 : 1.0;
        if( Opuci_Move( target_pos, dash_power, th_dist ).execute( agent ) )
        {
            agent->debugClient().addMessage("OurBall");
            agent->debugClient().setTarget( target_pos );
        }
        else
        {
            //目標位置に到達している場合は敵ゴールに体を向ける
            rcsc::Vector2D t_receive;
            bool dopointTo = Bhv_Offense(goal_center).decideTurnAngleWhenImThere( agent, t_receive );
            agent->doTurn( (t_receive - wm.self().pos()).th() - wm.self().body() );
            agent->debugClient().addMessage("TurnAndPointto%d", __LINE__);

            if( mate_min <= 2 && std::fabs( (t_receive - wm.self().pos()).th().degree() - agent->effector().queuedNextMyBody().degree() ) < 10.0
                && M_receive_pos.dist( wm.self().pos() )  < 20.0
                && wm.offsideLineX() - wm.self().pos().x < 3.5 && wm.self().pos().x < wm.offsideLineX() )
            {
                rcsc::Vector2D pointToPos;
                pointToPos.setPolar( 10.0, agent->effector().queuedNextMyBody() );
                pointToPos += wm.self().pos();
                agent->doPointto( t_receive.x, t_receive.y );
                pointToDone = true;
            }
/*
            agent->doTurn( -wm.self().body() );
            agent->debugClient().addMessage("Turn2OppGoal%d", __LINE__);

            if( mate_min <= 2 && std::fabs( agent->effector().queuedNextMyBody().degree() ) < 15.0
                && M_receive_pos.dist( wm.self().pos() )  < 20.0
                && wm.offsideLineX() - wm.self().pos().x < 3.5 && wm.self().pos().x < wm.offsideLineX() )
            {
                rcsc::Vector2D pointToPos;
                pointToPos.setPolar( 10.0, agent->effector().queuedNextMyBody() );
                pointToPos += wm.self().pos();
                agent->doPointto( pointToPos.x, pointToPos.y );
                pointToDone = true;
            }
*/
        }
    }

    if( !pointToDone && wm.self().pointtoPos().isValid()
        && wm.time().cycle() - wm.self().pointtoTime().cycle() > 5 )
        agent->doPointtoOff();

    Opuci_Neck().execute( agent );

    if( wm.ball().pos().dist( wm.self().pos() ) < 20 )
    {
        if( wm.getTeammateNearestToBall( 100 ) )
        {
            //最も近そうな味方が他にいればアテンションを向ける
            agent->doAttentionto( wm.self().side(),
                                  wm.getTeammateNearestToBall( 100 )->unum() );
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "%s:%d: Ball.posCount = %d, Attention to the nearest player to the ball (%d)"
                                ,__FILE__, __LINE__, wm.ball().posCount(), wm.getTeammateNearestToBall( 100 )->unum() );
        }
        else
        {
            agent->doAttentiontoOff();
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "%s:%d: Ball.posCount = %d, But no player to attend. Attention off"
                                ,__FILE__, __LINE__, wm.ball().posCount() );
        }
    }
    else
    {
        if( !wm.teammate( 8 ) || wm.teammate( 8 )->posCount() >=5 )
        {
            // 九郎修正ポイント
            //八朗の位置を教えてもらう
            agent->doAttentionto( wm.self().side(), 8 );
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "%s:%d: Attention to 8" ,__FILE__, __LINE__ );
        }
        else if( !wm.teammate( 11 ) || wm.teammate( 11 )->posCount() >= 5 )
        {
            //　十朗修正ポイント（もしくは九郎と十郎で共通）
            //十一朗の位置を教えてもらう
            agent->doAttentionto( wm.self().side(), 11 );
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "%s:%d: Attention to 11" ,__FILE__, __LINE__ );
        }
        else
        {
            int max_cnt = -1000;
            int max_index = -1;
            for( int i = 7 ; i <= 11 ; i++ )
            {
                if( !wm.teammate( i ) )
                    continue;

                if( max_cnt < wm.teammate( i )->posCount() )
                {
                    max_cnt = wm.teammate( i )->posCount();
                    max_index = i;
                }
            }
            
            if( max_index == -1 )
            {
                agent->doAttentiontoOff();
                rcsc::dlog.addText( rcsc::Logger::TEAM,
                                    "%s:%d: No player to attend. Attention Off." ,__FILE__, __LINE__ );
            }
            else if( max_cnt <= 1 )
            {
                agent->doAttentiontoOff();
                rcsc::dlog.addText( rcsc::Logger::TEAM,
                                    "%s:%d: Max posCount = %d. Attention Off" ,__FILE__, __LINE__, max_cnt );
            }
            else
            {
                agent->doAttentionto( wm.self().side(), max_index );
                rcsc::dlog.addText( rcsc::Logger::TEAM,
                                    "%s:%d: Attention to %d (posCount = %d)" ,__FILE__, __LINE__, max_index, max_cnt );
            }
        }
    }

    return;
}

/*-------------------------------------------------------------------*/
/*!

*/
/*-------------------------------------------------------------------*/

rcsc::Vector2D 
RoleJuro::offensePos( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: RoleJuro::offensePos" ,__FILE__, __LINE__ );

    const rcsc::WorldModel & wm = agent->world();
    const rcsc::ServerParam & sp = rcsc::ServerParam::i();

    std::vector< rcsc::Vector2D > oppline;
    Bhv_Offense().getOppEndLine( agent, oppline );

    rcsc::Vector2D target;
    int mate_min = wm.interceptTable()->teammateReachCycle();
    double pass_length = rcsc::calc_sum_geom_series( sp.ballSpeedMax(), sp.ballDecay(), 10 );

    if( fabs( M_receive_pos.x - wm.offsideLineX() ) < pass_length )
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: x: Stand by at the offside line." ,__FILE__, __LINE__ );
        if( wm.offsideLineX() - wm.self().pos().x > 5 )
            target.x = (int)((wm.offsideLineX() - 1.0)/3.0) * 3.0;
        else
            target.x = wm.offsideLineX() - 0.5;
    }
    else
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: x: Stand by at the passable line." ,__FILE__, __LINE__ );
        target.x = wm.offsideLineX() + pass_length;
    }

    if( wm.existKickableTeammate() && wm.ball().pos().absY() < 9.0 )
    {
        if( wm.offsideLineX() - wm.self().pos().x < 3.0 )
        {
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "%s:%d: y: Stand by in the passable area." ,__FILE__, __LINE__ );
            target.y = (int)((M_receive_pos.y + 10.0)/5.0)*5.0; //九郎修正ポイント　-10.0
        }
        else // if( wm.ball().pos().x < wm.self().pos().x && wm.offsideLineX() - wm.self().pos().x < 15.0 )
        {
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "%s:%d: y: Dont change. Go straight." ,__FILE__, __LINE__ );
            target.y = wm.self().pos().y;
        }
    }
    else if( fabs( M_receive_pos.y - wm.self().pos().y ) > pass_length )
    {
        if( oppline.empty() )
        {
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "%s:%d: Stand by in the passable area." ,__FILE__, __LINE__ );
            target.y = M_receive_pos.y + pass_length;
        }
        else
        {
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "%s:%d: Stand by at the other side." ,__FILE__, __LINE__ );
            
            // 九郎修正ポイント　左端で待機
            if( oppline.front().y < 20.0 )
                target.y = ( (int)((oppline.front().y + 34.0)/6.0) + 1) * 3.0;
            else
                target.y = oppline.front().y - 2.0;
        }
    }
    else
    {
        target.y = wm.self().pos().y;
    }

    // 九郎修正ポイント　正負反転
    if( target.x < -15 )
    {
        target.x = -15;
    }
    if( target.y > 33 )
    {
        target.y = 33;
    }
    if( target.y < -15 )
    {
        target.y = -15;
    }
    
    return target;
}

/*-------------------------------------------------------------------*/
/*!

*/
/*-------------------------------------------------------------------*/

rcsc::Vector2D 
RoleJuro::defensePos( rcsc::PlayerAgent * agent )
{
    const rcsc::WorldModel & wm = agent->world();
    const rcsc::ServerParam & sp = rcsc::ServerParam::i();
    rcsc::Vector2D target;

    std::vector< rcsc::Vector2D > oppline;
    Bhv_Offense().getOppEndLine( agent, oppline );

    rcsc::Vector2D rmostOpp_pos;
    //　九郎修正ポイント　左よりに変更
    if( oppline.empty() )
        rmostOpp_pos.assign( 0.0, 27.0 );
    else
        rmostOpp_pos = oppline.front();

    if( M_receive_pos.x < -25.0 || M_receive_pos.y < 0 )  //　九郎修正ポイント　正負反転
    {
        target.y = std::max( 10.0, rmostOpp_pos.y + 2.0 );
        target.x = std::min( M_receive_pos.x, wm.self().pos().x );
    }
    else
        target = M_receive_pos;

    // 九郎修正ポイント　正負反転
    if( target.x < -7 )
    {
        target.x = -7;
    }
    if( target.y < -15 )
    {
        target.y = 15;
    }
    if( target.y > 33 )
    {
        target.y = -33;
    }

    return target;
}

/*-------------------------------------------------------------------*/
/*!

*/
/*-------------------------------------------------------------------*/

double 
RoleJuro::dashPower( rcsc::PlayerAgent * agent, bool our_ball )
{
    const rcsc::WorldModel & wm = agent->world();
    const rcsc::ServerParam & sp = rcsc::ServerParam::i();
    double power = sp.maxPower();


    if( wm.self().stamina() < sp.staminaMax() * sp.effortDecThr() * 1.2 
        || wm.self().stamina() < sp.staminaMax() * sp.recoverDecThr() * 1.2 )
    {
        return 0.0;
    }


    if( our_ball )
    {
        int mate_min = wm.interceptTable()->teammateReachCycle();
        rcsc::Vector2D receive_pos = wm.ball().inertiaPoint( mate_min );
        if( receive_pos.x < -15 )
        {
            power = sp.maxPower() * 0.6;
        }
        else if( receive_pos.x < 5 )
        {
            power = sp.maxPower() * 0.8;
        }
        else
        {
            power = sp.maxPower();
        }
        if( receive_pos.x > wm.self().pos().x )
        {
            power = sp.maxPower();
        }
    }
    else
    {
        if( M_receive_pos.x < wm.self().pos().x )
            power = 20.0;
        else
            power = 50.0;
    }
    
    if( wm.self().pos().x > wm.offsideLineX() - 1 )
    {
        power = sp.maxPower();
    }
    
    
    return power;
}

/*-------------------------------------------------------------------*/
/*!

*/
/*-------------------------------------------------------------------*/

