// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "role_nanaro.h"

#include "bhv_formation1.h"
#include "bhv_dango.h"
#include "bhv_nana_offense.h"
#include "bhv_offense.h"
#include "bhv_shootchance.h"
#include "bhv_simple_dribble.h"
#include "opuci_chase_ball.h"
#include "opuci_other_pass.h"
#include "opuci_neck.h"
#include "opuci_move.h"
#include "opuci_one_step_kick.h"
#include "opuci_through_pass.h"
#include "opuci_direct_pass.h"
#include "bhv_defense.h"
#include "strategy.h"
#include "body_dribble_opuci.h"
#include "bhv_danger_area_tackle.h"
#include "bhv_basic_tackle.h"

#include <rcsc/formation/formation.h>
#include <rcsc/player/intercept_table.h>
#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/player/say_message_builder.h>
#include <rcsc/common/logger.h>
#include <rcsc/geom/rect_2d.h>

#include <rcsc/action/body_advance_ball2009.h>
#include <rcsc/action/body_smart_kick.h>
#include <rcsc/action/body_hold_ball.h>
#include <rcsc/action/body_intercept2009.h>
#include <rcsc/action/body_dribble2008.h>
const std::string RoleNanaro::NAME( "Nanaro" );

int RoleNanaro::M_ptr = -1;
int RoleNanaro::M_traj[100];
int RoleNanaro::M_unum2Mark = -1;
int RoleNanaro::M_passMate = -1;
int RoleNanaro::M_neck_cnt = -1;

int RoleNanaro::M_cnt_fw[11];
int RoleNanaro::M_cnt_mf[11];
int RoleNanaro::M_cnt_df[11];

/*-------------------------------------------------------------------*/
/*!

 */
namespace {
rcss::RegHolder role = SoccerRole::creators().autoReg( &RoleNanaro::create,
                                                       RoleNanaro::NAME );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
RoleNanaro::execute( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: RoleNanaro::execute"
                        ,__FILE__, __LINE__ );

    const rcsc::WorldModel & wm = agent->world();

    rcsc::Vector2D goal_center( 51.5, 0.0 );

    //int self_min = wm.interceptTable()->selfReachCycle();
    //int self_min = Bhv_Offense( goal_center ).selfReachCycle( agent );
    int self_min = std::min( wm.interceptTable()->selfReachCycle(), Opuci_ChaseBall().calcCycle( agent ) );
    int mate_min = wm.interceptTable()->teammateReachCycle();
    int opp_min = wm.interceptTable()->opponentReachCycle();

    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: self_min = %d"
                        ,__FILE__, __LINE__, self_min );

    int agent_reach_cycle = std::min( std::min( self_min, mate_min ), opp_min );
    M_receive_pos = wm.ball().inertiaPoint( agent_reach_cycle );
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: M_receive_pos( %f, %f )"
                        ,__FILE__, __LINE__, M_receive_pos.x, M_receive_pos.y );

    updateTrajectory( agent );

    if( wm.time().cycle() < 50 )
    {
        // reset see count
        for( int i = 0 ; i < 11 ; i++ )
        {
            M_cnt_fw[i] = 0;
            M_cnt_mf[i] = 0;
            M_cnt_df[i] = 0;
        }
    }
    else
    {
        updateSeeCount( agent );
        
        // find my target
        findOpponent2Check( agent );
    }

    rcsc::Vector2D top_left( 30, -25 );
    rcsc::Vector2D bottom_right( 52.5, 25 );
    rcsc::Rect2D shoot_chance( top_left, bottom_right );

    if( M_receive_pos.x >= 30.0 )
    {
        agent->debugClient().addMessage( "ShootChance" );
        Bhv_Shootchance( goal_center ).execute( agent );
    }
    else if( wm.self().isKickable() )
    {
        doKick( agent );
        
        if( M_passMate == -1 )
            Opuci_Neck().execute( agent );
        else
        {
            Opuci_Neck().lookAtPassReceiver( agent, M_passMate );
            M_neck_cnt--;
            if( M_neck_cnt <= 0 )
                M_passMate = -1;
        }
    }
    else
    {
        doMove( agent );
    }

    if( wm.ball().rposCount() == 0
        && wm.ball().pos().dist( wm.self().pos() ) < 20.0 )
    {
        //ボールのrposcountが0ならばボールの位置・速度，自分の位置，体の角度をメッセージで配信
        agent->addSayMessage( new rcsc::BallPlayerMessage( agent->effector().queuedNextBallPos(), 
                                                           agent->effector().queuedNextBallVel(),
                                                           wm.self().unum(),
                                                           agent->effector().queuedNextMyPos(),
                                                           agent->effector().queuedNextMyBody() ) );
    }
    else
    {
        //ボールのrposcountが1以上ならば自分の位置をメッセージで配信 #SelfMessageの方がいいかもしれない
        //agent->addSayMessage( new rcsc::OnePlayerMessage( wm.self().unum(), agent->effector().queuedNextMyPos() ) );
        const rcsc::PlayerPtrCont & opps = wm.opponentsFromSelf();
        rcsc::Vector2D first_pos = rcsc::ServerParam::i().theirTeamGoalPos();
        rcsc::Vector2D second_pos = rcsc::ServerParam::i().theirTeamGoalPos();
        int first_unum = 0;
        int second_unum = 0;
        int first_count = 100;
        int second_count = 100;
        for( rcsc::PlayerPtrCont::const_iterator it = opps.begin();
             it != opps.end();
             ++it )
        {
            if( (*it)->posCount() < first_count )
            {
                second_count = first_count;
                second_unum = first_unum;
                second_pos = first_pos;

                first_count = (*it)->posCount();
                first_unum = (*it)->unum();
                first_pos = (*it)->pos();
            }
            else if( (*it)->posCount() < second_count )
            {
                second_count = (*it)->posCount();
                second_unum = (*it)->unum();
                second_pos = (*it)->pos();
            }
        }

        if( first_unum != 0
            && second_unum != 0 )
        {
            agent->addSayMessage( new rcsc::ThreePlayerMessage( first_unum + 11,
                                                                first_pos,
                                                                second_unum + 11,
                                                                second_pos,
                                                                wm.self().unum(),
                                                                agent->effector().queuedNextMyPos() ) );
        }
        else
        {
            agent->addSayMessage( new rcsc::OnePlayerMessage( wm.self().unum(), agent->effector().queuedNextMyPos() ) );
        }
    }

    if( self_min < mate_min )
    {
        //自分がボールに一番近そうならばアテンションを切る
        agent->doAttentiontoOff();
    }
    else
    {
        if( wm.getTeammateNearestToBall( 100 ) )
        {
            //最も近そうな味方が他にいればアテンションを向ける
            agent->doAttentionto( wm.self().side(),
                                  wm.getTeammateNearestToBall( 100 )->unum() );
        }
    }

    return;
}

/*-------------------------------------------------------------------*/
/*!

*/
void
RoleNanaro::doKick( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: RoleNanaro::doKick"
                        ,__FILE__, __LINE__ );

    const rcsc::WorldModel & wm = agent->world();
    const rcsc::ServerParam & sp = rcsc::ServerParam::i();
    rcsc::Vector2D g_c( 51.5, 0.0 );
    rcsc::Vector2D pass_target;
    double first_speed = sp.ballSpeedMax();
    int opp_min = wm.interceptTable()->opponentReachCycle();
    const rcsc::PlayerPtrCont::const_iterator end_self = wm.teammatesFromSelf().end();

    std::vector< rcsc::PlayerObject* > point_mates;
    for( rcsc::PlayerPtrCont::const_iterator it = wm.teammatesFromSelf().begin();
         it != end_self;
         ++it )
    {
        if( (*it)->pointtoCount() < 10 )
        {
            point_mates.push_back( (*it) );
        }
    }
    if( !point_mates.empty() )
    {
        for( std::vector< rcsc::PlayerObject* >::iterator it = point_mates.begin();
             it != point_mates.end();
             ++it )
        {
            for( std::vector< rcsc::PlayerObject* >::iterator it2 = it;
                 it2 != point_mates.end();
                 ++it2 )
            {
                if( (*it)->pos().x < (*it2)->pos().x )
                    std::swap( *it, *it2 );
            }
        }
        for( std::vector< rcsc::PlayerObject* >::iterator it = point_mates.begin();
             it != point_mates.end();
             ++it )
        {
            if( Bhv_Offense().pointingPass( agent, (*it), pass_target, first_speed ) )
            {
                if( (*it)->seenPosCount() == 0 )
                {
                    const rcsc::PlayerObject * receiver = (*it);
                    if( rcsc::Body_SmartKick( pass_target, first_speed, first_speed * 0.95, 1 ).execute( agent ) )
                    {
                        agent->debugClient().setTarget( pass_target );
                        agent->debugClient().addMessage( "PointingPass%d", receiver->unum() );
                        agent->addSayMessage( new rcsc::PassMessage( receiver->unum(), pass_target,
                                                                     agent->effector().queuedNextBallPos(),
                                                                     agent->effector().queuedNextBallVel() ) );
                    }
                    if( M_neck_cnt <= 0 )
                        M_passMate = -1;
                }
                else if( M_passMate != -1 )
                {
                    rcsc::dlog.addText( rcsc::Logger::TEAM,
                                        "%s:%d: Keep locking on %d at the next cycle."
                                        ,__FILE__, __LINE__, M_passMate );
                    rcsc::Body_HoldBall().execute( agent );
                }
                else
                {
                    rcsc::dlog.addText( rcsc::Logger::TEAM,
                                        "%s:%d: seenCount = %d. Lock on %d at the next cycle."
                                        ,__FILE__, __LINE__, (*it)->seenPosCount(), (*it)->unum() );
                    M_passMate = (*it)->unum();
                    rcsc::Body_HoldBall().execute( agent );
                    M_neck_cnt = 3;
                }
                
                return;
            }
        }
    }
    
    std::vector< rcsc::Vector2D > oppline;
    Bhv_Offense( g_c ).getOppEndLine( agent, oppline );

    std::vector< rcsc::PlayerObject* > front_mates;
    bool frontier = true;
    // check if I'm in the frontier
    int count_thr = 2;
    if( wm.interceptTable()->opponentReachCycle() < 3 )
    {
        count_thr = 4;
    }
    for( rcsc::PlayerPtrCont::const_iterator it = wm.teammatesFromSelf().begin();
         it != end_self;
         ++it )
    {
        if( (*it)->pos().x > wm.self().pos().x )
        {
            frontier = false;
            if( (*it)->seenPosCount() <= count_thr
                && (*it)->pos().x < wm.offsideLineX() )
            {
                front_mates.push_back( (*it) );
            }
        }
    }

    for( std::vector< rcsc::PlayerObject* >::iterator it = front_mates.begin();
         it != front_mates.end();
         ++it )
    {
        for( std::vector< rcsc::PlayerObject* >::iterator it2 = it;
             it2 != front_mates.end();
             ++it2 )
        {
            if( (*it)->pos().x < (*it2)->pos().x )
                std::swap( *it, *it2 );
        }
    }    
    
    int self_opp = Bhv_Offense().countSectorOpp( agent, wm.self().pos(), 0, 15, 30 );

    std::vector< int > opp_num;
    Bhv_Offense().surroundOppNum( agent, opp_num );    
    int self_opp2 = 3;
    switch( wm.self().unum() )
    {
    case 7:
        self_opp2 = opp_num[0];
        break;
    case 8:
        self_opp2 = opp_num[1];
        break;
    case 9:
        self_opp2 = opp_num[2];
        break;
    case 10:
        self_opp2 = opp_num[3];
        break;
    case 11:
        self_opp2 = opp_num[4];
        break;
    default:
        break;
    }
    for( std::vector< rcsc::PlayerObject* >::iterator it = front_mates.begin();
         it != front_mates.end();
         ++it )
    {
        int mate_opp = Bhv_Offense().countSectorOpp( agent, (*it)->pos(), 0, 15, 30 );
        int mate_opp2 = 5;
        switch( (*it)->unum() )
        {
        case 7:
            mate_opp2 = opp_num[0];
            break;
        case 8:
            mate_opp2 = opp_num[1];
            break;
        case 9:
            mate_opp2 = opp_num[2];
            break;
        case 10:
            mate_opp2 = opp_num[3];
            break;
        case 11:
            mate_opp2 = opp_num[4];
            break;
        default:
            break;
        }
        if( mate_opp <= self_opp 
            || mate_opp2 <= self_opp2 )
       {
            const rcsc::PlayerObject * receiver = (*it);

            if( Opuci_ThroughPass().search( agent, receiver, pass_target, first_speed ) )
            {
                if( (*it)->seenPosCount() == 0 )
                {
                    agent->debugClient().addMessage( "ToFront" );
                    agent->debugClient().addMessage( "Target%d", receiver->unum() );
                    agent->debugClient().setTarget( pass_target );
                    rcsc::dlog.addText( rcsc::Logger::TEAM,
                                        "%s:%d: ThroughPass to %d (posCount = %d)"
                                        ,__FILE__, __LINE__, receiver->unum(), receiver->posCount() );
                    
                    if( rcsc::Body_SmartKick( pass_target, first_speed, first_speed * 0.8, 3 ).execute( agent ) )
                    {
                        agent->addSayMessage( new rcsc::PassMessage( receiver->unum(), pass_target,
                                                                     agent->effector().queuedNextBallPos(),
                                                                     agent->effector().queuedNextBallVel() ) );
                    }
                    if( M_neck_cnt <= 0 )
                        M_passMate = -1;
                }
                else if( M_passMate != -1 )
                {
                    rcsc::dlog.addText( rcsc::Logger::TEAM,
                                        "%s:%d: Keep locking on %d at the next cycle."
                                        ,__FILE__, __LINE__, M_passMate );
                    rcsc::Body_HoldBall().execute( agent );
                }
                else
                {
                    rcsc::dlog.addText( rcsc::Logger::TEAM,
                                        "%s:%d: seenCount = %d. Lock on %d at the next cycle."
                                        ,__FILE__, __LINE__, (*it)->seenPosCount(), (*it)->unum() );
                    M_passMate = (*it)->unum();
                    rcsc::Body_HoldBall().execute( agent );
                    M_neck_cnt = 3;
                }

                return;
            }
            else if( Opuci_OtherPass().search( agent, receiver, pass_target, first_speed, false ) )
            {
                if( (*it)->seenPosCount() == 0 )
                {
                    agent->debugClient().addMessage( "ToFront" );
                    agent->debugClient().addMessage( "Target%d", receiver->unum() );
                    agent->debugClient().setTarget( pass_target );
                    rcsc::dlog.addText( rcsc::Logger::TEAM,
                                        "%s:%d: OtherPass to %d (posCount = %d)"
                                        ,__FILE__, __LINE__, receiver->unum(), receiver->posCount() );
                    if( rcsc::Body_SmartKick( pass_target, first_speed, first_speed * 0.8, 3 ).execute( agent ) )
                    {
                        agent->addSayMessage( new rcsc::PassMessage( receiver->unum(), pass_target,
                                                                     agent->effector().queuedNextBallPos(),
                                                                     agent->effector().queuedNextBallVel() ) );
                    }
                    if( M_neck_cnt <= 0 )
                        M_passMate = -1;
                }
                else if( M_passMate != -1 )
                {
                    rcsc::dlog.addText( rcsc::Logger::TEAM,
                                        "%s:%d: Keep locking on %d at the next cycle."
                                        ,__FILE__, __LINE__, M_passMate );
                    rcsc::Body_HoldBall().execute( agent );
                }
                else
                {
                    rcsc::dlog.addText( rcsc::Logger::TEAM,
                                        "%s:%d: seenCount = %d. Lock on %d at the next cycle."
                                        ,__FILE__, __LINE__, (*it)->seenPosCount(), (*it)->unum() );
                    M_passMate = (*it)->unum();
                    rcsc::Body_HoldBall().execute( agent );
                    M_neck_cnt = 3;
                }
                
                return;
            }            
            else if( Opuci_DirectPass().search( agent, receiver, pass_target, first_speed ) )
            {
                if( (*it)->seenPosCount() == 0 )
                {
                    agent->debugClient().addMessage( "ToFront" );
                    agent->debugClient().addMessage( "Target%d", receiver->unum() );
                    agent->debugClient().setTarget( pass_target );
                    rcsc::dlog.addText( rcsc::Logger::TEAM,
                                        "%s:%d: DirectPass to %d (posCount = %d)"
                                        ,__FILE__, __LINE__, receiver->unum(), receiver->posCount() );
                    if( rcsc::Body_SmartKick( pass_target, first_speed, first_speed * 0.8, 3 ).execute( agent ) )
                    {
                        agent->addSayMessage( new rcsc::PassMessage( receiver->unum(), pass_target,
                                                                     agent->effector().queuedNextBallPos(),
                                                                     agent->effector().queuedNextBallVel() ) );
                    }
                    if( M_neck_cnt <= 0 )
                        M_passMate = -1;
                }
                else if( M_passMate != -1 )
                {
                    rcsc::dlog.addText( rcsc::Logger::TEAM,
                                        "%s:%d: Keep locking on %d at the next cycle."
                                        ,__FILE__, __LINE__, M_passMate );
                    rcsc::Body_HoldBall().execute( agent );
                }
                else
                {
                    rcsc::dlog.addText( rcsc::Logger::TEAM,
                                        "%s:%d: seenCount = %d. Lock on %d at the next cycle."
                                        ,__FILE__, __LINE__, (*it)->seenPosCount(), (*it)->unum() );
                    M_passMate = (*it)->unum();
                    rcsc::Body_HoldBall().execute( agent );
                    M_neck_cnt = 3;
                }

                return;
            }
        }
    }
    bool danger = false;
    const rcsc::PlayerPtrCont::const_iterator opp_end = wm.opponentsFromBall().end();
    for( rcsc::PlayerPtrCont::const_iterator it = wm.opponentsFromBall().begin();
         it != opp_end;
         ++it )
    {
        rcsc::Vector2D next_opp_pos = (*it)->pos() + (*it)->vel();
        double margin = sp.tackleDist();//(*it)->playerTypePtr()->kickableMargin();

        rcsc::Vector2D opp_to_ball = wm.ball().pos() - next_opp_pos;
/*
        rcsc::AngleDeg opp_dif = opp_to_ball.th() - (*it)->body();
        if( opp_dif.abs() < 15 )
        {
            margin = sp.tackleDist();
        }
*/
        
        rcsc::Circle2D turned_opp_circle( next_opp_pos, margin );
        rcsc::Vector2D opp_dash;
        opp_dash.setPolar( sp.defaultDashPowerRate() * 100, opp_to_ball.th() );
        next_opp_pos += opp_dash;
        rcsc::Circle2D dashed_opp_circle( next_opp_pos, margin );
        if( turned_opp_circle.contains( wm.ball().pos() ) 
            || dashed_opp_circle.contains( wm.ball().pos() ) )
        {
            danger = true;
            break;
        }
    }



    agent->debugClient().addMessage( "7kick" );
    //前線である場合
    if( frontier || wm.self().pos().x > (wm.offsideLineX() - 8.0))
    {
        rcsc::Vector2D top_left( wm.self().pos().x, wm.self().pos().y - 1.8 );
        rcsc::Vector2D bottom_right( wm.self().pos().x + 7, wm.self().pos().y + 1.8 );
        rcsc::Rect2D front_area( top_left, bottom_right );
        if( !wm.existOpponentIn( front_area, 5, true ) )
        {
            rcsc::Vector2D self_center( wm.self().pos().x + 8, wm.self().pos().y );
            if( self_center.y > 32 )
            {
                self_center.y = 32;
            }
            else if( self_center.y < -32 )
            {
                self_center.y = -32;
            }
            if( Body_DribbleOpuci( self_center, 1.0, sp.maxPower(), 4, false ).execute( agent ) )
            {
                agent->debugClient().addMessage( "FrontDribble" );
                return;
            }
        }
        double nearest_disy = 1000.0;
        double nearest_disy2 = 1500.0;
        rcsc::Vector2D nearestOppInLine( 0.0, 0.0 );
        rcsc::Vector2D nearestOppInLine2( 0.0, 0.0 );
        for( std::vector< rcsc::Vector2D >::iterator it = oppline.begin();
             it < oppline.end() ; it++ )
        {
            if( fabs( (*it).y - wm.self().pos().y ) < nearest_disy )
            {
                nearest_disy2 = nearest_disy;
                nearest_disy = fabs( (*it).y - wm.self().pos().y );
                nearestOppInLine2 = nearestOppInLine;
                nearestOppInLine = (*it);
            }
            else if( fabs( (*it).y - wm.self().pos().y ) < nearest_disy2 )
            {
                nearest_disy2 = fabs( (*it).y = wm.self().pos().y );
                nearestOppInLine2 = (*it);
            }
        }
	
        if( (wm.self().pos().y - nearestOppInLine.y)
            * (wm.self().pos().y - nearestOppInLine2.y) < 0 )
        {
            // I'm between the two nearest opponents in the frontier
            rcsc::Vector2D between = nearestOppInLine + nearestOppInLine2;
            
            between.setPolar( 7, between.th() );
            rcsc::Vector2D target = wm.self().pos() + between;
            if( target.y > 32 )
            {
                target.y = 32;
            }
            else if( target.y < -32 )
            {
                target.y = -32;
            }
            if( Body_DribbleOpuci( target, 1.0, sp.maxPower(), 4, false ).execute( agent ) )
            {
                agent->debugClient().addMessage( "DribbleC" );
                return;
            }
        }
        else if( wm.self().pos().y < nearestOppInLine.y )
        {
            rcsc::Vector2D top_side( nearestOppInLine.x, -31.5 );
            if( Body_DribbleOpuci( top_side, 1.0, sp.maxPower(), 4, false ).execute( agent ) )
            {
                agent->debugClient().addMessage( "DribbleD" );
                return;
            }                
        }
        else if( wm.self().pos().y > nearestOppInLine.y )
        {
            rcsc::Vector2D self_center( wm.self().pos().x + 10, wm.self().pos().y );
            if( self_center.y > 32 )
            {
                self_center.y = 32;
            }
            else if( self_center.y < -32 )
            {
                self_center.y = -32;
            }
            if( Body_DribbleOpuci( self_center, 1.0, sp.maxPower(), 4, false ).execute( agent ) )
            {
                agent->debugClient().addMessage( "DribbleF" );
                return;
            }                  
        }
    }
    else
    {
        if( wm.self().body().abs() < 90.0 ) // 敵ゴール方向を向いている
        {
            // スルーパスを考慮


            const rcsc::PlayerPtrCont::const_iterator end = wm.teammatesFromBall().end();
            for( rcsc::PlayerPtrCont::const_iterator it = wm.teammatesFromBall().begin();
                 it != end;
                 ++it )
            {
                if( opp_min > 4 )
                {
                    if( (*it)->posCount() > 1 )
                    {
                        continue;
                    }
                }
                else if( (*it)->posCount() > 3 )
                    continue;

                if( Opuci_ThroughPass().search( agent, (*it), pass_target, first_speed ) )
                {
                    if( (*it)->seenPosCount() == 0 )
                    {
                        agent->debugClient().addMessage( "Target%d", (*it)->unum() );
                        agent->debugClient().setTarget( pass_target );
                        if( rcsc::Body_SmartKick( pass_target, first_speed, first_speed * 0.8, 3 ).execute( agent ) )
                        {
                            agent->addSayMessage( new rcsc::PassMessage( (*it)->unum(), pass_target,
                                                                         agent->effector().queuedNextBallPos(),
                                                                         agent->effector().queuedNextBallVel() ) );
                        }
                        rcsc::dlog.addText( rcsc::Logger::TEAM,
                                            "%s:%d: pass_target(%f, %f), first_speed = %f"
                                            ,__FILE__, __LINE__, pass_target.x, pass_target.y, first_speed );
                        if( M_neck_cnt <= 0 )
                            M_passMate = -1;
                    }
                    else if( M_passMate != -1 )
                    {
                        rcsc::dlog.addText( rcsc::Logger::TEAM,
                                            "%s:%d: Keep locking on %d at the next cycle."
                                            ,__FILE__, __LINE__, M_passMate );
                        rcsc::Body_HoldBall().execute( agent );
                    }
                    else
                    {
                        rcsc::dlog.addText( rcsc::Logger::TEAM,
                                            "%s:%d: seenCount = %d. Lock on %d at the next cycle."
                                            ,__FILE__, __LINE__, (*it)->seenPosCount(), (*it)->unum() );
                        M_passMate = (*it)->unum();
                        rcsc::Body_HoldBall().execute( agent );
                        M_neck_cnt = 3;
                    }

                    return;
                }
                if( Opuci_OtherPass().search( agent, (*it), pass_target, first_speed, false ) )
                {
                    if( (*it)->seenPosCount() == 0 )
                    {
                        agent->debugClient().addMessage( "Target%d", (*it)->unum() );
                        agent->debugClient().setTarget( pass_target );
                        if( rcsc::Body_SmartKick( pass_target, first_speed, first_speed * 0.8, 3 ).execute( agent ) )
                        {
                            agent->addSayMessage( new rcsc::PassMessage( (*it)->unum(), pass_target,
                                                                         agent->effector().queuedNextBallPos(),
                                                                         agent->effector().queuedNextBallVel() ) );
                        }
                        if( M_neck_cnt <= 0 )
                            M_passMate = -1;
                    }
                    else if( M_passMate != -1 )
                    {
                        rcsc::dlog.addText( rcsc::Logger::TEAM,
                                            "%s:%d: Keep locking on %d at the next cycle."
                                            ,__FILE__, __LINE__, M_passMate );
                        rcsc::Body_HoldBall().execute( agent );
                    }
                    else
                    {
                        rcsc::dlog.addText( rcsc::Logger::TEAM,
                                            "%s:%d: seenCount = %d. Lock on %d at the next cycle."
                                            ,__FILE__, __LINE__, (*it)->seenPosCount(), (*it)->unum() );
                        M_passMate = (*it)->unum();
                        rcsc::Body_HoldBall().execute( agent );
                        M_neck_cnt = 3;
                    }
                    
                    return;
                }
            }

//            int opp_cycle;
            for( rcsc::PlayerPtrCont::const_iterator it = wm.teammatesFromBall().begin();
                 it != end;
                 ++it )
            {
                if( opp_min > 4 )
                {
                    if( (*it)->posCount() > 1 )
                    {
                        continue;
                    }
                }
                else if( (*it)->posCount() > 3 )
                    continue;
                if( (*it)->pos().x - 5.0 < wm.self().pos().x )
                    continue;
                if( wm.self().pos().dist( (*it)->pos() ) < 5.0 )
                    continue;

//                if( Bhv_Offense( g_c ).checkPassSafe( agent, (*it)->pos(), *it, opp_cycle ) ) // 通常パスを考慮
                if( Opuci_DirectPass().search( agent, (*it), pass_target, first_speed ) )
                {
                    if( (*it)->seenPosCount() == 0 )
                    {
                        agent->debugClient().addMessage( "PassTo%d", (*it)->unum() );
                        agent->debugClient().setTarget( pass_target );
                        if( rcsc::Body_SmartKick( pass_target, first_speed, first_speed * 0.8, 3 ).execute( agent ) )
                        {
                            agent->addSayMessage( new rcsc::PassMessage( (*it)->unum(), pass_target,
                                                                         agent->effector().queuedNextBallPos(),
                                                                         agent->effector().queuedNextBallVel() ) );
                        }                    
                        rcsc::dlog.addText( rcsc::Logger::TEAM,
                                            "%s:%d: PassTo%d. pass_target(%f, %f)"
                                            ,__FILE__, __LINE__, (*it)->unum(), pass_target.x, pass_target.y );
                        if( M_neck_cnt <= 0 )
                            M_passMate = -1;
                    }
                    else if( M_passMate != -1 )
                    {
                        rcsc::dlog.addText( rcsc::Logger::TEAM,
                                            "%s:%d: Keep locking on %d at the next cycle."
                                            ,__FILE__, __LINE__, M_passMate );
                        rcsc::Body_HoldBall().execute( agent );
                    }
                    else
                    {
                        rcsc::dlog.addText( rcsc::Logger::TEAM,
                                            "%s:%d: seenCount = %d. Lock on %d at the next cycle."
                                            ,__FILE__, __LINE__, (*it)->seenPosCount(), (*it)->unum() );
                        M_passMate = (*it)->unum();
                        rcsc::Body_HoldBall().execute( agent );
                        M_neck_cnt = 3;
                    }

                    return;
                }
            }
            // 前方向のドリブルを考慮
            
/*
  for( int dash_cycle = 2; dash_cycle >= 1 ; dash_cycle-- )
  {
  for( int i = 0; i <= 10; i += 2 )
  {
  double degree = (double)i;
  rcsc::AngleDeg right_angle( wm.self().body().degree() + degree );
  rcsc::AngleDeg left_angle( wm.self().body().degree() - degree );
		  
  if( Bhv_Offense( g_c ).doSelfPass( agent, right_angle, dash_cycle ) )
  {
  agent->debugClient().addMessage( "SelfPass%d", dash_cycle );
  rcsc::dlog.addText( rcsc::Logger::TEAM,
  "%s:%d: SelfPass%d. Angle = %f"
  ,__FILE__, __LINE__, i, right_angle.degree() );
  return;
  }
  if( i != 0 )
  {
  if( Bhv_Offense( g_c ).doSelfPass( agent, left_angle, dash_cycle ) )
  {
  agent->debugClient().addMessage( "SelfPass%d", dash_cycle );
  rcsc::dlog.addText( rcsc::Logger::TEAM,
  "%s:%d: SelfPass%d. Angle = %f"
  ,__FILE__, __LINE__, i, left_angle.degree() );
  return;
  }
  }
  }
  }
*/
            if( !danger )
            {
                rcsc::Vector2D self_center( wm.self().pos().x + 5, wm.self().pos().y );
                if( self_center.y > 32 )
                {
                    self_center.y = 32;
                }
                else if( self_center.y < -32 )
                {
                    self_center.y = -32;
                }
                if( Body_DribbleOpuci( self_center, 1.0, sp.maxPower(), 2, false ).execute( agent ) )
                {
                    agent->debugClient().addMessage( "FrontDribble" );
                    return;
                }                
            }
            if( opp_min > 4 )
                rcsc::Body_HoldBall().execute( agent );
            else
                rcsc::Body_AdvanceBall2009().execute( agent );
            return;
        }
        else // 自ゴール方向を向いている
        {
            // 横パス
            // 横ドリブル
            //Bhv_Offense( g_c ).execute( agent );
            rcsc::Vector2D pass_target;
            double first_speed = 2.0;
            const rcsc::PlayerPtrCont::const_iterator end = wm.teammatesFromBall().end();
            for( rcsc::PlayerPtrCont::const_iterator it = wm.teammatesFromBall().begin();
                 it != end;
                 ++it )
            {
                if( opp_min > 4 )
                {
                    if( (*it)->posCount() > 1 )
                    {
                        continue;
                    }
                }
                else if( (*it)->posCount() > 3 )
                    continue;
                if( (*it)->pos().x - 5.0 < wm.self().pos().x )
                    continue;
                if( wm.self().pos().dist( (*it)->pos() ) < 5.0 )
                    continue;
                
//                if( Bhv_Offense( g_c ).checkPassSafe( agent, (*it)->pos(), *it, opp_cycle ) ) // 通常パスを考慮
                if( Opuci_DirectPass().search( agent, (*it), pass_target, first_speed ) )
                {
                    agent->debugClient().addMessage( "PassTo%d", (*it)->unum() );
                    agent->debugClient().setTarget( pass_target );
                    if( rcsc::Body_SmartKick( pass_target, first_speed, first_speed * 0.8, 3 ).execute( agent ) )
                    {
                        agent->addSayMessage( new rcsc::PassMessage( (*it)->unum(), pass_target,
                                                                     agent->effector().queuedNextBallPos(),
                                                                     agent->effector().queuedNextBallVel() ) );
                    }                    
                    rcsc::dlog.addText( rcsc::Logger::TEAM,
                                        "%s:%d: PassTo%d. pass_target(%f, %f)"
                                        ,__FILE__, __LINE__, (*it)->unum(), pass_target.x, pass_target.y );
                    return;
                }
            }
        }
    }
    if( Body_DribbleOpuci( g_c, 1.0, sp.maxPower(), 1, false ).execute( agent ) )
    {
        agent->debugClient().addMessage( "OneDribble" );
        return;
    }
    else
    {
        rcsc::Body_HoldBall2008().execute( agent );
        return;
    }

    return;
}

/*-------------------------------------------------------------------*/
/*!

*/
void
RoleNanaro::doMove( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: RoleNanaro::doMove"
                        ,__FILE__, __LINE__ );

    const rcsc::WorldModel & wm = agent->world();
    const rcsc::ServerParam & SP = rcsc::ServerParam::i();
    static int unum2Mark = -1;
    static int unumMate1 = -1;
    static int unumMate2 = -1;

    rcsc::Vector2D goal_center( 51.5, 0.0 );

    int self_min = std::min( wm.interceptTable()->selfReachCycle(), Opuci_ChaseBall().calcCycle( agent ) );
    //int self_min = Bhv_Offense( goal_center ).selfReachCycle( agent );
    int mate_min = wm.interceptTable()->teammateReachCycle();
    int opp_min = wm.interceptTable()->opponentReachCycle();

    const rcsc::PlayerPtrCont & teammates = wm.teammatesFromBall();
    const rcsc::PlayerObject * first_mate = wm.getFirstPlayer( teammates.begin(), teammates.end(), 10, false );

    int agent_reach_cycle = std::min( std::min( self_min, mate_min ), opp_min );
    rcsc::Vector2D M_receive_pos = wm.ball().inertiaPoint( agent_reach_cycle );

    const rcsc::Rect2D our_penalty( rcsc::Vector2D( -SP.pitchHalfLength(),
                                                    -SP.penaltyAreaHalfWidth() + 1.0 ),
                                    rcsc::Size2D( SP.penaltyAreaLength() - 1.0,
                                                  SP.penaltyAreaWidth() - 2.0 ) );
    // tackle
    if( ( our_penalty.contains( wm.ball().pos() )
          || our_penalty.contains( M_receive_pos ) )
        && !wm.existKickableTeammate()
        && Bhv_DangerAreaTackle( 0.5 ).execute( agent ) )
    {
        return;
    }
    else if ( Bhv_BasicTackle( 0.9, 80.0 ).execute( agent ) )
    {
        return;
    }
    else if( wm.ball().pos().x < -38.0 && wm.ball().distFromSelf() < 4.0 )
    {
        if( Bhv_BasicTackle( 0.75, 80.0 ).execute( agent ) )
        {
            return;
        }
    }

    rcsc::Vector2D target;
    double dash_power;

    if( !wm.existKickableTeammate() && !wm.existKickableOpponent()
        && self_min <= mate_min + 1 && self_min < opp_min + 5 )
    {
        if( wm.existKickableOpponent() )
        {
            target = wm.ball().pos();
            dash_power = dashPower( agent, SP.maxPower() );
            agent->debugClient().addMessage( "AttackOpp" );
            Opuci_Move( target, dash_power, wm.ball().pos().dist( wm.self().pos() ) / 2.0 ).execute( agent );
        }
        else
        {
//            agent->debugClient().addMessage( "ChaseBall" );
//            Opuci_ChaseBall().execute( agent );
            agent->debugClient().addMessage( "Intercept" );
            rcsc::Body_Intercept2009().execute( agent );
        }

	rcsc::Vector2D next_ball_pos = agent->effector().queuedNextBallPos();
	rcsc::Vector2D next_self_pos = agent->effector().queuedNextSelfPos();
	rcsc::AngleDeg next_self_body = agent->effector().queuedNextSelfBody();
	rcsc::Vector2D rpos = next_ball_pos - next_self_pos;
	rcsc::AngleDeg angle = rpos.th() - next_self_body;
        if( (wm.ball().posCount() >= 1
	     || wm.ball().velCount() >= 1)
	    && fabs( angle.degree() ) < 115.0 )
        {
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "%s:%d: doturnneck( %f )"
                                ,__FILE__, __LINE__, angle.degree() );
            agent->doTurnNeck( angle -wm.self().neck() );
            agent->debugClient().addMessage( "LookBall" );
        }
        else
        {
            searchMatesToCheck( agent, unumMate1, unumMate2 );
            Opuci_Neck().lookBallAnd2Mates( agent, unumMate1, unumMate2 );
        }
    }
    else if( wm.self().pos().x > wm.offsideLineX() )
    {
        //オフサイドラインから戻るように修正
        target.x = wm.offsideLineX() - 2.0;
        target.y = wm.self().pos().y;
        dash_power = dashPower( agent, SP.maxPower() );
        Opuci_Move( target, dash_power, 1.0 ).execute( agent );

        agent->debugClient().addMessage("Back2Area");
        agent->debugClient().setTarget( target );

        Opuci_Neck().execute( agent );
    }
    else if( wm.self().pos().x < wm.defenseLineX() + 1.0 )
    {
        //ディフェンスラインをつくらない修正
        target.x = wm.defenseLineX() + 2.0;
        target.y = wm.self().pos().y;
        dash_power = dashPower( agent, SP.maxPower() );
        Opuci_Move( target, dash_power, 1.0 ).execute( agent );

        agent->debugClient().addMessage("AvoidMakingLine");
        agent->debugClient().setTarget( target );

        Opuci_Neck().execute( agent );
    }
    else if( M_receive_pos.x < -36.0 ||
             (!wm.existKickableTeammate() && M_receive_pos.x < 0.0 && std::abs( mate_min - opp_min ) < 5 ))
    {
        // 失点の危機
        target = setDangerPos( agent );
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: Target_pos(%f, %f)"
                            ,__FILE__, __LINE__, target.x, target.y );

        dash_power = dashPower( agent, SP.maxPower() * 0.9 );
        
        //目標位置へ移動
        if( Opuci_Move( target, dash_power, std::max( 0.1, target.dist( wm.self().pos() ) / 2.0 )).execute( agent ) )
        {
            agent->debugClient().addMessage("Danger");
            agent->debugClient().setTarget( target );
        }
        else
        {
            //目標位置に到達している場合はマークしている敵を見る
            rcsc::AngleDeg dif2mark;
            if( M_unum2Mark != -1 )
            {
                dif2mark = ( wm.opponent( M_unum2Mark )->pos() - wm.self().pos() ).th() - wm.self().body();
                agent->debugClient().addMessage("TurnToMark");
            }
            else
            {
                dif2mark = ( wm.ball().pos() - wm.self().pos() ).th() - wm.self().body();
                agent->debugClient().addMessage("TurnToBall");
            }
            agent->doTurn( dif2mark );
        }
        Opuci_Neck().exewithmark( agent, M_unum2Mark );
    }
    else if( opp_min < mate_min && !wm.existKickableTeammate() )
    {
        //敵が味方より早くボールに到達可能な場合
        double rate;
        if( M_receive_pos.dist( wm.self().pos() ) >= 25.0 
            && wm.ball().pos().dist( wm.self().pos() ) >= 25.0 )
            rate = 0.2;
        else
        {
            rate = std::max( 1.0 - M_receive_pos.dist( wm.self().pos() ) / 25.0,
                             1.0 - wm.ball().pos().dist( wm.self().pos() ) / 25.0 );
            rate = std::max( 0.2, rate );
        }
        if( M_receive_pos.x < -35.0 )
            rate = std::max( 0.7, rate );
        dash_power = dashPower( agent, SP.maxPower() * rate );
        target = setDefensivePos( agent );
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: Target_pos(%f, %f)"
                            ,__FILE__, __LINE__, target.x, target.y );
        //目標位置へ移動
        if( Opuci_Move( target, dash_power, std::max( 0.5, target.dist( wm.self().pos() ) / 2.0 )).execute( agent ) )
        {
            agent->debugClient().addMessage("OpponentBall");
            agent->debugClient().setTarget( target );
        }
        else
        {
            //目標位置に到達している場合はゴールとボール側を見る
            rcsc::Vector2D opp_goal_pos( SP.pitchHalfLength(), 0.0 );
            rcsc::AngleDeg dif2goal = ( opp_goal_pos - wm.self().pos() ).th() - wm.self().body();
            if( dif2goal.abs() < 10.0 )
            {
                rcsc::AngleDeg dif2ball = ( wm.ball().pos() - wm.self().pos() ).th() - wm.self().body();
                agent->doTurn( dif2ball );
                agent->debugClient().addMessage("TurnToBall");
            }
            else
            {
                agent->doTurn( dif2goal );
                agent->debugClient().addMessage("TurnToOppGoal");
            }
        }
        Opuci_Neck().exewithmark( agent, unum2Mark );
    }
    else if( first_mate )
    {
        agent->debugClient().addMessage( "7OffenceMv" );
        dash_power = dashPower( agent, SP.maxPower() * 0.9 );

        target = setOffensivePos( agent );
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: Target_pos(%f, %f)"
                            ,__FILE__, __LINE__, target.x, target.y );

        //目標位置へ移動
        if( Opuci_Move( target, dash_power,
                        std::max(3.0, wm.self().pos().dist(target)/3.0) ).execute( agent ) )
        {
            agent->debugClient().addMessage("OurBall");
            agent->debugClient().setTarget( target );
        }
        else if( Opuci_Move( target, dash_power, 1.0 ).execute( agent ) )
        {
            agent->debugClient().addMessage("FOurBall");
            agent->debugClient().setTarget( target );
        }
        else
        {
            //目標位置に到達している場合はゴールとややボール側を見る
            rcsc::Vector2D opp_goal_pos( SP.pitchHalfLength(), 0.0 );
            rcsc::AngleDeg dif2goal = ( opp_goal_pos - wm.self().pos() ).th() - wm.self().body();
            if( dif2goal.abs() < 10.0 )
            {
                rcsc::AngleDeg dif2ball = ( wm.ball().pos() - wm.self().pos() ).th() - wm.self().body();
                agent->doTurn( dif2ball );
                agent->debugClient().addMessage("TurnToBall");
            }
            else
            {
                agent->doTurn( dif2goal );
                agent->debugClient().addMessage("TurnToOppGoal");
            }
        }
        Opuci_Neck().execute( agent );

    }
    else
    {
        agent->debugClient().addMessage( "Formation1" );
        Bhv_Formation1().execute( agent );
    }

    return;
}

/*-------------------------------------------------------------------*/
/*!

*/
rcsc::Vector2D
RoleNanaro::setOffensivePos( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: role_nanaro::setOffensivePos"
                        ,__FILE__, __LINE__ );
    const rcsc::WorldModel & wm = agent->world();

    double near_x;
    if( wm.getTeammateNearestToSelf( 100 ) )
        near_x = wm.getTeammateNearestToSelf( 100 )->pos().x;
    else
        near_x = wm.offsideLineX();

    rcsc::Vector2D g_c( 52.5, 0.0 );
    std::vector< rcsc::Vector2D > oppline;
    Bhv_Offense( g_c ).getOppEndLine( agent, oppline );
    const int size_oppline = oppline.size();
    rcsc::Vector2D target; // 移動目標

    if( oppline.empty() || oppline.size() == 1 )
    {
        target.y = -17.0;
    }
    else
    {
        target.y = (int)((oppline.back().y + oppline[size_oppline-2].y)/6.0) * 3.0;
    }
    
    if( wm.existKickableTeammate() && wm.ball().pos().x < (wm.offsideLineX() - 10.0) )
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: Go to the front"
                            ,__FILE__, __LINE__ );
        target.x = wm.offsideLineX();
    }
    else
        target.x = std::max( wm.offsideLineX() - 15.0, near_x - 10.0 );

    if( target.y > 0.0 )
    target.y = -17.0;
    
    if( wm.self().pos().dist( wm.ball().pos() ) < 5.0 )
        target = wm.ball().pos();

    return target;
}
/*-------------------------------------------------------------------*/
/*!
  ダッシュパワーを決定する関数
*/
double
RoleNanaro::dashPower( rcsc::PlayerAgent * agent,
                        const double limit_power )
{
    const rcsc::WorldModel & wm = agent->world();
    const rcsc::ServerParam & SP = rcsc::ServerParam::i();
    if( wm.self().stamina() < SP.staminaMax() * SP.effortDecThr() * 1.2 
        || wm.self().stamina() < SP.staminaMax() * SP.recoverDecThr() * 1.2 )
    {
        //スタミナ切れが近い場合は停止する
        return 0.0;
    }
    //制限パワー：デフォルトは最大パワー
    return limit_power;
}

/*-------------------------------------------------------------------*/
/*!

*/
/*-------------------------------------------------------------------*/

rcsc::Vector2D
RoleNanaro::setDefensivePos( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: RoleNanaro::setDefensivePos"
                        ,__FILE__, __LINE__ );

    const rcsc::WorldModel & wm = agent->world();
    rcsc::Vector2D target;
    rcsc::Vector2D opp2Mark;

    if( M_unum2Mark != -1 && (M_traj[M_ptr] == -1 || M_receive_pos.x >= -9.0) )
    {
        opp2Mark.invalidate();
        M_unum2Mark = -1;
        
        // 七朗と八郎はミッドフィールダーに視点を置く
        if( 1 <= M_opp2Mark[1] && M_opp2Mark[1] <= 11 && wm.opponent( M_opp2Mark[1] ) )
        {
            M_unum2Mark = M_opp2Mark[1];
            opp2Mark = wm.opponent( M_unum2Mark )->pos();
        }
        else if( 1 <= M_opp2Mark[0] && M_opp2Mark[0] <= 11 && wm.opponent( M_opp2Mark[0] ) )
        {
            M_unum2Mark = M_opp2Mark[0];
            opp2Mark = wm.opponent( M_unum2Mark )->pos();
        }
    }
    else if( wm.opponent( M_unum2Mark ) )
        opp2Mark = wm.opponent( M_unum2Mark )->pos();
    else
    {
        opp2Mark.invalidate();
        M_unum2Mark = -1;
    }
    

    if( opp2Mark.valid() )
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: found opp2Mark(%f, %f)."
                            ,__FILE__, __LINE__, opp2Mark.x, opp2Mark.y );
        rcsc::Vector2D m2b = wm.ball().pos() - opp2Mark;
        m2b.setLength( 1.5 );
        target = opp2Mark + m2b;
    }
    else
    {
        target.x = M_receive_pos.x - 5.0;
        target.y = wm.self().pos().y;
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: stay back."
                            ,__FILE__, __LINE__ );
    }

    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: set target(%f, %f)."
                        ,__FILE__, __LINE__, target.x, target.y );
    return target;
}

/*-------------------------------------------------------------------*/
/*!

*/
/*-------------------------------------------------------------------*/

rcsc::Vector2D
RoleNanaro::setDangerPos( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: RoleNanaro::setDangerPos"
                        ,__FILE__, __LINE__ );

    const rcsc::WorldModel & wm = agent->world();
    rcsc::Vector2D target;
    rcsc::Vector2D opp2Mark;

    M_unum2Mark = -1;
    double min = 100000.0;
    for( rcsc::PlayerPtrCont::const_iterator it = wm.opponentsFromBall().begin();
         it != wm.opponentsFromBall().end();
         ++it )
    {
        if( -35.0 < (*it)->pos().x )
            continue;

        // 八朗修正ポイント　負の場合に変更
        if( M_receive_pos.y > 0.0 )
        {
            if( min > std::fabs( (*it)->pos().y ) )
            {
                min = std::fabs( (*it)->pos().y );
                opp2Mark = (*it)->pos();
                M_unum2Mark = (*it)->unum();
            }
        }
        else
        {
            // 八朗修正ポイント - 7.0 に変更
            if( min > std::fabs( (*it)->pos().y + 7.0 ) )
            {
                min = std::fabs( (*it)->pos().y + 7.0 );
                opp2Mark = (*it)->pos();
                M_unum2Mark = (*it)->unum();
            }
        }
    }

    if( M_unum2Mark == -1 )
    {
        opp2Mark.invalidate();
    }

    if( opp2Mark.valid() )
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: found opp2Mark(%f, %f)."
                            ,__FILE__, __LINE__, opp2Mark.x, opp2Mark.y );

        int dummy_i;
        target = Bhv_defense().defendOpponent( agent, M_unum2Mark,
                                               rcsc::Vector2D( wm.defenseLineX(), -9.0 ),
                                               rcsc::Vector2D( opp2Mark.x - 1.0, opp2Mark.y - 1.0) , &dummy_i );

        if( target.y < -12.0 )// 八郎修正ポイント 正負反転
            target.y = -11.0;
    }
    else
    {
        target.assign( -40.0, -9.0 ); // 八郎修正ポイント 9.0
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: Stay at a fixed point."
                            ,__FILE__, __LINE__ );
    }

    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: set target(%f, %f)."
                        ,__FILE__, __LINE__, target.x, target.y );
    return target;
}

/*-------------------------------------------------------------------*/
/*!

*/
/*-------------------------------------------------------------------*/

bool RoleNanaro::oppAttended( rcsc::PlayerAgent *agent, rcsc::Vector2D opp )
{
    const rcsc::WorldModel & wm = agent->world();

    const rcsc::PlayerPtrCont & mates = wm.teammatesFromSelf();
    for( rcsc::PlayerPtrCont::const_iterator it = mates.begin();
         it != mates.end();
         ++it )
    {
        if( (*it)->pos().dist( opp ) > 3.0 )
            continue;
        if( fabs( opp.x - (*it)->pos().x ) < 2.5
            && fabs( opp.y - (*it)->pos().y ) < 2.5 )
            return true;
    }

    return false;
}
/*-------------------------------------------------------------------*/
/*!

*/
void
RoleNanaro::searchMatesToCheck( rcsc::PlayerAgent *agent, int &unumMate1, int &unumMate2 )
{
    const rcsc::WorldModel & wm = agent->world();
    unumMate1 = -1;
    unumMate2 = -1;

    const rcsc::PlayerPtrCont & mates = wm.teammatesFromSelf();
    for( rcsc::PlayerPtrCont::const_iterator it = mates.begin();
         it != mates.end();
         ++it )
    {
        if( (*it)->pos().x > wm.self().pos().x )
        {
            if( unumMate1 == -1 ){
                unumMate1 = (*it)->unum();
                rcsc::dlog.addText( rcsc::Logger::TEAM,
                                    "%s:%d: 1st Mate to check unum=%d."
                                    ,__FILE__, __LINE__, unumMate1 );
            }
            else if( unumMate1 != -1 && unumMate2 == -1 )
            {
                unumMate2 = (*it)->unum();
                rcsc::dlog.addText( rcsc::Logger::TEAM,
                                    "%s:%d: 2nd Mate to check unum=%d."
                                    ,__FILE__, __LINE__, unumMate2 );
            }
            continue;
        }
    }

    if( unumMate1 == -1 )
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: Could not find Mate to check."
                            ,__FILE__, __LINE__ );
    }
    if( unumMate1 == -1 )
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: Could not find 2nd Mate to check."
                            ,__FILE__, __LINE__ );
    }
    
    return;
}
/*-------------------------------------------------------------------*/
/*!

*/
void
RoleNanaro::updateTrajectory( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: RoleHachiro::updateTrajectory"
                        ,__FILE__, __LINE__ );
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: Current Trajectory: M_ptr = %d"
                        ,__FILE__, __LINE__, M_ptr );

/*
    for( int i = 0 ; i < 100 ; i++ )
    {
        if( M_ptr == i )
        {
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "M_traj[%d] = %d <----- point"
                                , i, M_traj[i] );
        }
        else
        {
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "M_traj[ %d ] = %d"
                                , i, M_traj[i] );
        }
    }
*/

    const rcsc::WorldModel & wm = agent->world();
    bool mateKickable = false;

    if( M_ptr == -1 )
    {
        for( int i = 0 ; i < 100 ; i++ )
            M_traj[i] = -1;
    }

    const rcsc::PlayerObject *opp = wm.getOpponentNearestToBall( 100 );
    if( !opp || opp->pos().dist( wm.ball().pos() ) > 1.5 )
    {
        const rcsc::PlayerObject *mate = wm.getTeammateNearestToBall( 100 );
        if( mate && mate->pos().dist( wm.ball().pos() ) < 1.5 
            && wm.self().pos().dist( wm.ball().pos() ) > 1.5 )
            mateKickable = true;
        else
            return;
    }

    if( M_ptr == -1 )
    {
        M_ptr = 0;
        if( mateKickable == false )
            M_traj[M_ptr] = opp->unum();
        else
            M_traj[M_ptr] = -1;
    }
    else if( mateKickable == true && M_traj[M_ptr] != -1 )
    {
        M_ptr++;
        if( M_ptr == 100 )
            M_ptr = 0;

        M_traj[M_ptr] = -1;
    }
    else if( mateKickable == false && M_traj[M_ptr] != opp->unum() )
    {
        M_ptr++;
        if( M_ptr == 100 )
            M_ptr = 0;

        M_traj[M_ptr] = opp->unum();
    }

    if( M_ptr != -1 )
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: M_traj updated. M_traj[%d] = %d"
                            ,__FILE__, __LINE__, M_ptr, M_traj[M_ptr] );

/*    
    for( int i = 0 ; i < 100 ; i++ )
    {
        if( M_ptr == i )
        {
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "   M_traj[%d] = %d <----- point"
                                , i, M_traj[i] );
        }
        else
        {
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "   M_traj[%d] = %d"
                                , i, M_traj[i] );
        }
    }
*/

    return;
}
/*-------------------------------------------------------------------*/
/*!

*/
void
RoleNanaro::updateSeeCount( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: RoleHachiro::updateSeeCount"
                        ,__FILE__, __LINE__ );

    const rcsc::WorldModel & wm = agent->world();

    std::vector< int > ind_fw = Bhv_defense().oppForward( agent );
    std::vector< int > ind_mf = Bhv_defense().oppSemiForward( agent );
    std::vector< bool > checked( 11, false );
    const long weight = wm.time().cycle();
    
    for( std::vector<int>::iterator it = ind_fw.begin() ; it != ind_fw.end() ; it++ )
    {
        M_cnt_fw[*it-1] += weight;
        checked[*it-1] = true;
    }
    for( std::vector<int>::iterator it = ind_mf.begin() ; it != ind_mf.end() ; it++ )
    {
        M_cnt_mf[*it-1] += weight;
        checked[*it-1] = true;
    }
    for( int i = 0 ; i < 11 ; i++ )
    {
        // assign the remainder as defenders
        if( checked[i] == false )
            M_cnt_df[i] += weight;
    }




    return;
}
/*-------------------------------------------------------------------*/
/*!

*/
int
RoleNanaro::findOpponent2Check( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: RoleHachiro::findOpponent2Check" ,__FILE__, __LINE__ );

    const rcsc::WorldModel & wm = agent->world();
    int result;

    std::vector< int > label( 11, 0 );
    for( int i = 0 ; i < 11 ; i++ )
    {
        // determine the role of opponent players
        if( M_cnt_fw[i] >= M_cnt_mf[i] && M_cnt_fw[i] >= M_cnt_df[i] )
        {
            label[i] = 1; // foward
        }
        else if( M_cnt_mf[i] >= M_cnt_fw[i] && M_cnt_mf[i] >= M_cnt_df[i] )
        {
            label[i] = 0; // mid fielder
        }
        else
        {
            label[i] = -1; // defender
        }

        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: cnt: unum( %d): fw( %d ) mf( %d ) df( %d ): label = %d"
                            ,__FILE__, __LINE__, i+1, M_cnt_fw[i], M_cnt_mf[i], M_cnt_df[i], label[i] );
    }

    int tmp_ptr = M_ptr + 1;
    int flag = 0;
    std::vector< int > index( 11, 0 );
    for( int i = 0 ; i < 100 ; i++ )
    {
        if( tmp_ptr >= 100 )
            tmp_ptr = 0;

        if( M_traj[tmp_ptr] != -1 )
            index[M_traj[tmp_ptr]-1] += 100 + flag + i;

        if( M_traj[M_ptr] == M_traj[tmp_ptr] )
            flag = 200;
        else
        {
            flag -= 100;
            if( flag < 0 )
                flag = 0;
        }

        tmp_ptr++;
    }

    M_opp2Mark[0] = -1;
    M_opp2Mark[1] = -1;
    M_opp2Mark[2] = -1;
    std::vector< int > max_ind( 3, -1000 );
    for( int i = 0 ; i < 11 ; i++ )
    {
        // 八朗だと　マイナスであるかどうか
        if( !wm.opponent( i + 1 ) || wm.opponent( i + 1 )->pos().y > 0.0 )
            continue;

        if( label[i] == 1 )
        {
            if( max_ind[0] < index[i] )
            {
                M_opp2Mark[0] = i + 1;
                max_ind[0] = index[i];
            }
        }
        else if( label[i] == 0 )
        {
            if( max_ind[1] < index[i] )
            {
                M_opp2Mark[1] = i + 1;
                max_ind[1] = index[i];
            }
        }
        else
        {
            if( max_ind[2] < index[i] )
            {
                M_opp2Mark[2] = i + 1;
                max_ind[2] = index[i];
            }
        }
    }

    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: List of opp2Mark: %d, %d, %d"
                        ,__FILE__, __LINE__, M_opp2Mark[0], M_opp2Mark[1], M_opp2Mark[2] );

/*
    if( wm.opponent( M_opp2Mark[0] ) && wm.opponent( M_opp2Mark[1] ) )
        agent->debugClient().addLine( wm.opponent( M_opp2Mark[0] )->pos(),
                                      wm.opponent( M_opp2Mark[1] )->pos() );
    if( wm.opponent( M_opp2Mark[1] ) && wm.opponent( M_opp2Mark[2] ) )
        agent->debugClient().addLine( wm.opponent( M_opp2Mark[1] )->pos(),
                                      wm.opponent( M_opp2Mark[2] )->pos() );
*/

    // 常にMFをマーク
    result = M_opp2Mark[1];

    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: My target is %d"
                        ,__FILE__, __LINE__, result );
    if( agent->world().opponent( result ) )
        agent->debugClient().addCircle( agent->world().opponent( result )->pos(),
                                        1.5 );
    else
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: However, I cannot recognize him....",__FILE__, __LINE__ );

    // 七朗と八郎はミッドフィールダーに視点を置く
    return result;
}

/*-------------------------------------------------------------------*/
/*!

*/
/*-------------------------------------------------------------------*/

