// -*-c++-*-

/*!
  \file soccer_role.cpp
  \brief abstract player role class Header File
*/

/*
 *Copyright:

  Copyright (C) Hidehisa AKIYAMA

  This code is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3, or (at your option)
  any later version.

  This code is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this code; see the file COPYING.  If not, write to
  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "soccer_role.h"

#include "role_ichiro.h"
#include "role_jiro.h"
#include "role_saburo.h"
#include "role_shiro.h"
#include "role_goro.h"
#include "role_rokuro.h"
#include "role_nanaro.h"
#include "role_hachiro.h"
#include "role_kuro.h"
#include "role_juro.h"
#include "role_juichiro.h"

/*-------------------------------------------------------------------*/
/*!

*/
SoccerRole::Creators &
SoccerRole::creators()
{
    static Creators s_instance;
    return s_instance;
}

/*-------------------------------------------------------------------*/
/*!

*/
SoccerRole::Ptr
SoccerRole::create( const std::string & name )
{
    SoccerRole::Ptr ptr( static_cast< SoccerRole * >( 0 ) );

    Creator creator;
    if ( SoccerRole::creators().getCreator( creator, name ) )
    {
        ptr = creator();
    }
    else if ( RoleIchiro::NAME == name ) ptr = RoleIchiro::create();
    else if ( RoleJiro::NAME == name ) ptr = RoleJiro::create();
    else if ( RoleSaburo::NAME == name ) ptr = RoleSaburo::create();
    else if ( RoleShiro::NAME == name ) ptr = RoleShiro::create();
    else if ( RoleGoro::NAME == name ) ptr = RoleGoro::create();
    else if ( RoleRokuro::NAME == name ) ptr = RoleRokuro::create();
    else if ( RoleNanaro::NAME == name ) ptr = RoleNanaro::create();
    else if ( RoleHachiro::NAME == name ) ptr = RoleHachiro::create();
    else if ( RoleKuro::NAME == name ) ptr = RoleKuro::create();
    else if ( RoleJuro::NAME == name ) ptr = RoleJuro::create();
    else if ( RoleJuichiro::NAME == name ) ptr = RoleJuichiro::create();

    return ptr;
}
