# -*- coding: UTF-8 -*-
module RDGC
  module Actor
    module Character
      class Monster < Character
        include MonsterStatus

        CHASE_TRY_COUNT = 2

        def self.create(lv, x, y)
          m = self.new
          m.instance_eval do
            init_status(lv.to_i)
            self.x = x
            self.y = y
          end
          m
        end

        def action(d)
          # 状態チェック
          check_state(d)

          # 状態に応じて移動
          case
          when state_active?
            chase_move(d)
          when state_non_active?
            ramdom_move(d)
          end

          :monster_action
        end

        def effect_from(a)
          case a
          when Player
            result, dam = a.attack_to(self)

            case result
            when :critical
              Messages << "Critical!!"
            when :hit
            when :miss
              Messages << "#{a.name}は攻撃に失敗した"
              return
            when :fumble
              Messages << "#{a.name}は体勢を崩した"
              return
            end
            Messages << "#{name}に#{dam}のダメージを与えた"

            if disable?
              Messages << "#{name}を倒した　#{self.exp}の経験値獲得"
              lvup = a.add_exp(self.exp)
              Messages << "Lvが#{a.lv}に上がった！" if lvup
            end
          end
        end

        def state_active?
          @_state == :active ? true : false
        end

        def state_non_active?
          @_state == :non_active ? true : false
        end

        private

        def check_state(d)
          case
          when state_active?
            # 一定回数以上見失ったらnon_active
            if @_miss_count >= CHASE_TRY_COUNT
              @_state = :non_active
              clear_miss_count
            end
          when state_non_active?
            # プレイヤーとの相対距離をチェック
            @_state = :active if relative_distance(d.player) <= view_range
          else
            if relative_distance(d.player) <= view_range
              @_state = :active
            else
              @_state = :non_active
            end
          end
        end

        def movable_to?(d, dir)
          nx, ny = dir.apply_to(self.x, self.y)
          d.movable?(nx, ny)
        end

        def ramdom_move(d)
          dir_list = []
          Map::Direction.each do |dir|
            dir_list << dir if movable_to?(d, dir)
          end
          return if dir_list.empty?
          move_to_dir(d, dir_list.choice)
        end

        def chase_move(d)
          # 周囲の対象取得
          sb = StrategyBoard.create(view_range)
          list = sb.search(d, self.x, self.y)

          # とりあえずプレイヤーを探す
          # TODO "興味あるもの"を探すロジックに
          pl = nil
          near_mons = []
          list.each do |f|
            case f.article
            when Player
              pl = f
            when Monster
              # 隣接しているモンスターの位置は移動できない
              next unless f.position.distance == 1
              near_mons += f.position.dir
            end
          end

          if pl
            dir_list = pl.position.dir.select{|o| movable_to?(d, o)}.reject{|o| near_mons.include?(o)}
            if dir_list.empty?
              # プレイヤーはいるが移動できない
              add_miss_count
              ramdom_move(d)
            else
              # プレイヤーを追いかける
              clear_miss_count
              move_to_dir(d, dir_list.choice)
            end
          else
            # プレイヤーを見失った
            add_miss_count
            ramdom_move(d)
          end
        end

        def add_miss_count
          @_miss_count ||= 0
          @_miss_count += 1
        end

        def clear_miss_count
          @_miss_count = 0
        end

      end
    end
  end
end
