# -*- coding: UTF-8 -*-
module RDGC
  module Actor
    module Character
      class Player < Character
        include PlayerStatus

        def initialize(job)
          self.job = job
          init_status
          # TODO Timer値を可変に
          set_timer(Timer::AutoHealingTimer.create(ACT_MAX_COUNT * 3.0))
          update_time(next_act_count)
        end

        def action(d)
          if Input.keyPush?(K_SPACE)
            if d.player_in_step_down?
              # 階段を下りる
              return :player_step_down
            else
              # 時間だけ進める
              return :player_stay
            end
          end

          # 移動処理
          nx = self.x
          ny = self.y

          case
          when Input.keyPush?(K_UP)
            ny -=  1
          when Input.keyPush?(K_DOWN)
            ny += 1
          when Input.keyPush?(K_LEFT)
            nx -= 1
          when Input.keyPush?(K_RIGHT)
            nx += 1
          end

          if nx != x || ny != y
            moved = move(d, nx, ny)
            d.board.to_visible(nx, ny, view_range) if moved
            return :player_move
          end

          # 入力なし
          false
        end

        def effect_from(a)
          case a
          when Monster
            result, dam = a.attack_to(self)

            case result
            when :critical
              Messages << "Critical!!"
            when :hit
            when :miss, :fumble
              Messages << "#{a.name}の攻撃をかわした"
              return
            end
            Messages << "#{a.name}から#{dam}のダメージを受けた"

            if disable?
              Messages << "#{a.name}にやられた"
              Messages << "Press SPACE..."
            end
          end
        end

      end
    end
  end
end
