# -*- coding: UTF-8 -*-
module RDGC
  module Actor
    module Character
      module PlayerStatus
        include Status

        attr_accessor :job

        def name
        end

        def job_name
          @job.name
        end

        def exp
          @exp
        end

        def add_exp(val)
          @exp += val
          if exp >= next_lv_exp
            lvup
            @exp = 0
            return true
          end
          false
        end

        def rest_exp
          next_lv_exp - exp
        end

        def next_lv_exp
          @job.next_lv_exp(lv)
        end

        def lvup
          @lv += 1
          calc_status
          @hp = @max_hp
        end

        private

        def init_status
          @lv = 1
          @exp = 0
          calc_status

          # TODO from equip
          @wep_atk = 0.0
          @arm_def = 0.0

          @hp = @max_hp
        end

        def calc_status
          @raw_str = @job.status_from_lv(:str, lv)
          @raw_agi = @job.status_from_lv(:agi, lv)
          @raw_vit = @job.status_from_lv(:vit, lv)
          @raw_int = @job.status_from_lv(:int, lv)
          @raw_dex = @job.status_from_lv(:dex, lv)
          @raw_luk = @job.status_from_lv(:luk, lv)

          @max_hp = @job.max_hp_from_lv(lv, vit)

          @view_range = 2
          @max_act_time = ACT_MAX_COUNT - agi
          @act_ratio = 1.0
        end

      end
    end
  end
end