# -*- coding: UTF-8 -*-
module RDGC
  module Map
    class Direction

      attr_accessor :x, :y

      private

      def self.create(x, y)
        obj = self.new
        obj.x = x
        obj.y = y
        obj
      end

      public
      
      SELF = self.create(0, 0)
      LEFT = self.create(-1, 0)
      RIGHT = self.create(1, 0)
      UPPER = self.create(0, -1)
      BOTTOM = self.create(0, 1)

      def self.each
        self.dir_list.each do |d|
          yield(d)
        end
      end
      
      def self.dir_list
        [LEFT, UPPER, RIGHT, BOTTOM]
      end
      
      def self.opposite(dir)
        case dir
        when LEFT
          RIGHT
        when RIGHT
          LEFT
        when UPPER
          BOTTOM
        when BOTTOM
          UPPER
        end
      end

      def apply_to(sx, sy)
        return [sx + self.x, sy + self.y]
      end

    end
  end
end