# -*- coding: UTF-8 -*-
module RDGC
  module Map
    class Block < Area

      def self.create_blocks(top, bottom, left, right)
        bl = self.create(top, bottom, left, right).devide.collect
        bl.each{|b| b.fill}
        bl
      end

      def fill
        # TODO 実装してtile(x,y)を除去
      end

      def tile(x, y)
        return TileType::WALL unless has_xy?(x, y)

        if has_room? && room.has_xy?(x, y)
          return room.tile(x, y)
        end

        if has_road?
          roads.each do |r|
            return r.tile(x, y) if r.has_xy?(x, y)
          end
        end

        tile_data[x][y] ||= TileType::WALL
        tile_data[x][y]
      end

      def collect
        ret = []
        if @child
          @child.each do |c|
            ret << c.collect
          end
        else
          ret << self
        end
        ret.flatten
      end

      # need override
      def devide
        devide_by_two(bool_rand)
        self
      end

      def add_child(b)
        @child ||= []
        @child << b
      end

      def cling_to_top?(b)
        return false unless top == b.bottom+1
        return false if left > b.right
        return false if right < b.left
        true
      end

      def cling_to_bottom?(b)
        return false unless bottom == b.top-1
        return false if left > b.right
        return false if right < b.left
        true
      end

      def cling_to_left?(b)
        return false unless left == b.right+1
        return false if top > b.bottom
        return false if bottom < b.top
        true
      end

      def cling_to_right?(b)
        return false unless right == b.left-1
        return false if top > b.bottom
        return false if bottom < b.top
        true
      end

      def cling_direction_to(b)
        case
        when cling_to_top?(b)
          :top
        when cling_to_bottom?(b)
          :bottom
        when cling_to_left?(b)
          :left
        when cling_to_right?(b)
          :right
        end
      end

      def has_room?
        @room ? true : false
      end

      def room
        @room
      end

      def create_room
        @room = Room.create_from_block(self)
      end

      def set_start(f = true)
        @start = f
        self
      end

      def start?
        @start
      end

      def set_road_created(f = true)
        @road_created = f
        self
      end

      def road_created?
        @road_created
      end

      def roads
        @roads ||= []
        @roads
      end

      def add_road(road)
        @roads ||= []
        @roads << road
      end

      def has_road?
        roads.empty? ? false : true
      end

      def set_road_point(direction, point)
        @road_point ||= {}
        @road_point[direction] = point
      end

      def road_point(direction)
        @road_point ||= {}
        @road_point[direction]
      end

      def create_road_to(b)
        return unless has_room?
        return unless b.has_room?

        # どこで接しているか調べる
        # 接線に向かって道を伸ばす
        # 左か上に位置する部屋に接続線を引く
        case cling_direction_to(b)
        when :top
          my_x = create_road_from_room(:top)
          b_x = b.create_road_from_room(:bottom)
          b.create_road_for_adjoin_x(my_x, b_x)
        when :bottom
          my_x = create_road_from_room(:bottom)
          b_x = b.create_road_from_room(:top)
          create_road_for_adjoin_x(my_x, b_x)
        when :left
          my_y = create_road_from_room(:left)
          b_y = b.create_road_from_room(:right)
          b.create_road_for_adjoin_y(my_y, b_y)
        when :right
          my_y = create_road_from_room(:right)
          b_y = b.create_road_from_room(:left)
          create_road_for_adjoin_y(my_y, b_y)
        end
      end

      def create_road_from_room(direction)
        return unless has_room?

        # すでに道が引いてあったらそれを使う
        case direction
        when :top
          x = road_point(:top)

          if x
            x
          else
            x = range_rand(room.left, room.right)
            set_road_point(:top, x)
            add_road(Road.create(top, room.top-1, x, x))

            x
          end

        when :bottom
          x = road_point(:bottom)

          if x
            x
          else
            x = range_rand(room.left, room.right)
            set_road_point(:bottom, x)
            add_road(Road.create(room.bottom+1, bottom, x, x))

            x
          end

        when :left
          y = road_point(:left)

          if y
            y
          else
            y = range_rand(room.top, room.bottom)
            set_road_point(:left, y)
            add_road(Road.create(y, y, left, room.left-1))

            y
          end

        when :right
          y = road_point(:right)

          if y
            y
          else
            y = range_rand(room.top, room.bottom)
            set_road_point(:right, y)
            add_road(Road.create(y, y, room.right+1, right))

            y
          end

        end
      end

      def create_road_for_adjoin_x(x1, x2)
        p_s, p_e = [x1, x2].sort
        add_road(Road.create(bottom, bottom, p_s, p_e))
      end

      def create_road_for_adjoin_y(y1, y2)
        p_s, p_e = [y1, y2].sort
        add_road(Road.create(p_s, p_e, right, right))
      end

      def remove_room
        @room = nil
      end

      def devide_by_two(bool)
        bool ? devide_horizontal : devide_vertical
      end

      def devide_horizontal
        return if height <= min_devide_size

        # 分割幅決定
        point = devide_point(height)

        upper = Block.create(top, top + point - 1, left, right)
        lower = Block.create(top + point, bottom, left, right)

        add_child(upper)
        add_child(lower)

        if bool_rand
          upper.devide_vertical
          lower.devide_vertical if bool_rand
        else
          lower.devide_vertical
          upper.devide_vertical if bool_rand
        end

        self
      end

      def devide_vertical
        return if width <= min_devide_size

        # 分割点決定
        point = devide_point(width)

        lefter = Block.create(top, bottom, left, left + point - 1)
        righter = Block.create(top, bottom, left + point, right)

        add_child(lefter)
        add_child(righter)

        if bool_rand
          lefter.devide_horizontal
          righter.devide_horizontal if bool_rand
        else
          righter.devide_horizontal
          lefter.devide_horizontal if bool_rand
        end

        self
      end

      def min_devide_size
        # 最低必要サイズ = 最小ブロックサイズ*2
        MIN_BLOCK_SIZE*2
      end

      def devide_point(val)
        range_rand(MIN_BLOCK_SIZE, val - min_devide_size)
      end

    end
  end
end
