# -*- coding: UTF-8 -*-
module RDGC
  class Messages

    Message = Struct.new :mes_type, :mes

    def self.add(mes, type = nil)
      @@obj ||= self.new
      @@obj.instance_eval do
        add(mes, type)
      end
    end

    def self.<<(mes, type = nil)
      self.add(mes, type)
    end

    def self.each
      @@obj ||= self.new
      @@obj.instance_eval do
        list.each do |m|
          yield(m.mes, m.mes_type)
        end
      end
    end

    def self.clear
      @@obj ||= self.new
      @@obj.instance_eval do
        clear
      end
    end

    private

    def initialize
      @limit = 10
    end

    def list
      @list ||= []
      @list
    end

    def add(mes, type)
      m = Message.new
      m.mes_type = type
      m.mes = mes
      list << m

      if list.length > @limit
        list.shift
      end
    end

    def clear
      @list = []
    end

  end
end
