# -*- coding: UTF-8 -*-
module ROgue01
  class BlockDrawer

    def initialize
      @v_size = 7
      @block_size = 24
      @font = Font.new(20)
      @mes_font = Font.new(12)
      @floor = Image.new(@block_size, @block_size, [255, 255, 255, 255])
      @unknown = Image.new(@block_size, @block_size, [255, 200, 200, 200])
      @out = Image.new(@block_size, @block_size, [255, 0, 0, 0])
      @wall = Image.new(@block_size, @block_size, [255, 64, 64, 64])
      @player = Image.new(@block_size, @block_size, [255, 255, 0, 0])
      @step_down = Image.new(@block_size, @block_size, [255, 0, 255, 0])
      @step_up = Image.new(@block_size, @block_size, [255, 0, 0, 255])
      @mob_img = Image.load('.\dat\pink.dat')
    end

    def draw(d)
      draw_dungeon(d)
      draw_message(d)
      draw_status(d.player)
    end

    private

    def draw_status(p)
      right = 20 + (@v_size*2+1) * @block_size
      diff = @font.size
      up = 60

      Window.drawFont(right, up+diff*0, "STR:#{p.str}", @font)
      Window.drawFont(right, up+diff*1, "AGI:#{p.agi}", @font)
      Window.drawFont(right, up+diff*2, "VIT:#{p.vit}", @font)
      Window.drawFont(right, up+diff*3, "INT:#{p.int}", @font)
      Window.drawFont(right, up+diff*4, "DEX:#{p.dex}", @font)
      Window.drawFont(right, up+diff*5, "LUK:#{p.luk}", @font)

      Window.drawFont(right, up+diff*7, "ATK:#{p.atk}", @font)
      Window.drawFont(right, up+diff*8, "DEF:#{p.pdef}", @font)
    end

    def draw_message(d)
      Window.drawFont(0, 0, "Floor:#{d.floor} #{d.player.job_name} HP:#{d.player.hp}/#{d.player.max_hp} Lv:#{d.player.lv}/next:#{d.player.rest_exp}", @font)

      right = 20 + (@v_size*2+1) * @block_size
      mes_point = 64 + (@v_size+5) * @block_size

      RDGC::Messages.each do |mes, type|
        Window.drawFont(right, mes_point, mes.conv_sjis, @mes_font)
        mes_point += @mes_font.size
      end
    end

    def draw_dungeon(d)
      (-@v_size..@v_size).each do |x|
        (-@v_size..@v_size).each do |y|
          t = d.board.tile(d.player.x + x, d.player.y + y)
          case
          when t.out?
            i = @out
          when t.wall?
            i = @wall
          else
            if d.board.visible?(d.player.x + x, d.player.y + y)
              i = @floor
            else
              i = @unknown
            end
          end
          draw_block(x, y, i)

          if d.board.visible?(d.player.x + x, d.player.y + y)
            draw_block(x, y, @step_up) if d.step_up.exist?(d.player.x + x, d.player.y + y)
            if d.step_down
              draw_block(x, y, @step_down) if d.step_down.exist?(d.player.x + x, d.player.y + y)
            end

            d.monsters.each do |m|
              next unless m.exist?(d.player.x + x, d.player.y + y)
              case m
              when ROgue01::Monster::PinkMini
                draw_mini(x, y)
              when ROgue01::Monster::PinkBig
                draw_big(x, y)
              end
            end
          end
        end
      end

      draw_block(0, 0, @player)
    end

    def draw_block(dx, dy, b)
      Window.draw(block_x(dx), block_y(dy), b)
    end

    def draw_mini(dx, dy)
      Window.drawEx(block_x(dx), block_y(dy), @mob_img,
      {:scalex => 1.2, :scaley => 1.2, :z => 1})
    end

    def draw_big(dx, dy)
      Window.drawEx(block_x(dx), block_y(dy), @mob_img,
      {:scalex => 2.0, :scaley => 2.0, :z => 2})
    end

    def block_x(dx)
      left_margin = 10
      left_margin + (@v_size + dx) * @block_size
    end

    def block_y(dy)
      up_margin = 30
      up_margin + (@v_size + dy) * @block_size
    end

  end
end
