# -*- coding: UTF-8 -*-
module ROgue01
  module Dungeon
    class PinkMazeMonsterFactory < RDGC::Dungeon::MonsterFactory

      attr_accessor :game_mode

      def create(x, y)
        case self.game_mode
        when :normal
          create_normal(x, y)
        when :endless
          create_endless(x, y)
        else
          create_endless(x, y)
        end
      end

      def create_normal(x, y)
        Monster::PinkMini.create(create_lv, x, y)
      end

      def create_endless(x, y)
        target = select_rand(:mini => 10, :big => (floor/2.0).floor)
        case target
        when :mini
          Monster::PinkMini.create(create_lv, x, y)
        when :big
          Monster::PinkBig.create(floor, x, y)
        end
      end

      def create_lv
        range_rand((floor*0.5).ceil, floor*2)
      end

    end
  end
end
