# -*- coding: UTF-8 -*-
module ROgue01
  module Scene
    class Main < RogueScene

      def init
        @drawer = BlockDrawer.new
        @player = ROgue01::Player::SwordmanPlayer.new

        start_floor = params[:start_floor]
        start_floor ||= 1

        @master = PinkMazeGameMaster.start_for(@player, start_floor, :game_mode => game_mode)
      end

      def run
        super

        case
        when @master.gameover?
          to_gameover
        when @master.ending?
          to_ending
        else
          @master.proceed
        end
      end

      def render
        @drawer.draw(@master.dungeon)
      end

      def to_gameover
        return unless Input.keyPush?(K_SPACE)
        params[:start_floor] = @master.floor if endless_mode?
        params[:use_turn] = @master.turn_count if normal_mode?
        turn_to Gameover
      end

      def to_ending
        return unless Input.keyPush?(K_SPACE)
        params[:use_turn] = @master.turn_count
        turn_to Ending1
      end

    end
  end
end
