# -*- coding: UTF-8 -*-
module ROgue01
  module Scene
    module ScrollMessage

      def init
        @font = Font.new(16)
        @max_line = 18
        @mes_buf = []
        @state = :next
        @next = 0
        @blink_flag = false
        @frame_counter = 0
        init_massage
        next_scene
      end

      def init_massage
      end

      def next_scene
      end

      def run
        super
        @frame_counter += 1

        case @state
        when :next
          if has_next?
            next_message.each{|m| set_message(m)}
            @mes_buf << ""
            @state = :wait
          else
            turn_to @next_scene
          end
        when :wait
          turn_to @next_scene if Input.keyPush?(K_S)
          @state = :next if Input.keyPush?(K_SPACE)
        end
      end

      def render
        mes_point = 0
        @mes_buf.each do |m|
          Window.drawFont(0, mes_point, m, @font)
          mes_point += @font.size
        end

        if @blink_flag
          if has_next?
            last = "  [push to next]"
          else
            last = "  [push to start]"
          end
          Window.drawFont(0, mes_point, last.conv_sjis, @font)
        end

        @blink_flag = (! @blink_flag) if (@frame_counter % 50) == 0
      end

      private

      def has_next?
        @all_massage[@next] ? true : false
      end

      def next_message
        ret = @all_massage[@next]
        @next += 1
        ret
      end

      def set_message(mes)
        @mes_buf << mes.conv_sjis
        loop do
          break if @mes_buf.length <= @max_line
          @mes_buf.shift
        end
      end

    end
  end
end
