/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.functions;

import java.sql.SQLException;
import java.util.List;
import net.morilib.db.functions.FunctionType;
import net.morilib.db.misc.DefaultDelay;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.Rational;
import net.morilib.db.relations.RelationAggregate;
import net.morilib.db.relations.RelationFunction;
import net.morilib.db.relations.Relations;

public class FnCount
extends RelationFunction {
    @Override
    public boolean isAggregate() {
        return true;
    }

    @Override
    public Object operate(RelationAggregate m, List<Object> group, Object ... args) throws SQLException {
        Rational d = (Rational)m.get(group).force();
        if (args.length != 1) {
            throw ErrorBundle.getDefault(10007, "COUNT");
        }
        if (args[0] == Relations.ANY) {
            d = d.add(Rational.ONE);
        } else if (!args[0].equals("")) {
            d = d.add(Rational.ONE);
        }
        m.put(group, new DefaultDelay(d));
        return d;
    }

    @Override
    public Object init(RelationAggregate m) throws SQLException {
        Rational d = Rational.ZERO;
        m.init(new DefaultDelay(d));
        return d;
    }

    @Override
    public FunctionType getType() {
        return FunctionType.NUMERIC;
    }
}

