/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.functions;

import java.sql.SQLException;
import java.util.List;
import net.morilib.db.functions.FunctionType;
import net.morilib.db.misc.DefaultDelay;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.Rational;
import net.morilib.db.relations.RelationAggregate;
import net.morilib.db.relations.RelationExpression;
import net.morilib.db.relations.RelationFunction;

public class FnMin
extends RelationFunction {
    @Override
    public boolean isAggregate() {
        return true;
    }

    @Override
    public Object operate(RelationAggregate m, List<Object> group, Object ... args) throws SQLException {
        Object d = m.get(group).force();
        if (args.length != 1) {
            throw ErrorBundle.getDefault(10007, "MIN");
        }
        if (!args[0].equals("")) {
            if (d.equals("")) {
                d = args[0];
            } else if (RelationExpression.cmp(args[0], d) < 0) {
                d = args[0];
            }
        }
        m.put(group, new DefaultDelay(d));
        return d;
    }

    @Override
    public Object init(RelationAggregate m) throws SQLException {
        m.init(new DefaultDelay(""));
        return Rational.ZERO;
    }

    @Override
    public FunctionType getType() {
        return FunctionType.NUMERIC;
    }
}

