/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.functions;

import java.sql.SQLException;
import java.util.List;
import net.morilib.db.functions.FunctionType;
import net.morilib.db.misc.DefaultDelay;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.Rational;
import net.morilib.db.relations.RelationAggregate;
import net.morilib.db.relations.RelationFunction;

public class FnSum
extends RelationFunction {
    @Override
    public boolean isAggregate() {
        return true;
    }

    @Override
    public Object operate(RelationAggregate m, List<Object> group, Object ... args) throws SQLException {
        Rational d = (Rational)m.get(group).force();
        if (args.length != 1) {
            throw ErrorBundle.getDefault(10007, "SUM");
        }
        if (!args[0].equals("")) {
            if (args[0] instanceof Rational) {
                d = d.add((Rational)args[0]);
            } else {
                throw ErrorBundle.getDefault(10008, "SUM");
            }
        }
        m.put(group, new DefaultDelay(d));
        return d;
    }

    @Override
    public Object init(RelationAggregate m) throws SQLException {
        Rational d = Rational.ZERO;
        m.init(new DefaultDelay(d));
        return d;
    }

    @Override
    public FunctionType getType() {
        return FunctionType.NUMERIC;
    }
}

