/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.relations;

import java.io.IOException;
import java.math.MathContext;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.morilib.db.engine.SqlEngine;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.relations.AbstractRelation;
import net.morilib.db.relations.DefaultRelationTuple;
import net.morilib.db.relations.IsolatedRelation;
import net.morilib.db.relations.OperatedRelation;
import net.morilib.db.relations.OuterRelationTuple;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationAggregate;
import net.morilib.db.relations.RelationCursor;
import net.morilib.db.relations.RelationExpression;
import net.morilib.db.relations.RelationRefer;
import net.morilib.db.relations.RelationScanEvent;
import net.morilib.db.relations.RelationScanListener;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.relations.SingleTableRelation;
import net.morilib.db.relations.TableRelation;
import net.morilib.db.relations.VirtualCrossJoinRelation;
import net.morilib.db.schema.SqlSchema;
import net.morilib.db.sqlcs.ddl.SqlColumnAttribute;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;
import net.morilib.db.sqlcs.ddl.SqlTypeVarchar;
import net.morilib.db.sqlcs.dml.SqlJoinType;
import net.morilib.db.sqlcs.dml.SqlOrderBy;
import net.morilib.db.sqlcs.dml.SqlTableColumn;

public final class Relations {
    private static final RelationTuple X = new RelationTuple(){

        @Override
        public Object get(String name) throws SQLException {
            throw ErrorBundle.getDefault(10009, name);
        }

        @Override
        public RelationTuple copy() {
            return new DefaultRelationTuple(this.toMap());
        }

        @Override
        public Map<String, Object> toMap() {
            LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
            m.put("\u001e", "");
            return m;
        }
    };
    public static final Relation DUAL = new Dual();
    public static final MathContext MC = new MathContext(6);
    public static final RelationTuple NULLTUPLE = new RelationTuple(){

        @Override
        public Object get(String name) throws SQLException {
            throw ErrorBundle.getDefault(10009, name);
        }

        @Override
        public RelationTuple copy() throws SQLException {
            return new DefaultRelationTuple(this.toMap());
        }

        @Override
        public Map<String, Object> toMap() throws SQLException {
            return Collections.emptyMap();
        }
    };
    public static final RelationExpression ANY = new RelationExpression(){

        @Override
        public Object eval(SqlEngine v, SqlSchema f, RelationTuple t, RelationAggregate m, List<String> group, List<Object> h) throws IOException, SQLException {
            return this;
        }

        @Override
        public Object init(RelationAggregate m) throws SQLException {
            return this;
        }

        @Override
        public boolean isAggregate() {
            return false;
        }
    };

    private Relations() {
    }

    public static Relation join(SqlEngine v, SqlSchema f, RelationExpression on, final Relation a, Relation b, RelationAggregate m, List<String> group, final SqlJoinType tp, List<Object> h) throws IOException, SQLException {
        final VirtualCrossJoinRelation c = new VirtualCrossJoinRelation(a, b);
        final boolean[] fl = new boolean[1];
        RelationCursor i = c.iterator();
        final ArrayList<RelationTuple> l = new ArrayList<RelationTuple>();
        fl[0] = false;
        i.addRelationScanListener(new RelationScanListener(){

            @Override
            public void scaned(RelationScanEvent e) throws SQLException {
                if (tp == SqlJoinType.LEFT && !fl[0]) {
                    l.add(new OuterRelationTuple(a, e.getTuple(), c.getColumnNames()));
                }
                fl[0] = false;
            }
        });
        while (i.hasNext()) {
            RelationTuple t = i.next();
            if (!on.test(v, f, t, m, group, h).isTrue()) continue;
            l.add(t.copy());
            fl[0] = true;
        }
        return new TableRelation(c.getColumnNames(), l);
    }

    public static OperatedRelation operate(SqlEngine v, SqlSchema f, Relation a, List<SqlTableColumn> on, List<String> g, List<Object> hl, boolean[] ag) throws IOException, SQLException {
        ArrayList<String> h;
        RelationExpression[] x;
        String[] s;
        if (on.size() == 1 && on.get(0) == SqlTableColumn.WILDCARD) {
            List<SqlColumnDefinition> c = a.getColumnNames();
            ArrayList<SqlColumnDefinition> d = new ArrayList<SqlColumnDefinition>();
            int i = 0;
            while (i < c.size()) {
                if (a instanceof IsolatedRelation != c.get(i).getName().indexOf(46) < 0) {
                    d.add(c.get(i));
                }
                ++i;
            }
            s = new String[d.size()];
            x = new RelationExpression[d.size()];
            i = 0;
            while (i < d.size()) {
                s[i] = ((SqlColumnDefinition)d.get(i)).getName();
                x[i] = new RelationRefer(s[i]);
                ++i;
            }
            h = null;
        } else {
            x = new RelationExpression[on.size()];
            s = new String[on.size()];
            int i = 0;
            while (i < on.size()) {
                x[i] = v.visit(on.get(i).getExpression(), hl);
                s[i] = on.get(i).getAs();
                if (s[i] == null && x[i] instanceof RelationRefer) {
                    s[i] = ((RelationRefer)x[i]).getId();
                }
                ag[0] = ag[0] || x[i].isAggregate();
                ++i;
            }
            h = g != null ? g : (ag[0] ? new ArrayList<String>() : null);
        }
        return new OperatedRelation(a, v, f, Arrays.asList(x), Arrays.asList(s), h, hl);
    }

    static int compareKey(List<SqlColumnDefinition> l, RelationTuple a, RelationTuple b) throws SQLException {
        for (SqlColumnDefinition s : l) {
            Object y;
            Object x = a.get(s.getName());
            int c = RelationExpression.cmp(x, y = b.get(s.getName()));
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    public static Comparator<RelationTuple> getComparator(final Relation r, final List<SqlOrderBy> l) {
        return new Comparator<RelationTuple>(){

            @Override
            public int compare(RelationTuple a, RelationTuple b) {
                try {
                    for (SqlOrderBy o : l) {
                        Object x = a.get(o.getName());
                        Object y = b.get(o.getName());
                        int c = RelationExpression.cmp(x, y);
                        int n = c = o.isAscending() ? c : -c;
                        if (c == 0) continue;
                        return c;
                    }
                    return Relations.compareKey(r.getColumnNames(), a, b);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    static Object _get(RelationTuple v, Relation r, String n) throws SQLException {
        int c = n.indexOf(46);
        if (!(r instanceof SingleTableRelation)) {
            return v.get(n);
        }
        if (((SingleTableRelation)r).getName().equals(n.substring(0, c))) {
            return v.get(n.substring(c + 1));
        }
        return null;
    }

    static void _add(List<SqlColumnDefinition> cols, Relation r) {
        for (SqlColumnDefinition s : r.getColumnNames()) {
            if (r instanceof SingleTableRelation) {
                s = new SqlColumnDefinition(String.valueOf(((SingleTableRelation)r).getName()) + "." + s.getName(), s.getType(), s.getAttributes());
            }
            cols.add(s);
        }
    }

    private static class Dual
    extends AbstractRelation {
        private Dual() {
        }

        @Override
        public RelationCursor iterator() {
            return new RelationCursor(){
                private RelationTuple v = Relations.access$0();

                @Override
                public boolean hasNext() {
                    return this.v != null;
                }

                @Override
                public RelationTuple next() throws IOException, SQLException {
                    if (this.v != null) {
                        this.v = null;
                        return X;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public List<SqlColumnDefinition> getColumnNames() {
            return Collections.singletonList(new SqlColumnDefinition("\u001e", new SqlTypeVarchar(1), EnumSet.noneOf(SqlColumnAttribute.class)));
        }

        @Override
        public SqlColumnDefinition getDefinition(String name) {
            return null;
        }
    }
}

