/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.schema;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import net.morilib.db.fichier.FabriqueDeFichier;
import net.morilib.db.fichier.Fichier;
import net.morilib.db.map.CSVDataMapper;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.NullBoolean;
import net.morilib.db.relations.NamedRelation;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.schema.SqlSchema;
import net.morilib.db.sql.DbSqlLexer;
import net.morilib.db.sql.DbSqlParser;
import net.morilib.db.sqlcs.ddl.SqlCreateTable;

public class FileSqlSchema
implements SqlSchema {
    private static final SimpleDateFormat FMT = new SimpleDateFormat("'.bk'yyyyMMddHHmmssSSS");
    private FabriqueDeFichier fabrique;
    private Fichier base;

    public FileSqlSchema(FabriqueDeFichier f, Fichier s) {
        this.fabrique = f;
        this.base = s;
    }

    protected Fichier getFile(String name) throws IOException, SQLException {
        String t = name.toLowerCase();
        if (!this.isTable(name.toLowerCase())) {
            throw ErrorBundle.getDefault(10015, name);
        }
        Fichier f = this.fabrique().newInstance(this.base, String.valueOf(t) + ".csv");
        if (f.isFile()) {
            return f;
        }
        f = this.fabrique().newInstance(this.base, String.valueOf(t) + ".csv");
        f.createNewFile();
        return f;
    }

    protected Reader getReader(String name) throws IOException, SQLException {
        return this.fabrique().newInstance(this.base, name.toLowerCase()).openReader();
    }

    protected Reader getTableReader(String name) throws IOException, SQLException {
        return this.getFile(name).openReader();
    }

    protected PrintWriter getWriter(String name) throws IOException, SQLException {
        Fichier f = this.fabrique().newInstance(this.base, name.toLowerCase());
        return new PrintWriter(new BufferedWriter(f.openWriter()));
    }

    protected PrintWriter getTableWriter(String name) throws IOException, SQLException {
        return new PrintWriter(new BufferedWriter(this.getFile(name).openWriter()));
    }

    @Override
    public SqlCreateTable getCreateTable(String name) throws IOException, SQLException {
        Reader rd = this.getReader(String.valueOf(name) + ".ddl");
        try {
            DbSqlLexer l = new DbSqlLexer(rd);
            Object o = new DbSqlParser().parse(l);
            if (o instanceof SqlCreateTable) {
                SqlCreateTable sqlCreateTable = (SqlCreateTable)o;
                return sqlCreateTable;
            }
            throw ErrorBundle.getDefault(10041, new Object[0]);
        }
        finally {
            rd.close();
        }
    }

    @Override
    public boolean isTable(String name) throws IOException, SQLException {
        return this.fabrique().newInstance(this.base, String.valueOf(name) + ".ddl").isFile();
    }

    @Override
    public void putCreateTable(String name, SqlCreateTable table) throws IOException, SQLException {
        PrintWriter w = null;
        if (this.isTable(name)) {
            throw ErrorBundle.getDefault(10016, name);
        }
        try {
            w = this.getWriter(String.valueOf(name) + ".ddl");
            w.write(table.toString());
        }
        finally {
            if (w != null) {
                w.close();
            }
        }
    }

    @Override
    public void alterCreateTable(String name, SqlCreateTable table) throws IOException, SQLException {
        PrintWriter w = null;
        if (!this.isTable(name)) {
            throw ErrorBundle.getDefault(10015, name);
        }
        try {
            w = this.getWriter(String.valueOf(name) + ".ddl");
            w.write(table.toString());
        }
        finally {
            if (w != null) {
                w.close();
            }
        }
    }

    @Override
    public NamedRelation readRelation(String t, String as) throws IOException, SQLException {
        Fichier f = this.getFile(t);
        if (!f.getName().endsWith(".csv")) {
            throw ErrorBundle.getDefault(10042, new Object[0]);
        }
        CSVDataMapper m = new CSVDataMapper();
        return m.read(t, as, this.getCreateTable(t), this.getTableReader(t));
    }

    @Override
    public void writeRelation(String name, Collection<RelationTuple> z) throws IOException, SQLException {
        SqlCreateTable c = this.getCreateTable(name);
        Fichier f = this.getFile(name);
        Fichier t = null;
        char[] b = new char[1024];
        PrintWriter w = null;
        Reader r = null;
        if (!f.getName().endsWith(".csv")) {
            throw ErrorBundle.getDefault(10042, new Object[0]);
        }
        CSVDataMapper m = new CSVDataMapper();
        try {
            int j;
            t = this.fabrique().createTempFile("pre-", ".tmp");
            w = new PrintWriter(new BufferedWriter(t.openWriter()));
            m.write(name, c, w, z);
            w.close();
            w = null;
            r = new BufferedReader(t.openReader());
            w = this.getTableWriter(name);
            while ((j = r.read(b)) >= 0) {
                w.write(b, 0, j);
            }
        }
        finally {
            if (w != null) {
                w.close();
            }
            if (r != null) {
                r.close();
            }
            if (t != null) {
                t.delete();
            }
        }
    }

    @Override
    public Collection<String> getTableNames() {
        Fichier[] l;
        ArrayList<String> r = new ArrayList<String>();
        Fichier[] fichierArray = l = this.base.listFichiers();
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Fichier f = fichierArray[n2];
            String s = f.getName();
            if (s.endsWith(".ddl")) {
                r.add(s.substring(0, s.length() - 4));
            }
            ++n2;
        }
        return r;
    }

    @Override
    public void truncateTable(String name) throws IOException, SQLException {
        if (!this.isTable(name)) {
            throw ErrorBundle.getDefault(10015, name);
        }
        Fichier f = this.getFile(name);
        Fichier g = this.fabrique().newInstance(this.base, String.valueOf(f.getName()) + FMT.format(new Date()));
        f.renameTo(g);
    }

    @Override
    public void removeCreateTable(String name) throws IOException, SQLException {
        if (!this.isTable(name)) {
            throw ErrorBundle.getDefault(10015, name);
        }
        String s = FMT.format(new Date());
        Fichier f = this.getFile(name);
        Fichier g = this.fabrique().newInstance(this.base, String.valueOf(f.getName()) + s);
        f.renameTo(g);
        f = this.fabrique().newInstance(this.base, String.valueOf(name.toLowerCase()) + ".ddl");
        g = this.fabrique().newInstance(this.base, String.valueOf(f.getName()) + s);
        f.renameTo(g);
    }

    @Override
    public SqlSchema fork() {
        return new FileSqlSchema(this.fabrique, this.base);
    }

    @Override
    public NullBoolean isReadonly() {
        return NullBoolean.FALSE;
    }

    @Override
    public NullBoolean usesLocalFiles() {
        return NullBoolean.TRUE;
    }

    @Override
    public NullBoolean usesLocalFilePerTable() {
        return NullBoolean.TRUE;
    }

    @Override
    public FabriqueDeFichier fabrique() {
        return this.fabrique;
    }
}

