/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.schema;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.ParseDate;
import net.morilib.db.sqlcs.ddl.SqlColumnAttribute;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;
import net.morilib.db.sqlcs.ddl.SqlColumnType;
import net.morilib.db.sqlcs.ddl.SqlCreateTable;
import net.morilib.db.sqlcs.ddl.SqlTypeDate;
import net.morilib.db.sqlcs.ddl.SqlTypeNumeric;
import net.morilib.db.sqlcs.ddl.SqlTypeVarchar;
import net.morilib.parser.csv.CSVConfig;
import net.morilib.parser.csv.CSVException;
import net.morilib.parser.csv.StringCSVPullParser;

public final class SqlSchemata {
    private static final CSVConfig DEFT = new CSVConfig(",", 34, false);
    private static final Pattern PT1 = Pattern.compile("([0-9]+)|([0-9]*)\\.([0-9]+)");
    private static final Pattern PT2 = Pattern.compile("(.*/)?([^.]+)");
    private static final SqlTypeNumeric UNLIMITED_INTEGER = new SqlTypeNumeric(0, 0);
    private static int seq = 1;

    private SqlSchemata() {
    }

    private static SqlTypeNumeric getlen(SqlTypeNumeric n, Matcher m) {
        if (m.group(1) != null) {
            return n == null || n.getScale() <= 0 ? UNLIMITED_INTEGER : n;
        }
        int j = m.group(3).length();
        return n == null || n.getScale() <= j ? new SqlTypeNumeric(0, j) : n;
    }

    public static SqlCreateTable guessTable(String s, InputStream ins) throws IOException, SQLException {
        StringCSVPullParser p = null;
        BufferedReader r = null;
        try {
            Matcher w;
            r = new BufferedReader(new InputStreamReader(ins));
            p = new StringCSVPullParser(r, DEFT);
            if (!p.next()) {
                throw ErrorBundle.getDefault(10018, new Object[0]);
            }
            ArrayList<String> n = new ArrayList<String>(Arrays.asList(p.get()));
            HashSet z = new HashSet();
            int i = 0;
            while (i < n.size()) {
                if (((String)n.get(i)).equals("") || z.contains(n.get(i))) {
                    n.set(i, String.valueOf(((String)n.get(i)).toUpperCase()) + i);
                } else {
                    n.set(i, ((String)n.get(i)).toUpperCase());
                }
                ++i;
            }
            SqlColumnType[] t = new SqlColumnType[n.size()];
            i = 0;
            while (i < n.size()) {
                t[i] = null;
                ++i;
            }
            while (p.next()) {
                String[] y = p.get();
                i = 0;
                while (i < n.size()) {
                    if (i < y.length) {
                        if ((t[i] == null || t[i] instanceof SqlTypeNumeric) && (w = PT1.matcher(y[i])).matches()) {
                            t[i] = SqlSchemata.getlen((SqlTypeNumeric)t[i], w);
                        } else if ((t[i] == null || t[i] instanceof SqlTypeDate) && ParseDate.getDate(y[i]) != null) {
                            t[i] = t[i] == null ? new SqlTypeDate() : t[i];
                        } else if (!(t[i] instanceof SqlTypeVarchar)) {
                            t[i] = new SqlTypeVarchar(0);
                        }
                    }
                    ++i;
                }
            }
            ArrayList<SqlColumnDefinition> l = new ArrayList<SqlColumnDefinition>();
            i = 0;
            while (i < n.size()) {
                l.add(new SqlColumnDefinition((String)n.get(i), t[i], EnumSet.noneOf(SqlColumnAttribute.class)));
                ++i;
            }
            w = PT2.matcher(s);
            String v = w.lookingAt() ? w.group(2) : "table" + seq++;
            SqlCreateTable sqlCreateTable = new SqlCreateTable(v.toUpperCase(), l);
            return sqlCreateTable;
        }
        catch (CSVException e) {
            throw ErrorBundle.getDefault(10042, new Object[0]);
        }
        finally {
            if (p != null) {
                p.close();
            }
        }
    }

    public static SqlCreateTable guessTable(String s) throws IOException, SQLException {
        return SqlSchemata.guessTable(s, new FileInputStream(s));
    }
}

