/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.sql;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.Rational;
import net.morilib.db.sql.DbSqlLexer;
import net.morilib.db.sql.DbSqlNonterminal;
import net.morilib.db.sql.DbSqlParser;
import net.morilib.db.sql.DbSqlReserved;
import net.morilib.db.sqlcs.dml.SqlBinaryOperation;
import net.morilib.db.sqlcs.dml.SqlBinaryOperator;
import net.morilib.db.sqlcs.dml.SqlExists;
import net.morilib.db.sqlcs.dml.SqlExpression;
import net.morilib.db.sqlcs.dml.SqlExpressions;
import net.morilib.db.sqlcs.dml.SqlFunction;
import net.morilib.db.sqlcs.dml.SqlIn;
import net.morilib.db.sqlcs.dml.SqlInSubquery;
import net.morilib.db.sqlcs.dml.SqlNumeric;
import net.morilib.db.sqlcs.dml.SqlPlaceHolder;
import net.morilib.db.sqlcs.dml.SqlSelect;
import net.morilib.db.sqlcs.dml.SqlString;
import net.morilib.db.sqlcs.dml.SqlSubqueryLiteral;
import net.morilib.db.sqlcs.dml.SqlSymbol;
import net.morilib.db.sqlcs.dml.SqlTernaryOperation;
import net.morilib.db.sqlcs.dml.SqlTernaryOperator;
import net.morilib.db.sqlcs.dml.SqlUnaryOperation;
import net.morilib.db.sqlcs.dml.SqlUnaryOperator;

public class DbSqlExprParser {
    private List<Object> stack = new ArrayList<Object>();
    private DbSqlNonterminal gt = null;
    private int stat;

    private Object pop() {
        this.stack.remove(this.stack.size() - 1);
        return this.stack.remove(this.stack.size() - 1);
    }

    private void shift(int n) {
        this.stat = n;
        this.gt = null;
        this.stack.add(null);
        this.stack.add(n);
    }

    private void shift(int n, Object o) {
        this.stat = n;
        this.gt = null;
        this.stack.add(o);
        this.stack.add(n);
    }

    private void setGoto(DbSqlNonterminal nt, Object o) {
        this.stat = (Integer)this.stack.get(this.stack.size() - 1);
        this.gt = nt;
        this.stack.add(o);
    }

    private void goTo(int n) {
        this.stat = n;
        this.gt = null;
        this.stack.add(n);
    }

    public SqlExpression parse(DbSqlLexer lex) throws IOException, SQLException {
        this.stat = 100000;
        this.stack.add(100000);
        while (true) {
            switch (this.stat) {
                case 100000: {
                    if (this.gt == DbSqlNonterminal.EXPR) {
                        this.goTo(100100);
                        break;
                    }
                    if (lex.eqchar('(')) {
                        this.shift(101100);
                        break;
                    }
                    if (lex.eqchar('+')) {
                        this.shift(102100);
                        break;
                    }
                    if (lex.eqchar('-')) {
                        this.shift(103100);
                        break;
                    }
                    if (lex.eqsym("NOT")) {
                        this.shift(104100);
                        break;
                    }
                    if (lex.eqsym("EXISTS")) {
                        this.shift(119100);
                        break;
                    }
                    String s = lex.getsym();
                    if (s != null) {
                        this.shift(115100, s);
                        break;
                    }
                    s = lex.getstr();
                    if (s != null) {
                        this.shift(300100, s);
                        break;
                    }
                    Rational n = lex.getnum();
                    if (n != null) {
                        this.shift(300200, n);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(300300);
                        break;
                    }
                    if (lex.eqchar('?')) {
                        this.shift(300400);
                        break;
                    }
                    throw ErrorBundle.getDefault(10019, lex.get().toString());
                }
                case 100100: {
                    if (lex.eqchar('+')) {
                        this.shift(105200);
                        break;
                    }
                    if (lex.eqchar('-')) {
                        this.shift(106200);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(107200);
                        break;
                    }
                    if (lex.eqchar('/')) {
                        this.shift(108200);
                        break;
                    }
                    if (lex.eq((Object)DbSqlReserved.CONCAT)) {
                        this.shift(109200);
                        break;
                    }
                    SqlBinaryOperator r = lex.getrelop();
                    if (r != null) {
                        this.shift(110200, (Object)r);
                        break;
                    }
                    if (lex.eqsym("AND")) {
                        this.shift(111200);
                        break;
                    }
                    if (lex.eqsym("OR")) {
                        this.shift(112200);
                        break;
                    }
                    if (lex.eqsym("IN")) {
                        this.shift(114200);
                        break;
                    }
                    if (lex.eqsym("BETWEEN")) {
                        this.shift(116100);
                        break;
                    }
                    if (lex.eqsym("IS")) {
                        this.shift(118100);
                        break;
                    }
                    return (SqlExpression)this.pop();
                }
                case 101100: {
                    Object o;
                    if (this.gt == DbSqlNonterminal.EXPR) {
                        this.goTo(101200);
                        break;
                    }
                    if (lex.eqchar('(')) {
                        this.shift(101100);
                        break;
                    }
                    if (lex.eqchar('+')) {
                        this.shift(102100);
                        break;
                    }
                    if (lex.eqchar('-')) {
                        this.shift(103100);
                        break;
                    }
                    if (lex.eqsym("NOT")) {
                        this.shift(104100);
                        break;
                    }
                    if (lex.eqsym("EXISTS")) {
                        this.shift(119100);
                        break;
                    }
                    if (lex.eqsym("SELECT")) {
                        o = new DbSqlParser()._select(lex);
                        this.shift(101200, new SqlSubqueryLiteral((SqlSelect)o));
                        break;
                    }
                    String s = lex.getsym();
                    if (s != null) {
                        this.shift(115100, s);
                        break;
                    }
                    s = lex.getstr();
                    if (s != null) {
                        this.shift(300100, s);
                        break;
                    }
                    Rational n = lex.getnum();
                    if (n != null) {
                        this.shift(300200, n);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(300300);
                        break;
                    }
                    if (lex.eqchar('?')) {
                        this.shift(300400);
                        break;
                    }
                    throw ErrorBundle.getDefault(10019, lex.get().toString());
                }
                case 101200: {
                    if (lex.eqchar(')')) {
                        this.shift(101300);
                        break;
                    }
                    if (lex.eqchar('+')) {
                        this.shift(105200);
                        break;
                    }
                    if (lex.eqchar('-')) {
                        this.shift(106200);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(107200);
                        break;
                    }
                    if (lex.eqchar('/')) {
                        this.shift(108200);
                        break;
                    }
                    if (lex.eq((Object)DbSqlReserved.CONCAT)) {
                        this.shift(109200);
                        break;
                    }
                    SqlBinaryOperator r = lex.getrelop();
                    if (r != null) {
                        this.shift(110200, (Object)r);
                        break;
                    }
                    if (lex.eqsym("AND")) {
                        this.shift(111200);
                        break;
                    }
                    if (lex.eqsym("OR")) {
                        this.shift(112200);
                        break;
                    }
                    if (lex.eqsym("IN")) {
                        this.shift(114200);
                        break;
                    }
                    if (lex.eqsym("BETWEEN")) {
                        this.shift(116100);
                        break;
                    }
                    if (lex.eqsym("IS")) {
                        this.shift(118100);
                        break;
                    }
                    throw ErrorBundle.getDefault(10019, lex.get().toString());
                }
                case 101300: {
                    this.pop();
                    Object o = this.pop();
                    this.pop();
                    this.setGoto(DbSqlNonterminal.EXPR, o);
                    break;
                }
                case 102100: {
                    if (this.gt == DbSqlNonterminal.EXPR) {
                        this.goTo(102200);
                        break;
                    }
                    if (lex.eqchar('(')) {
                        this.shift(101100);
                        break;
                    }
                    String s = lex.getsym();
                    if (s != null) {
                        this.shift(115100, s);
                        break;
                    }
                    s = lex.getstr();
                    if (s != null) {
                        this.shift(300100, s);
                        break;
                    }
                    Rational n = lex.getnum();
                    if (n != null) {
                        this.shift(300200, n);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(300300);
                        break;
                    }
                    if (lex.eqchar('?')) {
                        this.shift(300400);
                        break;
                    }
                    throw ErrorBundle.getDefault(10019, lex.get().toString());
                }
                case 102200: {
                    SqlExpression x = (SqlExpression)this.pop();
                    this.pop();
                    x = new SqlUnaryOperation(SqlUnaryOperator.PLUS, x);
                    this.setGoto(DbSqlNonterminal.EXPR, x);
                    break;
                }
                case 103100: {
                    if (this.gt == DbSqlNonterminal.EXPR) {
                        this.goTo(103200);
                        break;
                    }
                    if (lex.eqchar('(')) {
                        this.shift(101100);
                        break;
                    }
                    String s = lex.getsym();
                    if (s != null) {
                        this.shift(115100, s);
                        break;
                    }
                    s = lex.getstr();
                    if (s != null) {
                        this.shift(300100, s);
                        break;
                    }
                    Rational n = lex.getnum();
                    if (n != null) {
                        this.shift(300200, n);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(300300);
                        break;
                    }
                    if (lex.eqchar('?')) {
                        this.shift(300400);
                        break;
                    }
                    throw ErrorBundle.getDefault(10019, lex.get().toString());
                }
                case 103200: {
                    SqlExpression x = (SqlExpression)this.pop();
                    this.pop();
                    x = new SqlUnaryOperation(SqlUnaryOperator.MINUS, x);
                    this.setGoto(DbSqlNonterminal.EXPR, x);
                    break;
                }
                case 104100: {
                    if (this.gt == DbSqlNonterminal.EXPR) {
                        this.goTo(104200);
                        break;
                    }
                    if (lex.eqchar('(')) {
                        this.shift(101100);
                        break;
                    }
                    if (lex.eqchar('+')) {
                        this.shift(102100);
                        break;
                    }
                    if (lex.eqchar('-')) {
                        this.shift(103100);
                        break;
                    }
                    if (lex.eqsym("EXISTS")) {
                        this.shift(119100);
                        break;
                    }
                    String s = lex.getsym();
                    if (s != null) {
                        this.shift(115100, s);
                        break;
                    }
                    s = lex.getstr();
                    if (s != null) {
                        this.shift(300100, s);
                        break;
                    }
                    Rational n = lex.getnum();
                    if (n != null) {
                        this.shift(300200, n);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(300300);
                        break;
                    }
                    if (lex.eqchar('?')) {
                        this.shift(300400);
                        break;
                    }
                    throw ErrorBundle.getDefault(10019, lex.get().toString());
                }
                case 104200: {
                    if (lex.eqchar('+')) {
                        this.shift(105200);
                        break;
                    }
                    if (lex.eqchar('-')) {
                        this.shift(106200);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(107200);
                        break;
                    }
                    if (lex.eqchar('/')) {
                        this.shift(108200);
                        break;
                    }
                    if (lex.eq((Object)DbSqlReserved.CONCAT)) {
                        this.shift(109200);
                        break;
                    }
                    SqlBinaryOperator r = lex.getrelop();
                    if (r != null) {
                        this.shift(110200, (Object)r);
                        break;
                    }
                    if (lex.eqsym("IN")) {
                        this.shift(114200);
                        break;
                    }
                    if (lex.eqsym("BETWEEN")) {
                        this.shift(116100);
                        break;
                    }
                    if (lex.eqsym("IS")) {
                        this.shift(118100);
                        break;
                    }
                    SqlExpression x = (SqlExpression)this.pop();
                    this.pop();
                    x = new SqlUnaryOperation(SqlUnaryOperator.NOT, x);
                    this.setGoto(DbSqlNonterminal.EXPR, x);
                    break;
                }
                case 105200: {
                    if (this.gt == DbSqlNonterminal.EXPR) {
                        this.goTo(105300);
                        break;
                    }
                    if (lex.eqchar('(')) {
                        this.shift(101100);
                        break;
                    }
                    if (lex.eqchar('+')) {
                        this.shift(102100);
                        break;
                    }
                    if (lex.eqchar('-')) {
                        this.shift(103100);
                        break;
                    }
                    if (lex.eqsym("NOT")) {
                        this.shift(104100);
                        break;
                    }
                    if (lex.eqsym("EXISTS")) {
                        this.shift(119100);
                        break;
                    }
                    String s = lex.getsym();
                    if (s != null) {
                        this.shift(115100, s);
                        break;
                    }
                    s = lex.getstr();
                    if (s != null) {
                        this.shift(300100, s);
                        break;
                    }
                    Rational n = lex.getnum();
                    if (n != null) {
                        this.shift(300200, n);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(300300);
                        break;
                    }
                    if (lex.eqchar('?')) {
                        this.shift(300400);
                        break;
                    }
                    throw ErrorBundle.getDefault(10019, lex.get().toString());
                }
                case 105300: {
                    if (lex.eqchar('*')) {
                        this.shift(107200);
                        break;
                    }
                    if (lex.eqchar('/')) {
                        this.shift(108200);
                        break;
                    }
                    SqlExpression y = (SqlExpression)this.pop();
                    this.pop();
                    SqlExpression x = (SqlExpression)this.pop();
                    x = new SqlBinaryOperation(SqlBinaryOperator.ADD, x, y);
                    this.setGoto(DbSqlNonterminal.EXPR, x);
                    break;
                }
                case 106200: {
                    if (this.gt == DbSqlNonterminal.EXPR) {
                        this.goTo(106300);
                        break;
                    }
                    if (lex.eqchar('(')) {
                        this.shift(101100);
                        break;
                    }
                    if (lex.eqchar('+')) {
                        this.shift(102100);
                        break;
                    }
                    if (lex.eqchar('-')) {
                        this.shift(103100);
                        break;
                    }
                    if (lex.eqsym("NOT")) {
                        this.shift(104100);
                        break;
                    }
                    if (lex.eqsym("EXISTS")) {
                        this.shift(119100);
                        break;
                    }
                    String s = lex.getsym();
                    if (s != null) {
                        this.shift(115100, s);
                        break;
                    }
                    s = lex.getstr();
                    if (s != null) {
                        this.shift(300100, s);
                        break;
                    }
                    Rational n = lex.getnum();
                    if (n != null) {
                        this.shift(300200, n);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(300300);
                        break;
                    }
                    if (lex.eqchar('?')) {
                        this.shift(300400);
                        break;
                    }
                    throw ErrorBundle.getDefault(10019, lex.get().toString());
                }
                case 106300: {
                    if (lex.eqchar('*')) {
                        this.shift(107200);
                        break;
                    }
                    if (lex.eqchar('/')) {
                        this.shift(108200);
                        break;
                    }
                    SqlExpression y = (SqlExpression)this.pop();
                    this.pop();
                    SqlExpression x = (SqlExpression)this.pop();
                    x = new SqlBinaryOperation(SqlBinaryOperator.SUB, x, y);
                    this.setGoto(DbSqlNonterminal.EXPR, x);
                    break;
                }
                case 107200: {
                    if (this.gt == DbSqlNonterminal.EXPR) {
                        this.goTo(107300);
                        break;
                    }
                    if (lex.eqchar('(')) {
                        this.shift(101100);
                        break;
                    }
                    if (lex.eqchar('+')) {
                        this.shift(102100);
                        break;
                    }
                    if (lex.eqchar('-')) {
                        this.shift(103100);
                        break;
                    }
                    if (lex.eqsym("NOT")) {
                        this.shift(104100);
                        break;
                    }
                    if (lex.eqsym("EXISTS")) {
                        this.shift(119100);
                        break;
                    }
                    String s = lex.getsym();
                    if (s != null) {
                        this.shift(115100, s);
                        break;
                    }
                    s = lex.getstr();
                    if (s != null) {
                        this.shift(300100, s);
                        break;
                    }
                    Rational n = lex.getnum();
                    if (n != null) {
                        this.shift(300200, n);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(300300);
                        break;
                    }
                    if (lex.eqchar('?')) {
                        this.shift(300400);
                        break;
                    }
                    throw ErrorBundle.getDefault(10019, lex.get().toString());
                }
                case 107300: {
                    SqlExpression y = (SqlExpression)this.pop();
                    this.pop();
                    SqlExpression x = (SqlExpression)this.pop();
                    x = new SqlBinaryOperation(SqlBinaryOperator.MUL, x, y);
                    this.setGoto(DbSqlNonterminal.EXPR, x);
                    break;
                }
                case 108200: {
                    if (this.gt == DbSqlNonterminal.EXPR) {
                        this.goTo(108300);
                        break;
                    }
                    if (lex.eqchar('(')) {
                        this.shift(101100);
                        break;
                    }
                    if (lex.eqchar('+')) {
                        this.shift(102100);
                        break;
                    }
                    if (lex.eqchar('-')) {
                        this.shift(103100);
                        break;
                    }
                    if (lex.eqsym("NOT")) {
                        this.shift(104100);
                        break;
                    }
                    if (lex.eqsym("EXISTS")) {
                        this.shift(119100);
                        break;
                    }
                    String s = lex.getsym();
                    if (s != null) {
                        this.shift(115100, s);
                        break;
                    }
                    s = lex.getstr();
                    if (s != null) {
                        this.shift(300100, s);
                        break;
                    }
                    Rational n = lex.getnum();
                    if (n != null) {
                        this.shift(300200, n);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(300300);
                        break;
                    }
                    if (lex.eqchar('?')) {
                        this.shift(300400);
                        break;
                    }
                    throw ErrorBundle.getDefault(10019, lex.get().toString());
                }
                case 108300: {
                    SqlExpression y = (SqlExpression)this.pop();
                    this.pop();
                    SqlExpression x = (SqlExpression)this.pop();
                    x = new SqlBinaryOperation(SqlBinaryOperator.DIV, x, y);
                    this.setGoto(DbSqlNonterminal.EXPR, x);
                    break;
                }
                case 109200: {
                    if (this.gt == DbSqlNonterminal.EXPR) {
                        this.goTo(109300);
                        break;
                    }
                    if (lex.eqchar('(')) {
                        this.shift(101100);
                        break;
                    }
                    if (lex.eqchar('+')) {
                        this.shift(102100);
                        break;
                    }
                    if (lex.eqchar('-')) {
                        this.shift(103100);
                        break;
                    }
                    if (lex.eqsym("NOT")) {
                        this.shift(104100);
                        break;
                    }
                    if (lex.eqsym("EXISTS")) {
                        this.shift(119100);
                        break;
                    }
                    String s = lex.getsym();
                    if (s != null) {
                        this.shift(115100, s);
                        break;
                    }
                    s = lex.getstr();
                    if (s != null) {
                        this.shift(300100, s);
                        break;
                    }
                    Rational n = lex.getnum();
                    if (n != null) {
                        this.shift(300200, n);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(300300);
                        break;
                    }
                    if (lex.eqchar('?')) {
                        this.shift(300400);
                        break;
                    }
                    throw ErrorBundle.getDefault(10019, lex.get().toString());
                }
                case 109300: {
                    if (lex.eqchar('+')) {
                        this.shift(105200);
                        break;
                    }
                    if (lex.eqchar('-')) {
                        this.shift(106200);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(107200);
                        break;
                    }
                    if (lex.eqchar('/')) {
                        this.shift(108200);
                        break;
                    }
                    SqlExpression y = (SqlExpression)this.pop();
                    this.pop();
                    SqlExpression x = (SqlExpression)this.pop();
                    x = new SqlBinaryOperation(SqlBinaryOperator.CONCAT, x, y);
                    this.setGoto(DbSqlNonterminal.EXPR, x);
                    break;
                }
                case 110200: {
                    if (this.gt == DbSqlNonterminal.EXPR) {
                        this.goTo(110300);
                        break;
                    }
                    if (lex.eqchar('(')) {
                        this.shift(101100);
                        break;
                    }
                    if (lex.eqchar('+')) {
                        this.shift(102100);
                        break;
                    }
                    if (lex.eqchar('-')) {
                        this.shift(103100);
                        break;
                    }
                    if (lex.eqsym("NOT")) {
                        this.shift(104100);
                        break;
                    }
                    if (lex.eqsym("EXISTS")) {
                        this.shift(119100);
                        break;
                    }
                    String s = lex.getsym();
                    if (s != null) {
                        this.shift(115100, s);
                        break;
                    }
                    s = lex.getstr();
                    if (s != null) {
                        this.shift(300100, s);
                        break;
                    }
                    Rational n = lex.getnum();
                    if (n != null) {
                        this.shift(300200, n);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(300300);
                        break;
                    }
                    if (lex.eqchar('?')) {
                        this.shift(300400);
                        break;
                    }
                    throw ErrorBundle.getDefault(10019, lex.get().toString());
                }
                case 110300: {
                    if (lex.eqchar('+')) {
                        this.shift(105200);
                        break;
                    }
                    if (lex.eqchar('-')) {
                        this.shift(106200);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(107200);
                        break;
                    }
                    if (lex.eqchar('/')) {
                        this.shift(108200);
                        break;
                    }
                    if (lex.eq((Object)DbSqlReserved.CONCAT)) {
                        this.shift(109200);
                        break;
                    }
                    SqlExpression y = (SqlExpression)this.pop();
                    SqlBinaryOperator r = (SqlBinaryOperator)((Object)this.pop());
                    SqlExpression x = (SqlExpression)this.pop();
                    x = new SqlBinaryOperation(r, x, y);
                    this.setGoto(DbSqlNonterminal.EXPR, x);
                    break;
                }
                case 111200: {
                    if (this.gt == DbSqlNonterminal.EXPR) {
                        this.goTo(111300);
                        break;
                    }
                    if (lex.eqchar('(')) {
                        this.shift(101100);
                        break;
                    }
                    if (lex.eqchar('+')) {
                        this.shift(102100);
                        break;
                    }
                    if (lex.eqchar('-')) {
                        this.shift(103100);
                        break;
                    }
                    if (lex.eqsym("NOT")) {
                        this.shift(104100);
                        break;
                    }
                    if (lex.eqsym("EXISTS")) {
                        this.shift(119100);
                        break;
                    }
                    String s = lex.getsym();
                    if (s != null) {
                        this.shift(115100, s);
                        break;
                    }
                    s = lex.getstr();
                    if (s != null) {
                        this.shift(300100, s);
                        break;
                    }
                    Rational n = lex.getnum();
                    if (n != null) {
                        this.shift(300200, n);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(300300);
                        break;
                    }
                    if (lex.eqchar('?')) {
                        this.shift(300400);
                        break;
                    }
                    throw ErrorBundle.getDefault(10019, lex.get().toString());
                }
                case 111300: {
                    if (lex.eqchar('+')) {
                        this.shift(105200);
                        break;
                    }
                    if (lex.eqchar('-')) {
                        this.shift(106200);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(107200);
                        break;
                    }
                    if (lex.eqchar('/')) {
                        this.shift(108200);
                        break;
                    }
                    if (lex.eq((Object)DbSqlReserved.CONCAT)) {
                        this.shift(109200);
                        break;
                    }
                    SqlBinaryOperator r = lex.getrelop();
                    if (r != null) {
                        this.shift(110200, (Object)r);
                        break;
                    }
                    if (lex.eqsym("IN")) {
                        this.shift(114200);
                        break;
                    }
                    if (lex.eqsym("BETWEEN")) {
                        this.shift(116100);
                        break;
                    }
                    if (lex.eqsym("IS")) {
                        this.shift(118100);
                        break;
                    }
                    SqlExpression y = (SqlExpression)this.pop();
                    this.pop();
                    SqlExpression x = (SqlExpression)this.pop();
                    x = new SqlBinaryOperation(SqlBinaryOperator.AND, x, y);
                    this.setGoto(DbSqlNonterminal.EXPR, x);
                    break;
                }
                case 112200: {
                    if (this.gt == DbSqlNonterminal.EXPR) {
                        this.goTo(112300);
                        break;
                    }
                    if (lex.eqchar('(')) {
                        this.shift(101100);
                        break;
                    }
                    if (lex.eqchar('+')) {
                        this.shift(102100);
                        break;
                    }
                    if (lex.eqchar('-')) {
                        this.shift(103100);
                        break;
                    }
                    if (lex.eqsym("NOT")) {
                        this.shift(104100);
                        break;
                    }
                    if (lex.eqsym("EXISTS")) {
                        this.shift(119100);
                        break;
                    }
                    String s = lex.getsym();
                    if (s != null) {
                        this.shift(115100, s);
                        break;
                    }
                    s = lex.getstr();
                    if (s != null) {
                        this.shift(300100, s);
                        break;
                    }
                    Rational n = lex.getnum();
                    if (n != null) {
                        this.shift(300200, n);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(300300);
                        break;
                    }
                    if (lex.eqchar('?')) {
                        this.shift(300400);
                        break;
                    }
                    throw ErrorBundle.getDefault(10019, lex.get().toString());
                }
                case 112300: {
                    if (lex.eqchar('+')) {
                        this.shift(105200);
                        break;
                    }
                    if (lex.eqchar('-')) {
                        this.shift(106200);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(107200);
                        break;
                    }
                    if (lex.eqchar('/')) {
                        this.shift(108200);
                        break;
                    }
                    if (lex.eq((Object)DbSqlReserved.CONCAT)) {
                        this.shift(109200);
                        break;
                    }
                    SqlBinaryOperator r = lex.getrelop();
                    if (r != null) {
                        this.shift(110200, (Object)r);
                        break;
                    }
                    if (lex.eqsym("AND")) {
                        this.shift(111200);
                        break;
                    }
                    if (lex.eqsym("IN")) {
                        this.shift(114200);
                        break;
                    }
                    if (lex.eqsym("BETWEEN")) {
                        this.shift(116100);
                        break;
                    }
                    if (lex.eqsym("IS")) {
                        this.shift(118100);
                        break;
                    }
                    SqlExpression y = (SqlExpression)this.pop();
                    this.pop();
                    SqlExpression x = (SqlExpression)this.pop();
                    x = new SqlBinaryOperation(SqlBinaryOperator.OR, x, y);
                    this.setGoto(DbSqlNonterminal.EXPR, x);
                    break;
                }
                case 114200: {
                    if (lex.eqchar('(')) {
                        this.shift(114300);
                        break;
                    }
                    throw ErrorBundle.getDefault(10019, lex.get().toString());
                }
                case 114300: {
                    Object o;
                    if (this.gt == DbSqlNonterminal.EXPR_LIST) {
                        this.goTo(114400);
                        break;
                    }
                    if (this.gt == DbSqlNonterminal.EXPR) {
                        this.goTo(201100);
                        break;
                    }
                    if (lex.eqchar('(')) {
                        this.shift(101100);
                        break;
                    }
                    if (lex.eqchar('+')) {
                        this.shift(102100);
                        break;
                    }
                    if (lex.eqchar('-')) {
                        this.shift(103100);
                        break;
                    }
                    if (lex.eqsym("NOT")) {
                        this.shift(104100);
                        break;
                    }
                    if (lex.eqsym("EXISTS")) {
                        this.shift(119100);
                        break;
                    }
                    if (lex.eqsym("SELECT")) {
                        o = new DbSqlParser()._select(lex);
                        this.shift(114410, (SqlSelect)o);
                        break;
                    }
                    String s = lex.getsym();
                    if (s != null) {
                        this.shift(115100, s);
                        break;
                    }
                    s = lex.getstr();
                    if (s != null) {
                        this.shift(300100, s);
                        break;
                    }
                    Rational n = lex.getnum();
                    if (n != null) {
                        this.shift(300200, n);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(300300);
                        break;
                    }
                    if (lex.eqchar('?')) {
                        this.shift(300400);
                        break;
                    }
                    throw ErrorBundle.getDefault(10019, lex.get().toString());
                }
                case 114400: {
                    if (lex.eqchar(')')) {
                        this.shift(114500);
                        break;
                    }
                    if (lex.eqchar(',')) {
                        this.shift(200200);
                        break;
                    }
                    throw ErrorBundle.getDefault(10019, lex.get().toString());
                }
                case 114500: {
                    this.pop();
                    List l = (List)this.pop();
                    this.pop();
                    this.pop();
                    SqlExpression x = (SqlExpression)this.pop();
                    x = new SqlIn(x, l);
                    this.setGoto(DbSqlNonterminal.EXPR, x);
                    break;
                }
                case 114410: {
                    if (lex.eqchar(')')) {
                        this.shift(114510);
                        break;
                    }
                    throw ErrorBundle.getDefault(10019, lex.get().toString());
                }
                case 114510: {
                    this.pop();
                    SqlSelect t = (SqlSelect)this.pop();
                    this.pop();
                    this.pop();
                    SqlExpression x = (SqlExpression)this.pop();
                    x = new SqlInSubquery(x, t);
                    this.setGoto(DbSqlNonterminal.EXPR, x);
                    break;
                }
                case 115100: {
                    if (lex.eqchar('(')) {
                        this.shift(115200);
                        break;
                    }
                    this.setGoto(DbSqlNonterminal.EXPR, new SqlSymbol(this.pop().toString()));
                    break;
                }
                case 115200: {
                    if (this.gt == DbSqlNonterminal.EXPR_LIST) {
                        this.goTo(115300);
                        break;
                    }
                    if (this.gt == DbSqlNonterminal.EXPR) {
                        this.goTo(201100);
                        break;
                    }
                    if (lex.eqchar(')')) {
                        this.shift(115310);
                        break;
                    }
                    if (lex.eqchar('(')) {
                        this.shift(101100);
                        break;
                    }
                    if (lex.eqchar('+')) {
                        this.shift(102100);
                        break;
                    }
                    if (lex.eqchar('-')) {
                        this.shift(103100);
                        break;
                    }
                    if (lex.eqsym("NOT")) {
                        this.shift(104100);
                        break;
                    }
                    if (lex.eqsym("EXISTS")) {
                        this.shift(119100);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(115320);
                        break;
                    }
                    String s = lex.getsym();
                    if (s != null) {
                        this.shift(115100, s);
                        break;
                    }
                    s = lex.getstr();
                    if (s != null) {
                        this.shift(300100, s);
                        break;
                    }
                    Rational n = lex.getnum();
                    if (n != null) {
                        this.shift(300200, n);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(300300);
                        break;
                    }
                    if (lex.eqchar('?')) {
                        this.shift(300400);
                        break;
                    }
                    throw ErrorBundle.getDefault(10019, lex.get().toString());
                }
                case 115300: {
                    if (lex.eqchar(')')) {
                        this.shift(115400);
                        break;
                    }
                    if (lex.eqchar(',')) {
                        this.shift(200200);
                        break;
                    }
                    throw ErrorBundle.getDefault(10019, lex.get().toString());
                }
                case 115310: {
                    this.pop();
                    this.pop();
                    String s = this.pop().toString();
                    this.setGoto(DbSqlNonterminal.EXPR, new SqlFunction(s, new SqlExpression[0]));
                    break;
                }
                case 115320: {
                    if (lex.eqchar(')')) {
                        this.shift(115420);
                        break;
                    }
                    throw ErrorBundle.getDefault(10019, lex.get().toString());
                }
                case 115400: {
                    this.pop();
                    List l = (List)this.pop();
                    this.pop();
                    String s = this.pop().toString();
                    this.setGoto(DbSqlNonterminal.EXPR, new SqlFunction(s, l));
                    break;
                }
                case 115420: {
                    this.pop();
                    this.pop();
                    this.pop();
                    String s = this.pop().toString();
                    List l = Collections.singletonList(SqlExpressions.ANY);
                    this.setGoto(DbSqlNonterminal.EXPR, new SqlFunction(s, l));
                    break;
                }
                case 116100: {
                    if (this.gt == DbSqlNonterminal.EXPR) {
                        this.goTo(116200);
                        break;
                    }
                    if (lex.eqchar('(')) {
                        this.shift(101100);
                        break;
                    }
                    if (lex.eqchar('+')) {
                        this.shift(102100);
                        break;
                    }
                    if (lex.eqchar('-')) {
                        this.shift(103100);
                        break;
                    }
                    if (lex.eqsym("NOT")) {
                        this.shift(104100);
                        break;
                    }
                    if (lex.eqsym("EXISTS")) {
                        this.shift(119100);
                        break;
                    }
                    String s = lex.getsym();
                    if (s != null) {
                        this.shift(115100, s);
                        break;
                    }
                    s = lex.getstr();
                    if (s != null) {
                        this.shift(300100, s);
                        break;
                    }
                    Rational n = lex.getnum();
                    if (n != null) {
                        this.shift(300200, n);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(300300);
                        break;
                    }
                    if (lex.eqchar('?')) {
                        this.shift(300400);
                        break;
                    }
                    throw ErrorBundle.getDefault(10019, lex.get().toString());
                }
                case 116200: {
                    if (lex.eqchar('+')) {
                        this.shift(105200);
                        break;
                    }
                    if (lex.eqchar('-')) {
                        this.shift(106200);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(107200);
                        break;
                    }
                    if (lex.eqchar('/')) {
                        this.shift(108200);
                        break;
                    }
                    if (lex.eq((Object)DbSqlReserved.CONCAT)) {
                        this.shift(109200);
                        break;
                    }
                    SqlBinaryOperator r = lex.getrelop();
                    if (r != null) {
                        this.shift(110200, (Object)r);
                        break;
                    }
                    if (lex.eqsym("AND")) {
                        this.shift(116300);
                        break;
                    }
                    if (lex.eqsym("IS")) {
                        this.shift(118100);
                        break;
                    }
                    throw ErrorBundle.getDefault(10019, lex.get().toString());
                }
                case 116300: {
                    if (this.gt == DbSqlNonterminal.EXPR) {
                        this.goTo(116400);
                        break;
                    }
                    if (lex.eqchar('(')) {
                        this.shift(101100);
                        break;
                    }
                    if (lex.eqchar('+')) {
                        this.shift(102100);
                        break;
                    }
                    if (lex.eqchar('-')) {
                        this.shift(103100);
                        break;
                    }
                    if (lex.eqsym("NOT")) {
                        this.shift(104100);
                        break;
                    }
                    if (lex.eqsym("EXISTS")) {
                        this.shift(119100);
                        break;
                    }
                    String s = lex.getsym();
                    if (s != null) {
                        this.shift(115100, s);
                        break;
                    }
                    s = lex.getstr();
                    if (s != null) {
                        this.shift(300100, s);
                        break;
                    }
                    Rational n = lex.getnum();
                    if (n != null) {
                        this.shift(300200, n);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(300300);
                        break;
                    }
                    if (lex.eqchar('?')) {
                        this.shift(300400);
                        break;
                    }
                    throw ErrorBundle.getDefault(10019, lex.get().toString());
                }
                case 116400: {
                    if (lex.eqchar('+')) {
                        this.shift(105200);
                        break;
                    }
                    if (lex.eqchar('-')) {
                        this.shift(106200);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(107200);
                        break;
                    }
                    if (lex.eqchar('/')) {
                        this.shift(108200);
                        break;
                    }
                    if (lex.eq((Object)DbSqlReserved.CONCAT)) {
                        this.shift(109200);
                        break;
                    }
                    SqlBinaryOperator r = lex.getrelop();
                    if (r != null) {
                        this.shift(110200, (Object)r);
                        break;
                    }
                    if (lex.eqsym("IN")) {
                        this.shift(114200);
                        break;
                    }
                    if (lex.eqsym("BETWEEN")) {
                        this.shift(116100);
                        break;
                    }
                    if (lex.eqsym("IS")) {
                        this.shift(118100);
                        break;
                    }
                    SqlExpression z = (SqlExpression)this.pop();
                    this.pop();
                    SqlExpression y = (SqlExpression)this.pop();
                    this.pop();
                    SqlExpression x = (SqlExpression)this.pop();
                    x = new SqlTernaryOperation(SqlTernaryOperator.BETWEEN, x, y, z);
                    this.setGoto(DbSqlNonterminal.EXPR, x);
                    break;
                }
                case 118100: {
                    if (lex.eqsym("NULL")) {
                        this.shift(118200);
                        break;
                    }
                    if (lex.eqsym("NOT")) {
                        this.shift(118210);
                        break;
                    }
                    throw ErrorBundle.getDefault(10019, lex.get().toString());
                }
                case 118200: {
                    this.pop();
                    this.pop();
                    SqlExpression x = (SqlExpression)this.pop();
                    x = new SqlUnaryOperation(SqlUnaryOperator.IS_NULL, x);
                    this.setGoto(DbSqlNonterminal.EXPR, x);
                    break;
                }
                case 118210: {
                    if (lex.eqsym("NULL")) {
                        this.shift(118310);
                        break;
                    }
                    throw ErrorBundle.getDefault(10019, lex.get().toString());
                }
                case 118310: {
                    this.pop();
                    this.pop();
                    this.pop();
                    SqlExpression x = (SqlExpression)this.pop();
                    x = new SqlUnaryOperation(SqlUnaryOperator.IS_NOT_NULL, x);
                    this.setGoto(DbSqlNonterminal.EXPR, x);
                    break;
                }
                case 119100: {
                    if (lex.eqchar('(')) {
                        this.shift(119200);
                        break;
                    }
                    throw ErrorBundle.getDefault(10019, lex.get().toString());
                }
                case 119200: {
                    lex.eatsym("SELECT");
                    this.shift(119300, new DbSqlParser()._select(lex));
                    break;
                }
                case 119300: {
                    if (lex.eqchar(')')) {
                        this.shift(119400);
                        break;
                    }
                    throw ErrorBundle.getDefault(10019, lex.get().toString());
                }
                case 119400: {
                    this.pop();
                    Object o = this.pop();
                    this.pop();
                    this.pop();
                    this.setGoto(DbSqlNonterminal.EXPR, new SqlExists((SqlSelect)o));
                    break;
                }
                case 200200: {
                    if (this.gt == DbSqlNonterminal.EXPR) {
                        this.goTo(200300);
                        break;
                    }
                    if (lex.eqchar('(')) {
                        this.shift(101100);
                        break;
                    }
                    if (lex.eqchar('+')) {
                        this.shift(102100);
                        break;
                    }
                    if (lex.eqchar('-')) {
                        this.shift(103100);
                        break;
                    }
                    if (lex.eqsym("NOT")) {
                        this.shift(104100);
                        break;
                    }
                    if (lex.eqsym("EXISTS")) {
                        this.shift(119100);
                        break;
                    }
                    String s = lex.getsym();
                    if (s != null) {
                        this.shift(115100, s);
                        break;
                    }
                    s = lex.getstr();
                    if (s != null) {
                        this.shift(300100, s);
                        break;
                    }
                    Rational n = lex.getnum();
                    if (n != null) {
                        this.shift(300200, n);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(300300);
                        break;
                    }
                    if (lex.eqchar('?')) {
                        this.shift(300400);
                        break;
                    }
                    throw ErrorBundle.getDefault(10019, lex.get().toString());
                }
                case 200300: {
                    if (lex.eqchar('+')) {
                        this.shift(105200);
                        break;
                    }
                    if (lex.eqchar('-')) {
                        this.shift(106200);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(107200);
                        break;
                    }
                    if (lex.eqchar('/')) {
                        this.shift(108200);
                        break;
                    }
                    if (lex.eq((Object)DbSqlReserved.CONCAT)) {
                        this.shift(109200);
                        break;
                    }
                    SqlBinaryOperator r = lex.getrelop();
                    if (r != null) {
                        this.shift(110200, (Object)r);
                        break;
                    }
                    if (lex.eqsym("AND")) {
                        this.shift(111200);
                        break;
                    }
                    if (lex.eqsym("OR")) {
                        this.shift(112200);
                        break;
                    }
                    if (lex.eqsym("IN")) {
                        this.shift(114200);
                        break;
                    }
                    if (lex.eqsym("BETWEEN")) {
                        this.shift(116100);
                        break;
                    }
                    if (lex.eqsym("IS")) {
                        this.shift(118100);
                        break;
                    }
                    SqlExpression x = (SqlExpression)this.pop();
                    this.pop();
                    List l = (List)this.pop();
                    l.add(x);
                    this.setGoto(DbSqlNonterminal.EXPR_LIST, l);
                    break;
                }
                case 201100: {
                    if (lex.eqchar('+')) {
                        this.shift(105200);
                        break;
                    }
                    if (lex.eqchar('-')) {
                        this.shift(106200);
                        break;
                    }
                    if (lex.eqchar('*')) {
                        this.shift(107200);
                        break;
                    }
                    if (lex.eqchar('/')) {
                        this.shift(108200);
                        break;
                    }
                    if (lex.eq((Object)DbSqlReserved.CONCAT)) {
                        this.shift(109200);
                        break;
                    }
                    SqlBinaryOperator r = lex.getrelop();
                    if (r != null) {
                        this.shift(110200, (Object)r);
                        break;
                    }
                    if (lex.eqsym("AND")) {
                        this.shift(111200);
                        break;
                    }
                    if (lex.eqsym("OR")) {
                        this.shift(112200);
                        break;
                    }
                    if (lex.eqsym("IN")) {
                        this.shift(114200);
                        break;
                    }
                    if (lex.eqsym("BETWEEN")) {
                        this.shift(116100);
                        break;
                    }
                    if (lex.eqsym("IS")) {
                        this.shift(118100);
                        break;
                    }
                    SqlExpression x = (SqlExpression)this.pop();
                    List l = new ArrayList<SqlExpression>();
                    l.add(x);
                    this.setGoto(DbSqlNonterminal.EXPR_LIST, l);
                    break;
                }
                case 300100: {
                    this.setGoto(DbSqlNonterminal.EXPR, new SqlString((String)this.pop()));
                    break;
                }
                case 300200: {
                    this.setGoto(DbSqlNonterminal.EXPR, new SqlNumeric((Rational)this.pop()));
                    break;
                }
                case 300300: {
                    this.pop();
                    this.setGoto(DbSqlNonterminal.EXPR, new SqlSymbol("*"));
                    break;
                }
                case 300400: {
                    this.pop();
                    this.setGoto(DbSqlNonterminal.EXPR, new SqlPlaceHolder(lex.nextPlaceNumber()));
                }
            }
        }
    }
}

