/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.sql;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.db.engine.SqlEngine;
import net.morilib.db.engine.SqlEngineFactory;
import net.morilib.db.fichier.FabriqueDeFichier;
import net.morilib.db.misc.Rational;
import net.morilib.db.misc.SqlResponse;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationCursor;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.schema.FileSqlSchema;
import net.morilib.db.schema.MemorySqlSchema;
import net.morilib.db.schema.SqlSchema;
import net.morilib.db.sqlcs.ddl.SqlColumnAttribute;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;
import net.morilib.db.sqlcs.ddl.SqlCreateTable;

public class RePlus {
    public static final String VERSION = "0.0.0";
    public static final int MAJOR_VERSION = 0;
    public static final int MINOR_VERSION = 0;
    private static final String PS1 = "rel>";
    private static final String PS2 = "%3d>";
    private static final String DESC_N = "NAME";
    private static final String DESC_T = "TYPE";
    private static final String DESC_A = "ATTRIBUTE";
    private static final Pattern PT1 = Pattern.compile("show\\p{Space}+tables;*", 2);
    private static final Pattern PT2 = Pattern.compile("d(esc(ribe)?)?\\p{Space}+([^\\p{Space};]+|\".*\");*", 2);

    private static boolean isquit(String s) {
        return s.equalsIgnoreCase("exit") || s.equalsIgnoreCase("quit");
    }

    private static Object exec(SqlSchema f, String t) throws IOException, SQLException {
        SqlEngine e = SqlEngineFactory.getInstance().getEngine();
        return e.execute(f, t);
    }

    private static void strrep(int x, char c) {
        int i = 0;
        while (i < x) {
            System.out.print(c);
            ++i;
        }
        System.out.print(' ');
    }

    private static int len(String s) {
        int r = 0;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            Character.UnicodeBlock b = Character.UnicodeBlock.of(c);
            r = b == null ? ++r : (b.equals(Character.UnicodeBlock.CJK_COMPATIBILITY) || b.equals(Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS) || b.equals(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS) || b.equals(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT) || b.equals(Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT) || b.equals(Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION) || b.equals(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS) || b.equals(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A) || b.equals(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B) || b.equals(Character.UnicodeBlock.KATAKANA) || b.equals(Character.UnicodeBlock.HIRAGANA) || b.equals(Character.UnicodeBlock.HANGUL_SYLLABLES) ? (r += 2) : ++r);
            ++i;
        }
        return r;
    }

    private static void lft(String s, int l) {
        int r = 0;
        int i = 0;
        while (i < s.length() && r < l) {
            char c = s.charAt(i);
            Character.UnicodeBlock b = Character.UnicodeBlock.of(c);
            r = b == null ? ++r : (b.equals(Character.UnicodeBlock.CJK_COMPATIBILITY) || b.equals(Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS) || b.equals(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS) || b.equals(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT) || b.equals(Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT) || b.equals(Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION) || b.equals(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS) || b.equals(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A) || b.equals(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B) || b.equals(Character.UnicodeBlock.KATAKANA) || b.equals(Character.UnicodeBlock.HIRAGANA) || b.equals(Character.UnicodeBlock.HANGUL_SYLLABLES) ? (r += 2) : ++r);
            System.out.print(c);
            ++i;
        }
        RePlus.strrep(l - r, ' ');
    }

    private static void _print(Object o) throws IOException, SQLException {
        ArrayList<RelationTuple> l = new ArrayList<RelationTuple>();
        if (o instanceof Relation) {
            int z;
            Object q;
            RelationTuple t;
            LinkedHashMap<String, Integer> m = new LinkedHashMap<String, Integer>();
            LinkedHashMap<String, Integer> r = new LinkedHashMap<String, Integer>();
            RelationCursor c = ((Relation)o).iterator();
            while (c.hasNext()) {
                t = c.next();
                for (String s : t.toMap().keySet()) {
                    q = t.get(s);
                    z = !(q instanceof Rational) ? 0 : (r.get(s) == null ? ((Rational)q).getScale() : Math.max((Integer)r.get(s), ((Rational)q).getScale()));
                    z = z < 4 ? z : 4;
                    r.put(s, z);
                }
            }
            c = ((Relation)o).iterator();
            while (c.hasNext()) {
                t = c.next();
                l.add(t);
                for (String s : t.toMap().keySet()) {
                    String v;
                    q = t.get(s);
                    if (q instanceof Rational) {
                        z = (Integer)r.get(s);
                        v = ((Rational)q).toBigDecimal(z).toString();
                    } else {
                        v = q.toString();
                    }
                    z = RePlus.len(v);
                    Integer n = (Integer)m.get(s);
                    if (n != null && z <= n) continue;
                    m.put(s, RePlus.len(v));
                }
            }
            for (String s : m.keySet()) {
                z = (Integer)m.get(s);
                RePlus.lft(s, z);
            }
            System.out.println();
            for (String s : m.keySet()) {
                z = (Integer)m.get(s);
                RePlus.strrep(z, '-');
            }
            System.out.println();
            for (RelationTuple p : l) {
                for (String s : m.keySet()) {
                    q = p.get(s);
                    if (q instanceof Rational) {
                        RePlus.lft(((Rational)q).toBigDecimal(4).toString(), (Integer)m.get(s));
                        continue;
                    }
                    RePlus.lft(q.toString(), (Integer)m.get(s));
                }
                System.out.println();
            }
            System.out.println();
        } else if (o instanceof Integer) {
            System.out.format("%d columns processed\n", ((Number)o).longValue());
        } else if (o instanceof SqlResponse) {
            System.out.println(((SqlResponse)o).toString());
        } else {
            System.out.println(o);
        }
    }

    private static void _showtables(Collection<String> c) {
        int m = -1;
        for (String s : c) {
            int n = m = s.length() > m ? s.length() : m;
        }
        System.out.println(DESC_N);
        RePlus.strrep(m, '-');
        System.out.println();
        for (String s : c) {
            System.out.println(s.toUpperCase());
        }
        System.out.println();
    }

    private static String attrtostr(EnumSet<SqlColumnAttribute> a) {
        StringBuffer b = new StringBuffer();
        String d = "";
        for (SqlColumnAttribute x : a) {
            b.append(d).append(x.toString());
            d = ",";
        }
        return b.toString();
    }

    static void _desc(SqlSchema f, String name) throws IOException, SQLException {
        SqlCreateTable c = f.getCreateTable(name);
        List<SqlColumnDefinition> l = c.getColumnDefinitions();
        int l1 = DESC_N.length();
        int l2 = DESC_T.length();
        int l3 = DESC_A.length();
        for (SqlColumnDefinition x : l) {
            int j = RePlus.len(x.getName().toUpperCase());
            l1 = j > l1 ? j : l1;
            j = RePlus.len(x.getType().toString());
            l2 = j > l2 ? j : l2;
            j = RePlus.len(RePlus.attrtostr(x.getAttributes()));
            int n = l3 = j > l3 ? j : l3;
        }
        RePlus.lft(DESC_N, l1);
        System.out.print(' ');
        RePlus.lft(DESC_T, l2);
        System.out.print(' ');
        RePlus.lft(DESC_A, l3);
        System.out.println();
        RePlus.strrep(l1, '-');
        System.out.print(' ');
        RePlus.strrep(l2, '-');
        System.out.print(' ');
        RePlus.strrep(l3, '-');
        System.out.println();
        for (SqlColumnDefinition x : l) {
            RePlus.lft(x.getName().toUpperCase(), l1);
            System.out.print(' ');
            RePlus.lft(x.getType().toString(), l2);
            System.out.print(' ');
            RePlus.lft(RePlus.attrtostr(x.getAttributes()), l3);
            System.out.println();
        }
        System.out.println();
    }

    public static void main(String[] args) {
        StringBuffer b = new StringBuffer();
        if (args.length <= 0) {
            System.err.println("Database localtion must be required");
            System.exit(86);
            return;
        }
        File f = new File(args[0]);
        try {
            String s;
            SqlSchema fs;
            if (f.isFile()) {
                fs = MemorySqlSchema.readCSVs(args);
            } else if (f.isDirectory()) {
                fs = new FileSqlSchema(FabriqueDeFichier.getDefault(), FabriqueDeFichier.getDefault().newInstance(f));
            } else {
                System.err.println("Database localtion is invalid");
                System.exit(86);
                return;
            }
            BufferedReader rd = new BufferedReader(new InputStreamReader(System.in));
            System.out.print(PS1);
            int l = 1;
            while ((s = rd.readLine()) != null) {
                try {
                    Matcher m;
                    if (b.length() == 0 && RePlus.isquit(s)) {
                        System.exit(0);
                        continue;
                    }
                    if (b.length() == 0 && PT1.matcher(s).matches()) {
                        RePlus._showtables(fs.getTableNames());
                        b = new StringBuffer();
                        l = 1;
                        System.out.print(PS1);
                        continue;
                    }
                    if (b.length() == 0 && (m = PT2.matcher(s)).matches()) {
                        s = m.group(3);
                        s = s.replaceFirst("^\"", "");
                        s = s.replaceFirst("\"$", "");
                        RePlus._desc(fs, s);
                        b = new StringBuffer();
                        l = 1;
                        System.out.print(PS1);
                        continue;
                    }
                    if (s.length() == 0) {
                        b = new StringBuffer();
                        l = 1;
                        System.out.print(PS1);
                        continue;
                    }
                    if (!s.endsWith(";")) {
                        b.append(s).append('\n');
                        System.out.format(PS2, ++l);
                        continue;
                    }
                    b.append(s).deleteCharAt(b.length() - 1);
                    Object o = RePlus.exec(fs, b.toString());
                    RePlus._print(o);
                    b = new StringBuffer();
                    l = 1;
                    System.out.print(PS1);
                }
                catch (SQLException e) {
                    System.err.format("ERROR REL-%d: %s\n", e.getErrorCode(), e.getMessage());
                    b = new StringBuffer();
                    l = 1;
                    System.out.print(PS1);
                }
            }
            System.exit(0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

