/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.functions;

import java.sql.SQLException;
import java.util.List;

import net.morilib.db.relations.RelationAggregate;
import net.morilib.db.relations.RelationExpression;
import net.morilib.db.relations.RelationFunction;

public class FnCoalesce extends RelationFunction {

	@Override
	public boolean isAggregate() {
		return false;
	}

	@Override
	public Object operate(RelationAggregate m, List<Object> group,
			Object... args) throws SQLException {
		for(Object o : args) {
			if(!RelationExpression.isNull(o)) {
				return o;
			}
		}
		return RelationExpression.NULL;
	}

	@Override
	public Object init(RelationAggregate m) throws SQLException {
		throw new RuntimeException();
	}

	@Override
	public FunctionType getType() {
		return FunctionType.STRING;
	}

}
