/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.engine;

import java.io.IOException;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import net.morilib.db.expr.RelationExpression;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.schema.SqlSchema;
import net.morilib.db.sql.DbSqlLexer;
import net.morilib.db.sql.DbSqlParser;
import net.morilib.db.sqlcs.ddl.SqlAlterTableAdd;
import net.morilib.db.sqlcs.ddl.SqlAlterTableDrop;
import net.morilib.db.sqlcs.ddl.SqlAlterTableModify;
import net.morilib.db.sqlcs.ddl.SqlAlterTableRenameColumn;
import net.morilib.db.sqlcs.ddl.SqlCreateTable;
import net.morilib.db.sqlcs.ddl.SqlDropTable;
import net.morilib.db.sqlcs.ddl.SqlTruncateTable;
import net.morilib.db.sqlcs.dml.SqlDelete;
import net.morilib.db.sqlcs.dml.SqlExpression;
import net.morilib.db.sqlcs.dml.SqlInsertSelect;
import net.morilib.db.sqlcs.dml.SqlInsertValues;
import net.morilib.db.sqlcs.dml.SqlRelation;
import net.morilib.db.sqlcs.dml.SqlSelect;
import net.morilib.db.sqlcs.dml.SqlSetExpression;
import net.morilib.db.sqlcs.dml.SqlUpdate;
import net.morilib.db.sqlcs.dml.SqlWith;

public abstract class SqlEngine {
    public abstract Relation visit(SqlSchema var1, SqlRelation var2, List<Object> var3) throws IOException, SQLException;

    public abstract Relation visit(SqlSchema var1, SqlSelect var2, RelationTuple var3, List<Object> var4) throws IOException, SQLException;

    public abstract RelationExpression visit(SqlExpression var1, List<Object> var2) throws SQLException;

    public abstract int visit(SqlSchema var1, SqlInsertValues var2, List<Object> var3) throws IOException, SQLException;

    public abstract int visit(SqlSchema var1, SqlInsertSelect var2, List<Object> var3) throws IOException, SQLException;

    public abstract int visit(SqlSchema var1, SqlUpdate var2, List<Object> var3) throws IOException, SQLException;

    public abstract int visit(SqlSchema var1, SqlDelete var2, List<Object> var3) throws IOException, SQLException;

    public abstract Relation visit(SqlSchema var1, SqlSetExpression var2, List<Object> var3) throws IOException, SQLException;

    public abstract Object visit(SqlSchema var1, SqlCreateTable var2) throws IOException, SQLException;

    public abstract Object visit(SqlSchema var1, SqlDropTable var2) throws IOException, SQLException;

    public abstract Object visit(SqlSchema var1, SqlTruncateTable var2) throws IOException, SQLException;

    public abstract Object visit(SqlSchema var1, SqlAlterTableAdd var2) throws IOException, SQLException;

    public abstract Object visit(SqlSchema var1, SqlAlterTableModify var2) throws IOException, SQLException;

    public abstract Object visit(SqlSchema var1, SqlAlterTableDrop var2) throws IOException, SQLException;

    public abstract Object visit(SqlSchema var1, SqlAlterTableRenameColumn var2) throws IOException, SQLException;

    public abstract Object visit(SqlSchema var1, SqlWith var2) throws IOException, SQLException;

    public Object visit(SqlSchema f, Object o, List<Object> h) throws IOException, SQLException {
        if (o instanceof SqlSetExpression) {
            return this.visit(f, (SqlSetExpression)o, h);
        }
        if (o instanceof SqlInsertValues) {
            return this.visit(f, (SqlInsertValues)o, h);
        }
        if (o instanceof SqlInsertSelect) {
            return this.visit(f, (SqlInsertSelect)o, h);
        }
        if (o instanceof SqlUpdate) {
            return this.visit(f, (SqlUpdate)o, h);
        }
        if (o instanceof SqlDelete) {
            return this.visit(f, (SqlDelete)o, h);
        }
        if (o instanceof SqlCreateTable) {
            return this.visit(f, (SqlCreateTable)o);
        }
        if (o instanceof SqlDropTable) {
            return this.visit(f, (SqlDropTable)o);
        }
        if (o instanceof SqlTruncateTable) {
            return this.visit(f, (SqlTruncateTable)o);
        }
        if (o instanceof SqlAlterTableAdd) {
            return this.visit(f, (SqlAlterTableAdd)o);
        }
        if (o instanceof SqlAlterTableModify) {
            return this.visit(f, (SqlAlterTableModify)o);
        }
        if (o instanceof SqlAlterTableDrop) {
            return this.visit(f, (SqlAlterTableDrop)o);
        }
        if (o instanceof SqlAlterTableRenameColumn) {
            return this.visit(f, (SqlAlterTableRenameColumn)o);
        }
        if (o instanceof SqlWith) {
            return this.visit(f, (SqlWith)o);
        }
        throw ErrorBundle.getDefault(10039, new Object[0]);
    }

    public Object execute(SqlSchema f, String t, List<Object> h) throws IOException, SQLException {
        DbSqlLexer l = new DbSqlLexer(new StringReader(t));
        return this.visit(f, new DbSqlParser().parse(l), Collections.<Object>emptyList());
    }

    public Object execute(SqlSchema f, String t) throws IOException, SQLException {
        return this.execute(f, t, Collections.<Object>emptyList());
    }
}

