/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.jdbc;

import java.io.IOException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import net.morilib.db.engine.SqlEngine;
import net.morilib.db.jdbc.RelationsDatabaseMetadata;
import net.morilib.db.jdbc.RelationsJDBCUtils;
import net.morilib.db.jdbc.RelationsPreparedStatement;
import net.morilib.db.jdbc.RelationsStatement;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.schema.SqlSchema;
import net.morilib.db.sql.DbSqlParser;

public class RelationsConnection
implements Connection {
    private static Logger logger = RelationsJDBCUtils.logger;
    SqlEngine engine;
    SqlSchema schema;
    String url;

    RelationsConnection(String l, SqlEngine e, SqlSchema s) {
        this.engine = e;
        this.schema = s;
        this.url = l;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        logger.finer("unwrap");
        throw new SQLException("not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        logger.finer("isWrapperFor");
        return false;
    }

    @Override
    public void abort(Executor e) throws SQLException {
        logger.finer("abort");
    }

    @Override
    public void clearWarnings() throws SQLException {
        logger.finer("clearWarnings");
    }

    private void checkclose() throws SQLException {
        logger.finer("checkclose");
        if (this.schema == null) {
            throw ErrorBundle.getDefault(20002, new Object[0]);
        }
    }

    @Override
    public void close() throws SQLException {
        logger.finer("close");
        this.checkclose();
        this.schema = null;
        this.engine = null;
    }

    @Override
    public void commit() throws SQLException {
        logger.finer("commit");
        this.checkclose();
    }

    @Override
    public Array createArrayOf(String s, Object[] a) throws SQLException {
        logger.finer("createArrayOf");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        logger.finer("createBlob");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        logger.finer("createClob");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        logger.finer("createNClob");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        logger.finer("createSQLXML");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Statement createStatement() throws SQLException {
        logger.finer("createStatement");
        return new RelationsStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        logger.finer("createStatement");
        logger.finer("resultSetType:" + resultSetType);
        logger.finer("resultSetConcurrency:" + resultSetConcurrency);
        return this.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        logger.finer("createStatement");
        logger.finer("resultSetType:" + resultSetType);
        logger.finer("resultSetConcurrency:" + resultSetConcurrency);
        logger.finer("resultSetHoldability:" + resultSetHoldability);
        return this.createStatement();
    }

    @Override
    public Struct createStruct(String arg0, Object[] arg1) throws SQLException {
        logger.finer("createStruct");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        logger.finer("getAutoCommit");
        return true;
    }

    @Override
    public String getCatalog() throws SQLException {
        logger.finer("getCatalog");
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        logger.finer("getClientInfo");
        return null;
    }

    @Override
    public String getClientInfo(String arg0) throws SQLException {
        logger.finer("getClientInfo");
        return null;
    }

    @Override
    public int getHoldability() throws SQLException {
        logger.finer("getHoldability");
        return 1;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        logger.finer("getMetaData");
        return new RelationsDatabaseMetadata(this);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        logger.finer("getTransactionIsolation");
        return 0;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        logger.finer("getTypeMap");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        logger.finer("getWarnings");
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        logger.finer("isClosed");
        return this.schema == null;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        logger.finer("isReadOnly");
        this.checkclose();
        return this.schema.isReadonly().isTrue();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        logger.finer("isValid");
        return false;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        logger.finer("nativeSQL");
        return sql;
    }

    @Override
    public CallableStatement prepareCall(String s) throws SQLException {
        logger.finer("prepareCall");
        throw new SQLException("prepared statement is not supported");
    }

    @Override
    public CallableStatement prepareCall(String s, int a, int v) throws SQLException {
        logger.finer("prepareCall");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String s, int a, int b, int v) throws SQLException {
        logger.finer("prepareCall");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String s) throws SQLException {
        logger.finer("prepareStatement");
        logger.finer("query:" + s);
        try {
            return new RelationsPreparedStatement(this, DbSqlParser.parse(s));
        }
        catch (IOException e) {
            throw ErrorBundle.getIODefault(e, new Object[0]);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String s, int resultSetType) throws SQLException {
        logger.finer("prepareStatement");
        logger.finer("query:" + s);
        logger.finer("resultSetType:" + resultSetType);
        return this.prepareStatement(s);
    }

    @Override
    public PreparedStatement prepareStatement(String s, int[] columnIndexes) throws SQLException {
        logger.finer("prepareStatement");
        logger.finer("query:" + s);
        logger.finer("columnIndexes:" + Arrays.toString(columnIndexes));
        return this.prepareStatement(s);
    }

    @Override
    public PreparedStatement prepareStatement(String s, String[] columnNames) throws SQLException {
        logger.finer("prepareStatement");
        logger.finer("query:" + s);
        logger.finer("columnNames:" + Arrays.toString(columnNames));
        return this.prepareStatement(s);
    }

    @Override
    public PreparedStatement prepareStatement(String s, int resultSetType, int resultSetConcurrency) throws SQLException {
        logger.finer("prepareStatement");
        logger.finer("query:" + s);
        logger.finer("resultSetType:" + resultSetType);
        logger.finer("resultSetConcurrency:" + resultSetConcurrency);
        return this.prepareStatement(s);
    }

    @Override
    public PreparedStatement prepareStatement(String s, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        logger.finer("prepareStatement");
        logger.finer("query:" + s);
        logger.finer("resultSetType:" + resultSetType);
        logger.finer("resultSetConcurrency:" + resultSetConcurrency);
        logger.finer("resultSetHoldability:" + resultSetHoldability);
        return this.prepareStatement(s);
    }

    @Override
    public void releaseSavepoint(Savepoint s) throws SQLException {
        logger.finer("releaseSavepoint");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback() throws SQLException {
        logger.finer("rollback");
    }

    @Override
    public void rollback(Savepoint s) throws SQLException {
        logger.finer("rollback");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAutoCommit(boolean b) throws SQLException {
        logger.finer("setAutoCommit");
    }

    @Override
    public void setCatalog(String c) throws SQLException {
        logger.finer("setCatalog");
    }

    @Override
    public void setClientInfo(Properties p) throws SQLClientInfoException {
        logger.finer("setClientInfo");
    }

    @Override
    public void setClientInfo(String k, String v) throws SQLClientInfoException {
        logger.finer("setClientInfo");
    }

    @Override
    public void setHoldability(int h) throws SQLException {
        logger.finer("setHoldability");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNetworkTimeout(Executor e, int a) throws SQLException {
        logger.finer("setNetworkTimeout");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setReadOnly(boolean arg0) throws SQLException {
        logger.finer("setReadOnly");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        logger.finer("setSavepoint");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String s) throws SQLException {
        logger.finer("setSavepoint");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        logger.finer("setTransactionIsolation");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        logger.finer("setTypeMap");
        throw new SQLFeatureNotSupportedException();
    }
}

