/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.misc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.morilib.parser.html.HTMLHandler;
import net.morilib.parser.html.HTMLParser;

public class XmlTags {
    public static void removeTag(InputStream in, OutputStream os, String tag, String id, String val) throws IOException, SQLException {
        BufferedReader b = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        PrintWriter w = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, "UTF-8")));
        RemTag h = new RemTag(w, tag, id, val);
        HTMLParser.parse((HTMLHandler)h, b);
        w.flush();
    }

    private static class RemTag
    implements HTMLHandler {
        String tag;
        String idname;
        String idval;
        private Map<String, String> tagw;
        private PrintWriter wr;
        private boolean tagr = true;

        RemTag(PrintWriter w, String t, String n, String v) {
            this.wr = w;
            this.tag = t;
            this.idname = n;
            this.idval = v;
        }

        private void puttagw() {
            if (this.tagw != null) {
                boolean bl = this.tagr = !this.tag.equals(this.tagw.get("")) || !this.idval.equals(this.tagw.get(this.idname));
            }
            if (this.tagw != null && this.tagr) {
                this.wr.format("<%s", this.tagw.remove(""));
                for (String s : this.tagw.keySet()) {
                    this.wr.format(" %s=\"%s\"", s, this.tagw.get(s));
                }
                this.wr.println('>');
            }
            this.tagw = null;
        }

        @Override
        public void string(String s) throws SQLException {
            this.puttagw();
            if (this.tagr) {
                this.wr.print(HTMLParser.escape(s));
            }
        }

        @Override
        public void startTag(String s) throws SQLException {
            this.puttagw();
            this.tagw = new HashMap<String, String>();
            this.tagw.put("", s);
        }

        @Override
        public void endTag(String s) throws SQLException {
            this.puttagw();
            if (this.tagr) {
                this.wr.format("</%s>", HTMLParser.escape(s));
            } else {
                this.tagr = this.tagr || s.equals(this.tag);
            }
        }

        @Override
        public void tagAttribute(String k, String v) throws SQLException {
            this.tagw.put(k, v);
        }

        @Override
        public void meta(String s) throws SQLException {
            this.wr.println(s);
        }

        @Override
        public void comment(String s) throws SQLException {
            this.wr.format("<!--%s-->", s);
        }
    }
}

