/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.relations;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.morilib.db.delay.DefaultDelay;
import net.morilib.db.delay.Delay;
import net.morilib.db.engine.SqlEngine;
import net.morilib.db.expr.RelationExpression;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.relations.AbstractRelation;
import net.morilib.db.relations.DefaultRelationTuple;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationAggregate;
import net.morilib.db.relations.RelationCursor;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.schema.SqlSchema;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;

public class OperatedRelation
extends AbstractRelation {
    private Relation wrap;
    private SqlEngine visit;
    private SqlSchema fs;
    private List<RelationExpression> exprs;
    private List<RelationAggregate> map;
    private List<String> ases;
    private List<String> group;

    public OperatedRelation(Relation w, SqlEngine v, SqlSchema f, List<RelationExpression> e, List<String> a, List<String> g, List<Object> h) throws SQLException {
        this.wrap = w;
        this.visit = v;
        this.fs = f;
        this.exprs = new ArrayList<RelationExpression>(e);
        this.ases = new ArrayList<String>();
        int i = 0;
        while (i < a.size()) {
            String s = a.get(i);
            s = s != null ? s : String.valueOf(i);
            this.ases.add(s);
            ++i;
        }
        if (g != null) {
            this.group = new ArrayList<String>(g);
            this.map = new ArrayList<RelationAggregate>();
            i = 0;
            while (i < this.exprs.size()) {
                this.map.add(new RelationAggregate());
                ++i;
            }
        }
    }

    public List<RelationAggregate> getMap() {
        return Collections.unmodifiableList(this.map);
    }

    @Override
    public RelationCursor iterator() {
        final RelationCursor itr = this.wrap.iterator();
        return new RelationCursor(){

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public RelationTuple next() throws IOException, SQLException {
                final Object[] a = new Object[OperatedRelation.this.exprs.size()];
                ArrayList<Object> l = new ArrayList<Object>();
                RelationTuple t = itr.next();
                if (OperatedRelation.this.group != null) {
                    for (String s : OperatedRelation.this.group) {
                        l.add(t.get(s));
                    }
                }
                int i = 0;
                while (i < OperatedRelation.this.exprs.size()) {
                    if (OperatedRelation.this.group != null) {
                        Object o;
                        boolean b = ((RelationAggregate)OperatedRelation.this.map.get(i)).containsKey(l);
                        if (!b && (o = ((RelationExpression)OperatedRelation.this.exprs.get(i)).init(OperatedRelation.this.visit, OperatedRelation.this.fs)) instanceof Delay) {
                            ((RelationAggregate)OperatedRelation.this.map.get(i)).put(l, (Delay)o);
                        }
                        a[i] = ((RelationExpression)OperatedRelation.this.exprs.get(i)).eval(OperatedRelation.this.visit, OperatedRelation.this.fs, t, (RelationAggregate)OperatedRelation.this.map.get(i), OperatedRelation.this.group, l);
                        if (!(a[i] instanceof Delay)) {
                            ((RelationAggregate)OperatedRelation.this.map.get(i)).put(l, new DefaultDelay(a[i]));
                        }
                    } else {
                        a[i] = ((RelationExpression)OperatedRelation.this.exprs.get(i)).eval(OperatedRelation.this.visit, OperatedRelation.this.fs, t, null, null, l);
                    }
                    ++i;
                }
                return new RelationTuple(){

                    @Override
                    public Object get(String name) throws SQLException {
                        int c = OperatedRelation.this.ases.indexOf(name);
                        if (c < 0) {
                            throw ErrorBundle.getDefault(10009, name);
                        }
                        return a[c];
                    }

                    @Override
                    public RelationTuple copy() {
                        return new DefaultRelationTuple(this.toMap());
                    }

                    @Override
                    public Map<String, Object> toMap() {
                        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
                        int i = 0;
                        while (i < OperatedRelation.this.exprs.size()) {
                            m.put((String)OperatedRelation.this.ases.get(i), a[i]);
                            ++i;
                        }
                        return m;
                    }
                };
            }
        };
    }

    @Override
    public List<SqlColumnDefinition> getColumnNames() {
        ArrayList<SqlColumnDefinition> l = new ArrayList<SqlColumnDefinition>();
        for (String s : this.ases) {
            SqlColumnDefinition d = this.getDefinition(s);
            l.add(new SqlColumnDefinition(s, d.getType(), d.getAttributes()));
        }
        return l;
    }

    @Override
    public SqlColumnDefinition getDefinition(String name) {
        int i = 0;
        while (i < this.ases.size()) {
            if (this.ases.get(i).equals(name)) {
                return this.wrap.getDefinition(this.wrap.getColumnNames().get(i).getName());
            }
            ++i;
        }
        return null;
    }
}

