/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.relations;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.relations.AbstractRelation;
import net.morilib.db.relations.DefaultRelationTuple;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationCursor;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.relations.Relations;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;

public class VirtualCrossJoinRelation
extends AbstractRelation {
    private Relation rela;
    private Relation relb;
    private transient List<SqlColumnDefinition> cols = null;

    public VirtualCrossJoinRelation(Relation a, Relation b) {
        this.rela = a;
        this.relb = b;
    }

    @Override
    public RelationCursor iterator() {
        return new RelationCursor(){
            private RelationCursor xi;
            private RelationCursor xj;
            private RelationTuple xv;
            private RelationTuple xw;
            {
                this.xi = VirtualCrossJoinRelation.this.rela.iterator();
                this.xj = VirtualCrossJoinRelation.this.relb.iterator();
                this.xv = null;
            }

            @Override
            public boolean hasNext() {
                return this.xi.hasNext() || this.xj.hasNext();
            }

            @Override
            public RelationTuple next() throws IOException, SQLException {
                if (this.xv == null) {
                    this.xv = this.xi.next();
                }
                if (!this.xj.hasNext()) {
                    if (this.xi.hasNext()) {
                        this.xv = this.xi.next();
                        this.xj = VirtualCrossJoinRelation.this.relb.iterator();
                    } else {
                        throw new NoSuchElementException();
                    }
                }
                this.xw = this.xj.next();
                if (!this.xj.hasNext()) {
                    this.fireScaned(this.xv);
                }
                return new RelationTuple(){

                    @Override
                    public Object get(String name) throws SQLException {
                        ArrayList<String> l = new ArrayList<String>();
                        for (SqlColumnDefinition d : VirtualCrossJoinRelation.this.getColumnNames()) {
                            l.add(d.getName());
                        }
                        if (!l.contains(name)) {
                            throw ErrorBundle.getDefault(10009, name);
                        }
                        Object o = Relations._get(xv, VirtualCrossJoinRelation.this.rela, name);
                        if (o != null) {
                            return o;
                        }
                        o = Relations._get(xw, VirtualCrossJoinRelation.this.relb, name);
                        if (o != null) {
                            return o;
                        }
                        throw ErrorBundle.getDefault(10009, name);
                    }

                    @Override
                    public RelationTuple copy() throws SQLException {
                        return new DefaultRelationTuple(this.toMap());
                    }

                    @Override
                    public Map<String, Object> toMap() throws SQLException {
                        List<SqlColumnDefinition> ases = VirtualCrossJoinRelation.this.getColumnNames();
                        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
                        int i = 0;
                        while (i < ases.size()) {
                            m.put(ases.get(i).getName(), this.get(ases.get(i).getName()));
                            ++i;
                        }
                        return m;
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SqlColumnDefinition> getColumnNames() {
        VirtualCrossJoinRelation virtualCrossJoinRelation = this;
        synchronized (virtualCrossJoinRelation) {
            if (this.cols == null) {
                this.cols = new ArrayList<SqlColumnDefinition>();
                Relations._add(this.cols, this.rela);
                Relations._add(this.cols, this.relb);
            }
        }
        return this.cols;
    }

    @Override
    public SqlColumnDefinition getDefinition(String name) {
        SqlColumnDefinition d = this.rela.getDefinition(name);
        if (d != null) {
            return d;
        }
        d = this.relb.getDefinition(name);
        if (d != null) {
            return d;
        }
        return null;
    }
}

