/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.schema;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import net.morilib.db.fichier.FabriqueDeFichier;
import net.morilib.db.map.CSVDataMapper;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.NullBoolean;
import net.morilib.db.relations.DefaultRelationTuple;
import net.morilib.db.relations.NamedRelation;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.relations.SingleTableRelation;
import net.morilib.db.relations.TableRenameRelation;
import net.morilib.db.schema.SqlSchema;
import net.morilib.db.schema.SqlSchemata;
import net.morilib.db.sqlcs.ddl.SqlColumnAttribute;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;
import net.morilib.db.sqlcs.ddl.SqlCreateTable;
import net.morilib.db.sqlcs.ddl.SqlTypeVarchar;

public class MemorySqlSchema
implements SqlSchema {
    private Map<String, NamedRelation> relations;
    private Map<String, SqlCreateTable> ddls;
    private Map<String, Relation> rels;

    MemorySqlSchema() {
    }

    public static MemorySqlSchema readCSV(SqlCreateTable d, InputStream ins) throws IOException, SQLException {
        MemorySqlSchema m = new MemorySqlSchema();
        CSVDataMapper p = new CSVDataMapper();
        m.ddls = new HashMap<String, SqlCreateTable>();
        m.relations = new HashMap<String, NamedRelation>();
        BufferedReader b = new BufferedReader(new InputStreamReader(ins));
        b.readLine();
        SingleTableRelation r = p.read(d.getName(), null, d, b);
        m.ddls.put(d.getName(), d);
        m.relations.put(d.getName(), r);
        return m;
    }

    public static MemorySqlSchema readProperties(String tn, String kn, String vn, InputStream ins) throws IOException, SQLException {
        MemorySqlSchema m = new MemorySqlSchema();
        Properties p = new Properties();
        m.ddls = new HashMap<String, SqlCreateTable>();
        m.relations = new HashMap<String, NamedRelation>();
        ArrayList<SqlColumnDefinition> f = new ArrayList<SqlColumnDefinition>();
        f.add(new SqlColumnDefinition(kn, new SqlTypeVarchar(0), EnumSet.of(SqlColumnAttribute.PRIMARY_KEY)));
        f.add(new SqlColumnDefinition(vn, new SqlTypeVarchar(0), EnumSet.noneOf(SqlColumnAttribute.class)));
        SqlCreateTable d = new SqlCreateTable(tn, f);
        p.load(ins);
        ArrayList<RelationTuple> l = new ArrayList<RelationTuple>();
        LinkedHashMap<String, Object> n = new LinkedHashMap<String, Object>();
        for (Map.Entry<Object, Object> o : p.entrySet()) {
            n.put(kn, o.getKey().toString());
            n.put(vn, o.getValue().toString());
            l.add(new DefaultRelationTuple(n));
        }
        m.ddls.put(tn, d);
        m.relations.put(tn, new SingleTableRelation(d, tn, l));
        return m;
    }

    public static MemorySqlSchema readCSVs(String ... csvs) throws IOException, SQLException {
        MemorySqlSchema m = new MemorySqlSchema();
        CSVDataMapper p = new CSVDataMapper();
        m.ddls = new HashMap<String, SqlCreateTable>();
        m.relations = new HashMap<String, NamedRelation>();
        String[] stringArray = csvs;
        int n = csvs.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            SqlCreateTable d = SqlSchemata.guessTable(s);
            BufferedReader b = new BufferedReader(new InputStreamReader(new FileInputStream(s)));
            b.readLine();
            SingleTableRelation r = p.read(d.getName(), null, d, b);
            m.ddls.put(d.getName(), d);
            m.relations.put(d.getName(), r);
            ++n2;
        }
        return m;
    }

    @Override
    public NamedRelation readRelation(String name, String as) throws IOException, SQLException {
        String s = name.toUpperCase();
        if (this.rels != null && this.rels.containsKey(name.toUpperCase())) {
            return new TableRenameRelation(this.rels.get(name.toUpperCase()), (as != null ? as : name).toUpperCase());
        }
        if (!this.relations.containsKey(s)) {
            throw ErrorBundle.getDefault(10015, name);
        }
        if (as == null) {
            return this.relations.get(s);
        }
        return new TableRenameRelation(this.relations.get(s), as);
    }

    @Override
    public void writeRelation(String name, Collection<RelationTuple> z) throws IOException, SQLException {
        throw ErrorBundle.getDefault(10017, new Object[0]);
    }

    @Override
    public SqlCreateTable getCreateTable(String name) throws IOException, SQLException {
        String s = name.toUpperCase();
        if (!this.ddls.containsKey(s)) {
            throw ErrorBundle.getDefault(10015, name);
        }
        return this.ddls.get(s);
    }

    @Override
    public Collection<String> getTableNames() {
        return Collections.unmodifiableCollection(this.relations.keySet());
    }

    @Override
    public boolean isTable(String name) throws IOException, SQLException {
        return this.relations.containsKey(name);
    }

    @Override
    public void putCreateTable(String name, SqlCreateTable table) throws IOException, SQLException {
        throw ErrorBundle.getDefault(10017, new Object[0]);
    }

    @Override
    public void alterCreateTable(String name, SqlCreateTable table) throws IOException, SQLException {
        throw ErrorBundle.getDefault(10017, new Object[0]);
    }

    @Override
    public void truncateTable(String name) throws IOException, SQLException {
        throw ErrorBundle.getDefault(10017, new Object[0]);
    }

    @Override
    public void removeCreateTable(String name) throws IOException, SQLException {
        throw ErrorBundle.getDefault(10017, new Object[0]);
    }

    @Override
    public SqlSchema fork() {
        return this;
    }

    @Override
    public NullBoolean isReadonly() {
        return NullBoolean.TRUE;
    }

    @Override
    public NullBoolean usesLocalFiles() {
        return NullBoolean.FALSE;
    }

    @Override
    public NullBoolean usesLocalFilePerTable() {
        return NullBoolean.FALSE;
    }

    @Override
    public FabriqueDeFichier fabrique() {
        return FabriqueDeFichier.getDefault();
    }

    @Override
    public void bindSchema(String name, Relation r) {
        this.rels.put(name, r);
    }
}

