/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.schema;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.parser.html.HTMLHandler;

class XlsxTables
implements HTMLHandler {
    Map<String, Integer> map = new HashMap<String, Integer>();
    Map<Integer, String> inv = new HashMap<Integer, String>();
    private S stat = S.INIT;
    private String name;
    private int id;

    XlsxTables() {
    }

    String getSheet(String name) {
        return "sheet" + this.map.get(name) + ".xml";
    }

    @Override
    public void string(String s) throws SQLException {
    }

    @Override
    public void startTag(String s) throws SQLException {
        switch (this.stat) {
            case INIT: {
                if (!s.equals("workbook")) break;
                this.stat = S.WORKBOOK;
                break;
            }
            case WORKBOOK: {
                if (!s.equals("sheets")) break;
                this.stat = S.SHEETS;
                break;
            }
            case SHEETS: {
                if (!s.equals("sheet")) break;
                this.id = -1;
                this.stat = S.SHEET;
                break;
            }
        }
    }

    @Override
    public void endTag(String s) throws SQLException {
        switch (this.stat) {
            case INIT: {
                break;
            }
            case WORKBOOK: {
                if (!s.equals("workbook")) break;
                this.stat = S.INIT;
                break;
            }
            case SHEETS: {
                if (!s.equals("sheets")) break;
                this.stat = S.WORKBOOK;
                break;
            }
            case SHEET: {
                if (!s.equals("sheet")) break;
                if (this.id < 0) {
                    throw ErrorBundle.getDefault(10046, new Object[0]);
                }
                this.map.put(this.name, this.id);
                this.inv.put(this.id, this.name);
                this.stat = S.SHEETS;
            }
        }
    }

    @Override
    public void tagAttribute(String k, String v) throws SQLException {
        if (this.stat == S.SHEET) {
            if (k.equals("sheetId")) {
                try {
                    this.id = Integer.parseInt(v);
                }
                catch (NumberFormatException e) {
                    throw ErrorBundle.getDefault(10046, new Object[0]);
                }
            } else if (k.equals("name")) {
                this.name = v;
            }
        }
    }

    @Override
    public void meta(String s) throws SQLException {
    }

    @Override
    public void comment(String s) throws SQLException {
    }

    private static enum S {
        INIT,
        WORKBOOK,
        SHEETS,
        SHEET;

    }
}

