/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.parser.html;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Properties;
import net.morilib.parser.html.HTMLHandler;

public class HTMLParser {
    private static final BigInteger LIM = BigInteger.valueOf(65536L);
    private static Properties prop = new Properties();
    private static Properties inv;

    static {
        HTMLParser._load(prop, "/net/morilib/parser/html/entities.properties");
        inv = new Properties();
        HTMLParser._load(inv, "/net/morilib/parser/html/entitiesinv.properties");
    }

    public static String escape(String s) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            String t = inv.getProperty(String.valueOf((int)c));
            if (t != null) {
                b.append('&').append(t).append(';');
            } else {
                b.append(c);
            }
            ++i;
        }
        return b.toString();
    }

    private static void _load(Properties v, String s) {
        InputStream ins = null;
        try {
            try {
                ins = HTMLParser.class.getResourceAsStream(s);
                v.load(ins);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static void addent1(String s, boolean d, StringBuffer b) {
        String t = prop.getProperty(s);
        if (t != null) {
            b.append((char)Integer.parseInt(t));
        } else {
            b.append("&" + s);
            if (d) {
                b.append(';');
            }
        }
    }

    private static void addent2(String s, boolean d, StringBuffer b) {
        try {
            BigInteger c = new BigInteger(s);
            if (c.compareTo(LIM) < 0) {
                b.append((char)c.intValue());
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        b.append("&#" + s);
        if (d) {
            b.append(';');
        }
    }

    public static void parse(HTMLHandler h, Reader rd) throws SQLException, IOException {
        StringBuffer b1 = new StringBuffer();
        StringBuffer b2 = null;
        String k = null;
        String l = null;
        S stat = S.INIT;
        while (true) {
            int c = rd.read();
            switch (stat) {
                case INIT: {
                    if (c < 0) {
                        if (b1.length() > 0) {
                            h.string(b1.toString());
                        }
                        return;
                    }
                    if (c == 60) {
                        if (b1.length() > 0) {
                            h.string(b1.toString());
                        }
                        b1 = new StringBuffer();
                        stat = S.TAG1;
                        break;
                    }
                    if (c == 38) {
                        b2 = new StringBuffer();
                        stat = S.ENT1;
                        break;
                    }
                    b1.appendCodePoint(c);
                    break;
                }
                case TAG1: {
                    if (c < 0) {
                        return;
                    }
                    if (c == 47) {
                        stat = S.TGE1;
                        break;
                    }
                    if (c == 33) {
                        stat = S.CMT1;
                        break;
                    }
                    if (c == 62) {
                        h.startTag(b1.toString());
                        b1 = new StringBuffer();
                        stat = S.INIT;
                        break;
                    }
                    if (c == 63) {
                        b1 = new StringBuffer();
                        b1.append('<').append('?');
                        stat = S.MET1;
                        break;
                    }
                    if (c == 32 || c == 9 || c == 10 || c == 13) break;
                    b1.appendCodePoint(c);
                    stat = S.TAG2;
                    break;
                }
                case TAG2: {
                    if (c < 0) {
                        return;
                    }
                    if (c == 47) {
                        l = b1.toString();
                        h.startTag(l);
                        b1 = new StringBuffer();
                        stat = S.TAG7;
                        break;
                    }
                    if (c == 62) {
                        h.startTag(b1.toString());
                        b1 = new StringBuffer();
                        stat = S.INIT;
                        break;
                    }
                    if (c == 32 || c == 9 || c == 10) {
                        l = b1.toString();
                        h.startTag(l);
                        b1 = new StringBuffer();
                        stat = S.TAG3;
                        break;
                    }
                    if (c == 13) break;
                    b1.appendCodePoint(c);
                    break;
                }
                case TAG3: {
                    if (c < 0) {
                        return;
                    }
                    if (c == 61) {
                        k = b1.toString();
                        b1 = new StringBuffer();
                        stat = S.TAG4;
                        break;
                    }
                    if (c == 47) {
                        if (b1.length() > 0) {
                            h.tagAttribute(b1.toString(), "");
                        }
                        stat = S.TAG7;
                        break;
                    }
                    if (c == 62) {
                        if (b1.length() > 0) {
                            h.tagAttribute(b1.toString(), "");
                        }
                        b1 = new StringBuffer();
                        stat = S.INIT;
                        break;
                    }
                    if (c == 32 || c == 9 || c == 10 || c == 13) break;
                    b1.appendCodePoint(c);
                    break;
                }
                case TAG4: {
                    if (c < 0) {
                        return;
                    }
                    if (c == 39) {
                        stat = S.TAG5;
                        break;
                    }
                    if (c == 34) {
                        stat = S.TAG6;
                        break;
                    }
                    if (c == 47) {
                        h.tagAttribute(k, b1.toString());
                        stat = S.TAG7;
                        break;
                    }
                    if (c == 62) {
                        h.tagAttribute(k, b1.toString());
                        b1 = new StringBuffer();
                        stat = S.INIT;
                        break;
                    }
                    if (c == 32 || c == 9 || c == 10) {
                        h.tagAttribute(k, b1.toString());
                        b1 = new StringBuffer();
                        stat = S.TAG3;
                        break;
                    }
                    if (c == 13) break;
                    b1.appendCodePoint(c);
                    break;
                }
                case TAG5: {
                    if (c < 0) {
                        return;
                    }
                    if (c == 39) {
                        stat = S.TAG4;
                        break;
                    }
                    if (c == 13) break;
                    b1.appendCodePoint(c);
                    break;
                }
                case TAG6: {
                    if (c < 0) {
                        return;
                    }
                    if (c == 34) {
                        stat = S.TAG4;
                        break;
                    }
                    if (c == 13) break;
                    b1.appendCodePoint(c);
                    break;
                }
                case TAG7: {
                    if (c < 0) {
                        return;
                    }
                    if (c == 62) {
                        h.endTag(l);
                        b1 = new StringBuffer();
                        stat = S.INIT;
                        break;
                    }
                    if (c == 32 || c == 9 || c == 10 || c == 13) break;
                    b1 = new StringBuffer().appendCodePoint(c);
                    stat = S.TAG3;
                    break;
                }
                case TGE1: {
                    if (c < 0) {
                        return;
                    }
                    if (c == 62) {
                        h.endTag(b1.toString().trim());
                        b1 = new StringBuffer();
                        stat = S.INIT;
                        break;
                    }
                    if (c == 13) break;
                    b1.appendCodePoint(c);
                    break;
                }
                case ENT1: {
                    if (c < 0) {
                        HTMLParser.addent1(b2.toString(), false, b1);
                        if (b1.length() > 0) {
                            h.string(b1.toString());
                        }
                        return;
                    }
                    if (c == 35) {
                        stat = S.ENT2;
                        break;
                    }
                    if (c == 59) {
                        HTMLParser.addent1(b2.toString(), true, b1);
                        stat = S.INIT;
                        break;
                    }
                    if (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57) {
                        b2.append((char)c);
                        break;
                    }
                    HTMLParser.addent1(b2.toString(), false, b1);
                    b1.appendCodePoint(c);
                    stat = S.INIT;
                    break;
                }
                case ENT2: {
                    if (c < 0) {
                        HTMLParser.addent2(b2.toString(), false, b1);
                        if (b1.length() > 0) {
                            h.string(b1.toString());
                        }
                        return;
                    }
                    if (c == 59) {
                        HTMLParser.addent2(b2.toString(), true, b1);
                        stat = S.INIT;
                        break;
                    }
                    if (c >= 48 && c <= 57) {
                        b2.append((char)c);
                        break;
                    }
                    HTMLParser.addent2(b2.toString(), false, b1);
                    b1.appendCodePoint(c);
                    stat = S.INIT;
                    break;
                }
                case MET1: {
                    b1.appendCodePoint(c);
                    if (c != 63) break;
                    stat = S.MET2;
                    break;
                }
                case MET2: {
                    b1.appendCodePoint(c);
                    if (c == 62) {
                        h.meta(b1.toString());
                        b1 = new StringBuffer();
                        stat = S.INIT;
                        break;
                    }
                    stat = S.MET1;
                    break;
                }
                case CMT1: {
                    switch (c) {
                        case 45: {
                            stat = S.CMT2;
                            break;
                        }
                        case 62: {
                            stat = S.INIT;
                            break;
                        }
                        default: {
                            stat = S.CMTP;
                            break;
                        }
                    }
                    break;
                }
                case CMT2: {
                    switch (c) {
                        case 45: {
                            b1 = new StringBuffer();
                            stat = S.CMT3;
                            break;
                        }
                        case 62: {
                            stat = S.INIT;
                            break;
                        }
                        default: {
                            stat = S.CMTP;
                            break;
                        }
                    }
                    break;
                }
                case CMT3: {
                    switch (c) {
                        case 45: {
                            stat = S.CMT4;
                            break;
                        }
                        case 62: {
                            stat = S.INIT;
                            break;
                        }
                        default: {
                            b1.appendCodePoint(c);
                            break;
                        }
                    }
                    break;
                }
                case CMT4: {
                    switch (c) {
                        case 45: {
                            stat = S.CMT5;
                            break;
                        }
                        case 62: {
                            stat = S.INIT;
                            break;
                        }
                        default: {
                            b1.append('-').appendCodePoint(c);
                            break;
                        }
                    }
                    break;
                }
                case CMT5: {
                    switch (c) {
                        case 62: {
                            h.comment(b1.toString());
                            stat = S.INIT;
                            break;
                        }
                        default: {
                            b1.append('-').append('-').appendCodePoint(c);
                            break;
                        }
                    }
                    break;
                }
                case CMTP: {
                    if (c != 62) break;
                    stat = S.INIT;
                }
            }
        }
    }

    public static void parse(HTMLHandler h, String s) throws SQLException, IOException {
        HTMLParser.parse(h, new StringReader(s));
    }

    static enum S {
        INIT,
        TAG1,
        TAG2,
        TAG3,
        TAG4,
        TAG5,
        TAG6,
        TAG7,
        TGE1,
        ENT1,
        ENT2,
        MET1,
        MET2,
        CMT1,
        CMT2,
        CMT3,
        CMT4,
        CMT5,
        CMTP;

    }
}

