/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.sqlcs.dml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SqlInsertSelect implements SqlDml {

	private List<String> columns;
	private SqlSelect select;
	private String name;

	public SqlInsertSelect(String n, List<String> c, SqlSelect s) {
		name = n;
		columns = new ArrayList<String>(c);
		select = s;
	}

	public String getName() {
		return name;
	}

	public List<String> getColumns() {
		return Collections.unmodifiableList(columns);
	}

	public SqlSelect getSelect() {
		return select;
	}

	@Override
	public int getMaxParameter() {
		return select.getMaxParameter();
	}

}
